<?php 

//---------------------------------------------------------------
// The user profile
//---------------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//--------------------------------------
require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../dbclass/Db.class.php");
require_once("../classes/clsloginvalidate.php");
require_once("../classes/clsinput.php");
require_once("../classes/clsuser.php");
//--------------------------------------

//echo($_POST["inputEmail"]);
//echo($_POST["inputEmailNew"]);
//echo($_POST["submit"]);
//exit();

//Update email address
if ( isset( $_POST["submit"] ) && isset( $_POST["inputEmail"] ) && isset ( $_POST["inputEmailNew"] ) && isset ( $_POST["inputEmailNewAgain"] ) )
{
	
	if (!loginvalidate::username( trim(input::get("inputEmail"))) )
	{
		displayprofile("Error in email");
		exit();
	}		
	
	if (!loginvalidate::username( trim(input::get("inputEmailNew")) ) )
	{
		displayprofile("Error in email");
		exit();
	}		
	
	if ( trim(input::get("inputEmailNew")) != trim(input::get("inputEmailNewAgain")) )
	{
		displayprofile("New emails must match");
		exit();				
	}		
	
	
	//Now do the update
	$update = user::updateEmail( trim(input::get("inputEmail")), trim(input::get("inputEmailNew")) );
	
	if ($update == 1)
	{
		displayprofile("Email has been updated " . date("Y-m-d H:i:s"));
		exit();
	}
	else
	{
		displayprofile("Email has NOT been updated");
		exit();
	}	

}

else
//Change password
if ( isset($_POST["submit"]) && isset($_POST["inputEmail"]) && isset($_POST["inputPassword"]) && isset($_POST["inputPasswordAgain"]) )
{		

	if (!loginvalidate::password( trim(input::get("inputPassword")) ) )
	{
		displayprofile("Error characters in password");
		exit();
	}
	
	if (!loginvalidate::password( trim(input::get("inputPasswordAgain")) ) )
	{
		displayprofile("Error characters in password");
		exit();
	}
	
	$inputPassword = trim(input::get("inputPassword"));
	$inputPasswordAgain = trim(input::get("inputPasswordAgain"));	
	
	//Check pw length
	if ( (strlen($inputPassword) <= 5) || (strlen($inputPassword) > 10) ) {
		displayprofile("Passwords must be 6 to 10 characters");
		exit();					
	}
	
	//Check pw length
	if ( (strlen($inputPasswordAgain) <= 5) || (strlen($inputPasswordAgain) > 10) ) {
		displayprofile("Passwords must be 6 to 10 characters");
		exit();					
	}	

	if ( trim(input::get("inputPassword")) != trim(input::get("inputPasswordAgain")) )
	{
		displayprofile("Passwords must match");
		exit();				
	}
	
	if (!loginvalidate::username( trim(input::get("inputEmail"))) )
	{
		displayprofile("Error in email");
		exit();
	}	
	
	//Now change password
	$update = user::updatePassword( trim(input::get("inputEmail")), trim(input::get("inputPassword") ) );	
	
	if ($update == true)
	{
		displayprofile("Password has been updated " . date("Y-m-d H:i:s") );		
		exit();
	}
	else
	{
		displayprofile("Password has NOT been updated");		
		exit();
	}
	
}
		
else

{
	displayprofile("");
}
//------------------------------------------------------
function displayprofile($_message)
{
require_once("code/header_signin.php");
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li> 
</ol>

<div class="container">    
    	
    <div class="row">
    	
    	<div class="col-md-2" sidebar>                

		  <ul class="nav nav-sidebar navbar-dark">
			<li><a href="a_setup_global.php">Global Set Up</a></li>
			<li><a href="a_setup_smtp.php">SMTP Set Up</a></li>			  
			<li><a href="a_setup_graphics.php">Graphics Set Up</a></li>
			<li><a href="a_folders.php">Secure Set Up</a></li>				
			<li class="active"><a href="#">Set Password</a></li> 
		  </ul>          

		</div>
   	
   		<div class="col-md-8">    	
    			
			<h2>Change the login admin username (email address) and password</h2>
		
			<h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
		
			<div class="frmbkg">      	

				<form class="form-signin" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">				

					<h2>Change your login email address</h2>

					<div class="form-group">
						<label for="inputEmail">Current Email Address</label>
						<input type="email" id="inputEmail" name="inputEmail" class="form-control" placeholder="Current Email Address" aria-describedby="basic-addon1" required autofocus />
					</div>        

					<div class="form-group">
						<label for="usename">New Email Address</label>  
						<input type="text" id="inputEmailNew" name="inputEmailNew" class="form-control" placeholder="New Email Address" aria-describedby="basic-addon1" required />
					</div>

					<div class="form-group">
						<label for="usename">New Email Address Again</label>  
						<input type="text" id="inputEmailNewAgain" name="inputEmailNewAgain" class="form-control" placeholder="New Email Address Again" aria-describedby="basic-addon1" required />
					</div>

					<button type="submit" class="btn btn-lg btn-primary btn-block">Change Email Address</button>
					<input type="hidden" name="submit" value="Change Email Address" />        

				</form>      

			</div>
		
			<br />

		  	<div class="frmbkg">      	

			  <form class="form-signin" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

				<h2 class="form-signin-heading">Change your password</h2>

					<div class="form-group">        
						<label for="inputPassword">Enter Username (email address)</label>            
						<input type="email" id="inputEmail" name="inputEmail" class="form-control" placeholder="Username (email address)" required />        
					</div>

					<div class="form-group">        
						<label for="inputPassword">New Password</label>            
						<input type="password" id="inputPassword" name="inputPassword" class="form-control" placeholder="New Password" required />        
					</div>        

					<div class="form-group">        
						<label for="inputPasswordAgain">New Password Again</label>            
						<input type="password" id="inputPasswordAgain" name="inputPasswordAgain" class="form-control" placeholder="New Password Again" required />        
					</div>        

				<button type="submit" class="btn btn-lg btn-primary btn-block">Change Password</button>
				<input type="hidden" name="submit" value="Change Password" />

			  </form>
      
      		</div>

		</div>
		<div class="col-md-2"></div>
	</div>
   
</div> <!-- /container -->
<?php
	
require_once("code/footer_bootstrapjs.php");	
}
?>