<?php

//---------------------------------------
//	csv import
//
//---------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//--------------------------------------

	$message = "";

	$inputSubmit = input::get('Next');

	if ( $inputSubmit == " Next --> " ) {	
	
		$securearea_id 	= input::get('txtSecureArea_Id');
		$item_id		= input::get('txtItem_Id');

		//echo($securearea_id);
		//echo($item_id);

		if ( $securearea_id == "None" || $item_id == "None" ) {
			
			$message = "Select secure area and item";
		
			} else {

			page2($securearea_id, $item_id);
			exit();
	
		}

	}

	$securearea_id 	= input::get('txtSecureArea_Id');

	require_once("code/header_forjs.php");

	?>
	<script language="JavaScript">

	//-----------------------------------------
	//Process change securearea
	function securearea_onchange(frmAreas) {
		frmAreas.submit(frmAreas);
	}	

	</script>
	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />
	
</html>
<body>

<?php
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
</ol>
	
<div class="container">	
	
	<div class="row">
 		<div class="col-md-2"></div>
		<div class="col-md-8">
	
			<h2>Import users  from a CSV file - first page</h2>
    
			<p>This section is used to import users into the application from a csv file.</p>		
			<p>Importing may take time to process, so don't move from this page until it has completed.</p>
			<p>For instructions and file format, refer to the web site <a href="http://www.withinweb.com/phpsecurearea/csv.php">witinweb.com</a></p>
   
   
      		<div class="frmbkg">   
   
 				<form name="frmAreas" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">	
		
         			<div class = "form-group">        
						<h5><label class="label label-danger"><?php if (isset($message)) { echo($message); } ?></label></h5>
					</div>  			
			
					<div class = "form-group">   
						<p><strong>Select the Secure Area and then the product item to import into :</strong></p>
					</div>
   		
					<p>Choose the Secure area to import into:</p> 		
                
					<?php

					$items = securearealist();
					
					?>
					<select name="txtSecureArea_Id" class="form-control" language="javascript" onChange="return securearea_onchange(frmAreas)">
    					<option value="None">--Make a choice--</option>
	                    <?php					
						foreach ( $items as $d_row ) {						
							?>                       
            	            	<option value="<?php echo($d_row["recid"]); ?>"<?php if ( $securearea_id == $d_row["recid"] ) {echo("selected");}?>><?php echo($d_row["securearea_name"]); ?></option>
                	        <?php
						}						
						?>                
					</select>        
               		<?php
					
					if ($securearea_id == "" OR $securearea_id == "None") {					
					
					} else {
						
						$items = secureareaintblitems($securearea_id);
						
						?>

						<p>&nbsp;</p>
						<p>Choose the Item number to import into:</p>
                            
							<select name="txtItem_Id" class="form-control">
								<option value="None">--Make a choice--</option>
								<?php					
								foreach ( $items as $d_row ) {					
								?>              
									<option value="<?php echo($d_row["recid"]); ?>"><?php echo($d_row["item_number"]); ?></option>
								<?php
								}						
								?>                
							</select> 
                            
					<?php
					}
					?>
           
           			<p>&nbsp;</p>
           			            
					<div class = "form-group">
            			<input type="submit"  name="Next" value=" Next --> " class="btn btn-primary btn-sm" />
					</div>
	
				</form>

			</div>
		</div>
		<div class="col-md-2"></div> 			
	</div>
		
</div>	
		
<?php
require_once("code/footer_bootstrapjs.php");



//---------------------------------------------------------------
function page2($securearea_id, $item_id) {

	require_once("code/header_forjs.php");
	?>
	<script language="JavaScript">

	//-----------------------------------------
	//Check that an entry has been placed in the file field
	//and check then ask the user to confirm that they actually
	//want to import the data because it overwrites anything 
	function validate() {
		var  strFile = document.frmRetrieve.userfile.value;

		if ( strFile == "" )
		{
			alert("Enter a file");
			return false;
		}
		else
		{		
			return true;
		}
			
	}
	</script>
	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />
	
</html>
<body>

<?php
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
</ol>	

<div class="container">	
	
	<div class="row">
 		<div class="col-md-2"></div>
		<div class="col-md-8">

			<h2>Import users from a CSV file - second page</h2>
			
			<p>This section is used to import users from a csv file.</p>		
			<p>Importing may take time to process, so don't move from this page until it has completed.</p>
			<p>For instructions and file format, refer to the web site <a href="http://www.withinweb.com/phpsecurearea/csv.php" target="_blank">witinweb.com</a>.</p>
				
			<div class="frmbkg">   

				<form enctype="multipart/form-data" action="a_csv_import.php" method="post" onSubmit="return validate()" name="frmRetrieve">

					<h3>Import users</h3>

					<input type="hidden" name="txtSecureArea_Id" value="<?php echo($securearea_id); ?>" />
					<input type="hidden" name="txtItem_Id" value="<?php echo($item_id); ?>" />				


					<p>Select a csv file in the correct format</p>				

					<div class = "form-group">				
						<input name="userfile" type="file" class="form-control" />
					</div>						
				
					<div class="form-group" data-toggle="buttons">
						<label class="btn">
							<input type="checkbox" name="txtImport_Passwords" />		 			
					  		<i class="fa fa-square-o fa-2x"></i>
				  			<i class="fa fa-check-square-o fa-2x"></i>
				  			<span style="white-space:normal;">If csv file has passwords and these are to be imported then tick the box, otherwise allow PHP-SecureArea to automatically create the passwords:</span>
						</label>
					</div>						
				
					<div class="form-group" data-toggle="buttons">
						<label class="btn">
							<input type="checkbox" name="txtSend_Passwords" />		 			
					  		<i class="fa fa-square-o fa-2x"></i>
				  			<i class="fa fa-check-square-o fa-2x"></i>
				  			<span style="white-space:normal;">Tick the box to email the password to the manually created users:</span>
						</label>
					</div>						
				
					<div class = "form-group">
						<input type="submit" value="Import" class="btn btn-primary btn-sm" />
					</div>

				</form>

			</div>

		</div>
		<div class="col-md-2"></div> 			
	</div>
		
</div>	
		
<?php
require_once("code/footer_bootstrapjs.php");
}

?>