<?php
session_start();

//---------------------------------------------------------------
//Email all purchasers
//---------------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//		This sends emails as Bcc

//Things to do :
//		Apparantly there are a number of issues with using Bcc in that
//		Windows implementations of PHP may not work correctly - it can show
//		all email addresses instead of just the one.  
//		Another problem is that although there is only one email, the 
//		server still has to split up the Bcc list into separate emails
//		and hence may take time to process the emails which may 
//		eventually timeout.
//		The best way is to write a schedule event which sends each 
//		email message every 1 second (say).  This would need a method
//		to identify which emails have been sent and if the list has 
//		completed or not.

// Increase maximum execution time, but don't complain about it if it isn't allowed.
@set_time_limit(300);

require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//--------------------------------------

//----------------------------------------------
main();


//----------------------------------------------
function main() {

	$inputSubmit = input::get('Email');
	
	switch($inputSubmit) {
	
		case "Send":
		
			$txtSubject 	= input::get('txtSubject');
			$txtBody 		= input::get('txtBody');
			$txtFormat		= input::get('txtFormat');
			
			$_SESSION['subject']	= stripslashes($txtSubject);
			$_SESSION['body']		= stripslashes($txtBody);
			
			sendmailconfirm($txtFormat);						
			break;
			
		case "Yes":
		
			//$txtSubject 	= $_POST['txtSubject'];			
			//$txtBody 		= $_POST['txtBody'];
			$txtFormat		=  $_POST['txtFormat'];			
			
			$testmode		= "false";
			$recordcount = sendmail($_SESSION['subject'],$_SESSION['body'], "", $txtFormat, $testmode);
			
			if ($recordcount  > 0)
				displayoptions("$recordcount email sent (sent using Bcc)");
			else
				displayoptions("No records found");
				
			break;
			
		case "No":
		
			displayoptions("");
			break;
			
		default :
			
			displayoptions("");
	
	}

}
//----------------------------------------------
/**
	* Display a page so that the user can mae a choice
*/
function displayoptions($_message) {

require_once "code/header.php";
require_once "code/navigation.php";
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
</ol>

<div class="container"> 
    
	<div class="row">
    	<div class="col-md-2" sidebar>
   			<ul class="nav nav-sidebar navbar-dark">
                <li class="active"><a href="a_emailall.php">Email All </a></li>
                <li><a href="a_emailsome.php">Email Some </a></li> 
                <li><a href="a_emailtest.php">Email Test </a></li> 
            </ul>                  
        </div>
		<div class="col-md-6">        

			<h2>Send an email to all purchasers</h2>

            <div class="frmbkg">
            
                <!-- START OF FORM -->        
                <form name="frmEmail" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                    
                    <div class = "form-group">        
                        <h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
                    </div>            
                                    
                    <p>Use this form to email all purchasers.</p>
                    <p>Complete the subject and body text for the email.</p>
                
                   <!--
                    <div class="form-group" class="form-control form-control-sm">     
                        <label for="txtFormat"><strong>Email Format :</strong></label>
                        <select name="txtFormat"  class="form-control form-control-sm">
                            <option name="text">text</option>
                            <option name="html">html</option>
                        </select>
                    </div>
                    -->
                    
                    <input type="hidden" name="txtFormat" value="text" />
        
                    <div class="form-group">         
                        <label for="txtSubject"><strong>Email subject</strong></label>
                        <input type="text" name="txtSubject" size="45" class="form-control form-control-sm" placeholder="Subject" required />
                    </div>
                    
                    <div class="form-group">                         
                        <label for="txtBody"><strong>Email body text</strong></label>
                        <textarea name="txtBody" cols="35" rows="10" class="form-control form-control-sm" placeholder="Body" required ></textarea>
                    </div>
        
                    <p>Note that if there are a large number of purchasers, there may be a delay before the script completes.</p>
                    <p>Press Send once and wait until the script completes.</p>
            
                    <div class="form-group">
						 <input type="submit" name="Email" value="Send" class="btn btn-primary btn-sm" />                        
                    </div>
                    
                </form>
                <!-- END OF MAIN FORM -->
        
            </div>    
        
        </div>
		<div class="col-md-4"></div>
	</div>

</div>

<?php include ("code/footer_bootstrapjs.php");
}
//----------------------------------------------
/**
	* Allows the user to confrirm to send the mail
*/
function sendmailconfirm($format) {

require_once "code/header.php";
require_once "code/navigation.php";
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
  <li><a href="a_items.php">Product List</a></li>
</ol>

<div class="container"> 

	<h2>Confirmation</h2>
    
        <form name="frmConfirm" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
            <!--<input type="hidden" name="txtSubject" value="<?php echo($subject); ?>">-->
            <!--<input type="hidden" name="txtBody" value="<?php echo($body); ?>">-->
            <input type="hidden" name="txtFormat" value="<?php echo($format); ?>" />
    
            <p>Confrim that you wish to send the email</p>
        
        	<div class="form-group">
	            <input type="submit" name="Email" value="Yes" class="btn btn-primary btn-sm" />&nbsp;&nbsp;
    	        <input type="submit" name="Email" value="No" class="btn btn-primary btn-sm" />
        	</div>
        
        	<div class="form-group">        
	            <label for="txtProduct"><strong>Subject</strong></label>
    	        <?php echo($_SESSION['subject']); ?>
			</div>        

        	<div class="form-group">                
	            <label for="txtProduct"><strong>Body</strong></label>
    	        <?php echo($_SESSION['body']); ?>
    		</div>
    
        </form>
    
</div>

<?php

}
?>