<?php

//	Tests the email system

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//--------------------------------------

//----------------------------------------------
main();

//----------------------------------------------
function main() {

	$inputSubmit = input::get('Email');
	
	if ($inputSubmit == "Send")
	{
		$inputFrom 		= input::get('txtFrom1');
		$inputTo 		= input::get('txtTo');
		$inputSubject 	= input::get('txtSubject');
		$body 			= input::get('txtBody');
		send($inputFrom, $inputTo, $inputSubject, $body);
		display("Email sent " . date("Y-m-d H:i:s"));
	} else {
		display("");	
	}

}
//----------------------------------------------
function display($_message) {

require_once("code/header.php");
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  	<li><a href="index1.php">Home</a></li> 	
</ol> 

<div class="container">	
    
    <div class="row">
    	<div class="col-md-2" sidebar>                
        	<ul class="nav nav-sidebar navbar-dark">
                <li><a href="a_emailall.php">Email All </a></li>
                <li><a href="a_emailsome.php">Email Some </a></li> 
                <li class="active"><a href="a_emailtest.php">Email Test </a></li> 
            </ul>        
        </div>
		<div class="col-md-6">        
    
    		<h2>Do an email test</h2>
        
            <div class="frmbkg">   
            
                <form name="frmEmail" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        
        			<div class = "form-group">
                    	<h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
            		</div>
            
                    <p>Use this form to test sending emails from the web server.</p>
                    <p>Complete the subject and body text for the email and<br>
                    also enter in an appropriate to and from address.</p>            
                    
                    <div class="form-group"> 
                        <label for="txtSubject"><strong>Email subject</strong></label>
                        <input type="text" name="txtSubject" class="form-control form-control-sm" placeholder="Subject" required />
                    </div>
                    
                    <div class="form-group"> 
                        <label for="txtBody"><strong>Email body text</strong></label>
                        <textarea name="txtBody" rows="8" class="form-control form-control-sm" placeholder="Body" required></textarea>
                    </div>
                    
                    <div class="form-group"> 
                        <label for="txtTo"><strong>Email to address</strong></label>
                        <input type="text" name="txtTo" class="form-control form-control-sm" placeholder="Email TO address" required />
                    </div>
                    
                    <div class="form-group">                
                        <label for="txtFrom1"><strong>Email from address</strong></label>
                        <input type="text" name="txtFrom1" class="form-control form-control-sm" placeholder="Email FROM address" required />                    
                    </div>
                
                    <div class="form-group">                    
                        <input type="submit" name="Email" value="Send" class="btn btn-primary btn-sm" />
                    </div>		
    
                </form>
    
            </div>
    
		</div>
		<div class="col-md-4"></div>
	</div>    
    

</div>

<?php include ("code/footer_bootstrapjs.php");
}
//----------------------------------------------
function send($from, $to, $subject, $body) {

	//echo("from : " . $from);
	//echo("to : " . $to);
	//echo("subject : " . $subject);
	//echo("body : " . $body);
	//exit();	

	mailmessage($to, $subject, $body, "", $from, "", "");
	
}
?>