<?php

//----------------------------------------------
//Define the folders and secure area names to be secured

//	When you delete a folder, or delete a securea area
//	or edit an existing secure area, it should really
//	blank off the original htaccess file.  It is quite 
//	difficult to do because you would have to do the changes 
//	to the record before the htaccess files are blanked off.
//	At the moment I assume that the user will manage the 
//----------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//----------------------------------------------

main();

//----------------------------------------------
function main() {

	$inputCreate = input::get('Create');
	$inputAction = input::get('action');
	$inputSubmit = input::get('submit');
	
	if ($inputCreate == "Add Secure Area") 
	{
	
		$securearea_name = input::get('txtSecureArea_Name');
		
		if ($securearea_name == "") 
		{
			display("Name must not be blank - no update");
		}
		else
		{			
			$result = createsecurearea( $securearea_name );
			display($result);
			exit();
		}

	}
	
	elseif ( $inputAction == "editsecurearea" )					//Edit the secure area name		
	{	
		editsecurearea( input::get('recid') );
	}

	elseif ( $inputSubmit == 'Update Secure Area' ) {			//Update the secure area name
		$result = updatesecurearea( input::get('recid'), input::get('txtSecureArea_Name') );
		display($result);
		exit;
	}	
	
	elseif ( $inputAction == "deletesecurearea" )				//Confirm to delete the secure area name
	{	
		confirmdeletesecurearea( input::get('recid') );
	}	
	
	elseif ( $inputSubmit == 'Delete Secure Area' ) {			//Now do the deletion
		$result = deletesecurearea( input::get('recid') );
		display($result);
		exit();
	}
	
	elseif ( $inputSubmit == 'Add Folder Path' ) {				//Add folder
	
		if ( input::get('txtFolder') == "" ) {
			display("Folder name must not be blank - no update");
			exit();
		}

		$folder = trim( input::get('txtFolder') );
		$folder = slashonend($folder);

		if ( !checkfolder( $folder ) ) {
			display("Folder is already in use - no update");
			exit();
		}		
		
		validatefolder( $folder , input::get('txtSecureArea_Id') );

		//echo("<br/>");
		//echo("folder: " . $folder);
		//echo("securearea_id: " . input::get('txtSecureArea_Id'));
		//exit();

		$result = addsecurefolder(  $folder, input::get('txtSecureArea_Id') );
		display($result);
		exit();
			
	}

	elseif ( $inputAction == "editfolder" )
	{	
		editfolder( input::get('recid'), input::get('secureareaid') );
	}		
	
	elseif ( $inputSubmit == 'Update folder' ) {
		//update folder needs to change the entries in the 
		//htaccess files if the folder name has changed, and do 
		//all the validation of folders in the same way as 
		//for adding a new folder.
		if ( input::get('txtFolder') == "" ) {
			display("Folder name must not be blank - no update");
			exit();
		}		

		$folder = trim( input::get('txtFolder') );
		$folder = slashonend($folder);

		if ( !checkfolder( $folder ) ) {
			display("Folder is already in use - no update");
			exit();
		}
				
		validatefolder( $folder, input::get('secureareaid') );	
		$result = updatefolder( input::get('recid'), $folder );
		display($result);
		exit();
		
	}

	elseif ( $inputAction == 'deletefolder' ) {					//Ask for confirmation
		confirmdeletefolder( input::get('recid') );
		exit();
	}	
	
	elseif ( $inputSubmit == 'Delete folder' ) {				//Now do the deletion
		$result = deletefolder( input::get('recid') );
		display($result);
		exit();
	}	
	
	else
	{
		display("");
	}

}
//----------------------------------------------
//Purpose	:	Display the main entry page
function display($msg) {	
	
require_once("code/header.php");
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  	<li><a href="index1.php">Home</a></li> 	
</ol> 

<div class="container">

	<div class="row">
		<div class="col-md-2" sidebar>                

		  <ul class="nav nav-sidebar navbar-dark">
			<li><a href="a_setup_global.php">Global Set Up</a></li>
			<li><a href="a_setup_smtp.php">SMTP Set Up</a></li>			  
			<li><a href="a_setup_graphics.php">Graphics Set Up</a></li>
			<li class="active"><a href="a_folders.php">Secure Set Up</a></li>				
			<li><a href="a_changepw.php">Set Password</a></li> 
		  </ul>          

		</div>
		<div class="col-md-8">

			<h2>Manage secure area names and folders</h2>

			<?php

			//Display the secure area names and folders
			$table = securearealist();

			if ($table) {	//tests if there are any entries in the table

			?>				

				<p>This is where you create a Secure Area by entering a suitable name and then adding a folder or folders 
				against that name.  The secure area name would be something like 'Protected Area 1' or 'Gold access' and the
					folder needs to be full folder path which would look something like <strong>/server/mysite/public_html/foldername/.</strong></p>

				<p>If you delete a secure area, make sure there are no products in the Product List page that use this secure area, 
				otherwise you will have Products with no defined access.</p>


				<?php displayform($msg);?>		

					<?php
					//----------------------------------------
					foreach( $table as $d_row ) {
						?>

						<div class="frmbkg">   

							<div class="row">

								<div class="col-md-8">
									<p><strong>Title:</strong> <?php echo(  $d_row['securearea_name']  ); ?></p>
								</div>								

								<div class="col-md-4">																
									<div style="float:right"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=editsecurearea&recid=<?php echo($d_row['recid']); ?>"><i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a>
										<a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=deletesecurearea&recid=<?php echo($d_row['recid']); ?>"><i class="fa fa-trash fa-2x" aria-hidden="true"></i></a></div>
								</div>

							</div>


							<div class="row">							

								<div class="col-md-4">
									<p>Add the folder path into the box</p>						
								</div>			

								<div class="col-md-8">		

									<form name="frmAddSecureArea" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
										<input type="hidden" name="txtSecureArea_Id" id="txtSecureArea_Id" value="<?php echo($d_row['recid']); ?>" />
										<input type="text" name="txtFolder" id="txtFolder" class="form-control" placeholder="Folder Path" />
										<br/>
										<input type="submit" name="submit" value="Add Folder Path" class="btn btn-primary btn-sm" />
									</form>

								</div>

							</div>					


							<?php			

							//Now for each recid entry, look up the related folders in tblfolders					
							$table_folders = secureareafolders($d_row['recid']);

							//echo("securearea_id: " . $d_row['recid'] . "<br/>");

							foreach ( $table_folders as $d_rows_folders ) {

								?>

								<div class="row">		
									<div class="col-md-12">&nbsp;</div>
								</div>
														
								<div class="row">		

									<div class="col-md-8">								
										<?php echo ( $d_rows_folders['folder_path'] ); ?>
									</div>								

									<div class="col-md-4">	
										<div style="float:right"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=editfolder&recid=<?php echo($d_rows_folders['recid']); ?>&secureareaid=<?php echo($d_row['recid']); ?>"><i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a>
											<a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=deletefolder&recid=<?php echo($d_rows_folders['recid']); ?>"><i class="fa fa-trash fa-2x" aria-hidden="true"></i></a></div>
									</div>

								</div>

								<?php								

							}
							?>

						</div>

						<p>&nbsp;</p>
					
						<?php

					}
					//----------------------------------------
					?>
				

			<?php
			}
			else
			{
				?>
					
					<p>This is where you create a Secure Area by entering a suitable name and then adding a folder or folders 
					against that name.  The secure area name would be something like 'Protected Area 1' or 'Gold access' and the
					folder needs to be full folder path which would look something like /server/mysite/public_html/foldername/.</p>

					<?php displayform($msg);?>

				<?php
			}
			?>

	
		</div>
		<div class="col-md-2"></div>
	</div>	

</div>

<?php include ("code/footer_bootstrapjs.php");
}
//-------------------------------------
//Purpose	:	Display the form for creating a new secure area
function displayform($msg) {
	
		?>
		
			<div class="frmbkg">   		
		
				<form name="frmFolder" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

					<div class = "form-group">
               			<h5><label class="label label-danger"><?php if ($msg == "") echo(""); else echo($msg); ?></label></h5>
           			</div>				
				
					<div class="form-group">       				
						<input type="text" name="txtSecureArea_Name" id="txtSecureArea_Name" class="form-control" placeholder="Secure Area Name" />
					</div>

					<div class="form-group"> 					
						<input type="submit" name="Create" value="Add Secure Area" class="btn btn-primary btn-sm" />
					</div>

					<div class="form-group"> 					
						<p>Enter a suitable name for the secure area into the box such as 'Music pages' or 'Secure area'</p>
					</div>

				</form>				
		
			</div>

			<p>&nbsp;</p>

		<?php

}
//-------------------------------------
//Purpose	:	Given the recid of the secure area name, this
//				edits the secure area name
function editsecurearea($recid) {

	require_once("code/header.php");
	require_once("code/navigation.php");
	
	?>
	<ol class="breadcrumb">
		<li><a href="index1.php">Home</a></li>
		<li><a href="a_folders.php">Folder list</a></li>
	</ol>	

	<div class="container">

		<div class="row">
			<div class="col-md-3">&nbsp;</div>
			<div class="col-md-6">

				<h2>Edit secure area name</h2>

				<div class="frmbkg"> 

					<form name="frmEditSecureArea" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

							<input type="text" name="txtSecureArea_Name" id="txtSecureArea_Name" value="<?php echo(getsecureareaname($recid)); ?>" class="form-control" placeholder="Secure Area Name"  />
							<br/>
							<input type="hidden" name="recid" value="<?php echo($recid); ?>" />
							<input type="submit" name="submit" value="Update Secure Area" class="btn btn-primary btn-sm" />

					</form>

					<br/>

				</div>

			</div>
			<div class="col-md-3">&nbsp;</div>
		</div>	
	
	</div>	

<?php include ("code/footer_bootstrapjs.php");
}
//-------------------------------------
//Purpose	:	Given the $recid of the secure area it confirms deletion of 
//				the secure area from tblsecureareas and all associated folders 
//				records	from tblfolders
function confirmdeletesecurearea($recid) {

	//Need to check if this secure area is used in products already.
	//If they are used then say - delete products first.
	
	$items = secureareaintblitems($recid);

	if (count($items) >= 1) {
		//Means that there are products with this rec id and a message should be displayed.
		$usedarea = true;
	} else {
		$usedarea = false;
	}

	require_once("code/header.php");
	require_once("code/navigation.php");
	?>
	<ol class="breadcrumb">
		<li><a href="index1.php">Home</a></li>
		<li><a href="a_folders.php">Folder list</a></li>
	</ol>	
			
	<div class="container">
			
		<div class="row">
			<div class="col-md-2">&nbsp;</div>
			<div class="col-md-8">

			<h2>Confirm deletion of secure area</h2>	
	
			<div class="frmbkg"> 

				<?php
				if ($usedarea == false) {
				?>
						<form name="frmConfirmDeleteSecureArea" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
							<p>Are you sure you want to delete this secure area ? : <strong><?php echo(getsecureareaname("$recid")); ?>?</strong><br><br>
								Note that deleting a secure area will cause failures with products which use this secure area</p>
							<input type="hidden" name="recid" value="<?php echo("$recid"); ?>">
							<input type="submit" name="submit" value="Delete Secure Area" class="btn btn-primary btn-sm" />
							&nbsp;&nbsp;&nbsp;
							<input type="submit" name="submit" value="No" class="btn btn-primary btn-sm" />
						</form>
				<?php
				} else {

					?>
						<br/>
						<p>This area is used by one of the products in the product list.<br/>  
						You need to delete the item from the product list before<br/>you are 
						able to delete the area.</p>
						<br/>
					<?php

				}
				?>

			</div>
	
			</div>
			<div class="col-md-2">&nbsp;</div>
		</div>

	</div>

<?php include ("code/footer_bootstrapjs.php");
}
//-------------------------------------
//Purpose	:	edit the existing folder entry
function editfolder($recid, $secureareaid) {

	require_once("code/header.php");
	require_once("code/navigation.php");
	?>
	<ol class="breadcrumb">
		<li><a href="index1.php">Home</a></li> 
		<li><a href="a_folders.php">Folder list</a></li> 	
	</ol>	
	
	<div class="container">

		<div class="row">
			<div class="col-md-2">&nbsp;</div>
			<div class="col-md-8">		
				
				<h2>Edit folder</h2>

					<div class="frmbkg">				

						<form name="frmEditFolder" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

							<input type="text" name="txtFolder" id="txtFolder" value="<?php echo(secureareagetfolder($recid)); ?>" class="form-control" placeholder="Secure Area Name" />
							<br/>
							<input type="hidden" name="recid" value="<?php echo($recid); ?>">
							<input type="hidden" name="secureareaid" value="<?php echo($secureareaid) ?>">
							<input type="submit" name="submit" value="Update folder" class="btn btn-primary btn-sm" />

						</form>

						<br/>
				
					</div>

				</div>

			</div>
			<div class="col-md-2">&nbsp;</div>
		</div>	
	
	</div>	

<?php include ("code/footer_bootstrapjs.php");
}
//-------------------------------------
//Purpose	:	Given the $recid of the folder it confirms deletion of 
//				the folder from tblfolders
function confirmdeletefolder($recid) {

	require_once("code/header.php");
	require_once("code/navigation.php");
	?>
	<ol class="breadcrumb">
		<li><a href="index1.php">Home</a></li>
		<li><a href="a_folders.php">Folder list</a></li> 	
	</ol>	
	
	<div class="container">

		<div class="row">
			<div class="col-md-2">&nbsp;</div>
			<div class="col-md-8">

				<h2>Confirm deletion of folder</h2>
				
				<div class="frmbkg">	

					<form name="frmConfirmFolder" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
						<p>Are you sure you want to delete this folder ? : <strong><?php echo(secureareagetfolder("$recid")); ?>?</strong></p>					
						<input type="hidden" name="recid" value="<?php echo("$recid"); ?>" />
						<input type="submit" name="submit" value="Delete folder" class="btn btn-primary btn-sm" />
						&nbsp;&nbsp;&nbsp;
						<input type="submit" name="submit" value="No" class="btn btn-primary btn-sm" />
					</form>

				</div>
		
			</div>
			<div class="col-md-2">&nbsp;</div>
		</div>

	</div>

<?php include ("code/footer_bootstrapjs.php");
}
//-------------------------------------
//Purpose	:	Checks if $folder is a valid folder on the server and 
//				checks if the folder has the correct permissions
function validatefolder($folder, $securearea_id) {

	clearstatcache();

	$folder = trim($folder);

	//echo("x" . $folder  . "x");
	//exit();

	//Check if folder exists
	if ( !file_exists($folder) ) 
	{
		display("Folder does not exist - create the folder first and try again");
		exit();	
	}

	//Check if .htaccess exists
	if ( !file_exists($folder . ".htaccess") ) 
	{	
		display(".htaccess file does not exist in " . $folder . " - copy master .htaccess file to the folder and try again");
		exit();
	}

	//Check file permissions
	if ( !is_writable($folder . ".htaccess") )
	{
		display("Change permissions on .htaccess file to 666 and try again");
		exit();
	}

	$password_location = getpasswordlocation();

	//Now open .htaccess file add in standard text, and point to htpasswd_[securearea_id] file.
	if ( !modifyhtaccess($folder, $password_location, $securearea_id) ) {
		display("Error in updating htaccess file in " . $folder);
		exit();		
	}

	//Now create the required htpasswd file in the password folder (if it does not already exist).
	if (!createhtpasswd($securearea_id, $password_location) ) {
		display("Error in creating htpasswd file in " . $password_location);
		exit();				
	}

	//Getting here means that the folders have been set up correctly
	//and can continue with adding or updating folder name.

}
//-----------------------------------
//Open the htaccess file in $folder
//Add in permissions etc
//Add in the location of htpasswd_[securearea_id]
//Save the changes
function modifyhtaccess($folder, $password_location, $securearea_id) {

	@ $fp = fopen($folder . ".htaccess", "w");

	if ( !$fp ) 
		return false;

	$data = "#File created : " . date('l dS \of F Y h:i:s A') . "\r\n";
	$data = $data . "IndexIgnore *\r\n";
	$data = $data . "<Files .htaccess>\r\n";
	$data = $data . "order allow,deny\r\n";
	$data = $data . "deny from all\r\n";
	$data = $data . "</Files>\r\n\r\n";
	$data = $data . "AuthName \"Restricted Area\"\r\n";
	$data = $data . "AuthType Basic\r\n";
	$data = $data . "AuthUserFile " . $password_location . ".htpasswd_" . $securearea_id . "\r\n";
	$data = $data .	"AuthGroupFile /dev/null\r\n";
	$data = $data . "require valid-user\r\n";

	fwrite($fp, $data);
	fclose($fp);

	return true;
	
}
//-----------------------------------
//blanks off the htaccess file
function blankhtaccess($folder, $password_location, $securearea_id) {

	@ $fp = fopen($folder . ".htaccess", "w");

	if ( !$fp ) 
		return false;
		
	$data = "";
	
	fwrite($fp, $data);
	fclose($fp);

	return true;

}
//-----------------------------------
//Creates .htpasswd file if it does not exist, in the password folder, the file is called .htpasswd_[securearea_id]
//This assumes that the folder has 777 access permissions as defined during set up.
function createhtpasswd($securearea_id, $password_location) {

	clearstatcache();

	//echo($password_location . ".htpasswd_" . $securearea_id);
	//exit();

	if ( file_exists($password_location . ".htpasswd_" . $securearea_id ) ) {
		return true;
	}
	else
	{
		//Create the file
		
		@ $fp = fopen($password_location  . ".htpasswd_" . $securearea_id, "w" );
		
		if ( !$fp ) 
			return false;
	
		$data = "";

		fwrite($fp, $data);
		fclose($fp);

		return true;
		
	}
	
}
?>