<?php

//---------------------------------------------------------------
//Get start date, get end date, make a list of months between those 
//dates and enter into labels.
//Get each set of values for each month.
//---------------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

// 30/12/2024 V2.9.6
// hbar removed from BAR_GRAPH()


require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsgraphs.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//--------------------------------------


//Use during testing :
//displaygraph();


//------------------------------------------------------
function displaygraph() {

	//Get oldest date in saleshistory
	$fromoldest 	= getoldestdate();
	$formatoldest 	= strtotime($fromoldest);
	$fromyear 		= date("Y", $formatoldest);
	$frommonth 		= date("m", $formatoldest);

	//echo($fromoldest);
	//echo($fromyear . " " . $frommonth);
	//exit();	

	//Get current year and month
	$toyear 		= date("Y");
	$tomonth 		= date("m");

	//Make list of months/years

	$stop = false;
	do {
	
		if ( $frommonth == $tomonth && $fromyear == $toyear ) 
			{
			$stop = true;
			}

		$date_array[] 	= $fromyear . "-" . $frommonth;

		$frommonth = $frommonth + 1;
		if ($frommonth == 13) 
			{
			$fromyear = $fromyear + 1;
			$frommonth = 1;
			}

	} while ($stop == false);

	//echo($fromyear . "-" . $frommonth . "<br>");
	//echo($toyear . "-" . $tomonth . "<br>");	
	//exit();

	$labels = "";
	$values = "";
	foreach($date_array  as $dates)
	{
	
		//labels for each month
		
		//echo($dates . "<br>");
		//format the dates into the form month name - year		
		list($year , $month) = explode('-', $dates);		
		//echo($month . "-" . $year . "<br>");
		
		switch ($month)
		{
		
			case 1 :	$labels = $labels . "Jan";
						break;
			case 2 :	$labels = $labels . "Feb";
						break;
			case 3 :	$labels = $labels . "Mar";
						break;
			case 4 :	$labels = $labels . "Apr";
						break;
			case 5 :	$labels = $labels . "May";
						break;
			case 6 :	$labels = $labels . "Jun";
						break;
			case 7 :	$labels = $labels . "Jul";
						break;
			case 8 :	$labels = $labels . "Aug";
						break;
			case 9 :	$labels = $labels . "Sep";
						break;
			case 10 :	$labels = $labels . "Oct";
						break;
			case 11 :	$labels = $labels . "Nov";
						break;
			case 12 :	$labels = $labels . "Dec";
						break;
			
		}

		$labels = $labels . "-" . $year . ",";

		//echo($labels . "<br>");

		//values for each month
		$values = $values . getvalues($month, $year) . ",";

		//echo("$month : " . getvalues($month, $year) . "<br>");
		//exit();
	}

	//exit();

	//remove last ,
	$labels = substr($labels, 0, -1);
	$values = substr($values, 0, -1);

	//echo($labels . "<br>");
	//echo($values . "<br>");

	//exit();

	$graph = new BAR_GRAPH();
	$graph->values = $values;
	$graph->labels = $labels;		
	//$graph->values = "380,150,265,310,430";
	//$graph->labels = "Jan,Feb,Mar,Apr,May";	
	$graph->showValues = 1;
	$graph->barColor = "#b0c4de";
	$graph->barBGColor = "#e5e5e5";
	$graph->barBorder = "1px solid #808080";
	$graph->labelColor = "#000000";
	$graph->labelBGColor = "";
	$graph->labelBorder = "1px dashed #A0A0A0";
	$graph->labelFont = "Verdana, Arial, Helvetica";
	$graph->labelSize = 14;
	$graph->absValuesColor = "#000000";
	$graph->absValuesBGColor = "#e5e5e5";
	$graph->absValuesBorder = "1px solid silver";
	$graph->absValuesFont = "Verdana, Arial, Helvetica";
	$graph->absValuesSize = 14;
	$graph->absValuesPrefix = "";
	$graph->percValuesColor = "#000000";
	$graph->percValuesFont = "Verdana, Arial, Helvetica";
	$graph->percValuesSize = 14;
	echo $graph->create();

}
//------------------------------------------------------
//Purpose : returns the accumulated values from tblsaleshistory for the month/year
function getvalues($month, $year) {

	//echo("month: " . $month);
	//echo("year: " . $year);
	//exit();	
	
	
	//Contruct date from $month/$year	
	$fromdate = $year . "-" . $month . "-01 00:00:00";	//first day of the month
	$lastday = mktime(0, 0, 0, $month + 1, 0, $year);	//last day of the month	
	$todate = date("Y",$lastday) . "-" . date("m",$lastday) . "-" . date("d",$lastday) . " 23:59:59";
	
	//echo("FROM : " . $fromdate . " TO " . $todate . "<br>");

	$returnvalue = gettotal($fromdate, $todate);

	//if ( $table[0]['total'] == "" ) {
	//	$returnvalue = 0;
	//}
	//else
	//{
	//	$returnvalue =  $table[0]['total'];
	//}

	return $returnvalue;

}

?>