<?php
//-----------------------------------
//Manage the items in tblitems table
//-----------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

// 30/12/2024 V2.9.6
// function delete changed to deleterecord

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//----------------------------------------------

main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

		$inputAction = input::get('action');
		$inputUpdate = input::get('Update');
		$inputSubmit = input::get('submit');
	
		if ( $inputAction == 'delete' ) 
		{ 	//Confirm to delete the item
			confirmdeletion( input::get('recid') );

		} elseif ( $inputSubmit == 'Yes') {	//Delete the item after confirmation
			deleterecord( input::get('recid') );
			
		} elseif ( $inputAction == 'edit') {	//Edit the item
			edit( input::get('recid'), "");			

		} elseif ( $inputUpdate == 'Update') {
			
			$item_number 		= input::get('txtItem_Number');
			$item_name 			= input::get('txtItem_Name');	
			$item_description	= input::get('txtItem_Description');	//Not used in this system
			
			$emailsubject		= input::get('txtEmailSubject');
			$emailtext			= input::get('txtEmailText');
			$item_image			= input::get('txtItem_Image');			//Not used in this system
			
			$recid				= input::get('txtRecId');
			$mc_currency		= input::get('txtMc_Currency');
			$currency			= input::get('mc_currency');
			$currency			= getcurrency($mc_currency);
			
			$securearea_id		= input::get('txtSecureArea_Id');
			
			//---------------
			//Trail period 1
			$a1					= input::get('a1');
			if ($a1 != "") {
				$a1				= checkleadingzeros( input::get('a1') );	//Cost 
			}
			
			$p1					= input::get('p1');					//Unit period
			$t1					= input::get('t1');					//Unit of D, W, M or Y	

			//---------------
			//Trail period 2
			$a2					= input::get('a2');
			if ($a2 != "") {
				$a2				= checkleadingzeros( input::get('a2') );	//Cost
			}
			$p2					= input::get('p2');						//Unit period
			$t2					= input::get('t2');						//Unit of D, W, M or Y
			
			//---------------		
			//Regular period 
			$a3					= checkleadingzeros( input::get('a3') );	//Cost
			$p3					= input::get('p3');						//Unit period
			$t3					= input::get('t3');						//Unit of D, W, M or Y

			//---------------
			//Recurring data
			$src				= input::get('src');				//Recurring payments
			$sra				= input::get('sra');				//Reattempt on failure			
			$srt				= input::get('srt');				//Recurring times (installments)
			
			//-----------------
			$publish = 1;	//The publish state is always true in this system

			if ($item_number == "" || $item_name == "" || $emailsubject == "" || $emailtext == "") {
				edit($recid, "ERROR - record not updated - fill in all fields");
			} else {
				update($item_number, $item_name, $recid, $emailsubject, $emailtext, $item_description, 
					   	$item_image, $publish, $mc_currency, $currency, $securearea_id, 
					   	$a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, $t3, $src, $sra, $srt);
			}
			
		}
		else
		{
	      displaylist("");
		}

}
//-----------------------------------
//Main display
//Purpose : Displays the list of items
function displaylist($_message) {

	require_once "code/header.php";	
	require_once "code/navigation.php";
	?>
		
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol>
		
	<div class="container">
        
			<div class="row">   
	    		<div class="col-md-12">
					<h2>Create and edit the product list</h2>
        		</div>   
   			</div>
	
	   		<div class="row">   
                <div class="col-md-12">
                        <h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
                </div>   
           	</div>
	
	    	<?php
				$table = itemlist();
			?>
	    
		    <div class="row">   
                <div class="col-md-12">&nbsp;</div>   
            </div>            
		
		  	<div class="row">    
                <div class="col-md-12">	
					<form name="frmCreate" method="post" action="a_itemscreate.php">			
						<input type="submit" name="create" value="Create an Item" class="btn btn-primary btn-sm" />					
					</form>
			   </div>
			</div>
			
	    	<div class="row">   
                <div class="col-md-12">&nbsp;</div>   
            </div>   	    
	    
		    <div class="row">   
                <div class="col-md-12">** Click on the column title arrows to sort the column</div>   
            </div>			
		
			<div class="row">   
	    		<div class="col-md-12">	
		
					<?php
					if (count($table) == 0)
					{
						echo('There are no items to display');
					}
					else
					{
					?>		

						<table cellspacing="0" width="100%" id="products" class="display">		   	
							<thead>
								<tr>
									<th>Product<br/>Item Number</th>					
									<th>Product<br/>Item Name</th>						
									<th>Regular<br/>Billing</th>	
									<th>&nbsp;</th>																	
									<th>Action</th>				
									<th>Secure Area</th>					
									<th>Create<br/>button</th>	
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th>Product<br/>Item Number</th>					
									<th>Product<br/>Item Name</th>						
									<th>Regular<br/>Billing</th>									
									<th>&nbsp;</th>																			
									<th>Action</th>				
									<th>Secure Area</th>					
									<th>Create<br/>button</th>	
								</tr>
							</tfoot>			
							<tbody>
								<?php
									foreach( $table as $d_row ) {
								 ?>
								 <tr>
									<td><?php echo ($d_row["item_number"]); ?></td>							
									<td><?php echo ($d_row["item_name"]); ?></td>
									<td><?php echo ($d_row["currency"]); ?><?php echo ($d_row["a3"]); ?></td>
									<td>
										<?php echo($d_row['p3']);?> 
										<?php							
											switch ($d_row['t3']) 
											{
											case 'D' :
												echo("days");
												break;				
											case 'W' :
												echo("weeks");
												break;
											case 'M' :
												echo("months");
												break;		
											case 'Y' :
												echo("years");
												break;																		
											}
										?>												
									</td>							
									<td>
										<a href="<?php $_SERVER['PHP_SELF'] ?>?action=edit&recid=<?php echo($d_row["recid"]) ?>">
										<i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a> 
										&nbsp;&nbsp;
										<a href="<?php $_SERVER['PHP_SELF'] ?>?action=delete&recid=<?php echo($d_row["recid"]) ?>">
										<i class="fa fa-trash fa-2x" aria-hidden="true"></i></a>
									</td>
									<td><?php echo( getsecureareaname($d_row['securearea_id']) );?></td>
									<td><a href="a_createbutton.php?recid=<?php echo($d_row["recid"]) ?>">Show buttons</a></td>
								</tr>
								<?php	
							}
							?>
							</tbody>			
						</table>

					<?php				
					}			
					?>

      			</div>
        	</div>
        
    	</div>                
        
		<?php
            require_once "code/footer_datatable.php";	
        ?>
        </body>
        </html>        
	<?php
}
//-----------------------------------
/**
* Purpose : Delete record from tblitems
* Input : The record id to be deleted
* 
*	@param int $recid
*	@return void
*/
function deleterecord($recid) {

	if (!is_numeric($recid)) { exit(); }

	$delete = deleteitem($recid);

	if ( $delete > 0 )
	{
		displaylist( "Record deleted: " . date("Y-m-d H:i:s"));		
	}
	else
	{
		displaylist( "Error - Unable to delete record" );
	}
}
//-----------------------------------
//Purpose : Asks if you want to delete the given item
//Inputs : the item_number to be deleted
function confirmdeletion($recid) {

	if (!is_numeric($recid)) { exit(); }
	
	require_once("code/header.php");	
	require_once("code/navigation.php");
	?>
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
  		<li><a href="a_items.php">List of Products</a></li>
	</ol> 
			
	  <div class="container">    
    
        <div class="row">   
            <div class="col-md-2"></div>    
            <div class="col-md-6">

			<h2>Confirm deletion</h2>
		
				<div class="frmbkg">     

					<form name="frmConfirmDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
						Are you sure you want to delete this item?<br><br>
						<input type="hidden" name="recid" value="<?php echo("$recid"); ?>" />
						<input type="submit" name="submit" value="Yes" class="btn btn-primary btn-sm" />
						&nbsp;&nbsp;&nbsp;
						<input type="submit" name="submit" value="No" class="btn btn-primary btn-sm" />		
					</form>

				</div>
	       
		   	</div>   
            <div class="col-md-4"></div>        
        </div>
    
    </div>

<?php
require_once ("code/footer_bootstrapjs.php");
}
//-----------------------------------
//Purpose : Edit the selected item
//Input :  the recid of the item
function edit($recid, $_message) {

	if (!is_numeric($recid)) { exit(); }
	
	$items = getproductdetails($recid);

	if (count($items) == 1) {
		$item_number 		= $items[0]["item_number"];
		$item_name 			= $items[0]["item_name"];
		$emailtext			= $items[0]["emailtext"];
		$emailsubject		= $items[0]["emailsubject"];
		$item_description	= $items[0]["item_description"];
		$publish			= $items[0]["publish"];
		$mc_currency		= $items[0]["mc_currency"];
		$item_image			= $items[0]["item_image"];
		$securearea_id		= $items[0]["securearea_id"];
		//Trail period 1
		$a1					= $items[0]["a1"];				//Cost 
		$p1					= $items[0]["p1"];				//Unit period
		$t1					= $items[0]["t1"];				//Unit of D, W, M or Y
		//Trail period 2
		$a2					= $items[0]["a2"];				//Cost
		$p2					= $items[0]["p2"];				//Unit period
		$t2					= $items[0]["t2"];				//Unit of D, W, M or Y		
		//Regular period 
		$a3					= $items[0]["a3"];				//Cost
		$p3					= $items[0]["p3"];				//Unit period
		$t3					= $items[0]["t3"];				//Unit of D, W, M or Y
		//Recurring data
		$src				= $items[0]['src'];				//Recurring payments
		$sra				= $items[0]['sra'];				//Reattempt on failure
		$srt				= $items[0]['srt'];				//Recurring times (installments)
		
	} else {
		displaylist( "Error with table, record not found " );
		exit();
	}

	require_once("code/header_forjs.php");
	?>
	<script language="javascript">
	
	//--------------------------------------------		
	function button_onclick(frmCreate) {
	
		var themessage = "Error in entries : ";
		var isOK = true;

		if ( frmCreate.txtItem_Number.value == "" ) {
			themessage = themessage + "\n" + "* Enter item number";
			isOK = false;
		}

		if ( frmCreate.txtItem_Name.value == "" ) {
			themessage = themessage + "\n" + "* Enter item name";
			isOK = false;
		}

		if ( frmCreate.txtEmailSubject.value == "" ) {
			themessage = themessage + "\n" + "* Enter email subject";
			isOK = false;			
		}

		if ( frmCreate.txtEmailText.value == "" ) {
			themessage = themessage + "\n" + "* Enter email text";
			isOK = false;		
		}


		if ( frmCreate.txtSecureArea_Id.value == "make a selection" ) {
			themessage = themessage + "\n" + "* Select a secure area in the drop down list";
			isOK = false;			
		}

		//--------------------------------
		//Trial 1
		if ( frmCreate.a1.value != "" ) {
		
			if ( !frmCreate.t1[0].checked && !frmCreate.t1[1].checked && !frmCreate.t1[2].checked && !frmCreate.t1[3].checked ) {
				themessage = themessage + "\n" + "* select a trail 1 cycle unit";
				isOK = false;		
			}
			
			if ( frmCreate.t1[0].checked ) {	//days 1 - 90
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 90 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* days value must be 1 - 90";
					isOK = false;
				}						
			}

			if ( frmCreate.t1[1].checked ) {  //weeks 1 - 52
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 52 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* weeks value must be 1 - 52";
					isOK = false;							
				}
			}

			if ( frmCreate.t1[2].checked ) {  //months 1 - 24
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 24 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* months value must be 1 - 24";
					isOK = false;						
				}
			}

			if ( frmCreate.t1[3].checked ) {  //years 1 - 5	
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 5 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* years value must be 1 - 5";
					isOK = false;						
				}						
			}
		
		}
		//end of trail 1
		//--------------------------------		

		//--------------------------------
		//Trial 2
		if ( frmCreate.a2.value != "" ) {
		
			if ( !frmCreate.t2[0].checked && !frmCreate.t2[1].checked && !frmCreate.t2[2].checked && !frmCreate.t2[3].checked ) {
				themessage = themessage + "\n" + "* select a trail 2 cycle unit";
				isOK = false;		
			}
			
			if ( frmCreate.t2[0].checked ) {	//days 1 - 90
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 90 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* days value must be 1 - 90";
					isOK = false;
				}						
			}

			if ( frmCreate.t2[1].checked ) {  //weeks 1 - 52
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 52 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* weeks value must be 1 - 52";
					isOK = false;							
				}
			}

			if ( frmCreate.t2[2].checked ) {  //months 1 - 24
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 24 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* months value must be 1 - 24";
					isOK = false;						
				}
			}

			if ( frmCreate.t2[3].checked ) {  //years 1 - 5	
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 5 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* years value must be 1 - 5";
					isOK = false;						
				}						
			}
		
		}
		//end of trail 2
		//--------------------------------

		//--------------------------------
		//Regular billing
		if ( frmCreate.a3.value == "" ) {
			themessage = themessage + "\n" + "* Enter regular billing cost";
			isOK = false;		
		}

		if ( !frmCreate.t3[0].checked && !frmCreate.t3[1].checked && !frmCreate.t3[2].checked && !frmCreate.t3[3].checked ) {
			themessage = themessage + "\n" + "* select a regular billing cycle unit";
			isOK = false;		
		}
		
		if ( frmCreate.t3[0].checked ) {	//days 1 - 90
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 90 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* days value must be 1 - 90";
				isOK = false;
			}						
		}

		if ( frmCreate.t3[1].checked ) {  //weeks 1 - 52
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 52 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* weeks value must be 1 - 52";
				isOK = false;							
			}
		}

		if ( frmCreate.t3[2].checked ) {  //months 1 - 24
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 24 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* months value must be 1 - 24";
				isOK = false;						
			}
		}

		if ( frmCreate.t3[3].checked ) {  //years 1 - 5	
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 5 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* years value must be 1 - 5";
				isOK = false;						
			}						
		}
		//end of regular billing
		//--------------------------------

		if ( isOK == false ) {
			window.alert(themessage);
		} else {
			frmCreate.submit(frmCreate);
		}

	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Trial 1
	function Payment_onchange_a1(frmCreate) {	
	
		if (frmCreate.a1.value != "") {
	
				if (!isNumber(frmCreate.a1.value)) {
					window.alert("Trial 1 - Enter a number with 2 decimal places");
					frmCreate.a1.focus();
				}
				else
				{
					position = frmCreate.a1.value.lastIndexOf(".");
					if (frmCreate.a1.value.substring(position).length != 3) {
						window.alert("Trial 1 - Enter 2 decimal places");
						frmCreate.a1.focus();	
					}
				}
	
		}
	
	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Trial 2
	function Payment_onchange_a2(frmCreate) {	
	
		if (frmCreate.a2.value != "") {
	
				if (!isNumber(frmCreate.a2.value)) {
					window.alert("Trial 2 - Enter a number with 2 decimal places");
					frmCreate.a2.focus();
				}
				else
				{
					position = frmCreate.a2.value.lastIndexOf(".");
					if (frmCreate.a2.value.substring(position).length != 3) {
						window.alert("Trial 2 - Enter 2 decimal places");
						frmCreate.a2.focus();	
					}
				}
		
		}
		
	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Regular billing
	function Payment_onchange_a3(frmCreate) {		
		if (!isNumber(frmCreate.a3.value)) {
			window.alert("Regular billing - Enter a number with 2 decimal places");
			frmCreate.a3.focus();
		}
		else
		{
			position = frmCreate.a3.value.lastIndexOf(".");
			if (frmCreate.a3.value.substring(position).length != 3) {
				window.alert("Regular billing - Enter 2 decimal places");
				frmCreate.a3.focus();	
			}
		}
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Trial 1
	function checkdurationvalue_onchange_p1(frmCreate) {
		
		if ( !isNumeric(frmCreate.p1.value) ) {
			window.alert("Value must be numeric with no decimal places");
			frmCreate.p1.focus();
		}
	
	}
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Trial 2
	function checkdurationvalue_onchange_p2(frmCreate) {
		
		if ( !isNumeric(frmCreate.p2.value) ) {
			window.alert("Value must be numeric with no decimal places");
			frmCreate.p2.focus();
		}
	
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Regular billing
	function checkdurationvalue_onchange_p3(frmCreate) {
		
		if ( !isNumeric(frmCreate.p3.value) ) {
			window.alert("Value must be numeric with no decimal places");
			frmCreate.p3.focus();
		}
	
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Recurring times
	function checkdurationvalue_onchange_srt(frmCreate) {
		
		if ( !isNumeric(frmCreate.srt.value) ) {
			window.alert("Value must be numeric with no decimal places");
			frmCreate.srt.focus();
		}
	
	}	
	//--------------------------------------------
	//Checks the number is a positive numeric value with
	//one decimal point
	function isNumber(inputVal) {
		oneDecimal = false;
		inputStr = inputVal.toString();
		for (var i = 0; i < inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);
			if (oneChar == "."  && !oneDecimal) {
				oneDecimal = true;
				continue;
			}
			if (oneChar < "0" || oneChar > "9") {
				return false;
			}		
		}
		
		if (oneDecimal == false) {
			return false; }
			else {
			return true; }
					
	}
	//--------------------------------------------
	//Checks if the entry is numeric
	function isNumeric(inputVal) {
		numeric = true;
		inputStr = inputVal.toString();
		for (var i = 0; i< inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);

			if (oneChar < "0" || oneChar > "9") {
				return false;
			}		

		}

		if (numeric == false) {
			return false; }
			else {
			return true; }

	}	
	//--------------------------------------------
	//checks that the characters are a - z and 0 - 9 only
	function isValidCharacters(frmCreate) {
		var inputStr = frmCreate.txtItem_Number.value.toString().toLowerCase();
		var validChars = "abcdefghijklmnopqrstuvwxyz0123456789 _-";
	
		for (var i = 0; i < inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);			
			var charpos = validChars.indexOf(oneChar);
			if (charpos < 0) {
				frmCreate.txtItem_Number.value = ""
				frmCreate.txtItem_Number.focus();
				alert("a-z 0-9 _ - and space characters only");
			}
		}	
	}	

	</script>
	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />	
	
</head>	
<body>

	<?php    
	require_once "code/navigation.php";  
    ?>
    
  	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
       	<li><a href="a_items.php">List of Products</a></li>
	</ol>
	
 	<div class="container">
  
   		<div class="row">   
            <div class="col-md-2"></div>    
            <div class="col-md-8">      	        

				<h2>Edit a product item</h2>

   					<div class="frmbkg">

						<form name="frmCreate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
						
							<input type="hidden" name="txtRecId" value="<?php echo("$recid"); ?>" />
							<input type ="hidden" name="page" value="<?php echo($pageno); ?>" />

							<div class = "form-group">
                            	<h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
                        	</div>                     
            
							<div class = "form-group">
								<input type="button" name="Update" value="Update" class="btn btn-primary btn-sm" language="javascript" onClick="return button_onclick(frmCreate)" />
								<input type="hidden" name="Update" value="Update" />
							</div>

							<div class = "form-group">
								<label for="txtItem_Number"><strong>Product item number</strong></label>
								<input type="text" name="txtItem_Number" id="txtItem_Number" value="<?php echo("$item_number"); ?>" class="form-control" placeholder="Product item number" language="javascript" onChange="return isValidCharacters(frmCreate)" />
							</div>
							
							<div class = "form-group">
								<label for="txtItem_Name"><strong>Product Item Name (brief)</strong></label>
								<input type="text" name="txtItem_Name" id="txtItem_Name" value="<?php echo("$item_name"); ?>" placeholder="The brief name of the product" class="form-control" />
							</div>						
						
							<div class = "form-group">							
								<label for="txtMc_Currency"><strong>Currency</strong></label>
								<select name="txtMc_Currency" id="txtMc_Currency" class="form-control">
									<option value="AUD" <?php if ($mc_currency == "AUD") echo("selected"); ?>>Australian Dollar</option>				
									<option value="CAD" <?php if ($mc_currency == "CAD") echo("selected"); ?>>Canadian Dollar</option>
									<option value="CHF" <?php if ($mc_currency == "CHF") echo("selected"); ?>>Swiss Franc</option>
									<option value="CZK" <?php if ($mc_currency == "CZK") echo("selected"); ?>>Czech Koruna</option>
									<option value="DKK" <?php if ($mc_currency == "DKK") echo("selected"); ?>>Danish Krone</option>
									<option value="EUR" <?php if ($mc_currency == "EUR") echo("selected"); ?>>Euro</option>
									<option value="GBP" <?php if ($mc_currency == "GBP") echo("selected"); ?>>Pound Sterling</option>
									<option value="HKD" <?php if ($mc_currency == "HKD") echo("selected"); ?>>Hong Kong Dollar</option>					
									<option value="HUF" <?php if ($mc_currency == "HUF") echo("selected"); ?>>Hungarian Forint</option>	
									<option value="JPY" <?php if ($mc_currency == "JPY") echo("selected"); ?>>Japanese Yen</option>						
									<option value="NOK" <?php if ($mc_currency == "NOK") echo("selected"); ?>>Norwegian Krone</option>					
									<option value="NZD" <?php if ($mc_currency == "NZD") echo("selected"); ?>>New Zealand Dollar</option>					
									<option value="PLN" <?php if ($mc_currency == "PLN") echo("selected"); ?>>Polish Zloty</option>					
									<option value="SEK" <?php if ($mc_currency == "SEK") echo("selected"); ?>>Swedish Krona</option>					
									<option value="SGD" <?php if ($mc_currency == "SGD") echo("selected"); ?>>Singapore Dollar</option>						
									<option value="USD" <?php if ($mc_currency == "" || $mc_currency == "USD") echo("selected"); ?>>U.S. Dollar</option>
								</select>			
							</div>

							<div class = "form-group">	
								<!-- Display available secure areas from tblsecureareas -->											
								<label for="txtSecureArea_Id"><strong>Secure Area</strong></label>
								<select name="txtSecureArea_Id" id="txtSecureArea_Id" class="form-control">
									<?php
									$table = securearealist();

									foreach( $table as $d_row_sa ) {
										?><option value="<?php echo($d_row_sa['recid']); ?>" <?php if ( $d_row_sa['recid'] == $securearea_id ) { echo("selected"); } ?>><?php echo($d_row_sa['securearea_name']); ?></option><?php
									}
									?>
								</select>
							</div>
	
							<div class="row">
								<div class="col-md-3">
									<label><strong>Subscription details</strong></label>								
								</div>							
								<div class="col-md-9">
								
								<div class="frmbkg">
							
									<div class = "form-group">
										<p class="orangetext">Trial 1</p>
									</div>						

									<div class = "form-group">	
										<label for="a1"><strong>Trial 1 billing cost : </strong></label>
										<input type="text" name="a1" id="name" value="<?php echo($a1); ?>" class="form-control" placeholder="Leave blank to ignore trial, or a number to 2 decimal places" language="javascript" onChange="return Payment_onchange_a1(frmCreate)" /> 0.00 = free, blank = ignore
									</div>

									<div class = "form-group">	
										<label for="p1"><strong>Trial 1 billing cycle : </strong></label>
										<input type="number" name="p1" class="form-control" placeholder="An integer value" value="<?php if ($p1 != 0) {echo($p1);} ?>" language="javascript" onChange="return checkdurationvalue_onchange_p1(frmCreate)" />
									</div>									

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">

											<label for="t1"><strong>Trial 1 cycle units :</strong></label><br/>									
											<label class="btn">
												<input type="radio" name="t1" value="D" <?php if ($t1 == "D") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t1" value="W" <?php if ($t1 == "W") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t1" value="M" <?php if ($t1 == "M") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t1" value="Y" <?php if ($t1 == "Y") { echo(" checked "); } ?>  />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>
										</div>

									</div>
								
								
									<div class = "form-group">
										<p class="orangetext">Trial 2</p>
									</div>

									<div class = "form-group">
										<label for="a2"><strong>Trial 2 billing cost : </strong></label>
										<input type="text" name="a2" id="a2" value="<?php echo($a2); ?>" class="form-control" placeholder="Leave blank to ignore trial, or a number to 2 decimal places" language="javascript" onChange="return Payment_onchange_a2(frmCreate)" /> 0.00 = free, blank = ignore
									</div>

									<div class = "form-group">
										<label for="p2"><strong>Trial 2 billing cycle :</strong></label>
										<input type="number" name="p2" id="p2" value="<?php if ($p2 != 0) {echo($p2);} ?>" class="form-control" placeholder="An integer value" language="javascript" onChange="return checkdurationvalue_onchange_p2(frmCreate)" />										
									</div>							
								
									<div class = "form-group">
									
										<div class="form-group btn-group" data-toggle="buttons">
											<label for="t2"><strong>Trial 2 cycle units :</strong></label><br/>
											<label class="btn">
											  <input type="radio" name="t2" value="D" <?php if ($t2 == "D") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t2" value="W" <?php if ($t2 == "W") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t2" value="M" <?php if ($t2 == "M") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t2" value="Y" <?php if ($t2 == "Y") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>																
										</div>
																
									</div>
			
									<div class = "form-group">
										<p class="orangetext">Regular billing</p>
									</div>									
									
									<div class = "form-group">
										<strong>Regular billing cost : </strong>
										<input type="text" name="a3" id="a3" value="<?php echo($a3); ?>" class="form-control" placeholder="A number to 2 decimal places" language="javascript" onChange="return Payment_onchange_a3(frmCreate)" />
									</div>
						
									<div class = "form-group">
										<strong>Regular billing cycle : </strong>
										<input type="number" name="p3" id="p3" value="<?php echo($p3); ?>" class="form-control" placeholder="An integer value" language="javascript" onChange="return checkdurationvalue_onchange_p3(frmCreate)" />
									</div>									
				
									<div class = "form-group">
																	
										<div class="form-group btn-group" data-toggle="buttons">
											<label for="t3"><strong>Regular billing cycle units :</strong></label><br/>
											<label class="btn">
											  <input type="radio" name="t3" value="D" <?php if ($t3 == "D") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t3" value="W" <?php if ($t3 == "W") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t3" value="M" <?php if ($t3 == "M") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t3" value="Y" <?php if ($t3 == "Y") { echo(" checked "); } ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>																
										</div>
										
									</div>													
			
									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="src"><strong>Recurring payments :</strong></label><br/>
											<label class="btn">
											  <input type="radio" name="src" value="1" <?php if ($src == 1){echo(" checked ");} ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Yes</span>
											</label>
											<label class="btn">
											  <input type="radio" name="src" value="0" <?php if ($src == 0){echo(" checked ");} ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> No</span>
											</label>											
										</div>
										
									</div>
									
									<div class = "form-group">
										
										<div class="form-group btn-group" data-toggle="buttons">
											<label for="sra"><strong>Reattempt on failure : </strong></label><br/>
											<label class="btn">
											  <input type="radio" name="sra" value="1" <?php if ($sra == 1){echo(" checked ");} ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Yes</span>
											</label>
											<label class="btn">
											  <input type="radio" name="sra" value="0" <?php if ($sra == 0){echo(" checked ");} ?> />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> No</span>
											</label>											
										</div>										
										
									</div>
									
									<div class = "form-group">									
										<label for="srt"><strong>Recurring times (installments) : </strong></label>
										<input type="number" name="srt" class="form-control" placeholder="Installments (integer value)" value="<?php echo($srt); ?>" language="javascript" onChange="return checkdurationvalue_onchange_srt(frmCreate)" />
									</div>
							
							
								</div>
						
							</div>
						</div>	
		
						<div class = "form-group">	
							<label for="txtEmailSubject"><strong>Email Subject</strong></label>
							<textarea name="txtEmailSubject" id="txtEmailSubject" rows="3" class="form-control"><?php echo("$emailsubject"); ?></textarea>
						</div>

						<div class = "form-group">
							<label for="txtEmailText"><strong>Email Text</strong></label>
							<br/>Login url, username and password are substituted for <strong>&lt;login_url&gt;</strong>, <strong>&lt;payer_email&gt;</strong> and <strong>&lt;password&gt;</strong> when the email is sent.
							<textarea name="txtEmailText" id="txtEmailText" rows="7" class="form-control"><?php echo("$emailtext"); ?></textarea>			
						</div>		

					</form>
					<!-- END OF MAIN FORM -->
	
				</div>
	
 		</div>
        <div class="col-md-2"></div>		
	</div>
		
</div>	
		
<?php
require_once("code/footer_bootstrapjs.php");
}
//-----------------------------------
//Purpose : Update the selected item
//Inputs : item_number, item_name, recid, emailsubject, emailtext, item_description, item_image, publish, mc_currency, currency, securearea_id, a1, p1, t1, a2, p2, t2, a3, p3, t3, src, sra, srt
function update($item_number, $item_name, $recid, $emailsubject, $emailtext, $item_description, $item_image, $publish, $mc_currency, $currency, $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, $t3, $src, $sra, $srt) {

	//echo($freeproduct);
	//exit();

	if ($a1 == "0.00") {$a1 = "0";}
	if ($a1 == "") {	//if a1 is blank, then re-set t1
		$p1 = "";
		$t1 = "";
	}
	if ($a2 == "") {	//if a2 is blank, then re-set t2
		$p2 = "";
		$t2 = "";
	}
	
	//these are needed to give a value so that insert statement will work
	if ($p1 == "") {$p1 = 0;}	
	if ($p2 == "") {$p2 = 0;}	
	if ($srt == "") {$srt = 0;}

	/*
	echo("item_number : $item_number<br/>");
	echo("item_name : $item_name<br/>");
	echo("recid : $recid <br/>");
	echo("emailsubject : $emailsubject<br/>");
	echo("emailtext : $emailtext<br/>");
	echo("item description : $item_description<br/>");
	echo("item image : $item_image<br/>");
	echo("publish : $publish<br/>");
	echo("mc currency : $mc_currency<br/>");
	echo("currency : $currency<br/>");
	echo("securearea id : $securearea_id<br/>");
	echo("a1 : $a1 <br/>");
	echo("p1 : $p1 <br/>");
	echo("t1 : $t1 <br/>");
	echo("a2 : $a2 <br/>");
	echo("p2 : $p2 <br/>");
	echo("t2 : $t2 <br/>");
	echo("a3 : $a3 <br/>");
	echo("p3 : $p3 <br/>");
	echo("t3 : $t3 <br/>");
	echo("src : $src <br/>");
	echo("sra : $sra <br/>");
	echo("srt : $srt <br/>");
	exit();	
	*/	
	
	if (checkitemnumberupdate($item_number, $recid) == 0) {
		
		$update = updateitem($item_number, $item_name, $recid, $emailsubject, $emailtext, $item_description, $item_image, 
							 $publish, $mc_currency, $currency, $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, 
							 $t3, $src, $sra, $srt);
		
		if ($update == 1)
		{
			edit($recid, "Record updated " . date("Y-m-d H:i:s") );
		}
		else
		{
			edit($recid, "Record NOT updated " . date("Y-m-d H:i:s"));
		}		
		
	} else {
	
		displaylist( "Item number already exists in table" );
	
	}

}
?>