<?php
//--------------------------------------
//display information about sales
//--------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//--------------------------------------

//--------------------------------------
main();

//--------------------------------------
function main() {
	
	require_once "code/header.php";
	require_once "code/navigation.php";	
	?>

		<ol class="breadcrumb">
			<li><a href="index1.php">Home</a></li>
		</ol>    

		<div class="container">

			<div class="row">   
				<div class="col-md-12">
					<h2>Sales totals</h2>
				</div>   
			</div>

				<?php

				$rangebutton	= input::get('rangebutton');

				//echo($rangebutton);

				if ( $rangebutton == "" ) {	//if this is the first time, then base the range on the oldest completed date

					$toyear = date("Y");
					$tomonth = date("m");
					$today = date("d");

					$oldest = getoldestdate();	//oldest completed data	
					$formatoldest = strtotime($oldest);
					$fromyear = date("Y",$formatoldest);
					$frommonth = date("m",$formatoldest);
					$fromday = date("d",$formatoldest);

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);	

				}
				elseif ($rangebutton == "Today"){

					$toyear = date("Y");
					$tomonth = date("m");
					$today = date("d");
					$fromyear = date("Y");
					$frommonth = date("m");
					$fromday = date("d");

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);

					$fromdate = $fromyear."-".$frommonth."-".$fromday;
					$todate = $toyear."-".$tomonth."-".$today." 23:59:59";		

					displayresults($fromdate, $todate);

				}
				elseif ($rangebutton == "Last 7 Days"){

					$lastweek = mktime (0,0,0,date("m"),date("d")-7,  date("Y"));
					$toyear = date("Y");
					$tomonth = date("m");
					$today = date("d");
					$fromyear = date("Y",$lastweek);
					$frommonth = date("m",$lastweek);
					$fromday = date("d",$lastweek);

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);		

					$fromdate = $fromyear."-".$frommonth."-".$fromday;
					$todate = $toyear."-".$tomonth."-".$today." 23:59:59";		

					displayresults($fromdate, $todate);

				}
				elseif ($rangebutton == "Last Month"){

					$lastweek = mktime (0,0,0,date("m")-1,date("d"),  date("Y"));
					$toyear = date("Y");
					$tomonth = date("m");
					$today = date("d");
					$fromyear = date("Y",$lastweek);
					$frommonth = date("m",$lastweek);
					$fromday = date("d",$lastweek);

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);		

					$fromdate = $fromyear."-".$frommonth."-".$fromday;
					$todate = $toyear."-".$tomonth."-".$today." 23:59:59";		

					displayresults($fromdate, $todate);

				}
				elseif ($rangebutton == "To / From"){

					$fromday 		= $_POST['fromday'];
					$frommonth 		= $_POST['frommonth'];
					$fromyear 		= $_POST['fromyear'];
					$today	 		= $_POST['today'];
					$tomonth 		= $_POST['tomonth'];
					$toyear	 		= $_POST['toyear'];

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);		

					$fromdate = $fromyear."-".$frommonth."-".$fromday;
					$todate = $toyear."-".$tomonth."-".$today." 23:59:59";		

					displayresults($fromdate, $todate);

				}
				elseif ($rangebutton == "All"){	

					$oldest = getoldestdate();	//oldest completed data	

					$toyear = date("Y");
					$tomonth = date("m");
					$today = date("d");			
					$formatoldest = strtotime($oldest);
					$fromyear = date("Y",$formatoldest);
					$frommonth = date("m",$formatoldest);
					$fromday = date("d",$formatoldest);

					displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear);		

					$fromdate = $fromyear."-".$frommonth."-".$fromday;
					$todate = $toyear."-".$tomonth."-".$today." 23:59:59";		

					displayresults($fromdate, $todate);

				}

				?>

		</div>

<?php require_once ("code/footer_bootstrapjs.php");
}
//--------------------------------------
//Purpose: Display the sales with the given dates
function displayinput($fromday, $frommonth, $fromyear, $today, $tomonth, $toyear) {

	//echo("$fromday" . "-" . "$frommonth" . "-" . "$fromyear<br>");
	//echo("$today" . "-"  . "$tomonth" . "-" . "$toyear");

	?>
			
	<div class="row">   
		<div class="col-md-12">										
			
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">

				<table border="0" align="center">
					<tr>
						<td width="27%"><strong>From</strong></td>
						<td width="35%"><strong>To</strong> 
						</td>
					</tr>
					<tr>
						<td>

							<select name="frommonth">
								<option value="1" <?php if ($frommonth == "01") {echo"selected";} ?> >Jan</option>
								<option value="2" <?php if ($frommonth == "02") {echo"selected";} ?> >Feb</option>
								<option value="3" <?php if ($frommonth == "03") {echo"selected";} ?> >Mar</option>
								<option value="4" <?php if ($frommonth == "04") {echo"selected";} ?> >Apr</option>
								<option value="5" <?php if ($frommonth == "05") {echo"selected";} ?> >May</option>
								<option value="6" <?php if ($frommonth == "06") {echo"selected";} ?> >Jun</option>
								<option value="7" <?php if ($frommonth == "07") {echo"selected";} ?> >Jul</option>
								<option value="8" <?php if ($frommonth == "08") {echo"selected";} ?> >Aug</option>
								<option value="9" <?php if ($frommonth == "09") {echo"selected";} ?> >Sep</option>
								<option value="10" <?php if ($frommonth == "10") {echo"selected";} ?> >Oct</option>
								<option value="11" <?php if ($frommonth == "11") {echo"selected";} ?> >Nov</option>
								<option value="12" <?php if ($frommonth == "12") {echo"selected";} ?> >Dec</option>
							</select>

							<select name="fromday">
								<option value="01" <?php if ($fromday == "01") {echo"selected";} ?> >1</option>
								<option value="02" <?php if ($fromday == "02") {echo"selected";} ?> >2</option>
								<option value="03" <?php if ($fromday == "03") {echo"selected";} ?> >3</option>
								<option value="04" <?php if ($fromday == "04") {echo"selected";} ?> >4</option>
								<option value="05" <?php if ($fromday == "05") {echo"selected";} ?> >5</option>
								<option value="06" <?php if ($fromday == "06") {echo"selected";} ?> >6</option>
								<option value="07" <?php if ($fromday == "07") {echo"selected";} ?> >7</option>
								<option value="08" <?php if ($fromday == "08") {echo"selected";} ?> >8</option>
								<option value="09" <?php if ($fromday == "09") {echo"selected";} ?> >9</option>
								<option value="10" <?php if ($fromday == "10") {echo"selected";} ?> >10</option>
								<option value="11" <?php if ($fromday == "11") {echo"selected";} ?> >11</option>
								<option value="12" <?php if ($fromday == "12") {echo"selected";} ?> >12</option>
								<option value="13" <?php if ($fromday == "13") {echo"selected";} ?> >13</option>
								<option value="14" <?php if ($fromday == "14") {echo"selected";} ?> >14</option>
								<option value="15" <?php if ($fromday == "15") {echo"selected";} ?> >15</option>
								<option value="16" <?php if ($fromday == "16") {echo"selected";} ?> >16</option>
								<option value="17" <?php if ($fromday == "17") {echo"selected";} ?> >17</option>
								<option value="18" <?php if ($fromday == "18") {echo"selected";} ?> >18</option>
								<option value="19" <?php if ($fromday == "19") {echo"selected";} ?> >19</option>
								<option value="20" <?php if ($fromday == "20") {echo"selected";} ?> >20</option>
								<option value="21" <?php if ($fromday == "21") {echo"selected";} ?> >21</option>
								<option value="22" <?php if ($fromday == "22") {echo"selected";} ?> >22</option>
								<option value="23" <?php if ($fromday == "23") {echo"selected";} ?> >23</option>
								<option value="24" <?php if ($fromday == "24") {echo"selected";} ?> >24</option>
								<option value="25" <?php if ($fromday == "25") {echo"selected";} ?> >25</option>
								<option value="26" <?php if ($fromday == "26") {echo"selected";} ?> >26</option>
								<option value="27" <?php if ($fromday == "27") {echo"selected";} ?> >27</option>
								<option value="28" <?php if ($fromday == "28") {echo"selected";} ?> >28</option>
								<option value="29" <?php if ($fromday == "29") {echo"selected";} ?> >29</option>
								<option value="30" <?php if ($fromday == "30") {echo"selected";} ?> >30</option>
								<option value="31" <?php if ($fromday == "31") {echo"selected";} ?> >31</option>
							</select>

							<select name="fromyear">							
								<option value="2016" <?php if ($fromyear == "2016") {echo"selected";} ?> >2016</option>        
								<option value="2017" <?php if ($fromyear == "2017") {echo"selected";} ?> >2017</option>
								<option value="2018" <?php if ($fromyear == "2018") {echo"selected";} ?> >2018</option>
								<option value="2019" <?php if ($fromyear == "2019") {echo"selected";} ?> >2019</option>
								<option value="2020" <?php if ($fromyear == "2020") {echo"selected";} ?> >2020</option>
                                <option value="2021" <?php if ($fromyear == "2021") {echo"selected";} ?> >2021</option>
								<option value="2022" <?php if ($fromyear == "2022") {echo"selected";} ?> >2022</option>        
								<option value="2023" <?php if ($fromyear == "2023") {echo"selected";} ?> >2023</option>
								<option value="2024" <?php if ($fromyear == "2024") {echo"selected";} ?> >2024</option>
								<option value="2025" <?php if ($fromyear == "2025") {echo"selected";} ?> >2025</option>
								<option value="2026" <?php if ($fromyear == "2026") {echo"selected";} ?> >2026</option>
								<option value="2027" <?php if ($fromyear == "2027") {echo"selected";} ?> >2027</option>
							</select>

					</td>
					<td>

							<select name="tomonth">
								<option value="1" <?php if ($tomonth == "01") {echo"selected";} ?> >Jan</option>
								<option value="2" <?php if ($tomonth == "02") {echo"selected";} ?> >Feb</option>
								<option value="3" <?php if ($tomonth == "03") {echo"selected";} ?> >Mar</option>
								<option value="4" <?php if ($tomonth == "04") {echo"selected";} ?> >Apr</option>
								<option value="5" <?php if ($tomonth == "05") {echo"selected";} ?> >May</option>
								<option value="6" <?php if ($tomonth == "06") {echo"selected";} ?> >Jun</option>
								<option value="7" <?php if ($tomonth == "07") {echo"selected";} ?> >Jul</option>
								<option value="8" <?php if ($tomonth == "08") {echo"selected";} ?> >Aug</option>
								<option value="9" <?php if ($tomonth == "09") {echo"selected";} ?> >Sep</option>
								<option value="10" <?php if ($tomonth == "10") {echo"selected";} ?> >Oct</option>
								<option value="11" <?php if ($tomonth == "11") {echo"selected";} ?> >Nov</option>
								<option value="12" <?php if ($tomonth == "12") {echo"selected";} ?> >Dec</option>
							</select>

							<select name="today">
								<option value="1" <?php if ($today == "01") {echo"selected";} ?> >1</option>
								<option value="2" <?php if ($today == "02") {echo"selected";} ?> >2</option>
								<option value="3" <?php if ($today == "03") {echo"selected";} ?> >3</option>
								<option value="4" <?php if ($today == "04") {echo"selected";} ?> >4</option>
								<option value="5" <?php if ($today == "05") {echo"selected";} ?> >5</option>
								<option value="6" <?php if ($today == "06") {echo"selected";} ?> >6</option>
								<option value="7" <?php if ($today == "07") {echo"selected";} ?> >7</option>
								<option value="8" <?php if ($today == "08") {echo"selected";} ?> >8</option>
								<option value="9" <?php if ($today == "09") {echo"selected";} ?> >9</option>
								<option value="10" <?php if ($today == "10") {echo"selected";} ?> >10</option>
								<option value="11" <?php if ($today == "11") {echo"selected";} ?> >11</option>
								<option value="12" <?php if ($today == "12") {echo"selected";} ?> >12</option>
								<option value="13" <?php if ($today == "13") {echo"selected";} ?> >13</option>
								<option value="14" <?php if ($today == "14") {echo"selected";} ?> >14</option>
								<option value="15" <?php if ($today == "15") {echo"selected";} ?> >15</option>
								<option value="16" <?php if ($today == "16") {echo"selected";} ?> >16</option>
								<option value="17" <?php if ($today == "17") {echo"selected";} ?> >17</option>
								<option value="18" <?php if ($today == "18") {echo"selected";} ?> >18</option>
								<option value="19" <?php if ($today == "19") {echo"selected";} ?> >19</option>
								<option value="20" <?php if ($today == "20") {echo"selected";} ?> >20</option>
								<option value="21" <?php if ($today == "21") {echo"selected";} ?> >21</option>
								<option value="22" <?php if ($today == "22") {echo"selected";} ?> >22</option>
								<option value="23" <?php if ($today == "23") {echo"selected";} ?> >23</option>
								<option value="24" <?php if ($today == "24") {echo"selected";} ?> >24</option>
								<option value="25" <?php if ($today == "25") {echo"selected";} ?> >25</option>
								<option value="26" <?php if ($today == "26") {echo"selected";} ?> >26</option>
								<option value="27" <?php if ($today == "27") {echo"selected";} ?> >27</option>
								<option value="28" <?php if ($today == "28") {echo"selected";} ?> >28</option>
								<option value="29" <?php if ($today == "29") {echo"selected";} ?> >29</option>
								<option value="30" <?php if ($today == "30") {echo"selected";} ?> >30</option>
								<option value="31" <?php if ($today == "31") {echo"selected";} ?> >31</option>
							</select>

							<select name="toyear">							
								<option value="2016" <?php if ($toyear == "2016") {echo"selected";} ?> >2016</option>        
								<option value="2017" <?php if ($toyear == "2017") {echo"selected";} ?> >2017</option>
								<option value="2018" <?php if ($toyear == "2018") {echo"selected";} ?> >2018</option>
								<option value="2019" <?php if ($toyear == "2019") {echo"selected";} ?> >2019</option>
								<option value="2020" <?php if ($toyear == "2020") {echo"selected";} ?> >2020</option>                                  
                                <option value="2021" <?php if ($toyear == "2021") {echo"selected";} ?> >2021</option>
								<option value="2022" <?php if ($toyear == "2022") {echo"selected";} ?> >2022</option>
								<option value="2023" <?php if ($toyear == "2023") {echo"selected";} ?> >2023</option>
								<option value="2024" <?php if ($toyear == "2024") {echo"selected";} ?> >2024</option>
								<option value="2025" <?php if ($toyear == "2025") {echo"selected";} ?> >2025</option>
								<option value="2026" <?php if ($toyear == "2026") {echo"selected";} ?> >2016</option>
								<option value="2027" <?php if ($toyear == "2027") {echo"selected";} ?> >2017</option>
                                
							</select> 

					</td>
				</tr>
				<tr>
						<td colspan="2" align="left">
							<p>&nbsp;</p>
							<input type="submit" name="rangebutton" value="All" class="btn btn-primary btn-sm" />
							<input type="submit" name="rangebutton" value="To / From" class="btn btn-primary btn-sm" />
							<input type="submit" name="rangebutton" value="Last Month" class="btn btn-primary btn-sm" />
							<input type="submit" name="rangebutton" value="Last 7 Days" class="btn btn-primary btn-sm" />
							<input type="submit" name="rangebutton" value="Today" class="btn btn-primary btn-sm" />
						</td>
				</tr>
			</table>

		</form>

 		</div>   
   	</div>

<?php
}
//--------------------------------------	
// get a list of items from the table saleshistory
function displayresults($fromdate, $todate) {

	// echo ("$fromdate <br> $todate");		
	
	$table = sales($fromdate, $todate);	
	?>
	
	<div class="row">   
		<div class="col-md-12">	
	
			<table align="center" cellpadding="0" cellspacing="0" class="tableoutline">
			<tr>
			<td>	

				<table border="0" align="center" cellpadding="4" cellspacing="0">
				<tr class="darkblue">
					<td align="right" class="orangetitle">Item</td>
					<td></td>
					<td align="right" class="orangetitle">Purchaser</td>
					<td></td>			
					<td align="right" class="orangetitle">Date</td>
					<td></td>
					<td align="right" class="orangetitle">Value</td>
				</tr>

				<?php

				$color = 0;

				foreach( $table as $d_row ) {

					if ($color == 0){
						?><tr class="lightgrey">
						<?php
							$color = 1;
					} else {
						?><tr class="darkgrey">
						<?php
						$color = 0;
					}

					?>

					<td align="right"><?php echo($d_row['item_name']); ?></td>
					<td width="15">&nbsp;</td>
					<td align="right"><?php echo($d_row['payer_email']); ?></td>
					<td width="15">&nbsp;</td>
					<td align="right"><?php
							echo( date("D", strtotime($d_row['completed'])) );
							echo(" ");					
							echo( date("d", strtotime($d_row['completed'])) );
							echo(" ");										
							echo( date("M", strtotime($d_row['completed'])) );					
							echo(" ");										
							echo( date("Y", strtotime($d_row['completed'])) );
					?>
					</td>
					<td width="15">&nbsp;</td>
					<td align="right"><?php echo($d_row['mc_gross']); ?></td>
					</tr>
				<?php
				}
				?>
				</tr>

				<tr class="lightgrey">

					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>		
					<td align="right"><strong>Total : </strong><?php echo(gettotal($fromdate, $todate)); ?></td>

				</tr>		
				</table>

			</td>
			</tr>
			</table>

	</div>
</div>

<?php
}