<?php
//-----------------------------------
//Edits the sec_tblsetup table
//-----------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

// 30/12/2024 V2.9.6
// removed unused variable $currency


require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../dbclass/Db.class.php");
require_once("../classes/clsinput.php");
require_once("../functions/misc.php");
//----------------------------------------------

main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

$inputSubmit = input::get('Submit');

if ($inputSubmit == 'Update') {
		
		$sitetitle			= input::get('txtSiteTitle');
		$paypaladdress 		= trim(input::get('txtPayPalAddress'));
		$adminaddress 		= trim(input::get('txtAdminAddress'));	
		
		if ( input::get('txtCopyEmail') == "on") 
			{$copyemail = 1;}
		else
			{$copyemail = 0;}	
	
		$cancel_url				= input::get('txtCancel_URL');
		$return_url				= input::get('txtReturn_URL');		
		
		$mc_currency			= input::get('txtCurrency');

		//$referring_server		= $_POST['txtReferring_Server'];
		$referring_server		= "";
		
		$sandbox_seller			= trim ( input::get('txtSandbox_Seller') );

		$install_folder			= input::get('txtInstall_Folder');		
		$install_folder			= checkurl($install_folder);

		$notify_url				= input::get('txtNotify_URL');
		$notify_sandbox_url		= input::get('txtNotify_Sandbox_URL');
		$password_location		= slashonend(input::get('txtPassword_Location'));		
	
		$notify_url				= $install_folder . "ipn/confirm.php";
		$notify_sandbox_url		= $install_folder . "ipn_sandbox/confirm.php";

		$protection_type		= input::get('txtProtection_Type');

		update($paypaladdress,  $adminaddress, $copyemail, $mc_currency, $sandbox_seller, $referring_server, $sitetitle, $cancel_url, $return_url, $notify_url, $notify_sandbox_url, $install_folder, $protection_type, $password_location);
		display("Record updated " . date("Y-m-d H:i:s"));
		
		} else {
			display(""); 
		}
}
//-----------------------------------
//Purpose :	Checks if the last character of url is "/"
//			If not it adds it on.
function checkurl($folder) {

	if (substr($folder, strlen($folder) - 1, 1) != "/") {
		$folder = $folder . "/";
	}
	return $folder;

}
//-----------------------------------
//Purpose : Update the selected item, (there is only one record in table setup which is record number 1)
//Inputs : paypaladdress, adminaddress, copyemail, mc_currency, sandbox_seller, referring_server, sitetitle, cancel_url, return_url, notify_url, notify_sandbox_url, install_folder, protection_type, password_location
function update($paypaladdress, $adminaddress, $copyemail, $mc_currency, $sandbox_seller, $referring_server, $sitetitle, $cancel_url, $return_url, $notify_url, $notify_sandbox_url, $install_folder, $protection_type, $password_location) {

	//$currency = getcurrency($mc_currency);

	if ($adminaddress == "") {
		$adminaddress = $paypaladdress;
	}

	//update	
	$update = updateglobal($paypaladdress, $adminaddress, $copyemail, $mc_currency, $sandbox_seller, 
						   $referring_server, $sitetitle, $cancel_url, $return_url, $notify_url, 
						   $notify_sandbox_url, $install_folder, $protection_type, $password_location);

	return $update;
}
//-----------------------------------
//Purpose : Display and edit the record
//Input :  Any error message
function display($msg) {	
	
	$items 				= gettblsetup();	
	
		$sitetitle			= $items[0]["sitetitle"];
		$paypaladdress 		= $items[0]["paypaladdress"];
		$copyemail			= $items[0]["copyemail"];	
		$mc_currency		= $items[0]["mc_currency"];

		$referring_server	= $items[0]["referring_server"];	
		$sandbox_seller		= $items[0]["sandbox_seller"];

		$cancel_url			= $items[0]["cancel_url"];
		$return_url			= $items[0]["return_url"];	
		$notify_url			= $items[0]["notify_url"];	
		$notify_sandbox_url	= $items[0]["notify_sandbox_url"];
		$install_folder		= $items[0]["install_folder"];

		$protection_type	= $items[0]["protection_type"];

		$password_location	= $items[0]["password_location"];

		$adminaddress		= $items[0]["adminaddress"];

	
	include("code/header_forjs.php");
	?>
	
	<script language="javascript" type="text/javascript">
	
		function FormSubmit(frmEdit) {
		
			var message = "";
			if ( frmEdit.txtPayPalAddress.value == "" ) {
				message += "* Enter your PayPal address\n";
			}
		
			if ( frmEdit.txtInstall_Folder.value == "" ) {
				message += "* Enter the application install folder\n";
			}
		
			if ( frmEdit.txtPassword_Location.value == "" ) {
				message += "* Enter the password folder\n";
			}
		
			if (frmEdit.txtPayPalAddress.value == "" || frmEdit.txtInstall_Folder.value == "" || frmEdit.txtPassword_Location.value == "" ) {
					window.alert(message);
			} else {
				frmEdit.submit(frmEdit);
			}
			
		}
	
	</script>
	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />	
	
</head>
<body>

	<?php
	//Check if password folder exists.
	//Check that the password folder is writable
	$bolerror = false;
	if ( $password_location != "" ) {

		if ( !file_exists($password_location) ) {
			$msg = $msg . "<br/><br/>FOLDER FOR .htpasswd FILE : The " . $password_location . " <br/>you entered does not exists, create the folder first";
			$bolerror = true;
		}

		if ( !is_writable($password_location) ) {
			$msg = $msg . "<br/><br/>FOLDER FOR .htpasswd FILE : " . "Folder " . $password_location . "<br/>has wrong permissions, change permissions to 777<br/><br/>";
			$bolerror = true;
		}

	}
	
	require_once "code/navigation.php";	
	?>

	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol>   


<div class="container">

	<div class="row">
		<div class="col-md-2" sidebar>                

		  <ul class="nav nav-sidebar navbar-dark">
			<li class="active"><a href="#">Global Set Up</a></li>
			<li><a href="a_setup_smtp.php">SMTP Set Up</a></li>
			<li><a href="a_setup_graphics.php">Graphics Set Up</a></li>
			<li><a href="a_folders.php">Secure Set Up</a></li>				
			<li><a href="a_changepw.php">Set Password</a></li> 
		  </ul>          

		</div>
		<div class="col-md-8">

			<h2>Enter the Global set up details</h2>

			<div class="frmbkg">   
		
			<form name="frmEdit" method="Post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

				<div class = "form-group">
                  	<h5><label class="label label-danger"><?php if ($msg == "") echo(""); else echo($msg); ?></label></h5>
            	</div>
	
				<div class="form-group">          
                  	<input type="hidden" name="Submit" value="Update">
					<input type="button" name="Submit" value="Update" language="javascript" onClick="return FormSubmit(frmEdit)" class="btn btn-primary btn-sm" />
				</div>		
	
				<p>* Mandatory entries</p>
		
				<div class="form-group">		
					<label for="txtPayPalAddress"><strong>* Your main admin address or Primary PayPal Email Address if you are using PayPal</strong></label>			
					<input type="email" name="txtPayPalAddress" value="<?php echo("$paypaladdress"); ?>" class="form-control form-control-sm" />			
				</div>			

				<div class="form-group">							
					<label for="txtInstall_Folder"><strong>* Full url of installation folder</strong> e.g. http://wwww.server.com/phpsecurearea/</label>			
					<input type="url" name="txtInstall_Folder" value="<?php echo("$install_folder"); ?>" class="form-control form-control-sm" />				
				</div>
	
				<div class="form-group">			
					<strong>Notify URL</strong>		
					<?php echo("$notify_url"); ?>
					<input type="hidden" name="txtNotify_URL" value="<?php echo("$notify_url"); ?>">				
				</div>	
	
				<div class="form-group">		
					<?php 
						if ($bolerror == true) {
						?><span class="red"><strong>* Folder where .htpasswd is located</strong> e.g. /server/user/lib/files/pwd/</span><?php
						} else { 
						?><strong>* Folder where .htpasswd is located</strong> e.g. /server/user/lib/files/pwd/</span><?php 
						} 
					?> 
					<br/>You must enter a valid folder.  See <a href="http://www.withinweb.com/phpsecurearea/faq.php#digitalfiles" target="_blank">for more information</a>
					<br/>The full folder path of this folder is <strong><?php echo(getcwd()); ?></strong>                

					<input type="text" name="txtPassword_Location" size="50" value="<?php echo("$password_location"); ?>" class="form-control form-control-sm" />			
				</div>	
	
				<div class="form-group">			
					<label for="txtSiteTitle"><strong>Your site title</strong> (optional)</label>			
					<input type="text" name="txtSiteTitle" value="<?php echo("$sitetitle"); ?>" class="form-control form-control-sm" />			
				</div>
		
				<div class="form-group">	
					<label for="txtCurrency"><strong>Default Currency</strong></label>	
			
					<select name="txtCurrency" class="form-control form-control-sm">
						<option value="AUD" <?php if ($mc_currency == "AUD") echo("selected"); ?>>Australian Dollar</option>					
						<option value="BRL" <?php if ($mc_currency == "BRL") echo("selected"); ?>>Brazilian Rea</option>
						<option value="CAD" <?php if ($mc_currency == "CAD") echo("selected"); ?>>Canadian Dollar</option>
						<option value="CHF" <?php if ($mc_currency == "CHF") echo("selected"); ?>>Swiss Franc</option>
						<option value="CZK" <?php if ($mc_currency == "CZK") echo("selected"); ?>>Czech Koruna</option>
						<option value="DKK" <?php if ($mc_currency == "DKK") echo("selected"); ?>>Danish Krone</option>
						<option value="EUR" <?php if ($mc_currency == "EUR") echo("selected"); ?>>Euro</option>
						<option value="GBP" <?php if ($mc_currency == "GBP") echo("selected"); ?>>Pound Sterling</option>
						<option value="HKD" <?php if ($mc_currency == "HKD") echo("selected"); ?>>Hong Kong Dollar</option>					
						<option value="HUF" <?php if ($mc_currency == "HUF") echo("selected"); ?>>Hungarian Forint</option>	                  
						<option value="JPY" <?php if ($mc_currency == "JPY") echo("selected"); ?>>Japanese Yen</option>						
						<option value="NOK" <?php if ($mc_currency == "NOK") echo("selected"); ?>>Norwegian Krone</option>                    
						<option value="MXN" <?php if ($mc_currency == "MXN") echo("selected"); ?>>Mexican Peso</option>					
						<option value="MYR" <?php if ($mc_currency == "MYR") echo("selected"); ?>>Malaysian Ringgits</option>
						<option value="NZD" <?php if ($mc_currency == "NZD") echo("selected"); ?>>New Zealand Dollar</option>						
						<option value="PHP" <?php if ($mc_currency == "PHP") echo("selected"); ?>>Philippine Pesos</option>	
						<option value="PLN" <?php if ($mc_currency == "PLN") echo("selected"); ?>>Polish Zloty</option>					
						<option value="SEK" <?php if ($mc_currency == "SEK") echo("selected"); ?>>Swedish Krona</option>					
						<option value="SGD" <?php if ($mc_currency == "SGD") echo("selected"); ?>>Singapore Dollar</option>					
						<option value="THB" <?php if ($mc_currency == "THB") echo("selected"); ?>>Thai Baht</option>
						<option value="TWD" <?php if ($mc_currency == "TWD") echo("selected"); ?>>Taiwan New Dollars</option>
						<option value="USD" <?php if ($mc_currency == "" || $mc_currency == "USD") echo("selected"); ?>>U.S. Dollar</option>
					</select>		
			
				</div>	

				<div class="form-group">			
					<label for="txtAdminAddress"><strong>Your site Admin Email Address</strong> (optional) If left blank, your PayPal email address is used as the admin address.
					<br/>The admin email address <span class="red">MUST</span> have the same domain name as the domain that your site is hosted on otherwise
						the customer may not receive their email.</label>			
					<input type="email" name="txtAdminAddress" value="<?php echo("$adminaddress"); ?>" class="form-control form-control-sm" />
				</div>
	
				<div class="form-group" data-toggle="buttons">
					<label class="btn <?php if ($copyemail == 1) {echo( " active " );}?> ">
						<input type="checkbox" name="txtCopyEmail" <?php if ($copyemail == 1) {echo( " checked " );}?> />	 			
					  	<i class="fa fa-square-o fa-2x"></i>
				  		<i class="fa fa-check-square-o fa-2x"></i>
				  		<span><strong>Copy Email</strong> When ticked, a copy of the email will be sent to you.</span>
					</label>
				</div>	   		   		   		   		   		   		   		   		   		   		   		   		   		   
			
				<div class="form-group">		
					<label for="txtCancel_URL"><strong>Cancel URL</strong> (optional) The url when the purchaser cancels the payment.
						<br/>Should be .php file and not htm or html</label>		
					<input type="email" name="txtCancel_URL" size="40" value="<?php echo("$cancel_url"); ?>" class="form-control form-control-sm" />
				</div>

				<div class="form-group">			
					<label for="txtCancel_URL"><strong>Return URL</strong> (optional) The url when the purchaser finishes payment.
						<br/>Should be .php file and not htm or html</label>			
					<input type="url" name="txtReturn_URL" size="40" value="<?php echo("$return_url"); ?>" class="form-control form-control-sm" />		
				</div>

				<input type="hidden" name="txtProtection_Type" value="1">	
	
			</form>
			
			</div>
			
		</div>
		<div class="col-md-2"></div>
	</div>
	
</div>

<?php include ("code/footer_bootstrapjs.php");
}