<?php
//-----------------------------------
//Edits the sec_tblsetup table for the graphics part
//-----------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../dbclass/Db.class.php");
require_once("../classes/clsinput.php");
require_once("../functions/misc.php");
//----------------------------------------------

main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

	$inputSubmit = input::get('Submit');

	if ($inputSubmit == 'Update') {
	
		$button		= input::get('txtButton');		//Defines which radio button has been selected
		$entered	= input::get('txtEntered');		//Filled in if manual entered		

		update($button, $entered);
		display("Record updated " . date("Y-m-d H:i:s"));
		
	} else {
		display(""); 
	}
	
}
//-----------------------------------
//Purpose : Update the selected item, (there is only one record in table setup which is record number 1)
//Inputs : $button, $entered
function update($button, $entered) {

	if ($button == "manual_entered") {
		$manual_entered = "1";
		$button = $entered; 
	} else  {
		$manual_entered = "0"; 
		$entered = "";
	}

	$update = updategraphics($button, $manual_entered);
	
	return $update;
	
}
//-----------------------------------
//Purpose : Display and edit the record
//Input :  Any error message
function display($_message) {

	$setup = gettblsetup();

		$button				= $setup[0]["button"];
		$manual_entered		= $setup[0]["manual_entered"];
	
	//echo($button);
	//echo($manual_entered);
	
	require_once("code/header_forjs.php");
	?>
	<script language="JavaScript">
		function FormSubmit(frmEdit) {
			frmEdit.submit(frmEdit);
		}
	</script>

	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />	
	
	</head>
	
	</html>
    <body>
    
	<?php                
	require_once("code/navigation.php");                
	?>

	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol>

	<div class="container"> 	
		
	<div class="row">   
		<div class="col-md-2" sidebar>

			<ul class="nav nav-sidebar navbar-dark">
		    	<li><a href="a_setup_global.php">Global Set Up </a></li>
               	<li><a href="a_setup_smtp.php">SMTP Set Up</a></li>			   
                <li class="active"><a href="#">Graphics Set Up</a></li>
				<li><a href="a_folders.php">Secure Set Up</a></li>						
				<li><a href="a_changepw.php">Set Password</a></li>                                                            
			</ul>            

		</div>
		<div class="col-md-8">
			
			<h2>Button graphic images</h2>    	
			
				<p>Choose an image or enter in the full url of one of your own images.</p>
			
					<div class="frmbkg">    
				
						<form name="frmEdit" method="Post" action="<?php echo $_SERVER['PHP_SELF']; ?>">  

							<div class="form-group">	
								<input type="hidden" name="Submit" value="Update">
								<input type="button" name="Submit" value="Update" language="javascript" onClick="return FormSubmit(frmEdit)" class="btn btn-primary btn-sm" />
							</div>
	
							<div class = "form-group">
                    			<h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
            				</div>			
			
							<div class = "form-group">
        
								<h5><strong>Buy now button images</strong></h5>

									<div class="row">
										<div class="col-md-12">
											<div class="form-group btn-group" data-toggle="buttons">
											<label class="btn">                                
												<input type="radio" name="txtButton" 
												<?php
												if ( ($button == "" || $button == "../images/btn/x-click-but24.gif") && ($manual_entered == "0") ) 
													echo("checked");
												?>
												value="../images/btn/x-click-but24.gif" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span><img src="../images/btn/x-click-but24.gif" border="0" alt="buy now button" /></span>	
											</label>										    
											</div>  
										</div>
									</div>																	                                                
			
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
											<label class="btn"> 
												<input type="radio" name="txtButton" 
												<?php
												if ($button == "../images/btn/x-click-butcc.gif" && $manual_entered == "0") 
													echo("checked");
												?>				
												value="../images/btn/x-click-butcc.gif" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span><img src="../images/btn/x-click-butcc.gif" border="0" alt="buy now button" /></span>
											</label>											   
											</div>			
										</div>
									</div>										    

									
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
										<label class="btn"> 
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-but06.gif" && $manual_entered == "0") 
												echo("checked");
											?>
											value="../images/btn/x-click-but06.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>										
											<span><img src="../images/btn/x-click-but06.gif" border="0" alt="buy now button" /></span>
										</label>									
										</div>			
										</div>
									</div>
									
									
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
										<label class="btn">                               
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-but12.gif" && $manual_entered == "0") 
												echo("checked");
											?>				
											value="../images/btn/x-click-but12.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>												
											<span><img src="../images/btn/x-click-but12.gif" border="0" alt="buy now button" /></span>
										</label>
										</div>			
										</div>
									</div>
									
									
									<div class="row">		
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
										<label class="btn">   
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-but20.gif" && $manual_entered == "0") 
												echo("checked");
											?>				
											value="../images/btn/x-click-but20.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>												
											<span><img src="../images/btn/x-click-but20.gif" border="0" alt="buy now button" /></span>
										</label>
										</div>			
										</div>
									</div>
										                                                          
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">										
										<label class="btn">                
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-but29.gif" && $manual_entered == "0") 
												echo("checked");
											?>
											value="../images/btn/x-click-but29.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>												
											<span><img src="../images/btn/x-click-but29.gif" border="0" alt="buy now button" /></span>
										</label>
										</div>			
										</div>
									</div>
										                                                          
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">	
										<label class="btn">                                            
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-but31.gif" && $manual_entered == "0") 
												echo("checked");
											?>
											value="../images/btn/x-click-but31.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>                                		
											<span><img src="../images/btn/x-click-but31.gif" border="0" alt="buy now button" /></span>                
										</label>
										</div>			
										</div>
									</div>									
									
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
									
										<label class="btn">                               
											<input type="radio" name="txtButton" 
											<?php
											if ($button == "../images/btn/x-click-butcc-subscribe.gif" && $manual_entered == "0") 
												echo("checked");
											?>
											value="../images/btn/x-click-butcc-subscribe.gif" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>         										
											<span><img src="../images/btn/x-click-butcc-subscribe.gif" border="0" alt="buy now button" /></span>
										</label>
										</div>			
										</div>
									</div>
									
									<div class="row">
										<div class="col-md-12">
										<div class="form-group btn-group" data-toggle="buttons">
										<label class="btn">                               
											<input type="radio" name="txtButton" 
											<?php
											if ($manual_entered == "1") 
												echo("checked");
											?>				
											value="manual_entered" />
											<i class="fa fa-circle-o fa-2x"></i>
											<i class="fa fa-check-circle-o fa-2x"></i>   
												<?php
													if ($manual_entered == "1") {
														$display_entered = $button;
													}
													else
													{
														$display_entered = ""; 
													}								
												?>
											<span>or enter the full url of your own image in the text box below:</span>
										</label>

								
										<input type="url" name="txtEntered" value="<?php echo($display_entered); ?>" class="form-control" />

										</div>			
										</div>
									</div>																																																																				
            
							</div>
							
					</form>
	
    			</div>

   		</div>   
            <div class="col-md-2"></div>        
        </div>
    
    </div>

<?php
require_once ("code/footer_bootstrapjs.php");
}
?>