<?php
//-----------------------------------
//Edits the sec_tblsetup table
//-----------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../dbclass/Db.class.php");
require_once("../classes/clsinput.php");
require_once("../functions/misc.php");
//----------------------------------------------

main();


//----------------------------------------------
//Purpose : Starts the page
function main() {

	$inputSubmit = input::get('Submit');
	
	if ($inputSubmit == 'Update') {
		
		$useSMTP 				= input::get('txtType');
		if ( $useSMTP == "standard" ) { $useSMTP = 0; } else { $useSMTP = 1; }		
		$SMTPHost 				= input::get('txtSMTPHost');
		$SMTPAuthentication 	= input::get('txtSMTPAuthentication');
		$SMTPUsername			= input::get('txtSMTPUsername');
		$SMTPPassword			= input::get('txtSMTPPassword');
		$txtTypeOfEncryption 	= input::get('txtTypeOfEncryption');
		$txtSMTPort				= input::get('txtSMTPort');
		$txtFromEmail 			= input::get('txtFromEmail');
		$txtFromName 			= input::get('txtFromName');
		$debug					= input::get('txtDebug');
		
		//echo($useSMTP);
		//exit;
		
		//Update table		
		updatesmtp($SMTPHost, $useSMTP, $SMTPAuthentication, $SMTPUsername, $SMTPPassword, 
					$txtTypeOfEncryption, $txtSMTPort, $txtFromEmail, $txtFromName, $debug);
		
		display("SMTP updated " . date("Y-m-d H:i:s"));
		
	}
	elseif ($inputSubmit == "Click to use SMTP")
	{
		//echo("use smtp");
		//Update sec_tblsmtp with usesmtp with 1
		updateusesmtp("1");
		display("");
	}
	elseif ($inputSubmit == "Click to use Standard PHP Email")
	{
		//echo("use sandard");
		//Update sec_tblsmtp with usesmtp with 0
		updateusesmtp("0");
		display("");
	}
	else
	{
		display("");
	}	
	
}
//-----------------------------------
//Purpose : Display and edit the record
//Input :  Any error message
function display($msg) {	

	//SMTP Host
	//SMTP Authentication (true/false)
	//SMTP Username
	//SMTP Password
	//Type of encryption (tls/ssl/no encryption)
	//SMTP port
	//Form Email address
	//From Name
	//Disable SSL Certif
	
	$smtp = smtpsettings();
	
	$txtType				= $smtp[0]["usesmtp"];
	$txtSMTPHost 			= $smtp[0]["smtphost"];
	$txtSMTPAuthentication 	= $smtp[0]["smtpauthentication"];
	$txtSMTPUsername 		= $smtp[0]["smtpusername"];
	$txtSMTPPassword 		= $smtp[0]["smtppassword"];
	$txtTypeOfEncryption 	= $smtp[0]["typeofencryption"];
	$txtSMTPort 			= $smtp[0]["smtpport"];
	$txtFromEmail 			= $smtp[0]["fromemail"];
	$txtFromName 			= $smtp[0]["fromname"];
	$txtDebug 				= $smtp[0]["debug"];
	
	require_once("code/header_forjs.php");		

	//jQuery for radio button selection
	//http://jsfiddle.net/7Ud6B/
	//http://jsfiddle.net/3ZnGj/3/
	
	?>	

	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />
	
</html>
<body>

<?php
require_once("code/navigation.php");
?>

		<ol class="breadcrumb">
			<li><a href="index1.php">Home</a></li>
		</ol>    

		<div class="container">
			
			<div class="row">
				<div class="col-md-2" sidebar>
		  			<ul class="nav nav-sidebar navbar-dark">
						<li><a href="a_setup_global.php">Global Set Up</a></li>
						<li class="active"><a href="#">SMTP Set Up</a></li>
						<li><a href="a_setup_graphics.php">Graphics Set Up</a></li>
						<li><a href="a_folders.php">Secure Set Up</a></li>				
						<li><a href="a_changepw.php">Set Password</a></li> 
		 	 		</ul>
				</div>
			
				<div class="col-md-8">
					
					<h2>SMTP Set Up (Optional)</h2>
					
					<p>Emails are sent using the standard PHP mail system but you may want to use SMTP 
					which may be set up from here.</p>
					
						<form name="frmEdit" method="Post" action="<?php echo $_SERVER['PHP_SELF']; ?>"> 
						
							<div class="form-group">
								<h5><label class="label label-danger"><?php if ($msg == "") echo(""); else echo($msg); ?></label></h5>
							</div>

							<div class="form-group">

								<?php
									if ($txtType == 0) {
										?>
											<p>Emails are configured to be sent by standard PHP mail.  To configure SMTP mail click here:</p>
											<input type="submit" name="Submit" value="Click to use SMTP" class="btn btn-primary btn-sm" />
										<?php
									}
								?>

								<?php
									if ($txtType == 1) {
										?>
											<p>Emails are configured to be sent by SMTP.  To send emails by standard PHP mail click here:</p>
											<input type="submit" name="Submit" value="Click to use Standard PHP Email" class="btn btn-primary btn-sm" />
										<?php
									}
								?>

							</div>

							<div id="smtpdetails">

								<div class="frmbkg">  

									<div class="form-group">                  			
										<input type="submit" name="Submit" value="Update" class="btn btn-primary btn-sm" />
									</div>						

									<div class="form-group">		
										<label for="txtSMTPHost"><strong>SMTP Host</strong></label>			
										<input type="text" name="txtSMTPHost" value="<?php echo($txtSMTPHost); ?>" class="form-control form-control-sm" />
										<label for="txtSMTPHostLabel">The SMTP server which will be used to send emails for example smtp.gmail.com</label>
									</div>

									<div class="form-group">		
										<label for="txtSMTPAuthentication"><strong>SMTP Authentication</strong></label>
										<select name="txtSMTPAuthentication" class="form-control form-control-sm">
											<option value="true" <?php if ($txtSMTPAuthentication == "true") echo("selected"); ?>>True</option>					
											<option value="false" <?php if ($txtSMTPAuthentication == "false") echo("selected"); ?>>False</option>
										</select>
										<label for="txtSMTPAuthenticationLabel">Whether to use SMTP Authentication when sending an email (recommended: True)</label>											
									</div>

									<div class="form-group">		
										<label for="txtSMTPUsername"><strong>SMTP Username</strong></label>			
										<input type="text" name="txtSMTPUsername" value="<?php echo($txtSMTPUsername); ?>" class="form-control form-control-sm" />
										<label for="txtSMTPUsernameLabel">Your SMTP Username</label>
									</div>		

									<div class="form-group">		
										<label for="txtSMTPPassword"><strong>SMTP Password</strong></label>			
										<input type="password" name="txtSMTPPassword" value="<?php echo($txtSMTPPassword); ?>" class="form-control form-control-sm" />
										<label for="txtSMTPPassword">Your SMTP Password</label>
									</div>		

									<div class="form-group">		
										<label for="txtTypeOfEncryption"><strong>Type of Encryption</strong></label>
										<select name="txtTypeOfEncryption" class="form-control form-control-sm">
											<option value="tls" <?php if ($txtTypeOfEncryption == "tls") echo("selected"); ?>>TLS</option>					
											<option value="ssl" <?php if ($txtTypeOfEncryption == "ssl") echo("selected"); ?>>SSL</option>
											<option value="" <?php if ($txtTypeOfEncryption == "") echo("selected"); ?>>No encryption</option>
										</select>
										<label for="txtTypeOfEncryptionLabel">The encryption which will be used when sending an email (recommended: TLS)</label>											
									</div>

									<div class="form-group">		
										<label for="txtSMTPort"><strong>SMTP port</strong></label>			
										<input type="text" name="txtSMTPort" value="<?php echo($txtSMTPort); ?>" class="form-control form-control-sm" />
										<label for="txtSMTPortLabel">The port which will be used when sending an email (587/465/25). If you choose TLS it should be set to 587. For SSL use port 465 instead</label>
									</div>

									<div class="form-group">		
										<label for="txtFromEmail"><strong>From email address</strong></label>			
										<input type="email" name="txtFromEmail" value="<?php echo($txtFromEmail); ?>" class="form-control form-control-sm" />
										<label for="txtFromEmailLabel">The email address which will be used as the From Address if it is not supplied to the mail function</label>
									</div>										

									<div class="form-group">		
										<label for="txtFromName"><strong>From name</strong></label>			
										<input type="text" name="txtFromName" value="<?php echo($txtFromName); ?>" class="form-control form-control-sm" />
										<label for="txtFromNameLabel">The name which will be used as the From Name if it is not supplied to the mail function</label>
									</div>	

									<div class="form-group">		
										<label for="txtDebug"><strong>Debug</strong></label>
										<select name="txtDebug" class="form-control form-control-sm">
											<option value="0" <?php if ($txtDebug == "0") echo("selected"); ?>>(0) Off</option>					
											<option value="1" <?php if ($txtDebug == "1") echo("selected"); ?>>(1) Client messages</option>
											<option value="2" <?php if ($txtDebug == "2") echo("selected"); ?>>(2) Client and server messages</option>
										</select>
										<label for="txtDebugLabel">Set the debug output value</label>											
									</div>	
														
								</div>

							</div>
						
					</form>
					
				</div>
				<div class="col-md-2"></div>
			</div>
			
		</div>
	
	<?php
	//echo("txt type: " . $txtType);
	
	require_once ("code/footer_bootstrapjs.php");
	
	echo( '<script type="text/javascript">' );
	echo( '$(document).ready(function () {' );
	
	if ($txtType == "1") {
		echo( "$('#smtpdetails').show('fast'); "); 
	}
	else
	{
		echo( "$('#smtpdetails').hide('fast'); "); 
	}
	
	echo( "$('#standard').click(function () {" );
	echo( "$('#smtpdetails').hide('fast'); ");
	echo( "}); ");
	echo( "$('#smtp').click(function () { ");
	echo( "$('#smtpdetails').show('fast'); ");
	echo( " }); ");
	echo( "}); ");
	echo( "</script> ");	
	
}