<?php

	//-----------------------------------
	// Transaction detail
	//-----------------------------------
	
	//************************************
	//  Paul Gibbs copyright 2024
	//  paulvgibbs@gmail.com
	//************************************

	require_once("a_checkaccess.php");
	require_once("../error.php"); 
	require_once("../dbclass/Db.class.php");
	require_once("../classes/clsinput.php");
	require_once("../functions/misc.php");
	require_once("../functions/formatting.php");
	//--------------------------------------
	
	$recid	= input::get('recid');
	if ( !is_numeric($recid) ) { exit(); }	

	$table = transactiondetail($recid);
	
	foreach( $table as $d_row ) {

		$item_id				=	$d_row["item_id"];
		$users_id				=	$d_row["users_id"];
		$receiver_email			=	$d_row["receiver_email"];
		$item_name				=	$d_row["item_name"]; 
		$item_number			=	$d_row["item_number"];
		$payment_status			=	$d_row["payment_status"];
		$mc_gross				=	$d_row["mc_gross"];
		$payer_email			=	$d_row["payer_email"];
		$txn_type				=	$d_row["txn_type"];
		$txn_id					=	$d_row["txn_id"];
		$mc_currency			=	$d_row["mc_currency"];
		$completed				=	$d_row["completed"];
		$quantity				=	$d_row["quantity"];	
	
		$business 				= 	$d_row["business"];
		$receiver_id			=	$d_row["receiver_id"];
		$invoice 				=	$d_row["invoice"];
		$custom					=	$d_row["custom"];
		$memo 					=	$d_row["memo"];
		$tax 					=	$d_row["tax"];
		$option_name1 			=	$d_row["option_name1"];
		$option_selection1		=	$d_row["option_selection1"];
		$option_name2 			=	$d_row["option_name2"];
		$option_selection2 		=	$d_row["option_selection2"];
		$num_cart_items 		=	$d_row["num_cart_items"];
		$mc_fee 				=	$d_row["mc_fee"];
		$payment_date 			=	$d_row["payment_date"];
		$payment_type			=	$d_row["payment_type"];
		$first_name				=	$d_row["first_name"];
		$last_name				=	$d_row["last_name"];
		$payer_business_name	=	$d_row["payer_business_name"];
		$address_name			=	$d_row["address_name"];
		$address_street			=	$d_row["address_street"];
		$address_city			=	$d_row["address_city"];
		$address_state			=	$d_row["address_state"];
		$address_zip			=	$d_row["address_zip"];
		$address_country		=	$d_row["address_country"];
		$address_status			=	$d_row["address_status"];
		$payer_id				=	$d_row["payer_id"];
		$payer_status			=	$d_row["payer_status"];
		$notify_version			=	$d_row["notify_version"];
		$verify_sign			=	$d_row["verify_sign"];

	}
	
	require_once "code/header.php";	
	require_once "code/navigation.php";
	?>    
    
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
       	<li><a href="a_transactions.php">Transaction List</a></li>
	</ol>    
    
   	<div class="container">    
    
     	<div class="row">   
            <div class="col-md-3"></div>    
            <div class="col-md-6">
    
    		<h2>Transaction Details</h2><br/>
    
             <table class="table table-striped">             
                <thead>
                    <tr>
                        <th>Name</th>
                        <th></th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>Name</th>
                        <th></th>
                        <th>Value</th>
                    </tr>                
                </tfoot>             
                <tbody>
                <tr>
                    <td>receiver_email</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $receiver_email )); ?></td>        
                </tr>
                
                <tr>
                    <td>item_name</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $item_name )) ; ?></td>        
                </tr>
                
                <tr>
                    <td>item_number</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $item_number )); ?></td>        
                </tr>
                
                <tr>
                    <td>payment_status</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payment_status )); ?></td>        
                </tr>      
   
                <tr>
                    <td>mc_gross</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $mc_gross )); ?></td>        
                </tr>
                
                <tr>
                    <td>mc_currency</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $mc_currency )); ?></td>        
                </tr>
                
                <tr>
                    <td>tax</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $tax )); ?></td>        
                </tr>
                
                <tr>
                    <td>quantity</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $quantity )); ?></td>        
                </tr>
                
                <tr>
                    <td>num_cart_items</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $num_cart_items )); ?></td>        
                </tr>
                
                <tr>
                    <td>mc_fee</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $mc_fee )); ?></td>        
                </tr>             
                
                <tr>
                    <td>payer_email</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payer_email )); ?></td>        
                </tr>
                
                <tr>
                    <td>txn_type</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $txn_type )); ?></td>        
                </tr>
                    
                <tr>
                    <td>txn_id</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $txn_id )); ?></td>        
                </tr>
                
                <tr>
                    <td>completed</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $completed )); ?></td>        
                </tr>
                
                <tr>
                    <td>custom</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $custom )); ?></td>        
                </tr>              
                
                <tr>
                    <td>business</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $business )); ?></td>        
                </tr>
                
                <tr>
                    <td>receiver_id</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $receiver_id )); ?></td>        
                </tr>
                
                <tr>
                    <td>invoice</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $invoice )); ?></td>        
                </tr>
                
                <tr>
                    <td>memo</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $memo )); ?></td>        
                </tr>                
                
                <tr>
                    <td>option_name1</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $option_name1 )); ?></td>        
                </tr>
                
                <tr>
                    <td>option_selection1</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $option_selection1 )); ?></td>        
                </tr>
                
                <tr>
                    <td>option_name2</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $option_name2 )); ?></td>        
                </tr>
                
                <tr>
                    <td>option_selection2</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $option_selection2 )); ?></td>        
                </tr>               
                
                <tr>
                    <td>payment_date</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payment_date )); ?></td>        
                </tr>
                
                <tr>
                    <td>payment_type</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payment_type )); ?></td>        
                </tr>
                
                <tr>
                    <td>first_name</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $first_name )); ?></td>        
                </tr>
                
                <tr>
                    <td>last_name</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $last_name )); ?></td>        
                </tr>                
                
                <tr>
                    <td>payer_business_name</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payer_business_name )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_name</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_name )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_street</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_street )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_city</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_city )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_state</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_state )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_zip</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_zip )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_country</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_country )); ?></td>        
                </tr>
                
                <tr>
                    <td>address_status</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $address_status )); ?></td>        
                </tr>                
                
                <tr>
                    <td>payer_id</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payer_id )); ?></td>        
                </tr>
                
                <tr>
                    <td>payer_status</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $payer_status )); ?></td>        
                </tr>
                
                <tr>
                    <td>notify_version</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $notify_version )); ?></td>        
                </tr>
                
                <tr>
                    <td>verify_sign</td>
                    <td width="20px">&nbsp;</td>
                    <td><?php echo( esc_html( $verify_sign )); ?></td>        
                </tr>

                </tbody>               
            </table>  
    
    
    	</div>
        <div class="col-md-3"></div>    
	</div>
    
   </div>    
    
<?php
	require_once("code/footer_bootstrapjs.php");
?>