<?php	

//--------------------------------------
// List the transactions
//--------------------------------------
	
//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php"); 
require_once("../dbclass/Db.class.php");
require_once("../classes/clsinput.php");
require_once("../functions/misc.php");
//--------------------------------------


//----------------------------------------------
main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

	$inputAction = input::get("action");
	$inputSubmit = input::get("submit");

	if ($inputAction == "delete")
	{		
		confirmdelete( input::get('recid') );
	}	
	elseif ( $inputSubmit == "Delete Transaction" )
	{	
		$delete = deletetransaction( input::get('recid') );	
		
		if ($delete == 1) {
			displaylist("Transaction " . input::get('recid') . " deleted: " . date("Y-m-d H:i:s"));
		}
		else
		{
			displaylist("Error in deleting transaction");	
		}
		
	}
	elseif ( $inputSubmit == "No" ) 
	{
		displaylist("");
	}
	else
	{
		displaylist("");	
	}
	
}
//----------------------------------------------
//Purpose : Displays the transactions
function displaylist($_message) {

	$table = gettransactions();
	
	require_once("code/header.php");	
	require_once("code/navigation.php");
	?>
 
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol> 
 
<div class="container-fluid">

   	<div class="row">   
	    <div class="col-md-12">
			<h2>Transactions</h2>
        </div>   
   	</div>

  	<div class="row">   
	    <div class="col-md-12">** Click on the column title arrows to sort the column</div>   
   	</div>
        
  <div class="row">   
	    <div class="col-md-12">
       
       		<h5><label class="label label-danger"><?php if (isset($_message)) { echo($_message); } ?></label></h5>    

            <?php
            if (count($table) == 0)
            {
                echo('There are no transactions to display');
            }
            else
            {
            ?>

                <table cellspacing="0" width="100%" id="products" class="display">
                    <thead>
                        <tr>
                            <th>Product Item No</th>
                            <th>Product Item Name</th>
                            <th>Customer</th>
                            <th>Payment status</th>
                            <th>Value</th>
                            <th>Qty</th>
                            <th>Total</th>
                            <th>Paypal trans id</th>
                            <th>Currency</th>
                            <th>Date/Time</th>
                            <th>Info</th>
                            <th>Delete</th>                             
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>Product Item No</th>
                            <th>Product Item Name</th>
                            <th>Customer</th>
                            <th>Payment status</th>
                            <th>Value</th>
                            <th>Qty</th>
                            <th>Total</th>
                            <th>Paypal trans id</th>
                            <th>Currency</th>
                            <th>Date/Time</th>
                            <th>Info</th>
                            <th>Delete</th>
                        </tr>                
                    </tfoot>
                    <tbody>
                        <?php
                        foreach($table as $d_row) {
                        ?>            
                        <tr>
                            <td><?php echo($d_row["item_number"]); ?></td>
                            <td><?php echo($d_row["item_name"]); ?></td>                    	
                            <td><?php echo($d_row["payer_email"]); ?></td>
                            <td><?php echo($d_row["payment_status"]); ?></td>
                            <td><?php echo($d_row["mc_gross"]); ?></td>                                
                            <td><?php echo($d_row["quantity"]); ?></td>
                            <td><?php echo($d_row["mc_gross"] * $d_row["quantity"]); ?></td>
                            <td><?php echo($d_row["txn_id"]); ?></td>  
                            <td><?php echo($d_row["mc_currency"]); ?></td>  
                            <td><?php echo($d_row["completed"]); ?></td>   
                            <td><a href="a_transaction_details.php?recid=<?php echo ($d_row["recid"]); ?>" class="blockover">Details</a></td>
                            <td align="center">
                            	<a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=delete&amp;recid=<?php echo($d_row['recid']);?>">
                                <i class="fa fa-trash fa-2x" aria-hidden="true"></i></a>
							</td>
                        </tr>
                        <?php
                        }
                        ?>
                    </tbody>
                </table>    
                
            <?php
            }
            ?>

  		</div>
	</div>    

</div>                
        
<?php
require_once ("code/footer_datatable_transactions.php");
?>

</body>
</html>

<?php
}
//----------------------------------------------
//Purpose : Asks if you want this deleted
function confirmdelete($recid) {

	require_once("code/header.php");	
	require_once("code/navigation.php");
	?>
    
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
 	 	<li><a href="a_transactions.php">Transaction List</a></li>        
	</ol>     

  	<div class="container">    
    
        <div class="row">   
            <div class="col-md-2"></div>    
            <div class="col-md-8">

				<h2>Manage Transactions - confirm deletion of a transaction</h2>

				<form name="frmConfirmDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
					Are you sure you want to delete this item : <strong><?php echo("$recid"); ?>?</strong><br/><br/>
					<input type="hidden" name="recid" value="<?php echo("$recid"); ?>">
					<input type="submit" name="submit" value="Delete Transaction" class="btn btn-primary btn-sm" />
                    &nbsp;&nbsp;&nbsp;
                    <input type="submit" name="submit" value="No" class="btn btn-primary btn-sm" />
				</form>

          	</div>   
            <div class="col-md-2"></div>        
        </div>
    
    </div>

<?php
require_once("code/footer_bootstrapjs.php");
	
}