<?php

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//  30/12/2024 V2.9.6
//	Removal of unused variables

//------------------------------------
//	Create a new user in the tblusers
//	and place them in htpasswd file
//------------------------------------

//----------------------------------------------
require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../classes/clspassword.php");
require_once("../classes/clshtpasswd.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
require_once("../functions/user.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//----------------------------------------------

main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

	$submitAction = input::get('submit');
	
	if ( $submitAction == 'Create New User' ) {
		//create the user
		
		$payer_email 	= input::get('txtPayer_Email');
		$product_id 	= input::get('txtProduct_Id');		
		
		if ( $payer_email == "" && $product_id == "--choose a product--" ) {
			display("Enter email address and a product");
			exit();
		}
		elseif ( $payer_email == "" )
		{
			display("Enter email address");
			exit();		
		}
		elseif ( $product_id == "--choose a product--" )
		{
			display("Select a product");
			exit;		
		}		

		$sendpassword  = input::get('txtSendPassword');		

		processcreate( strtolower($payer_email), input::get('txtActive'), $product_id, $sendpassword );
		display("");	
	} else {
		display("");
	}

}
//----------------------------------------------
//Purpose : this creates a new user for this email address
//This is a manual creation and is similar to the automatic creation of a user
//but has the manual flag set
function processcreate($payer_email, $active, $item_number, $sendpassword) {

	//given the $item_number, look up the details from tblitems for this item
	
	$itemdetails = gettblitems_number($item_number);

		$securearea_id 	= $itemdetails['securearea_id'];
		$item_name		= $itemdetails['item_name'];
		$mc_currency	= $itemdetails['mc_currency'];	

		//echo("emailaddress : " . $payer_email . "<br/>");
		//echo("active : " . $active . "<br/>");
		//echo("item number : " . $item_number . "<br/>");	
		//echo("sendpassword : " . $sendpassword . "<br/>");	
		//echo($securearea_id);
		//exit();

		if ( $active == "on" ) {
			$active = 1;
		} else {
			$active = 0;
		}

	//First check if this email exists, if not then create a new password
	//If it does exist, then get the password and decrypt.	
	$table = userintbluser($payer_email);
	
	//exit();

	if ( count($table) == 0 ) {		//user does not exist

		$password_plain = createpw();
	
		srand(make_seed());
		$iv = rand(1, 500);

		$encryption = new password($iv, $password_plain);
		$encryption->encode();
		$password_encrypt = $encryption->getencodedtext();
		
	}
	else
	{
	
		$message = "";
		
		$password_plain = getpassword($payer_email, $message);
		$iv = $table[0]['iv'];
		$password_encrypt = $table[0]['password'];

		if ( $message != "") {			
			display("SQL Error - a_usercreate.php ref 2 " . $message );
			exit();
		}
		
	}

	//echo($password_plain . "<br>");
	//echo($iv . "<br>");
	//echo($password_encrypt . "<br>");
	//exit();
	
	$message = "";

	//$users_id = 
	createmanualuser($payer_email, $password_plain, $password_encrypt, $iv, $item_number, $active, $securearea_id, $message);

	if ($message != "") {
		display($message);
		exit();
	}

	//if tick boxes are on, send email to user
	if ( $sendpassword == "on" && $active == 1 ) {

		//Send details of how to login to the customer
		$testmode = "false";
		sendlogindetails($payer_email, $password_plain, $item_number, $testmode);

	}

	//Insert into sec_tblsaleshistory with manual entry	
	$currentdate = date("Y-m-d H:i:s");

	//entries that are modified
	//$item_number = $item_number;
	//$item_name = $item_name;
	//$payer_email = $payer_email;	
	$completed = $currentdate;	
	$payment_status = "Manual";	
	$mc_gross = "0.00";
	//$mc_currency = $mc_currency;	
	$txn_id = $currentdate;
	
	//entries that are not modified
	$custom = NULL;
	$business = NULL;
	$receiver_id = NULL;
	$invoice = NULL;
	$memo = NULL;
	$tax = NULL;
	$option_name1 = NULL;
	$option_selection1 = NULL;
	$option_name2 = NULL;
	$option_selection2 = NULL;
	$num_cart_items = NULL;
	$mc_fee = NULL;
	$payment_date = NULL;
	$payment_type = NULL;
	$first_name = NULL;
	$last_name = NULL;
	$payer_business_name = NULL;
	$address_name = NULL;
	$address_street = NULL;
	$address_city = NULL;
	$address_state = NULL;
	$address_zip = NULL;
	$address_country = NULL;
	$address_status = NULL;	
	$payer_id = NULL;		
	$payer_status = NULL;
	$notify_version = NULL;
	$verify_sign = NULL;
	$receiver_email = NULL;	

		
	$rowsaffected = insertsaleshistory($custom, $business, $receiver_id, $invoice, $memo, $tax, $option_name1, $option_selection1,
					$option_name2, $option_selection2, $num_cart_items, $mc_fee, $payment_date, $payment_type, $first_name, $last_name, $payer_business_name, $address_name, $address_street, $address_city, $address_state, $address_zip, $address_country, $address_status, $payer_id, $payer_status, $notify_version, $verify_sign, $txn_id, $item_number, $item_name, $payment_status, $mc_gross, $mc_currency, $receiver_email, $payer_email, $completed);
	
	if ( $rowsaffected == 0 ) {	//SQL Error
		display("SQL Error - a_usercreate.php ref 3 - no insert into sec_tblsaleshistory " );
		exit();
	}

	display("User " . $payer_email . " created with password " . $password_plain);
	exit();

}
//----------------------------------------------
//Purpose : Displays the boxes for creating the user
function display($_message) {

require_once("code/header_forjs.php");

?>	
<link rel="stylesheet" text="text/css" href="css/checkbox.css" />
<?php
	
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
  <li><a href="a_usermanage.php">Manage users</a></li>
</ol>	

<div class="container">

	<div class="row">
 		<div class="col-md-2"></div>
        	<div class="col-md-8">	
	
				<h2>Manually create a user</h2>
	
				<p>Manually create a user and optionally make the user account active.<br/>An active user account means the user 
				can log in to the secure area, a disabled user is unable to log into the secure area.<br/>Also, optionally send an 
				email to the new user with their login details.
				<br/>Note that manually created users will never expire because control of subscriptions is only from PayPal, unless 
				you set up the CRON job which will expire users.</p>

				<div class="frmbkg">			
			
					<form name="frmCreate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

						<div class = "form-group">
							<h5><label class="label label-danger"><?php if (isset($_message)) { echo($_message); } ?></label></h5>
						</div>

						<div class = "form-group">			
							<input type="submit" name="submit" value="Create New User" class="btn btn-primary btn-sm" />
						</div>

						<div class = "form-group">
							<label for="txtPayer_Email"><strong>Enter in the email address : </strong></label>
							<input type="email" name="txtPayer_Email" id="txtPayer_Email" class="form-control" placeholder="Email address new user" required />
						</div>

						<div class = "form-group">				

							<!-- Display a list of current secure areas -->
							<strong>Choose a product item : </strong>

							<select name="txtProduct_Id" id="txtProduct_Id" class="form-control">
								<OPTION value="--choose a product--">--choose a product--</OPTION>
								<?php

								//SELECT recid, item_number FROM sec_tblitems ORDER BY item_number
								$table = itemlist();

								foreach( $table as $d_row ) {	
									echo("<OPTION value=\"" . $d_row["item_number"] . "\">" . $d_row["item_number"] . "</OPTION>");	
								}

								?>
							</select>

						</div>


						<div class="form-group" data-toggle="buttons">
							<label class="btn">
								<input type="checkbox" name="txtActive" checked />	
								<i class="fa fa-square-o fa-2x"></i>
								<i class="fa fa-check-square-o fa-2x"></i>
								<span><strong>Tick the box to activate the password</strong></span>
							</label>
						</div>					


						<div class="form-group" data-toggle="buttons">
							<label class="btn">
								<input type="checkbox" name="txtSendPassword" id="txtSendPassword" />	
								<i class="fa fa-square-o fa-2x"></i>
								<i class="fa fa-check-square-o fa-2x"></i>
								<span><strong>Tick the box to send password to new user by email</strong></span>
							</label>
						</div>

					</form>
				
				</div>

			</div>
        <div class="col-md-2"></div>		
	</div>

</div>

<?php require_once("code/footer_bootstrapjs.php");
}
?>