/*!
 * AnchorJS - v1.2.1 - 2015-07-02
 * https://github.com/bryanbraun/anchorjs
 * Copyright (c) 2015 Bryan Braun; Licensed MIT
 */
function AnchorJS(a){"use strict";this.options=a||{},this._applyRemainingDefaultOptions=function(a){this.options.icon=this.options.hasOwnProperty("icon")?a.icon:"",this.options.visible=this.options.hasOwnProperty("visible")?a.visible:"hover",this.options.placement=this.options.hasOwnProperty("placement")?a.placement:"right",this.options["class"]=this.options.hasOwnProperty("class")?a["class"]:""},this._applyRemainingDefaultOptions(a),this.add=function(a){var b,c,d,e,f,g,h,i,j,k,l,m;if(this._applyRemainingDefaultOptions(this.options),a){if("string"!=typeof a)throw new Error("The selector provided to AnchorJS was invalid.")}else a="h1, h2, h3, h4, h5, h6";if(b=document.querySelectorAll(a),0===b.length)return!1;for(this._addBaselineStyles(),c=document.querySelectorAll("[id]"),d=[].map.call(c,function(a){return a.id}),f=0;f<b.length;f++){if(b[f].hasAttribute("id"))e=b[f].getAttribute("id");else{g=b[f].textContent,h=g.replace(/[^\w\s-]/gi,"").replace(/\s+/g,"-").replace(/-{2,}/g,"-").substring(0,64).replace(/^-+|-+$/gm,"").toLowerCase(),k=h,j=0;do void 0!==i&&(k=h+"-"+j),i=d.indexOf(k),j+=1;while(-1!==i);i=void 0,d.push(k),b[f].setAttribute("id",k),e=k}l=e.replace(/-/g," "),m=document.createElement("a"),m.className="anchorjs-link "+this.options["class"],m.href="#"+e,m.setAttribute("aria-label","Anchor link for: "+l),m.setAttribute("data-anchorjs-icon",this.options.icon),"always"===this.options.visible&&(m.style.opacity="1"),""===this.options.icon&&(m.style.fontFamily="anchorjs-icons",m.style.fontStyle="normal",m.style.fontVariant="normal",m.style.fontWeight="normal",m.style.lineHeight=1),"left"===this.options.placement?(m.style.position="absolute",m.style.marginLeft="-1em",m.style.paddingRight="0.5em",b[f].insertBefore(m,b[f].firstChild)):(m.style.paddingLeft="0.375em",b[f].appendChild(m))}return this},this.remove=function(a){for(var b,c=document.querySelectorAll(a),d=0;d<c.length;d++)b=c[d].querySelector(".anchorjs-link"),b&&c[d].removeChild(b);return this},this._addBaselineStyles=function(){if(null===document.head.querySelector("style.anchorjs")){var a,b=document.createElement("style"),c=" .anchorjs-link {   opacity: 0;   text-decoration: none;   -webkit-font-smoothing: antialiased;   -moz-osx-font-smoothing: grayscale; }",d=" *:hover > .anchorjs-link, .anchorjs-link:focus  {   opacity: 1; }",e=' @font-face {   font-family: "anchorjs-icons";   font-style: normal;   font-weight: normal;   src: url(data:application/x-font-ttf;charset=utf-8;base64,AAEAAAALAIAAAwAwT1MvMg8SBTUAAAC8AAAAYGNtYXAWi9QdAAABHAAAAFRnYXNwAAAAEAAAAXAAAAAIZ2x5Zgq29TcAAAF4AAABNGhlYWQEZM3pAAACrAAAADZoaGVhBhUDxgAAAuQAAAAkaG10eASAADEAAAMIAAAAFGxvY2EAKACuAAADHAAAAAxtYXhwAAgAVwAAAygAAAAgbmFtZQ5yJ3cAAANIAAAB2nBvc3QAAwAAAAAFJAAAACAAAwJAAZAABQAAApkCzAAAAI8CmQLMAAAB6wAzAQkAAAAAAAAAAAAAAAAAAAABEAAAAAAAAAAAAAAAAAAAAABAAADpywPA/8AAQAPAAEAAAAABAAAAAAAAAAAAAAAgAAAAAAADAAAAAwAAABwAAQADAAAAHAADAAEAAAAcAAQAOAAAAAoACAACAAIAAQAg6cv//f//AAAAAAAg6cv//f//AAH/4xY5AAMAAQAAAAAAAAAAAAAAAQAB//8ADwABAAAAAAAAAAAAAgAANzkBAAAAAAEAAAAAAAAAAAACAAA3OQEAAAAAAQAAAAAAAAAAAAIAADc5AQAAAAACADEARAJTAsAAKwBUAAABIiYnJjQ/AT4BMzIWFxYUDwEGIicmND8BNjQnLgEjIgYPAQYUFxYUBw4BIwciJicmND8BNjIXFhQPAQYUFx4BMzI2PwE2NCcmNDc2MhcWFA8BDgEjARQGDAUtLXoWOR8fORYtLTgKGwoKCjgaGg0gEhIgDXoaGgkJBQwHdR85Fi0tOAobCgoKOBoaDSASEiANehoaCQkKGwotLXoWOR8BMwUFLYEuehYXFxYugC44CQkKGwo4GkoaDQ0NDXoaShoKGwoFBe8XFi6ALjgJCQobCjgaShoNDQ0NehpKGgobCgoKLYEuehYXAAEAAAABAACiToc1Xw889QALBAAAAAAA0XnFFgAAAADRecUWAAAAAAJTAsAAAAAIAAIAAAAAAAAAAQAAA8D/wAAABAAAAAAAAlMAAQAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAACAAAAAoAAMQAAAAAACgAUAB4AmgABAAAABQBVAAIAAAAAAAIAAAAAAAAAAAAAAAAAAAAAAAAADgCuAAEAAAAAAAEADgAAAAEAAAAAAAIABwCfAAEAAAAAAAMADgBLAAEAAAAAAAQADgC0AAEAAAAAAAUACwAqAAEAAAAAAAYADgB1AAEAAAAAAAoAGgDeAAMAAQQJAAEAHAAOAAMAAQQJAAIADgCmAAMAAQQJAAMAHABZAAMAAQQJAAQAHADCAAMAAQQJAAUAFgA1AAMAAQQJAAYAHACDAAMAAQQJAAoANAD4YW5jaG9yanMtaWNvbnMAYQBuAGMAaABvAHIAagBzAC0AaQBjAG8AbgBzVmVyc2lvbiAxLjAAVgBlAHIAcwBpAG8AbgAgADEALgAwYW5jaG9yanMtaWNvbnMAYQBuAGMAaABvAHIAagBzAC0AaQBjAG8AbgBzYW5jaG9yanMtaWNvbnMAYQBuAGMAaABvAHIAagBzAC0AaQBjAG8AbgBzUmVndWxhcgBSAGUAZwB1AGwAYQByYW5jaG9yanMtaWNvbnMAYQBuAGMAaABvAHIAagBzAC0AaQBjAG8AbgBzRm9udCBnZW5lcmF0ZWQgYnkgSWNvTW9vbi4ARgBvAG4AdAAgAGcAZQBuAGUAcgBhAHQAZQBkACAAYgB5ACAASQBjAG8ATQBvAG8AbgAuAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==) format("truetype"); }',f=" [data-anchorjs-icon]::after {   content: attr(data-anchorjs-icon); }";b.className="anchorjs",b.appendChild(document.createTextNode("")),a=document.head.querySelector('[rel="stylesheet"], style'),void 0===a?document.head.appendChild(b):document.head.insertBefore(b,a),b.sheet.insertRule(c,b.sheet.cssRules.length),b.sheet.insertRule(d,b.sheet.cssRules.length),b.sheet.insertRule(f,b.sheet.cssRules.length),b.sheet.insertRule(e,b.sheet.cssRules.length)}}}var anchors=new AnchorJS;/*!
 * clipboard.js v1.4.2
 * https://zenorocha.github.io/clipboard.js
 *
 * Licensed MIT � Zeno Rocha
 */
!function(a){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=a();else if("function"==typeof define&&define.amd)define([],a);else{var b;b="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,b.Clipboard=a()}}(function(){return function a(b,c,d){function e(g,h){if(!c[g]){if(!b[g]){var i="function"==typeof require&&require;if(!h&&i)return i(g,!0);if(f)return f(g,!0);var j=new Error("Cannot find module '"+g+"'");throw j.code="MODULE_NOT_FOUND",j}var k=c[g]={exports:{}};b[g][0].call(k.exports,function(a){var c=b[g][1][a];return e(c?c:a)},k,k.exports,a,b,c,d)}return c[g].exports}for(var f="function"==typeof require&&require,g=0;g<d.length;g++)e(d[g]);return e}({1:[function(a,b,c){var d=a("closest"),e=a("component-event"),f=["focus","blur"];c.bind=function(a,b,c,g,h){return-1!==f.indexOf(c)&&(h=!0),e.bind(a,c,function(c){var e=c.target||c.srcElement;c.delegateTarget=d(e,b,!0,a),c.delegateTarget&&g.call(a,c)},h)},c.unbind=function(a,b,c,d){-1!==f.indexOf(b)&&(d=!0),e.unbind(a,b,c,d)}},{closest:2,"component-event":4}],2:[function(a,b,c){var d=a("matches-selector");b.exports=function(a,b,c){for(var e=c?a:a.parentNode;e&&e!==document;){if(d(e,b))return e;e=e.parentNode}}},{"matches-selector":3}],3:[function(a,b,c){function d(a,b){if(f)return f.call(a,b);for(var c=a.parentNode.querySelectorAll(b),d=0;d<c.length;++d)if(c[d]==a)return!0;return!1}var e=Element.prototype,f=e.matchesSelector||e.webkitMatchesSelector||e.mozMatchesSelector||e.msMatchesSelector||e.oMatchesSelector;b.exports=d},{}],4:[function(a,b,c){var d=window.addEventListener?"addEventListener":"attachEvent",e=window.removeEventListener?"removeEventListener":"detachEvent",f="addEventListener"!==d?"on":"";c.bind=function(a,b,c,e){return a[d](f+b,c,e||!1),c},c.unbind=function(a,b,c,d){return a[e](f+b,c,d||!1),c}},{}],5:[function(a,b,c){function d(){}d.prototype={on:function(a,b,c){var d=this.e||(this.e={});return(d[a]||(d[a]=[])).push({fn:b,ctx:c}),this},once:function(a,b,c){var d=this,e=function(){d.off(a,e),b.apply(c,arguments)};return this.on(a,e,c)},emit:function(a){var b=[].slice.call(arguments,1),c=((this.e||(this.e={}))[a]||[]).slice(),d=0,e=c.length;for(d;e>d;d++)c[d].fn.apply(c[d].ctx,b);return this},off:function(a,b){var c=this.e||(this.e={}),d=c[a],e=[];if(d&&b)for(var f=0,g=d.length;g>f;f++)d[f].fn!==b&&e.push(d[f]);return e.length?c[a]=e:delete c[a],this}},b.exports=d},{}],6:[function(a,b,c){"use strict";function d(a,b){if(!(a instanceof b))throw new TypeError("Cannot call a class as a function")}c.__esModule=!0;var e=function(){function a(a,b){for(var c=0;c<b.length;c++){var d=b[c];d.enumerable=d.enumerable||!1,d.configurable=!0,"value"in d&&(d.writable=!0),Object.defineProperty(a,d.key,d)}}return function(b,c,d){return c&&a(b.prototype,c),d&&a(b,d),b}}(),f=function(){function a(b){d(this,a),this.resolveOptions(b),this.initSelection()}return a.prototype.resolveOptions=function(){var a=arguments.length<=0||void 0===arguments[0]?{}:arguments[0];this.action=a.action,this.emitter=a.emitter,this.target=a.target,this.text=a.text,this.trigger=a.trigger,this.selectedText=""},a.prototype.initSelection=function(){if(this.text&&this.target)throw new Error('Multiple attributes declared, use either "target" or "text"');if(this.text)this.selectFake();else{if(!this.target)throw new Error('Missing required attributes, use either "target" or "text"');this.selectTarget()}},a.prototype.selectFake=function(){var a=this;this.removeFake(),this.fakeHandler=document.body.addEventListener("click",function(){return a.removeFake()}),this.fakeElem=document.createElement("textarea"),this.fakeElem.style.position="absolute",this.fakeElem.style.left="-9999px",this.fakeElem.style.top=(window.pageYOffset||document.documentElement.scrollTop)+"px",this.fakeElem.setAttribute("readonly",""),this.fakeElem.value=this.text,this.selectedText=this.text,document.body.appendChild(this.fakeElem),this.fakeElem.select(),this.copyText()},a.prototype.removeFake=function(){this.fakeHandler&&(document.body.removeEventListener("click"),this.fakeHandler=null),this.fakeElem&&(document.body.removeChild(this.fakeElem),this.fakeElem=null)},a.prototype.selectTarget=function(){if("INPUT"===this.target.nodeName||"TEXTAREA"===this.target.nodeName)this.target.select(),this.selectedText=this.target.value;else{var a=document.createRange(),b=window.getSelection();b.removeAllRanges(),a.selectNodeContents(this.target),b.addRange(a),this.selectedText=b.toString()}this.copyText()},a.prototype.copyText=function(){var a=void 0;try{a=document.execCommand(this.action)}catch(b){a=!1}this.handleResult(a)},a.prototype.handleResult=function(a){a?this.emitter.emit("success",{action:this.action,text:this.selectedText,trigger:this.trigger,clearSelection:this.clearSelection.bind(this)}):this.emitter.emit("error",{action:this.action,trigger:this.trigger,clearSelection:this.clearSelection.bind(this)})},a.prototype.clearSelection=function(){this.target&&this.target.blur(),window.getSelection().removeAllRanges()},a.prototype.destroy=function(){this.removeFake()},e(a,[{key:"action",set:function(){var a=arguments.length<=0||void 0===arguments[0]?"copy":arguments[0];if(this._action=a,"copy"!==this._action&&"cut"!==this._action)throw new Error('Invalid "action" value, use either "copy" or "cut"')},get:function(){return this._action}},{key:"target",set:function(a){if(void 0!==a){if(!a||"object"!=typeof a||1!==a.nodeType)throw new Error('Invalid "target" value, use a valid Element');this._target=a}},get:function(){return this._target}}]),a}();c["default"]=f,b.exports=c["default"]},{}],7:[function(a,b,c){"use strict";function d(a){return a&&a.__esModule?a:{"default":a}}function e(a,b){if(!(a instanceof b))throw new TypeError("Cannot call a class as a function")}function f(a,b){if("function"!=typeof b&&null!==b)throw new TypeError("Super expression must either be null or a function, not "+typeof b);a.prototype=Object.create(b&&b.prototype,{constructor:{value:a,enumerable:!1,writable:!0,configurable:!0}}),b&&(Object.setPrototypeOf?Object.setPrototypeOf(a,b):a.__proto__=b)}function g(a,b){var c="data-clipboard-"+a;return b.hasAttribute(c)?b.getAttribute(c):void 0}c.__esModule=!0;var h=a("./clipboard-action"),i=d(h),j=a("delegate-events"),k=d(j),l=a("tiny-emitter"),m=d(l),n=function(a){function b(c,d){e(this,b),a.call(this),this.resolveOptions(d),this.delegateClick(c)}return f(b,a),b.prototype.resolveOptions=function(){var a=arguments.length<=0||void 0===arguments[0]?{}:arguments[0];this.action="function"==typeof a.action?a.action:this.defaultAction,this.target="function"==typeof a.target?a.target:this.defaultTarget,this.text="function"==typeof a.text?a.text:this.defaultText},b.prototype.delegateClick=function(a){var b=this;this.binding=k["default"].bind(document.body,a,"click",function(a){return b.onClick(a)})},b.prototype.undelegateClick=function(){k["default"].unbind(document.body,"click",this.binding)},b.prototype.onClick=function(a){this.clipboardAction&&(this.clipboardAction=null),this.clipboardAction=new i["default"]({action:this.action(a.delegateTarget),target:this.target(a.delegateTarget),text:this.text(a.delegateTarget),trigger:a.delegateTarget,emitter:this})},b.prototype.defaultAction=function(a){return g("action",a)},b.prototype.defaultTarget=function(a){var b=g("target",a);return b?document.querySelector(b):void 0},b.prototype.defaultText=function(a){return g("text",a)},b.prototype.destroy=function(){this.undelegateClick(),this.clipboardAction&&(this.clipboardAction.destroy(),this.clipboardAction=null)},b}(m["default"]);c["default"]=n,b.exports=c["default"]},{"./clipboard-action":6,"delegate-events":1,"tiny-emitter":5}]},{},[7])(7)}),/*!

Holder - client side image placeholders
Version 2.8.2+c34r9
© 2015 Ivan Malopinsky - http://imsky.co

Site:     http://holderjs.com
Issues:   https://github.com/imsky/holder/issues
License:  MIT

*/
!function(a){if(a.document){var b=a.document;b.querySelectorAll||(b.querySelectorAll=function(c){var d,e=b.createElement("style"),f=[];for(b.documentElement.firstChild.appendChild(e),b._qsa=[],e.styleSheet.cssText=c+"{x-qsa:expression(document._qsa && document._qsa.push(this))}",a.scrollBy(0,0),e.parentNode.removeChild(e);b._qsa.length;)d=b._qsa.shift(),d.style.removeAttribute("x-qsa"),f.push(d);return b._qsa=null,f}),b.querySelector||(b.querySelector=function(a){var c=b.querySelectorAll(a);return c.length?c[0]:null}),b.getElementsByClassName||(b.getElementsByClassName=function(a){return a=String(a).replace(/^|\s+/g,"."),b.querySelectorAll(a)}),Object.keys||(Object.keys=function(a){if(a!==Object(a))throw TypeError("Object.keys called on non-object");var b,c=[];for(b in a)Object.prototype.hasOwnProperty.call(a,b)&&c.push(b);return c}),Array.prototype.forEach||(Array.prototype.forEach=function(a){if(void 0===this||null===this)throw TypeError();var b=Object(this),c=b.length>>>0;if("function"!=typeof a)throw TypeError();var d,e=arguments[1];for(d=0;c>d;d++)d in b&&a.call(e,b[d],d,b)}),function(a){var b="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";a.atob=a.atob||function(a){a=String(a);var c,d=0,e=[],f=0,g=0;if(a=a.replace(/\s/g,""),a.length%4===0&&(a=a.replace(/=+$/,"")),a.length%4===1)throw Error("InvalidCharacterError");if(/[^+\/0-9A-Za-z]/.test(a))throw Error("InvalidCharacterError");for(;d<a.length;)c=b.indexOf(a.charAt(d)),f=f<<6|c,g+=6,24===g&&(e.push(String.fromCharCode(f>>16&255)),e.push(String.fromCharCode(f>>8&255)),e.push(String.fromCharCode(255&f)),g=0,f=0),d+=1;return 12===g?(f>>=4,e.push(String.fromCharCode(255&f))):18===g&&(f>>=2,e.push(String.fromCharCode(f>>8&255)),e.push(String.fromCharCode(255&f))),e.join("")},a.btoa=a.btoa||function(a){a=String(a);var c,d,e,f,g,h,i,j=0,k=[];if(/[^\x00-\xFF]/.test(a))throw Error("InvalidCharacterError");for(;j<a.length;)c=a.charCodeAt(j++),d=a.charCodeAt(j++),e=a.charCodeAt(j++),f=c>>2,g=(3&c)<<4|d>>4,h=(15&d)<<2|e>>6,i=63&e,j===a.length+2?(h=64,i=64):j===a.length+1&&(i=64),k.push(b.charAt(f),b.charAt(g),b.charAt(h),b.charAt(i));return k.join("")}}(a),Object.prototype.hasOwnProperty||(Object.prototype.hasOwnProperty=function(a){var b=this.__proto__||this.constructor.prototype;return a in this&&(!(a in b)||b[a]!==this[a])}),function(){if("performance"in a==0&&(a.performance={}),Date.now=Date.now||function(){return(new Date).getTime()},"now"in a.performance==0){var b=Date.now();performance.timing&&performance.timing.navigationStart&&(b=performance.timing.navigationStart),a.performance.now=function(){return Date.now()-b}}}(),a.requestAnimationFrame||(a.webkitRequestAnimationFrame?!function(a){a.requestAnimationFrame=function(b){return webkitRequestAnimationFrame(function(){b(a.performance.now())})},a.cancelAnimationFrame=webkitCancelAnimationFrame}(a):a.mozRequestAnimationFrame?!function(a){a.requestAnimationFrame=function(b){return mozRequestAnimationFrame(function(){b(a.performance.now())})},a.cancelAnimationFrame=mozCancelAnimationFrame}(a):!function(a){a.requestAnimationFrame=function(b){return a.setTimeout(b,1e3/60)},a.cancelAnimationFrame=a.clearTimeout}(a))}}(this),function(a,b){"object"==typeof exports&&"object"==typeof module?module.exports=b():"function"==typeof define&&define.amd?define(b):"object"==typeof exports?exports.Holder=b():a.Holder=b()}(this,function(){return function(a){function b(d){if(c[d])return c[d].exports;var e=c[d]={exports:{},id:d,loaded:!1};return a[d].call(e.exports,e,e.exports,b),e.loaded=!0,e.exports}var c={};return b.m=a,b.c=c,b.p="",b(0)}([function(a,b,c){a.exports=c(1)},function(a,b,c){(function(b){function d(a,b,c,d){var g=e(c.substr(c.lastIndexOf(a.domain)),a);g&&f({mode:null,el:d,flags:g,engineSettings:b})}function e(a,b){var c={theme:z(D.settings.themes.gray,null),stylesheets:b.stylesheets,instanceOptions:b},d=a.split("?"),e=d[0].split("/");c.holderURL=a;var f=e[1],g=f.match(/([\d]+p?)x([\d]+p?)/);if(!g)return!1;if(c.fluid=-1!==f.indexOf("p"),c.dimensions={width:g[1].replace("p","%"),height:g[2].replace("p","%")},2===d.length){var h=r.parse(d[1]);if(h.bg&&(c.theme.background=t.parseColor(h.bg)),h.fg&&(c.theme.foreground=t.parseColor(h.fg)),h.bg&&!h.fg&&(c.autoFg=!0),h.theme&&c.instanceOptions.themes.hasOwnProperty(h.theme)&&(c.theme=z(c.instanceOptions.themes[h.theme],null)),h.text&&(c.text=h.text),h.textmode&&(c.textmode=h.textmode),h.size&&(c.size=h.size),h.font&&(c.font=h.font),h.align&&(c.align=h.align),c.nowrap=t.truthy(h.nowrap),c.auto=t.truthy(h.auto),c.outline=t.truthy(h.outline),t.truthy(h.random)){D.vars.cache.themeKeys=D.vars.cache.themeKeys||Object.keys(c.instanceOptions.themes);var i=D.vars.cache.themeKeys[0|Math.random()*D.vars.cache.themeKeys.length];c.theme=z(c.instanceOptions.themes[i],null)}}return c}function f(a){var b=a.mode,c=a.el,d=a.flags,e=a.engineSettings,f=d.dimensions,h=d.theme,i=f.width+"x"+f.height;if(b=null==b?d.fluid?"fluid":"image":b,null!=d.text&&(h.text=d.text,"object"===c.nodeName.toLowerCase())){for(var l=h.text.split("\\n"),m=0;m<l.length;m++)l[m]=t.encodeHtmlEntity(l[m]);h.text=l.join("\\n")}var n=d.holderURL,o=z(e,null);if(d.font&&(h.font=d.font,!o.noFontFallback&&"img"===c.nodeName.toLowerCase()&&D.setup.supportsCanvas&&"svg"===o.renderer&&(o=z(o,{renderer:"canvas"}))),d.font&&"canvas"==o.renderer&&(o.reRender=!0),"background"==b)null==c.getAttribute("data-background-src")&&v.setAttr(c,{"data-background-src":n});else{var p={};p[D.vars.dataAttr]=n,v.setAttr(c,p)}d.theme=h,c.holderData={flags:d,engineSettings:o},("image"==b||"fluid"==b)&&v.setAttr(c,{alt:h.text?h.text+" ["+i+"]":i});var q={mode:b,el:c,holderSettings:{dimensions:f,theme:h,flags:d},engineSettings:o};"image"==b?(d.auto||(c.style.width=f.width+"px",c.style.height=f.height+"px"),"html"==o.renderer?c.style.backgroundColor=h.background:(g(q),"exact"==d.textmode&&(c.holderData.resizeUpdate=!0,D.vars.resizableImages.push(c),j(c)))):"background"==b&&"html"!=o.renderer?g(q):"fluid"==b&&(c.holderData.resizeUpdate=!0,"%"==f.height.slice(-1)?c.style.height=f.height:null!=d.auto&&d.auto||(c.style.height=f.height+"px"),"%"==f.width.slice(-1)?c.style.width=f.width:null!=d.auto&&d.auto||(c.style.width=f.width+"px"),("inline"==c.style.display||""===c.style.display||"none"==c.style.display)&&(c.style.display="block"),k(c),"html"==o.renderer?c.style.backgroundColor=h.background:(D.vars.resizableImages.push(c),j(c)))}function g(a){function c(){var b=null;switch(i.renderer){case"canvas":b=F(k,a);break;case"svg":b=y(k,a);break;default:throw"Holder: invalid renderer: "+i.renderer}return b}var d=null,e=a.mode,f=a.el,g=a.holderSettings,i=a.engineSettings;switch(i.renderer){case"svg":if(!D.setup.supportsSVG)return;break;case"canvas":if(!D.setup.supportsCanvas)return;break;default:return}var j={width:g.dimensions.width,height:g.dimensions.height,theme:g.theme,flags:g.flags},k=h(j);if(d=c(),null==d)throw"Holder: couldn't render placeholder";"background"==e?(f.style.backgroundImage="url("+d+")",f.style.backgroundSize=j.width+"px "+j.height+"px"):("img"===f.nodeName.toLowerCase()?v.setAttr(f,{src:d}):"object"===f.nodeName.toLowerCase()&&(v.setAttr(f,{data:d}),v.setAttr(f,{type:"image/svg+xml"})),i.reRender&&b.setTimeout(function(){var a=c();if(null==a)throw"Holder: couldn't render placeholder";"img"===f.nodeName.toLowerCase()?v.setAttr(f,{src:a}):"object"===f.nodeName.toLowerCase()&&(v.setAttr(f,{data:a}),v.setAttr(f,{type:"image/svg+xml"}))},150)),v.setAttr(f,{"data-holder-rendered":!0})}function h(a){function b(a,b,c,d){b.width=c,b.height=d,a.width=Math.max(a.width,b.width),a.height+=b.height}var c=D.defaults.size;switch(parseFloat(a.theme.size)?c=a.theme.size:parseFloat(a.flags.size)&&(c=a.flags.size),a.font={family:a.theme.font?a.theme.font:"Arial, Helvetica, Open Sans, sans-serif",size:i(a.width,a.height,c,D.defaults.scale),units:a.theme.units?a.theme.units:D.defaults.units,weight:a.theme.fontweight?a.theme.fontweight:"bold"},a.text=a.theme.text||Math.floor(a.width)+"x"+Math.floor(a.height),a.noWrap=a.theme.nowrap||a.flags.nowrap,a.align=a.theme.align||a.flags.align||"center",a.flags.textmode){case"literal":a.text=a.flags.dimensions.width+"x"+a.flags.dimensions.height;break;case"exact":if(!a.flags.exactDimensions)break;a.text=Math.floor(a.flags.exactDimensions.width)+"x"+Math.floor(a.flags.exactDimensions.height)}var d=new s({width:a.width,height:a.height}),e=d.Shape,f=new e.Rect("holderBg",{fill:a.theme.background});if(f.resize(a.width,a.height),d.root.add(f),a.flags.outline){var g=new w(f.properties.fill);g=g.lighten(g.lighterThan("7f7f7f")?-.1:.1),f.properties.outline={fill:g.toHex(!0),width:2}}var h=a.theme.foreground;if(a.flags.autoFg){var j=new w(f.properties.fill),k=new w("fff"),l=new w("000",{alpha:.285714});h=j.blendAlpha(j.lighterThan("7f7f7f")?l:k).toHex(!0)}var m=new e.Group("holderTextGroup",{text:a.text,align:a.align,font:a.font,fill:h});m.moveTo(null,null,1),d.root.add(m);var n=m.textPositionData=E(d);if(!n)throw"Holder: staging fallback not supported yet.";m.properties.leading=n.boundingBox.height;var o=null,p=null,q=a.width*D.vars.lineWrapRatio,r=q;if(n.lineCount>1){var t,u=0,v=0,x=0;p=new e.Group("line"+x),("left"===a.align||"right"===a.align)&&(r=a.width*(1-2*(1-D.vars.lineWrapRatio)));for(var y=0;y<n.words.length;y++){var z=n.words[y];o=new e.Text(z.text);var A="\\n"==z.text;!a.noWrap&&(u+z.width>=r||A===!0)&&(b(m,p,u,m.properties.leading),m.add(p),u=0,v+=m.properties.leading,x+=1,p=new e.Group("line"+x),p.y=v),A!==!0&&(o.moveTo(u,0),u+=n.spaceWidth+z.width,p.add(o))}if(b(m,p,u,m.properties.leading),m.add(p),"left"===a.align)m.moveTo(a.width-q,null,null);else if("right"===a.align){for(t in m.children)p=m.children[t],p.moveTo(a.width-p.width,null,null);m.moveTo(0-(a.width-q),null,null)}else{for(t in m.children)p=m.children[t],p.moveTo((m.width-p.width)/2,null,null);m.moveTo((a.width-m.width)/2,null,null)}m.moveTo(null,(a.height-m.height)/2,null),(a.height-m.height)/2<0&&m.moveTo(null,0,null)}else o=new e.Text(a.text),p=new e.Group("line0"),p.add(o),m.add(p),"left"===a.align?m.moveTo(a.width-q,null,null):"right"===a.align?m.moveTo(0-(a.width-q),null,null):m.moveTo((a.width-n.boundingBox.width)/2,null,null),m.moveTo(null,(a.height-n.boundingBox.height)/2,null);return d}function i(a,b,c,d){var e=parseInt(a,10),f=parseInt(b,10),g=Math.max(e,f),h=Math.min(e,f),i=.8*Math.min(h,g*d);return Math.round(Math.max(c,i))}function j(a){var b;b=null==a||null==a.nodeType?D.vars.resizableImages:[a];for(var c=0,d=b.length;d>c;c++){var e=b[c];if(e.holderData){var f=e.holderData.flags,h=A(e);if(h){if(!e.holderData.resizeUpdate)continue;if(f.fluid&&f.auto){var i=e.holderData.fluidConfig;switch(i.mode){case"width":h.height=h.width/i.ratio;break;case"height":h.width=h.height*i.ratio}}var j={mode:"image",holderSettings:{dimensions:h,theme:f.theme,flags:f},el:e,engineSettings:e.holderData.engineSettings};"exact"==f.textmode&&(f.exactDimensions=h,j.holderSettings.dimensions=f.dimensions),g(j)}else n(e)}}}function k(a){if(a.holderData){var b=A(a);if(b){var c=a.holderData.flags,d={fluidHeight:"%"==c.dimensions.height.slice(-1),fluidWidth:"%"==c.dimensions.width.slice(-1),mode:null,initialDimensions:b};d.fluidWidth&&!d.fluidHeight?(d.mode="width",d.ratio=d.initialDimensions.width/parseFloat(c.dimensions.height)):!d.fluidWidth&&d.fluidHeight&&(d.mode="height",d.ratio=parseFloat(c.dimensions.width)/d.initialDimensions.height),a.holderData.fluidConfig=d}else n(a)}}function l(){var a,c=[],d=Object.keys(D.vars.invisibleImages);d.forEach(function(b){a=D.vars.invisibleImages[b],A(a)&&"img"==a.nodeName.toLowerCase()&&(c.push(a),delete D.vars.invisibleImages[b])}),c.length&&C.run({images:c}),setTimeout(function(){b.requestAnimationFrame(l)},10)}function m(){D.vars.visibilityCheckStarted||(b.requestAnimationFrame(l),D.vars.visibilityCheckStarted=!0)}function n(a){a.holderData.invisibleId||(D.vars.invisibleId+=1,D.vars.invisibleImages["i"+D.vars.invisibleId]=a,a.holderData.invisibleId=D.vars.invisibleId)}function o(a){D.vars.debounceTimer||a.call(this),D.vars.debounceTimer&&b.clearTimeout(D.vars.debounceTimer),D.vars.debounceTimer=b.setTimeout(function(){D.vars.debounceTimer=null,a.call(this)},D.setup.debounce)}function p(){o(function(){j(null)})}var q=c(2),r=c(3),s=c(4),t=c(5),u=c(6),v=c(7),w=c(8),x=c(9),y=c(10),z=t.extend,A=t.dimensionCheck,B=x.svg_ns,C={version:x.version,addTheme:function(a,b){return null!=a&&null!=b&&(D.settings.themes[a]=b),delete D.vars.cache.themeKeys,this},addImage:function(a,b){var c=v.getNodeArray(b);return c.forEach(function(b){var c=v.newEl("img"),d={};d[D.setup.dataAttr]=a,v.setAttr(c,d),b.appendChild(c)}),this},setResizeUpdate:function(a,b){a.holderData&&(a.holderData.resizeUpdate=!!b,a.holderData.resizeUpdate&&j(a))},run:function(a){a=a||{};var c={},g=z(D.settings,a);D.vars.preempted=!0,D.vars.dataAttr=g.dataAttr||D.setup.dataAttr,D.vars.lineWrapRatio=g.lineWrapRatio||D.setup.lineWrapRatio,c.renderer=g.renderer?g.renderer:D.setup.renderer,-1===D.setup.renderers.join(",").indexOf(c.renderer)&&(c.renderer=D.setup.supportsSVG?"svg":D.setup.supportsCanvas?"canvas":"html");var h=v.getNodeArray(g.images),i=v.getNodeArray(g.bgnodes),j=v.getNodeArray(g.stylenodes),k=v.getNodeArray(g.objects);return c.stylesheets=[],c.svgXMLStylesheet=!0,c.noFontFallback=g.noFontFallback?g.noFontFallback:!1,j.forEach(function(a){if(a.attributes.rel&&a.attributes.href&&"stylesheet"==a.attributes.rel.value){var b=a.attributes.href.value,d=v.newEl("a");d.href=b;var e=d.protocol+"//"+d.host+d.pathname+d.search;c.stylesheets.push(e)}}),i.forEach(function(a){if(b.getComputedStyle){var d=b.getComputedStyle(a,null).getPropertyValue("background-image"),h=a.getAttribute("data-background-src"),i=h||d,j=null,k=g.domain+"/",l=i.indexOf(k);if(0===l)j=i;else if(1===l&&"?"===i[0])j=i.slice(1);else{var m=i.substr(l).match(/([^\"]*)"?\)/);if(null!==m)j=m[1];else if(0===i.indexOf("url("))throw"Holder: unable to parse background URL: "+i}if(null!=j){var n=e(j,g);n&&f({mode:"background",el:a,flags:n,engineSettings:c})}}}),k.forEach(function(a){var b={};try{b.data=a.getAttribute("data"),b.dataSrc=a.getAttribute(D.vars.dataAttr)}catch(e){}var f=null!=b.data&&0===b.data.indexOf(g.domain),h=null!=b.dataSrc&&0===b.dataSrc.indexOf(g.domain);f?d(g,c,b.data,a):h&&d(g,c,b.dataSrc,a)}),h.forEach(function(a){var b={};try{b.src=a.getAttribute("src"),b.dataSrc=a.getAttribute(D.vars.dataAttr),b.rendered=a.getAttribute("data-holder-rendered")}catch(e){}var f=null!=b.src,h=null!=b.dataSrc&&0===b.dataSrc.indexOf(g.domain),i=null!=b.rendered&&"true"==b.rendered;f?0===b.src.indexOf(g.domain)?d(g,c,b.src,a):h&&(i?d(g,c,b.dataSrc,a):!function(a,b,c,e,f){t.imageExists(a,function(a){a||d(b,c,e,f)})}(b.src,g,c,b.dataSrc,a)):h&&d(g,c,b.dataSrc,a)}),this}},D={settings:{domain:"holder.js",images:"img",objects:"object",bgnodes:"body .holderjs",stylenodes:"head link.holderjs",themes:{gray:{background:"#EEEEEE",foreground:"#AAAAAA"},social:{background:"#3a5a97",foreground:"#FFFFFF"},industrial:{background:"#434A52",foreground:"#C2F200"},sky:{background:"#0D8FDB",foreground:"#FFFFFF"},vine:{background:"#39DBAC",foreground:"#1E292C"},lava:{background:"#F8591A",foreground:"#1C2846"}}},defaults:{size:10,units:"pt",scale:1/16}},E=function(){var a=null,b=null,c=null;return function(d){var e=d.root;if(D.setup.supportsSVG){var f=!1,g=function(a){return document.createTextNode(a)};(null==a||a.parentNode!==document.body)&&(f=!0),a=u.initSVG(a,e.properties.width,e.properties.height),a.style.display="block",f&&(b=v.newEl("text",B),c=g(null),v.setAttr(b,{x:0}),b.appendChild(c),a.appendChild(b),document.body.appendChild(a),a.style.visibility="hidden",a.style.position="absolute",a.style.top="-100%",a.style.left="-100%");var h=e.children.holderTextGroup,i=h.properties;v.setAttr(b,{y:i.font.size,style:t.cssProps({"font-weight":i.font.weight,"font-size":i.font.size+i.font.units,"font-family":i.font.family})}),c.nodeValue=i.text;var j=b.getBBox(),k=Math.ceil(j.width/(e.properties.width*D.vars.lineWrapRatio)),l=i.text.split(" "),m=i.text.match(/\\n/g);k+=null==m?0:m.length,c.nodeValue=i.text.replace(/[ ]+/g,"");var n=b.getComputedTextLength(),o=j.width-n,p=Math.round(o/Math.max(1,l.length-1)),q=[];if(k>1){c.nodeValue="";for(var r=0;r<l.length;r++)if(0!==l[r].length){c.nodeValue=t.decodeHtmlEntity(l[r]);var s=b.getBBox();q.push({text:l[r],width:s.width})}}return a.style.display="none",{spaceWidth:p,lineCount:k,boundingBox:j,words:q}}return!1}}(),F=function(){var a=v.newEl("canvas"),b=null;return function(c){null==b&&(b=a.getContext("2d"));var d=c.root;a.width=D.dpr(d.properties.width),a.height=D.dpr(d.properties.height),b.textBaseline="middle";var e=d.children.holderBg,f=D.dpr(e.width),g=D.dpr(e.height),h=2,i=h/2;b.fillStyle=e.properties.fill,b.fillRect(0,0,f,g),e.properties.outline&&(b.strokeStyle=e.properties.outline.fill,b.lineWidth=e.properties.outline.width,b.moveTo(i,i),b.lineTo(f-i,i),b.lineTo(f-i,g-i),b.lineTo(i,g-i),b.lineTo(i,i),b.moveTo(0,i),b.lineTo(f,g-i),b.moveTo(0,g-i),b.lineTo(f,i),b.stroke());var j=d.children.holderTextGroup;b.font=j.properties.font.weight+" "+D.dpr(j.properties.font.size)+j.properties.font.units+" "+j.properties.font.family+", monospace",b.fillStyle=j.properties.fill;for(var k in j.children){var l=j.children[k];for(var m in l.children){var n=l.children[m],o=D.dpr(j.x+l.x+n.x),p=D.dpr(j.y+l.y+n.y+j.properties.leading/2);b.fillText(n.properties.text,o,p)}}return a.toDataURL("image/png")}}();for(var G in D.flags)D.flags.hasOwnProperty(G)&&(D.flags[G].match=function(a){return a.match(this.regex)});D.setup={renderer:"html",debounce:100,ratio:1,supportsCanvas:!1,supportsSVG:!1,lineWrapRatio:.9,dataAttr:"data-src",renderers:["html","canvas","svg"]},D.dpr=function(a){return a*D.setup.ratio},D.vars={preempted:!1,resizableImages:[],invisibleImages:{},invisibleId:0,visibilityCheckStarted:!1,debounceTimer:null,cache:{}},function(){var a=1,c=1,d=v.newEl("canvas"),e=null;d.getContext&&-1!=d.toDataURL("image/png").indexOf("data:image/png")&&(D.setup.renderer="canvas",e=d.getContext("2d"),D.setup.supportsCanvas=!0),D.setup.supportsCanvas&&(a=b.devicePixelRatio||1,c=e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1),D.setup.ratio=a/c,document.createElementNS&&document.createElementNS(B,"svg").createSVGRect&&(D.setup.renderer="svg",D.setup.supportsSVG=!0)}(),m(),q&&q(function(){D.vars.preempted||C.run(),b.addEventListener?(b.addEventListener("resize",p,!1),b.addEventListener("orientationchange",p,!1)):b.attachEvent("onresize",p),"object"==typeof b.Turbolinks&&b.document.addEventListener("page:change",function(){C.run()})}),a.exports=C}).call(b,function(){return this}())},function(a,b,c){function d(a){function b(a){if(!v){if(!g.body)return e(b);for(v=!0;a=w.shift();)e(a)}}function c(a){(t||a.type===i||g[m]===l)&&(d(),b())}function d(){t?(g[s](q,c,j),a[s](i,c,j)):(g[o](r,c),a[o](k,c))}function e(a,b){setTimeout(a,+b>=0?b:1)}function f(a){v?e(a):w.push(a)}null==document.readyState&&document.addEventListener&&(document.addEventListener("DOMContentLoaded",function y(){document.removeEventListener("DOMContentLoaded",y,!1),document.readyState="complete"},!1),document.readyState="loading");var g=a.document,h=g.documentElement,i="load",j=!1,k="on"+i,l="complete",m="readyState",n="attachEvent",o="detachEvent",p="addEventListener",q="DOMContentLoaded",r="onreadystatechange",s="removeEventListener",t=p in g,u=j,v=j,w=[];if(g[m]===l)e(b);else if(t)g[p](q,c,j),a[p](i,c,j);else{g[n](r,c),a[n](k,c);try{u=null==a.frameElement&&h}catch(x){}u&&u.doScroll&&!function z(){if(!v){try{u.doScroll("left")}catch(a){return e(z,50)}d(),b()}}()}return f.version="1.4.0",f.isReady=function(){return v},f}a.exports="undefined"!=typeof window&&d(window)},function(a,b,c){var d=encodeURIComponent,e=decodeURIComponent,f=c(11),g=c(12),h=/(\w+)\[(\d+)\]/,i=/\w+\.\w+/;b.parse=function(a){if("string"!=typeof a)return{};if(a=f(a),""===a)return{};"?"===a.charAt(0)&&(a=a.slice(1));for(var b={},c=a.split("&"),d=0;d<c.length;d++){var g,j,k,l=c[d].split("="),m=e(l[0]);if(g=h.exec(m))b[g[1]]=b[g[1]]||[],b[g[1]][g[2]]=e(l[1]);else if(g=i.test(m)){for(g=m.split("."),j=b;g.length;)if(k=g.shift(),k.length){if(j[k]){if(j[k]&&"object"!=typeof j[k])break}else j[k]={};g.length||(j[k]=e(l[1])),j=j[k]}}else b[l[0]]=null==l[1]?"":e(l[1])}return b},b.stringify=function(a){if(!a)return"";var b=[];for(var c in a){var e=a[c];if("array"!=g(e))b.push(d(c)+"="+d(a[c]));else for(var f=0;f<e.length;++f)b.push(d(c+"["+f+"]")+"="+d(e[f]))}return b.join("&")}},function(a,b,c){var d=function(a){function b(a,b){for(var c in b)a[c]=b[c];return a}var c=1,d=function(a){c++,this.parent=null,this.children={},this.id=c,this.name="n"+c,"undefined"!=typeof a&&(this.name=a),this.x=this.y=this.z=0,this.width=this.height=0};d.prototype.resize=function(a,b){null!=a&&(this.width=a),null!=b&&(this.height=b)},d.prototype.moveTo=function(a,b,c){this.x=null!=a?a:this.x,this.y=null!=b?b:this.y,this.z=null!=c?c:this.z},d.prototype.add=function(a){var b=a.name;if("undefined"!=typeof this.children[b])throw"SceneGraph: child already exists: "+b;this.children[b]=a,a.parent=this};var e=function(){d.call(this,"root"),this.properties=a};e.prototype=new d;var f=function(a,c){if(d.call(this,a),this.properties={fill:"#000000"},"undefined"!=typeof c)b(this.properties,c);else if("undefined"!=typeof a&&"string"!=typeof a)throw"SceneGraph: invalid node name"};f.prototype=new d;var g=function(){f.apply(this,arguments),this.type="group"};g.prototype=new f;var h=function(){f.apply(this,arguments),this.type="rect"};h.prototype=new f;var i=function(a){f.call(this),this.type="text",this.properties.text=a};i.prototype=new f;var j=new e;return this.Shape={Rect:h,Text:i,Group:g},this.root=j,this};a.exports=d},function(a,b,c){b.extend=function(a,b){var c={};for(var d in a)a.hasOwnProperty(d)&&(c[d]=a[d]);if(null!=b)for(var e in b)b.hasOwnProperty(e)&&(c[e]=b[e]);return c},b.cssProps=function(a){var b=[];for(var c in a)a.hasOwnProperty(c)&&b.push(c+":"+a[c]);return b.join(";")},b.encodeHtmlEntity=function(a){for(var b=[],c=0,d=a.length-1;d>=0;d--)c=a.charCodeAt(d),b.unshift(c>128?["&#",c,";"].join(""):a[d]);return b.join("")},b.imageExists=function(a,b){var c=new Image;c.onerror=function(){b.call(this,!1)},c.onload=function(){b.call(this,!0)},c.src=a},b.decodeHtmlEntity=function(a){return a.replace(/&#(\d+);/g,function(a,b){return String.fromCharCode(b)})},b.dimensionCheck=function(a){var b={height:a.clientHeight,width:a.clientWidth};return b.height&&b.width?b:!1},b.truthy=function(a){return"string"==typeof a?"true"===a||"yes"===a||"1"===a||"on"===a||"✓"===a:!!a},b.parseColor=function(a){var b,c=/(^(?:#?)[0-9a-f]{6}$)|(^(?:#?)[0-9a-f]{3}$)/i,d=/^rgb\((\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/,e=/^rgba\((\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(0\.\d{1,}|1)\)$/,f=a.match(c);return null!==f?(b=f[1]||f[2],"#"!==b[0]?"#"+b:b):(f=a.match(d),null!==f?b="rgb("+f.slice(1).join(",")+")":(f=a.match(e),null!==f?b="rgba("+f.slice(1).join(",")+")":null))}},function(a,b,c){(function(a){var d=c(7),e="http://www.w3.org/2000/svg",f=8;b.initSVG=function(a,b,c){var g,h,i=!1;a&&a.querySelector?(h=a.querySelector("style"),null===h&&(i=!0)):(a=d.newEl("svg",e),i=!0),i&&(g=d.newEl("defs",e),h=d.newEl("style",e),d.setAttr(h,{type:"text/css"}),g.appendChild(h),a.appendChild(g)),a.webkitMatchesSelector&&a.setAttribute("xmlns",e);for(var j=0;j<a.childNodes.length;j++)a.childNodes[j].nodeType===f&&a.removeChild(a.childNodes[j]);for(;h.childNodes.length;)h.removeChild(h.childNodes[0]);return d.setAttr(a,{width:b,height:c,viewBox:"0 0 "+b+" "+c,preserveAspectRatio:"none"}),a},b.svgStringToDataURI=function(){var b="data:image/svg+xml;charset=UTF-8,",c="data:image/svg+xml;charset=UTF-8;base64,";return function(d,e){return e?c+btoa(a.unescape(encodeURIComponent(d))):b+encodeURIComponent(d)}}(),b.serializeSVG=function(b,c){if(a.XMLSerializer){var e=new XMLSerializer,f="",g=c.stylesheets;if(c.svgXMLStylesheet){for(var h=d.createXML(),i=g.length-1;i>=0;i--){var j=h.createProcessingInstruction("xml-stylesheet",'href="'+g[i]+'" rel="stylesheet"');h.insertBefore(j,h.firstChild)}h.removeChild(h.documentElement),f=e.serializeToString(h)}var k=e.serializeToString(b);return k=k.replace(/\&amp;(\#[0-9]{2,}\;)/g,"&$1"),f+k}}}).call(b,function(){return this}())},function(a,b,c){(function(a){b.newEl=function(b,c){return a.document?null==c?a.document.createElement(b):a.document.createElementNS(c,b):void 0},b.setAttr=function(a,b){for(var c in b)a.setAttribute(c,b[c])},b.createXML=function(){return a.DOMParser?(new DOMParser).parseFromString("<xml />","application/xml"):void 0},b.getNodeArray=function(b){var c=null;return"string"==typeof b?c=document.querySelectorAll(b):a.NodeList&&b instanceof a.NodeList?c=b:a.Node&&b instanceof a.Node?c=[b]:a.HTMLCollection&&b instanceof a.HTMLCollection?c=b:b instanceof Array?c=b:null===b&&(c=[]),c=Array.prototype.slice.call(c)}}).call(b,function(){return this}())},function(a,b,c){var d=function(a,b){"string"==typeof a&&(this.original=a,"#"===a.charAt(0)&&(a=a.slice(1)),/[^a-f0-9]+/i.test(a)||(3===a.length&&(a=a.replace(/./g,"$&$&")),6===a.length&&(this.alpha=1,b&&b.alpha&&(this.alpha=b.alpha),this.set(parseInt(a,16)))))};d.rgb2hex=function(a,b,c){function d(a){var b=(0|a).toString(16);return 16>a&&(b="0"+b),b}return[a,b,c].map(d).join("")},d.hsl2rgb=function(a,b,c){var d=a/60,e=(1-Math.abs(2*c-1))*b,f=e*(1-Math.abs(parseInt(d)%2-1)),g=c-e/2,h=0,i=0,j=0;return d>=0&&1>d?(h=e,i=f):d>=1&&2>d?(h=f,i=e):d>=2&&3>d?(i=e,j=f):d>=3&&4>d?(i=f,j=e):d>=4&&5>d?(h=f,j=e):d>=5&&6>d&&(h=e,j=f),h+=g,i+=g,j+=g,h=parseInt(255*h),i=parseInt(255*i),j=parseInt(255*j),[h,i,j]},d.prototype.set=function(a){this.raw=a;var b=(16711680&this.raw)>>16,c=(65280&this.raw)>>8,d=255&this.raw,e=.2126*b+.7152*c+.0722*d,f=-.09991*b-.33609*c+.436*d,g=.615*b-.55861*c-.05639*d;return this.rgb={r:b,g:c,b:d},this.yuv={y:e,u:f,v:g},this},d.prototype.lighten=function(a){var b=Math.min(1,Math.max(0,Math.abs(a)))*(0>a?-1:1),c=255*b|0,e=Math.min(255,Math.max(0,this.rgb.r+c)),f=Math.min(255,Math.max(0,this.rgb.g+c)),g=Math.min(255,Math.max(0,this.rgb.b+c)),h=d.rgb2hex(e,f,g);return new d(h)},d.prototype.toHex=function(a){return(a?"#":"")+this.raw.toString(16)},d.prototype.lighterThan=function(a){return a instanceof d||(a=new d(a)),this.yuv.y>a.yuv.y},d.prototype.blendAlpha=function(a){a instanceof d||(a=new d(a));var b=a,c=this,e=b.alpha*b.rgb.r+(1-b.alpha)*c.rgb.r,f=b.alpha*b.rgb.g+(1-b.alpha)*c.rgb.g,g=b.alpha*b.rgb.b+(1-b.alpha)*c.rgb.b;return new d(d.rgb2hex(e,f,g))},a.exports=d},function(a,b,c){a.exports={version:"2.8.2",svg_ns:"http://www.w3.org/2000/svg"}},function(a,b,c){(function(b){var d=c(6),e=c(7),f=c(5),g=c(9),h=g.svg_ns,i="\nCreated with Holder.js "+g.version+".\nLearn more at http://holderjs.com\n(c) 2012-2015 Ivan Malopinsky - http://imsky.co\n";a.exports=function(){if(b.XMLSerializer){var a=e.createXML(),c=d.initSVG(null,0,0),g=e.newEl("rect",h);return c.appendChild(g),function(b,j){var k=b.root;d.initSVG(c,k.properties.width,k.properties.height);for(var l=c.querySelectorAll("g"),m=0;m<l.length;m++)l[m].parentNode.removeChild(l[m]);var n=j.holderSettings.flags.holderURL,o="holder_"+(Number(new Date)+32768+(0|32768*Math.random())).toString(16),p=e.newEl("g",h),q=k.children.holderTextGroup,r=q.properties,s=e.newEl("g",h),t=q.textPositionData,u="#"+o+" text { "+f.cssProps({fill:r.fill,"font-weight":r.font.weight,"font-family":r.font.family+", monospace","font-size":r.font.size+r.font.units})+" } ",v=a.createComment("\nSource URL: "+n+i),w=a.createCDATASection(u),x=c.querySelector("style"),y=k.children.holderBg;if(e.setAttr(p,{id:o}),c.insertBefore(v,c.firstChild),x.appendChild(w),p.appendChild(g),y.properties.outline){var z=e.newEl("path",h),A=y.properties.outline.width,B=A/2;e.setAttr(z,{d:["M",B,B,"H",y.width-B,"V",y.height-B,"H",B,"V",0,"M",0,B,"L",y.width,y.height-B,"M",0,y.height-B,"L",y.width,B].join(" "),"stroke-width":y.properties.outline.width,stroke:y.properties.outline.fill,fill:"none"}),p.appendChild(z)}p.appendChild(s),c.appendChild(p),e.setAttr(g,{width:y.width,height:y.height,fill:y.properties.fill}),q.y+=.8*t.boundingBox.height;for(var C in q.children){var D=q.children[C];for(var E in D.children){var F=D.children[E],G=q.x+D.x+F.x,H=q.y+D.y+F.y,I=e.newEl("text",h),J=document.createTextNode(null);e.setAttr(I,{x:G,y:H}),J.nodeValue=F.properties.text,I.appendChild(J),s.appendChild(I)}}var K=d.svgStringToDataURI(d.serializeSVG(c,j.engineSettings),"background"===j.mode);return K}}}()}).call(b,function(){return this}())},function(a,b,c){function d(a){return a.replace(/^\s*|\s*$/g,"")}b=a.exports=d,b.left=function(a){return a.replace(/^\s*/,"")},b.right=function(a){return a.replace(/\s*$/,"")}},function(a,b,c){var d=Object.prototype.toString;a.exports=function(a){switch(d.call(a)){case"[object Date]":return"date";case"[object RegExp]":return"regexp";case"[object Arguments]":return"arguments";case"[object Array]":return"array";case"[object Error]":return"error"}return null===a?"null":void 0===a?"undefined":a!==a?"nan":a&&1===a.nodeType?"element":(a=a.valueOf?a.valueOf():Object.prototype.valueOf.apply(a),typeof a)}}])}),function(a,b){b&&(Holder=a.Holder)}(this,"undefined"!=typeof Meteor&&"undefined"!=typeof Package),/*!
 * JavaScript for Bootstrap's docs (http://getbootstrap.com)
 * Copyright 2011-2015 Twitter, Inc.
 * Licensed under the Creative Commons Attribution 3.0 Unported License. For
 * details, see https://creativecommons.org/licenses/by/3.0/.
 */
!function(a){"use strict";a(function(){a(".tooltip-demo").tooltip({selector:'[data-toggle="tooltip"]',container:"body"}),a('[data-toggle="popover"]').popover(),a(".tooltip-test").tooltip(),a(".popover-test").popover(),a('.bd-example-indeterminate [type="checkbox"]').prop("indeterminate",!0),a(".bd-example [href=#]").click(function(a){a.preventDefault()}),a(".highlight").each(function(){var b='<div class="bd-clipboard"><span class="btn-clipboard" title="Copy to clipboard">Copy</span></div>';a(this).before(b),a(".btn-clipboard").tooltip()});var b=new Clipboard(".btn-clipboard",{target:function(a){return a.parentNode.nextElementSibling}});b.on("success",function(b){a(b.trigger).attr("title","Copied!").tooltip("_fixTitle").tooltip("show").attr("title","Copy to clipboard").tooltip("_fixTitle"),b.clearSelection()}),b.on("error",function(b){var c=/Mac/i.test(navigator.userAgent)?"Press ⌘ to copy":"Press Ctrl-C to copy";a(b.trigger).attr("title",c).tooltip("_fixTitle").tooltip("show").attr("title","Copy to clipboard").tooltip("_fixTitle")})})}(jQuery),function(){"use strict";anchors.options.placement="left",anchors.add(".bd-content > h1, .bd-content > h2, .bd-content > h3, .bd-content > h4, .bd-content > h5")}();