<?php

//-----------------------------
//Input validator
//http://codingforums.com/archive/index.php?t-6356.html
//http://www.devshed.com/c/a/PHP/Building-An-Extensible-Form-Validator-Class/11/
//-----------------------------


//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//	30/12/2024 V2.9.6
//	Unused variables removed

/*
	isEmpty($var, $errormsg) - check whether the specified form variable is empty;
	isString($var, $errormsg) - check whether the specified form variable contains string data;
	isNumber($var, $errormsg) - check whether the specified form variable contains numeric data;
	isWithinRange($var, $errormsg) - check whether the specified form variable contains a value within the specified numeric range;
	isEmailAddress($var, $errormsg) - check whether the specified form variable contains a valid email address;
	isError() - check whether any errors have occurred in form validation;
	getErrorList() - return the list of validation errors;
	resetErrorList() - reset the error list.
*/




//***********************************************************************
class Validate {


	//===============================================================
	// private variables
	var $_errorList;	
	var $_link;


	//----------------------------------------------------------------	
	// methods (private)
	
	//----------------------------------------------------------------
	// methods (public)

	// constructor
	// reset error list
	function __construct()
	{
		$this->resetErrorList();
	}
	

	function loadlink($link)
	{
		$this->_link = $link;
	}

	//----------------------------------------------------------------
	// check whether input is empty
	function isEmpty($field, $msg) {
	
		$value = $field;
	
		if (trim($value) == "") {
				$this->_errorList[] = array("field" => $field, "value" => $value, "msg" => $msg);
				return false;
			}
				else
			{
				return true;
			}
	}


	//----------------------------------------------------------------
	// check whether input is a string
	// Optional length is passed in
	function isString( $field, $msg, $length = "" ) {
	
		$value = $field;
		
		if(!is_string($value))
			{
			$this->_errorList[] = array("field" => $field, "value" => $value, "msg" => $msg);
			//$field_error='style="background-color:#CC0000; color:#FFFFFF;"';
			return false;
			}
		else
			{
			
				if ($length == "") {
					return true;
				} else {					
					
					if ( strlen($field) <= $length ) {
						return true;
					} else {
						$this->_errorList[] = array("field" => $field, "value" => $value, "msg" => $msg);
						//$field_error='style="background-color:#CC0000; color:#FFFFFF;"';
						return false;					
					}
					
				}			
				
			}
			
	}


	//----------------------------------------------------------------
	// check whether input is a number
	function isNumber( $field, $msg ) {		
	
		$value = $field;	
		
		if(!is_numeric($value))
			{
			$this->_errorList[] = array("field" => $field, "value" => $value, "msg" => $msg);
			return false;
		}
			else
		{
			return true;
		}
	}


	//----------------------------------------------------------------
	// check whether input is a valid email address
	function isEmailAddress( $field, $msg ) {	
	
		$value = $field;

		//may not be correct - may be best jsut to check for @ character, no spaces and its' length

		$pattern = "/^([a-zA-Z0-9])+([\.a-zA-Z0-9_-])*@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-]+)+/";

		if(preg_match($pattern, $value))
			{
			return true;
			}
		else
			{
			$this->_errorList[] = array("field" => $field, "value" => $value, "msg" => $msg);
			return false;
			}
	}

	//----------------------------------------------------------------
	// return the current list of errors
	function getErrorList() {
	
			return $this->_errorList;
			
	}

	//----------------------------------------------------------------
	// check whether any errors have occurred in validation
	// returns Boolean 
	function isError() {
	
			if (sizeof($this->_errorList) > 0)
		{
			return true;
		}
			else
		{
		return false;
		}
		
	}


	//----------------------------------------------------------------
	// reset the error list
	function resetErrorList() {
	
			$this->_errorList = array();
			
		}


	//----------------------------------------------------------------
	//http://www.askbee.net/articles/php/SQL_Injection/sql_injection.html
	//Purpose : correctly quotes strings to stop sql injection
	function sql_quote( $value, $link ) {
	
    	//if( is_get_magic_quotes_gpc() )	//if magic quotes are on we have to remove the slashes first as other wise they will double up
    	//{
        // 	  $value = stripslashes( $value );
	    //}
    	//check if this function exists
	    if( function_exists( "mysqli_real_escape_string" ) )
    	{
        	  $value = mysqli_real_escape_string( $link, $value );
	    }
    	//for PHP version < 4.3.0 use addslashes
	    else
    	{
        	  $value = addslashes( $value );
	    }
    	return $value;
	
	}


}

?>