<?php

error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);

//----------------------------------------------------
//	This is a cron job that is intended to control users (manual or non-manual users)
//
//	If the item for that user 
//	has (recrring payments set to 'no') OR (recurring payments set to 'yes' AND
//	recuring times > 0) then this cron job will disable the user.
//
//	if (recurring payments = 'no') OR (recurring payments = 'yes' AND recuring times > 0)
//
//	For an item where recurring payments has been sent to 'yes' it is not relevent.
//
//
//a3	[Required] 
//		Regular billing cost - the rate of the subscription
//
//p3	[Required] 
//		Regular billing cycle. This is the length of the billing cycle. The number is 
//		modified by the regular billing cycle units (t3, below)
//
//t3	[Required]
//		Regular billing cycle units. This is the units of the regular billing 
//		cycle (p3, above) Acceptable values are: D (days), W (weeks), M (months), Y (years)
//
//src	[Optional]
//		Recurring payments. If set to '1' the payment will recur unless your customer 
//		cancels the subscription before the end of the billing cycle. If omitted, the 
//		subscription payment will not recur at the end of the billing cycle
//
//sra	[Optional]
//		Reattempt on failure. If set to '1' and the payment fails, the payment will be reattempted two 
//		more times. After the third failure, the subscription will be cancelled. If omitted and the 
//		payment fails, payment will not be reattempted and the subscription will be immediately cancelled
//
//srt	[Optional]
//		Recurring Times. This is the number of payments which will occur at the regular rate. If 
//		omitted, payment will continue to recur at the regular rate until the subscription is cancelled.
//
//----------------------------------------------------


//	NOTE : Uncomment the last lines of this file and modify the email to / from address 
//	so that the cron job sends an email each time it is run.
//----------------------------------------------------

	//Get a list of current active manually created users
	
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	//Look up absolute file path
	$current_file_path = dirname(__FILE__);
	//echo($current_file_path . "<br/>");
	$file_path1 = substr($current_file_path, 0, -4) . "dbclass/Db.class.php";
	//echo($file_path1 . "<br/>");
	require_once($file_path1);

	$file_path2 = substr($current_file_path, 0, -4) . "classes/clshtpasswd.php";
	//echo($file_path2 . "<br/>");
	require_once($file_path2);

	$file_path3 = substr($current_file_path, 0, -4) . "functions/misc.php";
	//echo($file_path3 . "<br/>");
	require_once($file_path3);

	$file_path4 = substr($current_file_path, 0, -4) . "functions/user.php";
	//echo($file_path4 . "<br/>");
	require_once($file_path4);

	$file_path5 = substr($current_file_path, 0, -4) . "error.php";
	//echo($file_path5 . "<br/>");
	require_once($file_path5);
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	
	$currentdate = date("Y-m-d H:i:s");
	$message = "";
	$expired_emails = "";

	//Query returns all the users who are manually created, and who are in the htpasswd file and are older than the current date
	//The cron job will disable the user, removing them from the htpasswd file so that in_htpasswd will become 0

 	$items = usersforcron();	

	if (count($items) > 0)
	{

		foreach( $items as $d_row ) {

			//For each email address we need to check recurring payments for that product item

			//$src = recurring flag 1 = payments will recurr
			//$t3 = regular billing cycle units

			$item_number = $d_row['item_number'];
			$details = getuserdetails($item_number);
				$src = $details["src"];
				$t3 = $details["t3"];

			if ( $t3 == "" ) { 	$t3 = 0; }

			echo( $d_row['payer_email'] . " " . $d_row['item_number'] . " " . $d_row['sub_expire_date'] . " " . $src . " " . "<br/>");

            //echo("src: " . $src);
            //echo("t3: ". $t3);
            
			//if ( ( $src == 0 ) || ( $src == 1 && $t3 > 0 ) ) {	//Means that recurring payments are set so this user should have access removed
																//$src == 1 and $t3 > 0 means we have recurring flag set and have a defined numbers of billing units

                
                
            if ( ( $src == 0 ) || ( $src == 1) ) {      //Does this work for trial period with no payment
                
                $currentdate = date("Y-m-d H:i:s");

                //Compare currentdate with sub_expire_date                
                if ($currentdate > $d_row['sub_expire_date']) {    
                    //echo(" User deleted");
                    
                    $payer_email 	= $d_row['payer_email'];
				    $securearea_id 	= $d_row['securearea_id'];
				
				    disableuser($payer_email, $securearea_id, $message);

                    //Given the payer_email, get the record id (users_id) from sec_tblusers
                    $table = userintbluser($payer_email);			
                    if (count($table) == 0 )
                    {
                        $message .= " SQL error - cron.php ref 2 ";
                    }
                    $users_id = $table[0]['recid'];

                    //Set sub_due_date and sub_expire_date to blank for this user id and secure area id
                    $introwsaffected = blankdates($users_id, $securearea_id);
                    if ( $introwsaffected == 0 ) {
                        $message .= " Warning - cron.php ref 3 ";
                    }

                    $expired_emails = $expired_emails . " " . $payer_email;                    
                    
                }
                else
                {
                    echo("do not delete user");
                }
                                
                
			}

		}

	}
/*
	//----------------------------------------------------------
	//Send email 	
	$toaddress 		= "to@site.com";
	$fromaddress 	= "from@site.com";

	$subject 		= "PHP-SecureArea Cron job has run";

	if (count($items) == 0) {
		$body = "Cron job has run - no users have to be disabled";
	}
	else
	{
		$body = "Cron job has run \r\n\r\n" . $expired_emails . "\r\n\r\n" . $message;
	}
	
	$headers 		= "From:" . $fromaddress . "\r\n";
	
	$addparam = "-f".$fromaddress;
	
	//Uncomment this line to send the email
	mail($toaddress, $subject, $body, $headers, $addparam);	//Send with header
	//----------------------------------------------------------	
*/
?>