<?php

require_once("checkaccess.php");

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//-----------------------------------------
//Allows the user to recover a password by 
//entering their email address.
//Retrieves the password for this user name.
//Decrypts the password.
//Sends it to the given email address.
//-----------------------------------------

error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);

main();


//-----------------------------------------
function main() {
	sendpassword();
	header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "../../index.php");
}


//-----------------------------------------
//Purpose:	Validate username then, password and send to email address
function sendpassword() {	
	
	require_once("../lang/file.php");
	require_once("../../functions/user.php");
	require_once("../../functions/misc.php");
	require_once("../../dbclass/Db.class.php");
	require_once("../../classes/clspassword.php");	
	require_once("../../classes/clsloginvalidate.php");	
	require_once("functions.php");
	
	$message = "";
	$payer_email = $_POST['username'];
	
	//Validate username	(message is normally returned as a by reference variable)
	$result = validateusername( $payer_email, $message );

	$message = $L_GETPW['MESSAGE'];

	if ( !$result ) {	//returns true if username is in database, false if not in database
		header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "../../recoverpw.php?message=" . $message );
		exit();
	} else {

		$message = "";

		$password_plain = getpassword($payer_email, $message);

		if ( $message != "" ) {
			header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "../../recoverpw.php?message=" . $message );
			exit();
		}

		//send login details to user
		sendpw( $payer_email, $password_plain );

	}

}

?>