<?php

//----------------------------------------------------------
//List of general functions
//----------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//
//************************************

//  30/12/2024 V2.9.6
//	* getversionnumber() now returns all paths
//	* getinstallfolder() now returns all paths
//	* unused variables removed

//echo(createpw());   //use during testing


//-------------------------------------
//Purpose: Returns all the smtp details
function smtpsettings() {
	
	$db = new Db();
	
	$items = $db->query( "SELECT * FROM sec_tblsmtp WHERE recid = 1 ");
	
	return $items;
}
//----------------------------------------------------------
//Purpose: update smtp table
function updatesmtp($smtphost, $usesmtp, $smtpauthentication, $smtpusername, $smtppassword, 
					$typeofencryption, $smtpport, $fromemail, $fromname, $debug) {
	
	
	//echo($smtphost . "<br/>");
	//echo($usesmtp . "<br/>");
	//echo($smtpauthentication . "<br/>");
	//echo($smtpusername . "<br/>");
	//echo($smtppassword . "<br/>"); 
	//echo($typeofencryption . "<br/>");
	//echo($smtpport . "<br/>");
	//echo($fromemail . "<br/>");
	//echo($fromname . "<br/>");
	//exit();
	
	$db = new Db();
	
	$update = $db->query( " UPDATE sec_tblsmtp 
								SET 
								smtphost = :smtphost,
								usesmtp = :usesmtp,
								smtpauthentication = :smtpauthentication,
								smtpusername = :smtpusername,
								smtppassword = :smtppassword,
								typeofencryption = :typeofencryption,
								smtpport =:smtpport,
								fromemail =:fromemail,
								fromname =:fromname,
								debug =:debug
								WHERE recid = 1 ",							
							 	array(
									"smtphost" => $smtphost,
									"usesmtp" => $usesmtp,
									"smtpauthentication" => $smtpauthentication,
									"smtpusername" => $smtpusername,
									"smtppassword" => $smtppassword,
									"typeofencryption" => $typeofencryption,
									"smtpport" => $smtpport,
									"fromemail" => $fromemail,
									"fromname" => $fromname,
									"debug" => $debug
								)
							);
	
	return $update;	
	
}
//----------------------------------------------------------
//Purpose	:	Updates the usesmtp flage
function updateusesmtp($usesmtp) {
	
	$db = new Db();
	
	$update = $db->query( " UPDATE sec_tblsmtp 
								SET								
								usesmtp = :usesmtp							
								WHERE recid = 1 ",							
							 	array(								
									"usesmtp" => $usesmtp			
								)
							);
	
	return $update;	
	
}
//----------------------------------------------------------
//Purpose	:	Get tblitems details given the recid of the record
//Outputs	:	Certain details from tblitems in an array
function gettblitems($recid) {
	
	$db = new Db();	

	//$strSQL = " SELECT item_number, item_name, mc_currency, a1, p1, t1, a2, p2, t2, a3, p3, t3, src, sra, srt FROM sec_tblitems WHERE recid = $recid "	
	$table = $db->query(" SELECT item_number, item_name, mc_currency, a1, p1, t1, a2, 
						p2, t2, a3, p3, t3, src, sra, srt
						FROM sec_tblitems 
						WHERE recid = :recid", 
						array(
							"recid" => $recid
							));	

				$array_name['item_number'] 		= $table[0]["item_number"];
				$array_name['item_name']		= $table[0]["item_name"];
				$array_name['mc_currency']		= $table[0]["mc_currency"];

				$array_name['a1']				= $table[0]["a1"];
				$array_name['p1']				= $table[0]["p1"];
				$array_name['t1']				= $table[0]["t1"];		

				$array_name['a2']				= $table[0]["a2"];
				$array_name['p2']				= $table[0]["p2"];
				$array_name['t2']				= $table[0]["t2"];		

				$array_name['a3']				= $table[0]["a3"];
				$array_name['p3']				= $table[0]["p3"];
				$array_name['t3']				= $table[0]["t3"];		

				$array_name['src']				= $table[0]["src"];
				$array_name['sra']				= $table[0]["sra"];
				$array_name['srt']				= $table[0]["srt"];

	return $array_name;

}
//----------------------------------------
//Purpose: get some item details given the item_number
function gettblitems_number($item_number) {
	
	$db = new Db();	
	
	$table = $db->query(" SELECT recid, securearea_id, item_name, mc_currency, a1, p1, 
							t1, a2, p2, t2, a3, p3, t3, src, sra, srt
						FROM sec_tblitems 
						WHERE item_number = :item_number", 
						array(
							"item_number" => $item_number
							));
	
	$array_name['securearea_id'] 	= $table[0]["securearea_id"];
	$array_name['item_name']		= $table[0]["item_name"];
	$array_name['mc_currency']		= $table[0]["mc_currency"];
	
	$array_name['recid']			= $table[0]["recid"];
	
	$array_name['a1']				= $table[0]["a1"]; 	//Trial amount 1. This is the price of the first trial period. For a free trial, use a value of 0.
	$array_name['p1']				= $table[0]["p1"];	//Trial period 1. This is the length of the first trial period. The number is modified by the trial period 1 units (t1, below).
	$array_name['t1']				= $table[0]["t1"];	//Trial period 1 units. This is the units of trial period 1 (p1, above). Acceptable values are: D (days), W (weeks), M (months), Y (years).

	$array_name['a2']				= $table[0]["a2"];	//Trial amount 2. This is the price of the second trial period.
	$array_name['p2']				= $table[0]["p2"];	//Trial period 2. This is the length of the second trial period. The number is modified by the trial period 1 units (t2, below).
	$array_name['t2']				= $table[0]["t2"];	//Trial period 2 units. This is the units of trial period 2 (p2, above). Acceptable values are: D (days), W (weeks), M (months), Y (years).

	$array_name['a3']				= $table[0]["a3"];	//[required] Regular rate. This is the price of the subscription.				
	$array_name['p3']				= $table[0]["p3"];	//[required] Regular billing cycle. This is the length of the billing cycle. The number is modified by the regular billing 
														//cycle units (t3, below).
	$array_name['t3']				= $table[0]["t3"];	//[required] Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: 
														//D (days), W (weeks), M (months), Y (years)	

	$array_name['src']				= $table[0]["src"];	//Recurring payments. If set to “1,” the payment will recur unless your customer cancels the subscription before the end of
														//the billing cycle. If omitted, the subscription payment will not recur at the end of the billing cycle.
	$array_name['sra']				= $table[0]["sra"];	//Reattempt on failure. If set to “1,” and the payment fails, the payment will be reattempted two more times. After the 
														//third failure, the subscription will be canceled. If omitted and the payment fails, payment will not be reattempted and 
														//the subscription will be immediately canceled.		
	$array_name['srt']				= $table[0]["srt"];	//Recurring Times. This is the number of payments which will occur at the regular rate. If omitted, payment will continue 
														//to recur at the regular rate until the subscription is cancelled.		

			
	return $array_name;	
	
}
//----------------------------------------
//Purpose: Given payer_email return user details in sec_tblusers
function userintbluser($payer_email) {
	
	$db = new Db();
	
	$table = $db->query(" SELECT recid, password, iv
							FROM sec_tblusers 
							WHERE payer_email = :payer_email", 
							array(
								"payer_email" => $payer_email
							));
	return $table;		

}
//----------------------------------------
//Purpose: Return person details from sec_tblusers given the recid
function userpersondetails($recid) {
	
	$db = new Db();
	
	$table = $db->query( "SELECT name, telephone, mobile, address_line1, 
							address_line2, city, zip_post_code, country, state 
							FROM sec_tblusers WHERE recid =:recid",
							array(
								"recid" => $recid
							));

	return $table;
	
}
//----------------------------------------
//Purpose: Return person details from sec_tblusers given the payer_email
function userpersondetailspayer_email($payer_email) {

	//echo($payer_email);
	//exit();
	
	$db = new Db();
	
	$table = $db->query( "SELECT name, telephone, mobile, address_line1, 
							address_line2, city, zip_post_code, country, state 
							FROM sec_tblusers WHERE payer_email =:payer_email",
							array(
								"payer_email" => $payer_email
							));

	//echo(count($table));
	
	return $table;
	
}
//----------------------------------------
//Purpose: Insert new person details into sec_tblusers
function insertuserpersondetails( $payer_email, $signedup, $name, $telephone, $mobile, 
								 $address_line1, $address_line2, $city, $zip_post_code, $country, $state) {
	
	$db = new Db();
	
	$insert = $db->query( " INSERT INTO sec_tblusers 
			(
			payer_email, 
			signedup, 
			name, 
			telephone, 
			mobile, 
			address_line1, 
			address_line2, 
			city, 
			zip_post_code, 
			country, 
			state
			)
			VALUES 
			(
			:payer_email,
			:signedup, 
			:name, 
			:telephone, 
			:mobile, 
			:address_line1, 
			:address_line2, 
			:city, 
			:zip_post_code, 
			:country, 
			:state
			) ",
			array(					
				"payer_email" => $payer_email,
				"signedup" => $signedup,
				"name" => $name,
				"telephone" => $telephone, 
				"mobile" => $mobile, 
				"address_line1"	=> $address_line1, 
				"address_line2" => $address_line2,  
				"city" => $city, 
				"zip_post_code" => $zip_post_code, 
				"country" => $country, 
				"state" => $state
			));	
	
	
	if ( $insert == 0 )
	{
		return $insert;		//is an error
	}
	else
	{
		$lastinsertid = $db->lastInsertId(); 			
		//echo("lastinsertid: " . $lastinsertid);
		//exit();			
		return $lastinsertid;		
	}	
	
}
//----------------------------------------
//Purpose: Update the sec_tblusers table given the $recid
function updatetblusers($name, $telephone, $mobile, $address_line1, $address_line2,
								$city, $zip_post_code, $country, $state, $recid ) {
	
	$db = new Db();
	
	$update = $db->query( " UPDATE sec_tblusers 
								SET 
								name = :name,
								telephone = :telephone,
								mobile = :mobile,
								address_line1 = :address_line1,
								address_line2 = :address_line2,
								city =:city,
								zip_post_code =:zip_post_code,
								country =:country,
								state =:state
								WHERE recid = :recid ",							
							 	array(
									"name" => $name,
									"telephone" => $telephone,
									"mobile" => $mobile,
									"address_line1" => $address_line1,
									"address_line2" => $address_line2,
									"city" => $city,
									"zip_post_code" => $zip_post_code,
									"country" => $country,
									"state" => $state,
									"recid" => $recid
								)
							);
	
	return $update;
	
}
//----------------------------------------
//Purpose: Update the sec_tblusers table given the $recid
function updatetbluserspayer_email($name, $telephone, $mobile, $address_line1, $address_line2,
								$city, $zip_post_code, $country, $state, $payer_email ) {
	
	$db = new Db();
	
	$update = $db->query( " UPDATE sec_tblusers 
								SET 
								name = :name,
								telephone = :telephone,
								mobile = :mobile,
								address_line1 = :address_line1,
								address_line2 = :address_line2,
								city =:city,
								zip_post_code =:zip_post_code,
								country =:country,
								state =:state
								WHERE payer_email = :payer_email ",							
							 	array(
									"name" => $name,
									"telephone" => $telephone,
									"mobile" => $mobile,
									"address_line1" => $address_line1,
									"address_line2" => $address_line2,
									"city" => $city,
									"zip_post_code" => $zip_post_code,
									"country" => $country,
									"state" => $state,
									"payer_email" => $payer_email
								)
							);
	
	//echo($name);
	//echo($telephone);
	//echo($mobile);
	//echo($address_line1);
	//echo($address_line2);
	//echo($city);
	//echo($state);
	//echo($zip_post_code);
	//echo($country);
	//echo($payer_email);	
	//exit();	
	
	return $update;
	
}
//----------------------------------------
//Purpose: Return some product details given the recid
function getproductdetails($recid) {
	
	$db = new Db();
	
	$table = $db->query(" SELECT item_number, item_name, emailtext, emailsubject, item_description, 
				item_image, publish, mc_currency, securearea_id, a1, p1, t1, a2, p2, t2, a3, p3, 
				t3, src, sra, srt
				FROM sec_tblitems WHERE recid = :recid", 
		array(
				"recid" => $recid
				));		

	return $table;
	
}
//-----------------------------------
//Purpose : Delete record from tblitems
//Input : The record id to be deleted
function deleteitem($recid) {

	$db = new Db();
	
	$delete = $db->query(" DELETE FROM sec_tblitems 
							WHERE recid = :recid ", 
						array(
							"recid" => $recid
							));

	return ($delete);

}
//-----------------------------------
//Purpose: Add an item to tblitems
function insertitem($item_number, $item_name, $emailsubject, $emailtext, $item_description, $publish, 
					$mc_currency, $currency, $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, 
					$p3, $t3, $src, $sra, $srt, $item_image) {
	
	$db = new Db();	
	
	$insert	= $db->query(" INSERT INTO sec_tblitems 
					(
					item_number, 
					item_name,
					emailsubject,
					emailtext,
					item_description, 
					publish,
					mc_currency,
					currency,
					securearea_id,
					a1,
					p1,
					t1,
					a2,
					p2,
					t2,
					a3,
					p3,
					t3,
					src,
					sra,
					srt,
					item_image
					) 
					VALUES 
					( 
					:item_number, 
					:item_name,
					:emailsubject,
					:emailtext,
					:item_description, 
					:publish,
					:mc_currency,
					:currency,
					:securearea_id,
					:a1,
					:p1,
					:t1,
					:a2,
					:p2,
					:t2,
					:a3,
					:p3,
					:t3,
					:src,
					:sra,
					:srt,
					:item_image
					) ",
					array( 	
					
						"item_number" => $item_number, 
						"item_name" => $item_name,
						"emailsubject" => $emailsubject,
						"emailtext" => $emailtext,
						"item_description" => $item_description, 
						"publish" => $publish,
						"mc_currency" => $mc_currency,
						"currency" => $currency,
						"securearea_id" => $securearea_id,
						"a1" => $a1,
						"p1" => $p1,
						"t1" => $t1,
						"a2" => $a2,
						"p2" => $p2,
						"t2" => $t2,
						"a3" => $a3,
						"p3" => $p3,
						"t3" => $t3,
						"src" => $src,
						"sra" => $sra,
						"srt" => $srt,
						"item_image" => $item_image
		
					));	
	
	return $insert;	
	
}
//-----------------------------------
//Purpose: Update an item to tblitems
function updateitem($item_number, $item_name, $recid, $emailsubject, $emailtext, $item_description, $item_image, $publish, 
						$mc_currency, $currency, $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, $t3, $src, 
						$sra, $srt) {
	
	//echo($item_number);
	//exit();
	
	$db = new Db();
	
	$update = $db->query( " UPDATE sec_tblitems 
							SET 
							item_number = :item_number,
							item_name = :item_name,
							emailsubject =:emailsubject,
							emailtext =:emailtext,
							item_description =:item_description,
							item_image =:item_image,
							publish =:publish, 
							mc_currency =:mc_currency,
							currency =:currency,
							securearea_id =:securearea_id,
							a1 =:a1,
							p1 =:p1,
							t1 =:t1,
							a2 =:a2,
							p2 =:p2,
							t2 =:t2,
							a3 =:a3,
							p3 =:p3,
							t3 =:t3,
							src =:src,
							sra =:sra,
							srt	=:srt
							WHERE recid = :recid ",							
						 	array(
								"item_number" => $item_number,
								"item_name" => $item_name,
								"emailsubject" => $emailsubject,
								"emailtext" => $emailtext,
								"item_description" => $item_description,
								"item_image" => $item_image,
								"publish" => $publish,
								"mc_currency" => $mc_currency,
								"currency" => $currency,
								"securearea_id" => $securearea_id,
								"a1" => $a1,
								"p1" => $p1,
								"t1" => $t1,
								"a2" => $a2,
								"p2" => $p2,
								"t2" => $t2,
								"a3" => $a3,
								"p3" => $p3,
								"t3" => $t3,
								"src" => $src,
								"sra" => $sra,
								"srt" => $srt,
								"recid" => $recid		
							)
						);
	
	return $update;
	
}
//-----------------------------------------------
//Used during testing of checkleadingzeros
//$input = ".02";
//echo("input   :   $input<br>");
//echo("result  : " . checkleadingzeros($input) . "<br>");

//-----------------------------------------------
//Purpose : Checks gross payment for leading zeros
//Changes '.02' to '0.02'
//Changes '00.10' to '0.10'
//Changes '02.00' to '2.00'
//Changes '002.00' to '2.00'
function checkleadingzeros($input) {

	$inputarray = explode(".", $input);
	
	$left 	=	$inputarray[0];
	$right 	= 	$inputarray[1];

	//Check for '.02' and change to '0.02'
	if (strlen($left) == 0) {
		$result = "0." . $right;		
	} else {

		//If strlen is 1 dont do anything 
		//and return the reslt as is 
		if (strlen($left) == 1) {
			$result = $input;
		} else {

					//Getting here means that there are more than two characters in $left
	
					//Check if first character is 0 
					//don't have to do anything if it is not 0
					if (substr($left, 0, 1) != 0) {
						$result = $input;		
					} else {

							if (strlen($left) > 1) {
								$check = substr($left, 0, strlen($left) - 1);
								//echo("check : $check");		
								//For each character in $check from the left, test if it is a zero.
								//If the character is not zero then exit the loop.
								//If it is a zero then remove it until the next character remaining is not a zero.
								
								//$temp = 0;
								$i = 0;								
								for ($i = 0; $i <= strlen($check) - 1; $i++) {
									    //echo( "<br> char $i : " . substr( $check, $i , 1 )  );									
										if ( substr( $check, $i, 1) != 0 ) {
											break;										
										}									
								}
						
								//echo("<br>Number of leading zeros : $i<br>");						
								$result = substr($left, $i) . "." . $right;
						
							} 
	
					}

			}

	}

	return $result;

}
//-----------------------------------
//Purpose: Checks if $item_number already exists in tblitems
function checkitemnumbercreate($item_number) {

	$db = new Db();	
	
	$table = $db->query(" SELECT item_number FROM sec_tblitems 
							WHERE item_number = :item_number ", 
						array(
							"item_number" => $item_number
							));
	
	return count($table);
	
}
//-----------------------------------
//Purpose: Checks if $item_number already exists in tblitems
function checkitemnumberupdate($item_number, $recid) {
	
	$db = new Db();	
	
	$table = $db->query(" SELECT item_number FROM sec_tblitems 
							WHERE item_number = :item_number AND recid <> :recid ", 
						array(
							"item_number" => $item_number,
							"recid" => $recid
							));
	
	return count($table);	
	
}
//-----------------------------------
//Purpose : gets the default email subject as entered in tblsetup
function getemailsubject() {

	$db = new Db();
	
	$table = $db->query( " SELECT emailsubject FROM sec_tblsetup WHERE recid = 1 " );

	$emailsubject = $table[0]["emailsubject"];
	
	return $emailsubject;
}
//-----------------------------------
//Purpose : gets the default email text as entered in tblsetup
function getemailtext() {

	$db = new Db();

	$table = $db->query( " SELECT emailtext FROM sec_tblsetup WHERE recid = 1 " );
	
	$emailtext = $table[0]["emailtext"];

	return $emailtext;
}
//-------------------------------------
//Purpose: Returns all the item details
function itemlist() {
	
	$db = new Db();
	
	$items = $db->query( "SELECT recid, item_number, item_name, publish, a3, p3, t3, 
					securearea_id, currency FROM sec_tblitems ORDER BY item_number ");
	
	return $items;
}
//----------------------------------------------------------
//Purpose: Returns default mc_currency from tblsetup
function getmc_currency() {

	$db = new Db();

	$table = $db->query( " SELECT mc_currency FROM sec_tblsetup WHERE recid = 1 ");

	$mc_currency = $table[0]["mc_currency"];

	return $mc_currency;	
}
//-------------------------------------
//Purpose: Gets the number of rows in the table tblitems
function getitemrowcount() {
	
	$db = new Db();
	
	$items = $db->query(" SELECT recid FROM sec_tblitems ");	
	
	return count($items);	
}
//-------------------------------------
//Purpose	:	Given the recid, this returns the secure area name
//				from the table
function getsecureareaname($recid) {

	$db = new Db();
	
	$table = $db->query(" SELECT securearea_name FROM sec_tblsecureareas 
							WHERE recid = :recid ", 
						array(
							"recid" => $recid
							));

	if ( count($table) == 0 )
	{
		return "";
	}
	else
	{
		return $table[0]['securearea_name'];	
	}	
	
}
//-------------------------------------
//Purpose	:	Given the recid, this returns the folder path from the table
function secureareagetfolder($recid) {
	
	$db = new Db();

	$table = $db->query(" SELECT folder_path FROM sec_tblfolders 
						WHERE recid = :recid ", 
					array(
						"recid" => $recid
						));

	return $table[0]['folder_path'];
}
//-------------------------------------
//Purpose	:	Update the folder
function updatefolder($recid, $folder) {

	if ( $folder == "" ) {
		return("Folder name should not be blank");
	}
	else
	{
		$db = new Db();
		//$update = 
		$db->query( " UPDATE sec_tblfolders 
								SET folder_path = :folder_path 
								WHERE recid = :recid ",							
							 	array(
									"folder_path" => trim($folder),
									"recid" => $recid
								)
							);

		return("Folder updated " . date("Y-m-d H:i:s"));
		
	}
}
//-----------------------------------------------------
//Check if the $folder already exists in sec_tblfolders
//Cannot use the same folder twice.
//Returns true if it does exist.
//Returns false if it does not exist.
function checkfolder($folder) {

	$db = new Db();
	
	$table = $db->query(" SELECT folder_path FROM sec_tblfolders ");
	
	if ( count($table) == 0 ) {
		return true;
	}

	foreach( $table as $d_row ) {
		if ( strcmp( strtolower(trim($folder)), strtolower(trim($d_row['folder_path'])) ) == 0  ) {
			//echo($folder . " " . $d_row['folder_path'] . "<br/>");
			//exit();
			return false;					
		}		
	}

	return true;

}
//-------------------------------------
//Purpose	:	Delete the record id from tblfolders
function deletefolder($recid) {

	$db = new Db();

	//$delete =
	$db->query(" DELETE FROM sec_tblfolders 
								WHERE recid = :recid ", 
						array(
							"recid" => $recid
							));

	return("Folder deleted " . date("Y-m-d H:i:s"));

}
//-----------------------------------
//Purpose :	Get list of secure areas 
function securearealist() {
	
	$db = new Db();
	
	$query = " SELECT DISTINCT recid, securearea_name 
					FROM 
					sec_tblsecureareas 
					ORDER BY 
					securearea_name ";
	
	$table = $db->query($query);
	
	return $table;	
	
}
//-----------------------------------
//Purpose :	get folder details for this id
function secureareafolders($securearea_id) {
	
		$db = new Db();	
	
		$table = $db->query(" SELECT recid, folder_path 
								FROM sec_tblfolders 
								WHERE securearea_id = :securearea_id ", 
						array(
							"securearea_id" => $securearea_id
							));	
	
		return $table;
	
}
//-------------------------------------
//Purpose	:	add a new folder to the given secure area name as 
//				defined by the $recid
function addsecurefolder($folder, $securearea_id) {

	if ($folder == "") {
		return("Folder name must not be blank - no update");
	}
	else
	{
	
		$db = new Db();

		//$insert = 
		$db->query(" INSERT INTO sec_tblfolders 
					(securearea_id, folder_path) 
					VALUES 
					( :securearea_id, :folder_path ) ",
					array( 	
							"securearea_id" => $securearea_id,
							"folder_path" => trim($folder)
							));		
		
		return("Folder added " . date("Y-m-d H:i:s"));

	}

}
//-------------------------------------
//Purpose	:	Given the secure area record id and the new secure area name
//				this updates the secure area name providing that the 
//				new name does not already exist in the table of secure area names
function updatesecurearea($recid, $securearea_name) {

	if ( checksecurearea($securearea_name) > 0 ) {
		
		return("Secure Area name already exists in table");
		
	}
	else
	{	
		
		$db = new Db();			

		//$update = 
		$db->query( " UPDATE sec_tblsecureareas 
								SET securearea_name = :securearea_name 
								WHERE recid = :recid ",							
							 	array(
									"securearea_name" => $securearea_name,
									"recid" => $recid
								)
							);
		
		return("Secure Area Updated " . date("Y-m-d H:i:s"));

	}

}
//-------------------------------------
//Purpose:	:  	Looks at sec_tblitems using securearea_id
function secureareaintblitems($securearea_id) {
	
	$db = new Db();
	
	$items = $db->query( " SELECT recid, item_number 
							FROM sec_tblitems 
							WHERE securearea_id = :securearea_id ",					   
							array (
								"securearea_id" => $securearea_id
							)
					   );
	
	return $items;
	
}
//-------------------------------------
//Purpose	:	Given the $recid of the secure area, delete the 
//				secure area from tblsecureareas and all associated folders 
//				records	from tblfolders
function deletesecurearea($recid) {

	$db = new Db();
	
	//Delete the securearea_id
	//$delete1 = 
	$db->query( " DELETE FROM sec_tblsecureareas WHERE recid = :recid ",						
						array (	
							"recid" => $recid		
							)						 
						);
	
	//Delete all the entries from tblfolders with the defined securearea_id
	//$delete2 = 
	$db->query(" DELETE FROM sec_tblfolders WHERE securearea_id = :securearea_id ",
						  	array(
								"securearea_id" => $recid
							)						 
						 );	
	
	return("Secure Area deleted " . date("Y-m-d H:i:s"));
	
}
//----------------------------------------------
//Purpose : Creates a new secure area name entry in tblsecureareas
//Input :	The secure area name
function createsecurearea($securearea_name) {

	if (checksecurearea($securearea_name) >= 1) {		
		
			return("Secure Area name already exists");		
		
		}
		else
		{		

			//INSERT INTO sec_tblsecureareas (securearea_name) VALUES ($securearea_name)

			$db = new Db();
			//$rowcount =
			$db->query(" INSERT INTO sec_tblsecureareas 
						(securearea_name) 
						VALUES 
						( :securearea_name ) ",
						array( 	
								"securearea_name" => $securearea_name
								));	

			return("Secure Area Name added " . date("Y-m-d H:i:s"));
			
		}

}
//-------------------------------------
//Purpose	:	Checks if the secure area name already exists in the table
//				Returns the record count
function checksecurearea($securearea_name) {

	$db = new Db();
		
	$table = $db->query(" SELECT securearea_name 
								FROM sec_tblsecureareas 
								WHERE 
								securearea_name = :securearea_name", 
						array(
							"securearea_name" => $securearea_name
							));	

	if (!$table) 
		$count = 0;
	else
		$count = count($table);
	
	return $count;

}
//----------------------------------------------------------
//Purpose	:	Get tblsetup details
//Outputs	:	Returns some setup details used for ipn post 
//				and returns an array
function gettblsetuppost() {

	$db = new Db();
	
	//$strSQL = " SELECT paypaladdress, sandbox_seller, cancel_url, return_url, notify_url, notify_sandbox_url FROM sec_tblsetup WHERE recid = 1 "	
	$query = " SELECT paypaladdress, sandbox_seller, cancel_url, return_url, notify_url, 
				notify_sandbox_url FROM sec_tblsetup WHERE recid = 1 ";	
   				//only one record
	
	$table = $db->query($query);
		
		$array_name['paypaladdress'] 		= $table[0]["paypaladdress"];
		$array_name['sandbox_seller']		= $table[0]["sandbox_seller"];		
		$array_name['cancel_url']			= $table[0]["cancel_url"];
		$array_name['return_url']			= $table[0]["return_url"];
		$array_name['notify_url']			= $table[0]["notify_url"];
		$array_name['notify_sandbox_url']	= $table[0]["notify_sandbox_url"];		


	return $array_name;
}
//----------------------------------------------------------
//Purpose	:	Given the item_number get the recid in tblitems
//Output	:	the recid of the item
function getitemrecid($item_number) {

	$db = new Db();		

	//$strSQL = " SELECT recid FROM sec_tblitems WHERE item_number = $item_number " 
	$table = $db->query(" SELECT recid FROM sec_tblitems WHERE item_number = :item_number ", 
						array(
							"item_number" => $item_number
							));

	if (count($table) == 0) {
		echo("Error in table - record in tblitems not found - misc.php ref 10");
		exit();
	} else {	
		return ($table[0]["recid"]);
	}

}
//----------------------------------------------------------
/**
* Purpose	:	Get the install_location from tblsetup
* Output	:	The value of install_location
* @return string
*/
function getinstallfolder() {

	$db = new Db();

	$query = "SELECT install_folder FROM sec_tblsetup WHERE recid = 1";

	$table = $db->query($query);	

	if (count($table) == 0) 
	{
        return "";
	} 
	else 
	{	
		return $table[0]["install_folder"];
	}

}
//----------------------------------------------------------
//Purpose	:	Given the item_number, return the emailsubject, and emailtext as an array from tblitems
//Outputs	:	The emailsubject, emailtext into an array
function getemaildetails($item_number) {
	
	$db = new Db();
	
	//$strSQL = " SELECT emailsubject, emailtext FROM sec_tblitems WHERE item_number = '$item_number' "
	$table = $db->query(" SELECT emailsubject, emailtext FROM sec_tblitems WHERE item_number = :item_number ", 
						array(
							"item_number" => $item_number
							));		
	
	if (count($table) == 0) {
		$array_name['emailsubject']			= "";
		$array_name['emailtext']			= "";
	}else {	
		$array_name['emailsubject']			= $table[0]["emailsubject"];
		$array_name['emailtext']			= $table[0]["emailtext"];
	}

	return $array_name;

}
//----------------------------------------------------------
//Purpose : returns the receiver email address (the registered paypal address) from the sec_tblsetup
function getreceiveremail() {

	$db = new Db();	

	//$strSQL = " SELECT paypaladdress FROM sec_tblsetup WHERE recid = 1 "
	$table = $db->query(" SELECT paypaladdress FROM sec_tblsetup WHERE recid = 1 ");

	if (count($table) == 0) {
		$email = "";		
	}else {
		$email = $table[0]["paypaladdress"];
	}
	
	return $email;
	
}
//----------------------------------------------------------
/**
* Purpose : returns the admin email address from ipn_tblsetup
* If the admin address is blank (it is optional), it returns the normal 
* paypal receiver address.
* This address is used as the from address in emails
* @return string
*/
function getadminemail() {

	$db = new Db();

	$query = "SELECT adminaddress, paypaladdress FROM sec_tblsetup WHERE recid = 1";

	$table = $db->query($query);

	if (count($table) == 0) 
	{		
	}
	else 
	{
	
		if ($table[0]["adminaddress"] == "") {
			$email = $table[0]["paypaladdress"];			
		} else {	
			$email = $table[0]["adminaddress"];
		}
		
	}	
	
	//echo($email);
	//exit();
	
	return $email;	
}
//----------------------------------------------------------
/**
* Purpose : Check to see if this email address exists
*/
function checkpasswordemail($email) {
	
	$db = new Db();

	$table = $db->query(" SELECT username
						FROM sec_tblpasswords
						WHERE username = :username", 
					array(
						"username" => $email
						));		
	
	$username = trim($table[0]["username"]);	
	
	//echo($table[0]["username"]);
	//exit();
	
	if ( $username == trim($email))
	{
		return true;
	}
	else
	{
		return false;
	}
	
}
//----------------------------------------------------------
//Returns the entry in the password_location field in tblsetup
function getpasswordlocation() {

	$db = new Db();
	
	$table = $db->query( " SELECT password_location FROM sec_tblsetup WHERE recid = 1 " );
	
	$password_location 	= $table[0]["password_location"];
	
	return $password_location;
	
}
//----------------------------------------------------------
//Purpose: Returns securearea_id, unit and value entry in the tblitems for the given item_number
function getuserdetails($item_number) {

	$db = new Db();

	//$strSQL = " SELECT securearea_id, item_name, mc_currency, a1, p1, t1, a2, p2, t2, a3, p3, t3, src, sra, srt FROM sec_tblitems WHERE item_number = '" . $item_number . "'"
	$table = $db->query(" SELECT securearea_id, item_name, mc_currency, 
							a1, p1, t1, a2, p2, t2, a3, p3, t3, src, sra, srt 
									FROM sec_tblitems
									WHERE 
									item_number = :item_number ", 
										array(
											"item_number" => $item_number
									));

		$array_name['securearea_id'] 	= $table[0]["securearea_id"];
		$array_name['item_name']		= $table[0]["item_name"];
		$array_name['mc_currency']		= $table[0]["mc_currency"];
		$array_name['a1'] 				= $table[0]["a1"];
		$array_name['p1'] 				= $table[0]["p1"];
		$array_name['t1']				= $table[0]["t1"];
		$array_name['a2'] 				= $table[0]["a2"];
		$array_name['p2'] 				= $table[0]["p2"];
		$array_name['t2']				= $table[0]["t2"];
		$array_name['a3'] 				= $table[0]["a3"];
		$array_name['p3'] 				= $table[0]["p3"];
		$array_name['t3']				= $table[0]["t3"];
		$array_name['src']				= $table[0]["src"];
		$array_name['sra']				= $table[0]["sra"];
		$array_name['srt']				= $table[0]["srt"];

	return $array_name;

}
//-----------------------------------
//Purpose :	Checks if the last character of the folder 
//			name is "/" or "\" for windows installation
//			If not it adds it on "/" or "\".
function slashonend($folder) {

	if (substr($folder, strlen($folder) - 1, 1) != DIRECTORY_SEPARATOR) {
		$folder = $folder . DIRECTORY_SEPARATOR;
	}
	return $folder;

}
//----------------------------------------------------------
/**
* Purpose : Returns the program version number from tblsetup
* Output : the version number
* @return string
*/
function getversionnumber() {

	$db = new Db();

	$query = " SELECT version_no FROM sec_tblsetup WHERE recid = 1 ";
	
	$table = $db->query($query);

	if (count($table) == 0) {
        return 0;
	} else {	
		return $table[0]["version_no"];
	}

}
//-----------------------------------------------------------------
//Purpose 	:	Checks if the txn_id has already been used in sec_tblsaleshistory
//Inputs	:	The txn_id to check against
//Outputs	:	The number of records found
function checktxnid($txn_id, $toaddress, $fromaddress, $testmode) {

	$db = new Db();

	//$strSQL = " SELECT txn_id FROM sec_tblsaleshistory WHERE txn_id = '" . $txn_id . "'";
	$table = $db->query("SELECT txn_id FROM sec_tblsaleshistory 
						WHERE txn_id = :txn_id ", 
						array("txn_id" => $txn_id)
						);	

	return count($table);

}
//----------------------------------------
//Purpose: Used to check if there is anything in saleshistory table
function saleshistorycheck()
{

	// Creates the instance
	$db = new Db();
		
	$query = " SELECT recid FROM sec_tblsaleshistory ";	
	
	$table = $db->query($query);	
	
	return $table;	
}
//----------------------------------------
//Purpose: Returns data from saleshistory table
function sales($fromdate, $todate) {

	$db = new Db();

	$table = $db->query("SELECT item_name, mc_gross, quantity, payer_email, completed FROM sec_tblsaleshistory 
						WHERE completed >= :fromdate AND completed <= :todate ORDER BY completed ", 
						array("fromdate" => $fromdate, "todate" => $todate)
						);	
	
	return $table;
}
//------------------------------------------------------
//Purpose: Returns the sum total for a given from and to date
function gettotal($fromdate, $todate) {

	$db = new Db();

	$table = $db->query("SELECT sum(mc_gross * quantity) as total FROM sec_tblsaleshistory  
						WHERE completed >= :fromdate AND completed <= :todate ", 
						array("fromdate" => $fromdate, "todate" => $todate)
						);

	$value = $table[0]['total'];
	
	if ($value == "")
	{
		$value = 0;
	}

	return number_format($value, 2, '.', '');
}
//----------------------------------------
//Purpose: Trasnsaction detail  for a particular recid
function transactiondetail($recid) {

	// Creates the instance
	$db = new Db();
	
	$table = $db->query(" SELECT * FROM sec_tblsaleshistory WHERE recid = :recid", 
			array(
				"recid" => $recid
				));		
	
 	return $table;
}
//----------------------------------------
//Purpose: Deletes the transaction given by $recid
function deletetransaction($recid) {

	// Creates the instance
	$db = new Db();

	$delete = $db->query(" DELETE FROM sec_tblsaleshistory WHERE recid = :recid", 
			array(
				"recid" => $recid
				));		
	
 	return $delete;	
}
//------------------------------------------------------
//Purpose : Returns the oldest completed date in the table
function getoldestdate() {

	$db = new Db();

	$query = "SELECT completed FROM sec_tblsaleshistory ORDER BY completed ASC LIMIT 0,1 ";	
	
	$table = $db->query($query);

	return $table[0]["completed"];	//oldest completed date
}
//------------------------------------------------------
//Purpose: Returns all transactions
function gettransactions() {

	// Creates the instance
	$db = new Db();

	$query  = "";
	$query  .= " SELECT sec_tblsaleshistory.recid, sec_tblsaleshistory.receiver_email, sec_tblsaleshistory.payer_email, ";
	$query  .= " sec_tblsaleshistory.item_name, sec_tblsaleshistory.item_number, sec_tblsaleshistory.payment_status, ";
	$query  .= " sec_tblsaleshistory.mc_gross, sec_tblsaleshistory.quantity, sec_tblsaleshistory.txn_type, ";
	$query  .= " sec_tblsaleshistory.txn_id, sec_tblsaleshistory.mc_currency, sec_tblsaleshistory.completed ";
	$query  .= " FROM sec_tblsaleshistory LEFT JOIN sec_tblitems ON sec_tblsaleshistory.item_id = sec_tblitems.recid ";
	$query  .= " ORDER BY completed desc ";

	$table = $db->query($query);		

	return $table;	
}
//------------------------------------------------------
//Purpose:  Insert into tblsaleshistory
function insertsaleshistory($custom, $business, $receiver_id, $invoice, $memo, $tax, $option_name1, $option_selection1, $option_name2,
									$option_selection2, $num_cart_items, $mc_fee, $payment_date, $payment_type, $first_name, $last_name,
									$payer_business_name, $address_name, $address_street, $address_city, $address_state, $address_zip,
									$address_country, $address_status, $payer_id, $payer_status, $notify_version, $verify_sign,
									$txn_id, $item_number, $item_name, $payment_status, $mc_gross, $mc_currency, $receiver_email, 
									$payer_email, $completed) {


/*
	echo($custom);
	echo($business); 
	echo($receiver_id);
	echo($invoice); 
	echo($memo); 
	echo($tax); 
	echo($option_name1); 
	echo($option_selection1);
	echo($option_name2);									
	echo($option_selection2);
	echo($num_cart_items); 
	echo($mc_fee); 
	echo($payment_date); 
	echo($payment_type);
	echo($first_name);
	echo($last_name);									
	echo($payer_business_name); 
	echo($address_name); 
	echo($address_street); 
	echo($address_city); 
	echo($address_state); 
	echo($address_zip);									
	echo($address_country); 
	echo($address_status); 
	echo($payer_id); 
	echo($payer_status); 
	echo($notify_version); 
	echo($verify_sign);									
	echo($txn_id); 
	echo($item_number); 
	echo($item_name); 
	echo($payment_status); 
	echo($mc_gross); 
	echo($mc_currency); 
	echo($receiver_email);									
	echo($payer_email); 
	echo($completed);	
*/	
	
	// Creates the instance
	$db = new Db();
	
	$insert = $db->query( " INSERT INTO sec_tblsaleshistory 
								(	
								custom,
								business,
								receiver_id,
								invoice,
								memo,
								tax,
								option_name1,
								option_selection1,
								option_name2,
								option_selection2,
								num_cart_items,
								mc_fee,
								payment_date,
								payment_type,
								first_name,
								last_name,
								payer_business_name,
								address_name,
								address_street,
								address_city,
								address_state,
								address_zip,
								address_country,
								address_status,
								payer_id,
								payer_status,
								notify_version,
								verify_sign,
								txn_id,
								item_number,
								item_name,
								payment_status,
								mc_gross,
								mc_currency,
								receiver_email,
								payer_email,
								completed
								)
								VALUES
								(
								:custom,
								:business,
								:receiver_id,
								:invoice,
								:memo,
								:tax,
								:option_name1,
								:option_selection1,
								:option_name2,
								:option_selection2,
								:num_cart_items,
								:mc_fee,
								:payment_date,
								:payment_type,
								:first_name,
								:last_name,
								:payer_business_name,
								:address_name,
								:address_street,
								:address_city,
								:address_state,
								:address_zip,
								:address_country,
								:address_status,
								:payer_id,
								:payer_status,
								:notify_version,
								:verify_sign,
								:txn_id,
								:item_number,
								:item_name,
								:payment_status,
								:mc_gross,
								:mc_currency,
								:receiver_email,
								:payer_email,
								:completed
								) ",
								array(	
									"custom" => $custom,
									"business" => $business,
									"receiver_id" => $receiver_id,
									"invoice" => $invoice,
									"memo" => $memo,
									"tax" => $tax,
									"option_name1" => $option_name1,
									"option_selection1" => $option_selection1,
									"option_name2" => $option_name2,
									"option_selection2" => $option_selection2,
									"num_cart_items" => $num_cart_items,
									"mc_fee" => $mc_fee,
									"payment_date" => $payment_date,
									"payment_type"  => $payment_type,
									"first_name"  => $first_name,
									"last_name"  => $last_name,
									"payer_business_name"  => $payer_business_name,
									"address_name"  => $address_name,
									"address_street" => $address_street,
									"address_city" => $address_city,
									"address_state" => $address_state,
									"address_zip" => $address_zip,
									"address_country" => $address_country,
									"address_status" => $address_status,
									"payer_id" => $payer_id,
									"payer_status" => $payer_status,
									"notify_version" => $notify_version,
									"verify_sign" => $verify_sign,
									"txn_id" => $txn_id,
									"item_number" => $item_number,
									"item_name" => $item_name,
									"payment_status" => $payment_status,
									"mc_gross" => $mc_gross,
									"mc_currency" => $mc_currency,
									"receiver_email" => $receiver_email,
									"payer_email" => $payer_email,
									"completed"  => $completed
								));
	
	return $insert;

}
//-----------------------------------
//Purpose:  Given the mc_currency, return the display value for this currency
function getcurrency($mc_currency) {

	switch ($mc_currency) {
		case "AUD" :		//AUD Australian Dollar
			$ret = "AUD $";
			break;			
		case "CAD" :		//CAD Canadian Dollar
			$ret = "CAD $";
			break;	
		case "CHF" :		//CHF Swiss Franc
			$ret = "CHF Fr";
			break;	
		case "CZK" :		//CZK Czech Koruna
			$ret = "CZK K&#269;";
			break;			
		case "DKK" :		//DKK Danish Krone
			$ret = "DKK kr";
			break;						
		case "EUR" :		//EUR Euro
			$ret = "EUR &#8364;";
			break;	
		case "GBP" :		//GBP Pound Sterling
			$ret = "GBP &pound;";
			break;
		case "HKD" :		//HKD Hong Kong Dollar
			$ret = "HKD $";
			break;			
		case "HUF" :		//HUF Hungarian Forint
			$ret = "HUF Ft";
			break;
		case "JPY" :		//JPY Japanese Yen
			$ret = "YEN &yen;";
			break;
		case "NOK" :		//NOK Norwegian Krone
			$ret = "NOK kr";
			break;			
		case "NZD" :		//NZD New Zealand Dollar
			$ret = "NZD $";
			break;	
		case "PLN" :		//PLN Polish Zloty
			$ret = "PLN z&#322;";
			break;
		case "SEK" :		//SEK Swedish Krona
			$ret = "SEK kr";
			break;
		case "SGD" :		//SGD Singapore Dollar
			$ret = "SGD $";
			break;
		case "USD" :		//USD U.S. Dollar
			$ret = "USD $";
			break;			
		default :
			$ret = "unknown";
	}

	return $ret;

}
//----------------------------------------
//Purpose: Return array of tblsetup
function gettblsetup() {

	$db = new Db();	
	
	$query = " SELECT paypaladdress, adminaddress, copyemail, mc_currency, manual_entered, 
	sandbox_seller, referring_server, sitetitle, cancel_url, return_url, notify_url, 
	notify_sandbox_url, install_folder, protection_type, password_location, button, manual_entered
	FROM sec_tblsetup WHERE recid = 1";	
   //only one record
	
	$table = $db->query($query);
	
	return $table;
}
//----------------------------------------
//Purpose: update the graphic button selections
function updategraphics($button, $manual_entered) {

	//echo($manual_entered_secure_checkout_paypal);
	//exit();

	$db = new Db();
	
	$update	=  $db->query("UPDATE sec_tblsetup SET 
			button = :button, 
			manual_entered = :manual_entered
			WHERE recid = 1", 
	array(
		"button" => $button, 
		"manual_entered" => $manual_entered			
	)); 

	return $update;	
}
//----------------------------------------------------------
/**
* Purpose	:	Update tblsetup details
* Outputs	:	Number of rows updated
* returns int
*/	
function updateglobal($paypaladdress, $adminaddress, $copyemail, $mc_currency, $sandbox_seller, 
						$referring_server, $sitetitle, $cancel_url, $return_url, $notify_url, 
						$notify_sandbox_url, $install_folder, $protection_type, $password_location) {	
	
	$db = new Db();
	
	$update	= $db->query("UPDATE sec_tblsetup SET 
		paypaladdress = :paypaladdress, 
		adminaddress =:adminaddress, 
		copyemail =:copyemail, 
		mc_currency = :mc_currency, 
		sandbox_seller =:sandbox_seller, 
		referring_server =:referring_server, 
		sitetitle =:sitetitle, 
		cancel_url =:cancel_url, 
		return_url =:return_url, 
		notify_url =:notify_url, 
		notify_sandbox_url =:notify_sandbox_url, 
		install_folder =:install_folder, 
		protection_type =:protection_type, 
		password_location =:password_location
		WHERE recid = 1", 
		array(
		"paypaladdress"				=> $paypaladdress,		
		"adminaddress"				=> $adminaddress,		
		"copyemail" 				=> $copyemail,		
		"mc_currency" 				=> $mc_currency,		
		"sandbox_seller" 			=> $sandbox_seller, 
		"referring_server"			=> $referring_server,
		"sitetitle"					=> $sitetitle,
		"cancel_url"				=> $cancel_url,
		"return_url"				=> $return_url,
		"notify_url"				=> $notify_url,
		"notify_sandbox_url"		=> $notify_sandbox_url,
		"install_folder"			=> $install_folder,
		"protection_type"			=> $protection_type,
		"password_location"			=> $password_location		
		)); 

	return $update;	
}
//-----------------------------------------------------------------
//Purpose	:	Second version to create a random password
//				Create a password for use by the user which should be
//				8 characters long, consisting of 2-9, a-h, j,k, m, n, p-z  - i.e. not 0 or 1 or i or l or o
//				Lower case only.
function createpw() {

	$digits = 8;

	srand ((double) microtime() * 10000000);
	//Array of alphabets
	$input = array ("A", "B", "C", "D", "E", "G", "H", "J", "K", "M", "N", "P", "R", "S", "V", "W", "X", "Y", "Z");

	$random_generator="";// Initialize the string to store random numbers
	for($i=1;$i<$digits+1;$i++){ // Loop the number of times of required digits

	if(rand(1,2) == 1){// to decide the digit should be numeric or alphabet
	// Add one random alphabet
	$rand_index = array_rand($input);
	$random_generator .=$input[$rand_index]; // One char is added

	}else{

	// Add one numeric digit between 1 and 10
	$random_generator .=rand(2,9); // one number is added
	} // end of if else

	} // end of for loop

	return strtolower($random_generator);

}
//-----------------------------------------------------------------
//Purpose: Used in random number creation to seed 
function make_seed() {
    list($usec, $sec) = explode(' ', microtime());
    return (float) $sec + ((float) $usec * 100000);
}
//----------------------------------------------
//Purpose:  Send emails according to which products have been selected
//If product is blank then send emails to all purchasers
//If product is not blank then send emails to just those purchasers who bought that product
//Inputs : 	email subject, enmail body, any product info, the format of the email as text or html.
//			If $product is blank then, one sql statement is used sending emails to all products
//			If not blank, another sql is used sending emails to defined products.
//Returns : the number of emails sent

//We send an email to your own admin address as the to address, and then send emails to all others 
//as Bcc with the from address from your admin address.
function sendmail($subject, $body, $product, $format, $testmode) {

	$adminaddress = getadminemail();

	$db = new Db();

	//Get all the unique email addresses from tblSalesHistory
	
	if ($product == "") 
	{
		$table = $db->query("SELECT DISTINCT payer_email FROM sec_tblsaleshistory");			
	}
	else
	{
		$table = $db->query("SELECT DISTINCT payer_email FROM sec_tblsaleshistory 
				WHERE item_number =:item_number ", 
				array("item_number" => $product)
				);
	}

	//First check if there any rows	
	if ($table) {

		$bcc_address = "";
		foreach( $table as $d_row ) {
			$bcc_address .= $d_row["payer_email"] . ",";		//Constuct list of Bcc separated by ,
		}

		//Remove last ,
		$bcc_address = substr($bcc_address,0,strlen($bcc_address)-1);

		//echo("<br><b>Bcc to address :</b><br>$bcc_address<br><b>subject :</b><br>$subject<b><br>body :</b><br>$body<br><b>from address :</b><br>$adminaddress<br><b>format : </b>$format<br>");
		//exit();

		mailmessage($adminaddress, $subject, $body, $format, $adminaddress, $bcc_address, $testmode);
		return count($table);

	} else {
		return 0;
	}

}
//-----------------------------------------------------------------
/**
* Purpose	:	Send the mail message
* Inputs	:	to address, subject, $body text, $format, $fromaddress, $bcc and testmode
* format is "html" if html format is required which sets the header, blank sends normal email
* fromaddress is the from address
* bcc is the list of bcc addresses separated by ,
* testmode is "true" if this comes from the local ipntest so that the emails 
* can be seen on the page.
*
* Emails are either sent using in built php function or smtp if configured.
*/
function mailmessage($to, $subject, $body, $format, $fromaddress, $bcc, $testmode) {
		
	$smtp = smtpsettings();
	
	$smtpuse = $smtp[0]["usesmtp"];
	
	//echo($smtpuse);
	//exit();

	if ($smtpuse == 1) {$smtpuse = true;} else {$smtpuse = false;}	

	if ($smtpuse != true) {
		mailmessage_nonsmtp($to, $subject, $body, $format, $fromaddress, $bcc, $testmode);
	} else {
		mailmessage_smtp($to, $subject, $body, $format, $fromaddress, $bcc, $testmode, $smtp);
	}
	
}
//-----------------------------------------------------------------
/**
* Purpose	:	Send the mail message using NON smtp
* Inputs	:	to address, subject, $body text, $html, $fromaddress, $bcc and testmode
* format is "html" if html format is required which sets the header, blank sends normal email
* fromaddress is the from address
* bcc is the list of bcc addresses separated by ,
* testmode is "true" if this comes from the local ipntest so that the emails 
* can be seen on the page.
*/
function mailmessage_nonsmtp($to, $subject, $body, $format, $fromaddress, $bcc, $testmode) {

//echo($body);
//exit();

	//Headers are separated by $sep (It may be necessary to use \n on some servers, but this not actually correct)
	$sep = "\r\n";		//separater for headers

	$testmode = "false";	
	if ($testmode == "true") {	
		//Used during testing :
		echo("<br><br>");
		echo("*******************************************<br>");
		echo("<strong>To:</strong><br/>$to<br/>");
		echo("<strong>fromaddress:</strong><br/>$fromaddress<br/>");
		echo("<strong>bcc:</strong><br/>$bcc<br/>");
		echo("<strong>Subject:</strong><br/>$subject<br/>");
		$body1 = str_replace("\r\n", "<br/>", $body);
		echo("<strong>Body:</strong><br/>$body1<br/>");
		echo("<br/><br/>");
	}
	//exit();

	//subject must not have newline character and make max length of 70 characters
	//body - each line should be separated with a LF (\n). Lines should not be larger than 70 characters. 

	//replace any \r\n, \n or \r with a space in subject line and only use 70 characters
	$subject = str_replace("\r\n", " ", $subject);
	$subject = str_replace("\n", " ", $subject);
	$subject = str_replace("\r", " ", $subject);
	//$subject = substr ( $subject, 0, 70 );

	//replace any \r\n with \n and use wordwrap() to split the lines which will use \n for new line
	//$body = str_replace("\r\n", "\n", $body);
	//$body = wordwrap($body, 70, "\n");
	$body = WrapText($body, 70, "\n", false);

	//construct the header
	$headers = "";

	if ( $format == "html" ) {  //To send HTML mail, you can set the Content-type header.
		$headers .= "MIME-Version: 1.0" . $sep;
		$headers .= "Content-type: text/html; charset=iso-8859-1" . $sep;
		
		//Mod added to convert double quote marks to the html equivilant
		//$body = str_replace('"', '&#34;', $body);
		//Mod added to convert single quote marks to the html equivilant		
		//$body = str_replace("'", "&#39;", $body);		
	}

	$headers .= "From:" . $fromaddress . $sep;

	if ( $bcc != "" ) {
		$headers .= "Bcc:" . $bcc . $sep;
	}

	//The following is not needed now as you can use the smtp settings in the settings file
	//The following is only applicable on windows servers
	//ini_set("SMTP", "<smpt server name here>");
	//ini_set("smtp_port","25");
	//ini_set("sendmail_from", "<from address here>");
	//mail($to, $subject, $body);


	// Check for safe mode - safe mode has been removed since PHP 5.6
	//if( ini_get('safe_mode') ){		//safe mode on
	//	mail($to, $subject, $body, $headers);	//Send with header.  
	//}else{							//safe mode off
		//Mod to overcome problem with some ISP not liking a Return-Path of root or nobody
		//If safe mode is on, the the fifth parameter is disabled so may have to use the above line instead.			
		$addparam = "-f".$fromaddress;
		mail($to, $subject, $body, $headers, $addparam);	//Send with header
	//}

	//Alternative method of sending mail
	//mail( $to, $subject, $body, "From: $fromaddress" );

}
//-----------------------------------------------------------------
/*
* Purpose	:	Send the mail message using smtp
* Inputs	:	to address, subject, $body text, $html, $fromaddress, $bcc and testmode
* format is "html" if html format is required which sets the header, blank sends normal email
* fromaddress is the from address
* bcc is the list of bcc addresses separated by ,
* testmode is "true" if this comes from the local ipntest so that the emails 
* can be seen on the page.
*/
function mailmessage_smtp($to, $subject, $body, $format, $fromaddress, $bcc, $testmode, $smtp) {

	$testmode = "false";
	if ($testmode == "true") {	
		//Used during testing :
		echo("<br><br>");
		echo("*******************************************<br>");
		echo("<strong>To:</strong><br/>$to<br/>");
		echo("<strong>fromaddress:</strong><br/>$fromaddress<br/>");
		echo("<strong>bcc:</strong><br/>$bcc<br/>");
		echo("<strong>Subject:</strong><br/>$subject<br/>");
		$body1 = str_replace("\r\n", "<br/>", $body);
		echo("<strong>Body:</strong><br/>$body1<br/>");
		echo("<br/><br/>");
	}

	//echo($smtpuse . "<br/>");
	//echo($smtphost . "<br/>");
	//echo($smtpusername . "<br/>");
	//echo($smtppassword . "<br/>");
	//exit();	
	
	$smtphost 				= $smtp[0]["smtphost"];
	$smtpauthentication 	= $smtp[0]["smtpauthentication"];
	$smtpusername 			= $smtp[0]["smtpusername"];
	$smtppassword 			= $smtp[0]["smtppassword"];
	$typeofencryption 		= $smtp[0]["typeofencryption"];
	$smtpport 				= $smtp[0]["smtpport"];
	$fromaddress 			= $smtp[0]["fromemail"];
	$fromname 				= $smtp[0]["fromname"];
	$debug					= $smtp[0]["debug"];
	
	if ($debug == 2) {
	
		echo("SMTP Host: " . $smtphost . "<br/>");
		echo("SMTP Authentication: " . $smtpauthentication . "<br/>");
		echo("SMTP Username: " . $smtpusername . "<br/>");
		echo("SMTP Password :  xxxxxxxx<br/>");
		if ($typeofencryption == "") { $typeofencryption = "None"; } 
		echo("Type of encryption: " . $typeofencryption . "<br/>");
		echo("SMTP port: " . $smtpport . "<br/>");
		echo("From address: " . $fromaddress . "<br/>");
		echo("From name: " . $fromname . "<br/>");
		echo("Debug mode: " . $debug . "<br/>");
	
	}
	
	$mail = new PHPMailer();

	$mail->IsSMTP();                        	// set mailer to use SMTP
	$mail->SMTPDebug = $debug;					// 0 = off (for production use) 1 = client messages 2 = client and server messages
	$mail->Host 	= $smtphost;  				// specify main and backup server
	$mail->Port 	= $smtpport;				// The smtp port
	$mail->SMTPAuth = $smtpauthentication;     	// turn on SMTP authentication true or false
	$mail->Username = $smtpusername;  			// SMTP username
	$mail->Password = $smtppassword; 			// SMTP password	
	$mail->setFrom($fromaddress);				// The from address	
	$mail->FromName = $fromname;				// The from name
	$mail->SMTPSecure = $typeofencryption;		// Options: '', 'ssl' or 'tls'.
	$mail->AddAddress($to);						// The to address
	$mail->WordWrap = 50;                  		// set word wrap to 50 characters (DONT CHANGE THIS)
	//$mail->IsHTML(true);                 		// set email format to HTML
	if ($bcc != "") {
		$bcc_array = explode(",",$bcc);	
		foreach( $bcc_array as $entry ) {
			$mail->AddBCC($entry);
		}
	}
		
	$mail->Subject = $subject;
	$mail->Body    = $body;
	//$mail->AltBody = $body;

	if(!$mail->Send())
	{

		//send by non-smtp instead
		mailmessage_nonsmtp($to, $subject, $body, $format, $fromaddress, $bcc, $testmode);

		//send warning error to admin email address
		$subject = "PHP-SecureArea - Email message could not be sent by smtp.";
		
		$body = "body : " . $body . "\r\n\r\n to : " . $to . "\r\n\r\n subject : " . $subject . "\r\n\r\n fromaddress : " . $fromaddress . "\r\n\r\n " . "Mailer Error: " . $mail->ErrorInfo . " email was sent non-smtp instead ";
		mailmessage_nonsmtp($fromaddress, $subject, $body, $format, $fromaddress, $bcc, $testmode);

	}
	
}
//-----------------------------------------------------------------
/**
* Purpose : Wraps message for use with mailers that do not
* automatically perform wrapping and for quoted-printable.
* $message is the input text
* $length is normally 70
* $LE is the line ending character which is normally "\n"
* $qp_mode is quoted-printable which is normally false
* @return string
*/
function WrapText($message, $length, $LE, $qp_mode = false) {
	$soft_break = ($qp_mode) ? sprintf(" =%s", $LE) : $LE;

	$message = FixEOL($message, $LE);
        if (substr($message, -1) == $LE)
            $message = substr($message, 0, -1);

        $line = explode($LE, $message);
        $message = "";
        for ($i=0 ;$i < count($line); $i++)
        {
          $line_part = explode(" ", $line[$i]);
          $buf = "";
          for ($e = 0; $e<count($line_part); $e++)
          {
              $word = $line_part[$e];
              if ($qp_mode and (strlen($word) > $length))
              {
                $space_left = $length - strlen($buf) - 1;
                if ($e != 0)
                {
                    if ($space_left > 20)
                    {
                        $len = $space_left;
                        if (substr($word, $len - 1, 1) == "=")
                          $len--;
                        elseif (substr($word, $len - 2, 1) == "=")
                          $len -= 2;
                        $part = substr($word, 0, $len);
                        $word = substr($word, $len);
                        $buf .= " " . $part;
                        $message .= $buf . sprintf("=%s", $LE);
                    }
                    else
                    {
                        $message .= $buf . $soft_break;
                    }
                    $buf = "";
                }
                while (strlen($word) > 0)
                {
                    $len = $length;
                    if (substr($word, $len - 1, 1) == "=")
                        $len--;
                    elseif (substr($word, $len - 2, 1) == "=")
                        $len -= 2;
                    $part = substr($word, 0, $len);
                    $word = substr($word, $len);

                    if (strlen($word) > 0)
                        $message .= $part . sprintf("=%s", $LE);
                    else
                        $buf = $part;
                }
              }
              else
              {
                $buf_o = $buf;
                $buf .= ($e == 0) ? $word : (" " . $word); 

                if (strlen($buf) > $length and $buf_o != "")
                {
                    $message .= $buf_o . $soft_break;
                    $buf = $word;
                }
              }
          }
          $message .= $buf . $LE;
        }

        return $message;
}
//-----------------------------------------------------------------
/**
* Purpose : Changes every end of line from CR or LF to CRLF. 
* $LE is line ending characer which is normally '\n'
* @return string
*/
function FixEOL($str, $LE) {
	$str = str_replace("\r\n", "\n", $str);
	$str = str_replace("\r", "\n", $str);
	$str = str_replace("\n", $LE, $str);
	return $str;
}
//-----------------------------------------------------------------
/**
* Purpose	:	Create a random link password
* Create a link for use by the user which should be
* 20 characters long, consisting of 2-9, a-h, j,k, m, n, p-z  - i.e. not 0 or 1 or i or l or o
* Lower case only.
* @return string
*/
function createlink() {

	$digits = 20;

	srand ((double) microtime() * 10000000);
	//Array of alphabets
	$input = array ("A", "B", "C", "D", "E", "G", "H", "J", "K", "M", "N", "P", "R", "S", "V", "W", "X", "Y", "Z");

	$random_generator="";// Initialize the string to store random numbers
	for($i=1;$i<$digits+1;$i++){ // Loop the number of times of required digits

	if(rand(1,2) == 1){// to decide the digit should be numeric or alphabet
	// Add one random alphabet
	$rand_index = array_rand($input);
	$random_generator .=$input[$rand_index]; // One char is added

	}else{

	// Add one numeric digit between 1 and 10
	$random_generator .=rand(2,9); // one number is added
	} // end of if else

	} // end of for loop

	return strtolower($random_generator);

}
//----------------------------------------------------------
/**
* Purpose : Update tblpasswords with recover link and date entered.
* Returns: Number of records updated
*/
function savelink($link, $email) {
	
	$db = new Db();
	
	$linkdate = date("Y-m-d H:i:s");
	
	$update	=  $db->query("UPDATE sec_tblpasswords 
			SET link 		= :link, 			
			linkdate 		= :linkdate
			WHERE username 	= :username", 
		array(
			"link" => $link,			
			"linkdate" => $linkdate,
			"username" => $email
		));
			
	return $update;
	
}
//----------------------------------------------------------
/**
* Purpose : Get tblpassword details
* Returns: Table
*/
function getlinkdata() {
	
	$db = new Db();
	
	$table = $db->query(" SELECT link, linkdate FROM sec_tblpasswords");
	
	return $table;
	
}
//----------------------------------------------------------
//Purpose	:	Sends login details, password etc to purchaser
function sendlogindetails($payer_email, $password, $item_number, $testmode) {
		
		//echo("payer email : " . $payer_email . "<br/>");
		//echo("password : " . $password . "<br/>");
		//echo("item number : " . $item_number . "<br/>");
		//echo("test mode : " . $testmode . "<br/>");
		//exit();
		
		//Get the url of the customer login area	
		$url = getinstallfolder() . "customeradmin/index.php";	
	
		//Get emailsubject, emailtext from tblitems for this item - not from tblsetup which is the global settings.
		$emaildetails 		= getemaildetails($item_number);
			$emailsubject 	= $emaildetails['emailsubject'];
			$emailtext 		= $emaildetails['emailtext'];
		
		$setup 				= gettblsetup();
			$copyemail		= $setup[0]['copyemail'];
			$toaddress		= $setup[0]['paypaladdress'];

		$fromaddress 		= getadminemail();	
		
		//Case insensitive replace.
		$emailtext = preg_replace("/<login_url>/i", $url, $emailtext);
		$emailtext = preg_replace("/<password>/i", $password, $emailtext );
		$emailtext = preg_replace("/<payer_email>/i", $payer_email, $emailtext );

			//echo("main<br/>");
			//echo("payer_email". $payer_email . "<br/>");
			//echo("subject". $emailsubject . "<br/>");
			//echo("text". $emailtext . "<br/>");				
			//echo("fromaddress". $fromaddress . "<br/>");
			//echo($testmode . "<br/>");			
			//exit();
			
		//Send email to customer
		mailmessage($payer_email, $emailsubject , $emailtext, "", $fromaddress, "", $testmode);
	
		//Copy email if flag is set
		$emailsubject = $emailsubject . " (copy)";
		if ($copyemail == 1) {
		
			//echo("copy<br/>");
			//echo($toaddress . "<br/>");
			//echo($emailsubject . "<br/>");
			//echo($emailtext . "<br/>");				
			//echo($fromaddress . "<br/>");
			//echo($testmode . "<br/>");			
			//exit();
			
			mailmessage($toaddress, $emailsubject, $emailtext, "", $fromaddress, "", $testmode);
			
		}

}
?>