<?php

error_reporting(E_ALL);
//distribution
//error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);	


//------------------------------------------------
//Create the tables
//------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//V1.14	 added to tblsaleshistory
//		business VARCHAR(255)
//		receiver_id VARCHAR(255)
//		invoice VARCHAR(255)
//		custom VARCHAR(255)
//		memo VARCHAR(255)
//		tax VARCHAR(255)
//		option_name1 VARCHAR(255)
//		option_selection1 VARCHAR(255)
//		option_name2 VARCHAR(255)
//		option_selection2 VARCHAR(255)
//		num_cart_items VARCHAR(255)
//		mc_fee VARCHAR(255)
//		payment_date VARCHAR(255)
//		payment_type VARCHAR(255)
//		first_name VARCHAR(255)
//		last_name VARCHAR(255)
//		payer_business_name VARCHAR(255)
//		address_name VARCHAR(255)
//		address_street VARCHAR(255)
//		address_city VARCHAR(255)
//		address_state VARCHAR(255)
//		address_zip VARCHAR(255)
//		address_country VARCHAR(255)
//		address_status VARCHAR(255)
//		payer_id VARCHAR(255)
//		payer_status VARCHAR(255)
//		notify_version VARCHAR(255)
//		verify_sign VARCHAR(255)


//V1.15			added to sec_tblpurchased_secureareas 
//				sub_due_date DATETIME 
//				added to sec_tblsaleshsitory
//				quantity INT default '1' NOT NULL

//V2.0			Additional fields in sec_tblusers
//				sec_tblpurchased_secureareas : sub_expire_date

//V2.9			Additional fields in sec_tblpasswords needed for recover password
//				link VARCHAR(255)	
//				linkdate DATETIME
//				New table sec_tblsmtp needed for SMTP set up 
//				and insert of default value for record 1



//------------------------------------
//database version number
$dbversion = "2.9.6";
//------------------------------------


//------------------------------------------------
main($dbversion);

//------------------------------------------------
function main($dbversion) {

	if ( isset($_POST['Submit']) ) {
		$submit = $_POST['Submit'];
	} else {
		$submit = "";
	}

	if ($submit == "") {
		displayheader();
		display();
		displayfooter();
	}
	else
	{
		$host = $_POST['txtHost'];
		$user = $_POST['txtUser'];
		$password = $_POST['txtPassword'];
		$dbname = $_POST['txtDBName'];		
		createtables($host, $user, $password, $dbname, $dbversion);
	}

}
//------------------------------------------------
function display() {

	?>
	
	<div id="contentall">	
	
<table>
<tr>
<td>

	<table border="0" align="center" width="560px">
	<tr>
		<td>
		<ul>
			<li>This page is used to install the MySQL tables to your database.</li>
            <li>It will also check an existing set of tables and columns and will add new tables and columns to 
            bring the database up to the latest version.</li>
			<li>FTP the file to your web server into a folder with an appropriate name.</li>
            <li>The database should already exist and have a username and password.</li>
			<li>Run this file (install.php) from your web browser and enter the details in the form below.</li>
			<li>Press submit, will add in new table columns as required.</li>
			<li>Delete this file (install.php) from your web server.</li>
			<li>For full details refer to the installation documentation on the website.</li>
		</ul>
		</td>
	</tr>
	</table>

</td>
</tr>

<tr>
	<td>&nbsp;</td>
</tr>

<tr>
<td>
	
		<form name="frmTables" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
	
		<table border="0" align="center" class="tableoutline">
		<tr>
		<td>	
	
		<table border="0" align="center">
		<tr>
			<td valign="middle" align="right">Host name (usually localhost)</td>
			<td width="15"></td>
			<td valign="middle"><input type="text" name="txtHost" value="localhost"></td>
		</tr>
		<tr>
			<td valign="middle" align="right">Database user name</td>
			<td width="15"></td>
			<td valign="middle"><input type="text" name="txtUser"></td>
		</tr>
		<tr>
			<td valign="middle" align="right">Datebase password</td>
			<td width="15"></td>
			<td valign="middle"><input type="password" name="txtPassword"></td>
		</tr>
		<tr>
			<td valign="middle" align="right">Database Name</td>
			<td width="15"></td>
			<td valign="middle"><input type="text" name="txtDBName" value="phpsecurearea"></td>
		</tr>	
		<tr>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
		</tr>		
		<tr>	
			<td colspan="3" align="center"><input type="Submit" name="Submit" value="Submit"></td>
		</tr>
		</table>

		</td>	
		</tr>
		</table>	
	
		</form>

</td>
</tr>
</table>

	</div>

	<?php

}
//------------------------------------------------
function createtables($host, $user, $password, $dbname, $dbversion) {

	//echo("$host, $user, $password, $dbname");
	//exit();

	displayheader();

	//Create link
	$link = mysqli_connect($host, $user, $password, $dbname);

	//Check the connection
	if (!$link) {
		printf("Could not connect to database: %s\n", mysqli_connect_error());
		exit();
	}

	//+++++++++++++++++++++++++++++++++++++++++++++++++
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblitems'");
	if($checktable->num_rows == 0) {

		//Create table
		$query = "CREATE TABLE sec_tblitems ( "
				. " recid INT NOT NULL AUTO_INCREMENT ,"
				. " item_number VARCHAR(50) UNIQUE ,"
				. " item_name VARCHAR(100) ,"
				. " item_description TEXT ,"

				. " mc_currency VARCHAR(10) , "

				. " currency VARCHAR(20) , "
				. " emailsubject TEXT ,"
				. " emailtext TEXT , "
				. " item_image VARCHAR(150) , "		
				. " securearea_id INT default '0' NOT NULL ,"

				. " a1 VARCHAR(10) ,"						//Trial period 1, cost - not used
				. " p1 INT ,"								//Trial period 1, unit period - not used
				. " t1 VARCHAR(1) ,"						//Trial period 1, Unit of D, W, M or Y - not used

				. " a2 VARCHAR(10) ,"						//Trial period 2, cost - not used	
				. " p2 INT ,"								//Trial period 1, unit period - not used
				. " t2 VARCHAR(1) ,"						//Trial period 1, Unit of D, W, M or Y - not used

				. " a3 VARCHAR(10) ,"				//Regular billing cost - the rate of the subscription
				. " p3 INT default '1' NOT NULL ,"			//Regular billing cycle. This is the length of the billing cycle. The number is modified by the regular billing cycle units (t3, below)
				. " t3 VARCHAR(1) default 'D' NOT NULL ,"	//Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: D (days), W (weeks), M (months), Y (years)

				. " src INT default '1' NOT NULL, "			//Recurring payments. If set to “1” the payment will recur
				. " sra INT default '1' NOT NULL, "			//Reattempt on failure.
				. " srt INT , "								//Recurring Times. This is the number of payments which will occur at the regular rate. If omitted, payment will continue to recur at the regular rate until the subscription is cancelled.

				. " publish INT default '1' NOT NULL ,"
				. " PRIMARY KEY (recid) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblitems was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblitems " . mysqli_error($link) . "</font><br/><br/>");
			}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblitems exists</font><br/><br/>"); 	
	}
	
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblsetup'");
	if($checktable->num_rows == 0) {
	
		//Create table
		$query = "CREATE TABLE sec_tblsetup ( "
				. " recid INT , "
				. " paypaladdress VARCHAR(100) , "		
				. " emailsubject TEXT , "
				. " emailtext TEXT , "		
				. " adminaddress VARCHAR(100) , "
				. " copyemail INT DEFAULT '1' NOT NULL , "
				. " mc_currency VARCHAR(10) DEFAULT 'USD', "
				. " currency VARCHAR(20) DEFAULT 'USD $', "

				. " button VARCHAR(200) DEFAULT '../images/btn/x-click-but24.gif' , "
				. " manual_entered INT DEFAULT '0' NOT NULL , "		

				. " password_location VARCHAR (255) , "
				. " sandbox_seller VARCHAR (100) , "
				. " referring_server VARCHAR(100) , "
				. " sitetitle VARCHAR(255) , "	
				. " cancel_url VARCHAR(200) , "
				. " return_url VARCHAR(200) , "		
				. " notify_url VARCHAR(200) , "
				. " notify_sandbox_url VARCHAR(200) , "
				. " install_folder VARCHAR(150) , "
				. " protection_type INT DEFAULT '1' NOT NULL, "  //1 represents Basic Authentication, but will always be this in this system.
				. " version_no VARCHAR(10) ,"		
				. " PRIMARY KEY (recid) ) "
				. " "; 
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblsetup was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblsetup " . mysqli_error($link) . "</font><br/><br/>");
			}

		
		//Create record id 1 in sec_tblsetup
		$query = "INSERT INTO sec_tblsetup (recid, emailsubject, emailtext, sitetitle, version_no) "
				. "Values ( 1, 'Subject of email which is sent to the purchaser', "
				. " 'Body text of the email which should include a url to the protected folder or folders, and the username/password similar to the following :\r\n\r\nTo log in to the secure folder or folders, enter the following into your browser address bar :\r\n[manually enter the url of the secure folder or folders]:\r\nLogin with :\r\n\r\nUsername : <payer_email>\r\nPassword : <password>\r\n\r\nTo change your password or recover a lost password, login to the administration area : <login_url> with the same username/password.\r\n\r\n--------------------------------\r\nIf this is a PayPal recurring payment and you want to cancel further payments:\r\n(1) Login to your PayPal account.\r\n(2) Click on the Home listing to see your money in - money out details.\r\n(3) You should see a Recent Activity listing.\r\n(4) You need to find the subscription where it says created.  Click on created to show the subscription details.\r\n(5) Click on Cancel\r\nIt will pop up a box saying Youre about to cancel this recurring payment plan\r\n(6)Click Cancel Plan\r\nIf you are having problems finding the subscription, click on Activity in the main menu and then select All Transactions.  In the transactions type drop down listing select subscription payments.  From this list you should see the subscription and the name of the person that you are paying.  If you click on the name for the created subscripton, it will take you to the transaction details where you can cancel.\r\nCancelling your Subscription will immediately stop all future scheduled payments for this Subscription.\r\nNote that when you cancel your subscription you will still be able to log in until the subscription period has expired.', " . " 'Site title' , '".$dbversion."'  )";

		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The default record in sec_tblsetup was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error inserting record into sec_tblsetup " . mysqli_error($link) . "</font><br/><br/>");
			}		
		
	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblsetup exists</font><br/><br/>"); 	
	}
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblsaleshistory'");
	if($checktable->num_rows == 0) {	
	
		//Create table
		$query = " CREATE TABLE sec_tblsaleshistory ( "
				. " recid INT NOT NULL AUTO_INCREMENT, "
				. " item_id INT , "
				. " users_id INT , "	
				. " receiver_email VARCHAR( 100 ) , "
				. " item_name VARCHAR( 100 ) , "				
				. " item_number VARCHAR( 50 ) , "
				. " payment_status VARCHAR( 50 ) , "	
				. " mc_gross VARCHAR( 10 ) , "		
				. " payer_email VARCHAR( 100 ) , "				
				. " txn_type VARCHAR( 50 ) , "
				. " txn_id VARCHAR( 100 ) , "
				. " mc_currency VARCHAR(10) , "
				. " completed  DATETIME , "
				. " quantity INT default '1' NOT NULL , "		

				. " business VARCHAR(255), "
				. " receiver_id VARCHAR(255), "
				. " invoice VARCHAR(255), "
				. " custom TEXT, "
				. " memo TEXT, "
				. " tax VARCHAR(255), "
				. " option_name1 VARCHAR(255), "
				. " option_selection1 VARCHAR(255), "
				. " option_name2 VARCHAR(255), "
				. " option_selection2 VARCHAR(255), "
				. " num_cart_items VARCHAR(255), "
				. " mc_fee VARCHAR(255), "
				. " payment_date VARCHAR(255), "
				. " payment_type VARCHAR(255), "
				. " first_name VARCHAR(255), "
				. " last_name VARCHAR(255), "
				. " payer_business_name VARCHAR(255), "
				. " address_name VARCHAR(255), "
				. " address_street VARCHAR(255), "
				. " address_city VARCHAR(255), "
				. " address_state VARCHAR(255), "
				. " address_zip VARCHAR(255), "
				. " address_country VARCHAR(255), "
				. " address_status VARCHAR(255), "
				. " payer_id VARCHAR(255), "
				. " payer_status VARCHAR(255), "
				. " notify_version VARCHAR(255), "
				. " verify_sign VARCHAR(255), "		

				. " PRIMARY KEY ( recid ) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblsaleshistory was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblsaleshistory " .mysqli_error($link) . "</font><br/><br/>");
			}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblsaleshistory exists</font><br/><br/>"); 	
	}
	

	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblusers'");
	if($checktable->num_rows == 0) {	

			//Create table
			$query = " CREATE TABLE sec_tblusers ( "
					. " recid INT NOT NULL AUTO_INCREMENT, "
					. " payer_email VARCHAR(100) UNIQUE NOT NULL , "		//Purchaser payer_email address - the log in user name - must be unique
					. " password VARCHAR(50) , "						//User password (encrypted)
					. " iv INT , "										//Initialisation vector for encrypting / decrypting the user password

					//------------------------
					// additional fields for version 2.0
					. " signedup INT DEFAULT '0' NOT NULL, "			//1 = the person has signed up, 0 = the person has not finished the sign up process		
					. " name VARCHAR(100), "
					. " telephone VARCHAR(100), "
					. " mobile VARCHAR(100), "
					. " address_line1 VARCHAR(100), "
					. " address_line2 VARCHAR(100), "		
					. " city VARCHAR(100), "
					. " state VARCHAR(100), "
					. " country VARCHAR(100), "	
					. " zip_post_code VARCHAR(20), "

					. " field1 VARCHAR(100), "			//Extra user defined fields
					. " field2 VARCHAR(100), "
					. " field3 VARCHAR(100), "
					. " field4 VARCHAR(100), "
					. " field5 VARCHAR(100), "		
					//------------------------

					. " PRIMARY KEY (recid) ) "
					. " ";
		
			if ( mysqli_query( $link, $query ) )
				{
				echo("<font color=\"##009900\">The table sec_tblusers was successfully created</font><br/><br/>"); 
				}
			else
				{
				echo("<font color=\"#FF0000\">Error creating table sec_tblusers " . mysqli_error($link) . "</font><br/><br/>");
				}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblusers exists</font><br/><br/>"); 	
	}		
		
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblpasswords'");
	if($checktable->num_rows == 0) {	

		//Create table
		$query = "CREATE TABLE sec_tblpasswords ( "
				. " username VARCHAR(50) , "
				. " userpassword VARCHAR(50) , "
				. " type INT DEFAULT '1' NOT NULL , "
				. " link VARCHAR(255) , "
				. " linkdate DATETIME , "
				. " PRIMARY KEY (username) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblpasswords was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblpasswords " . mysqli_error($link) . "</font><br/><br/>");
			}
		
		
		//Create default site admin user / password
		$query = "INSERT INTO sec_tblpasswords (username, userpassword, type) Values ( 'admin@somewhere.com',  md5('password'), 0 )";
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The site user / password of admin@somewhere.com / password was successfully created</font><br><br>");
			}
		else
			{
			echo("<font color=\"#FF0000\">Error inserting record into sec_tblpasswords " . mysqli_error($link) . "</font><br><br>");
			}		
		

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblpasswords exists</font><br/><br/>"); 	
	}		
	
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tbldatalayer'");
	if($checktable->num_rows == 0) {

		//Create table
		$query = "CREATE TABLE sec_tbldatalayer ( "
				. "  recid INT NOT NULL AUTO_INCREMENT, "
				. "  name VARCHAR(255), "
				. "  age INT, "
				. "  description BLOB, "
				. "  PRIMARY KEY (recid) ) "
				. " ";

		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tbldatalayer was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tbldatalayer " . mysqli_error($link) . "</font><br/><br/>");
			}
		
	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tbldatalayer exists</font><br/><br/>"); 	
	}			

	
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblsecureareas'");
	if($checktable->num_rows == 0) {

		//Create table
		$query = "CREATE TABLE sec_tblsecureareas ( "
				. "  recid INT NOT NULL AUTO_INCREMENT, "
				. "  securearea_name VARCHAR(50) ,"
				. "  PRIMARY KEY (recid) ) "
				. " ";	

		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblsecureareas was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblsecureareas " . mysqli_error($link) . "</font><br/><br/>");
			}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblsecureareas exists</font><br/><br/>"); 	
	}	
	
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblfolders'");
	if($checktable->num_rows == 0) {

		//Create table
		$query = "CREATE TABLE sec_tblfolders ( "
				. "  recid INT NOT NULL AUTO_INCREMENT, "
				. "  securearea_id INT ,"
				. "  folder_path VARCHAR(255) , "
				. "  PRIMARY KEY (recid) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblfolders was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblfolders " . mysqli_error($link) . "</font><br/><br/>");
			}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblfolders exists</font><br/><br/>"); 	
	}	
	

	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblpurchased_secureareas'");
	if($checktable->num_rows == 0) {	
	
		//Create table
		$query = "CREATE TABLE sec_tblpurchased_secureareas ( "
				. "  recid INT NOT NULL AUTO_INCREMENT , "
				. "  item_number VARCHAR(50) , "	
				. "  securearea_id INT , "
				. "  in_htpasswd INT , "
				. "  manual INT DEFAULT '0' NOT NULL, "				//1 means is a manual created user
				. "  users_id INT , "
				. "  sub_eot INT DEFAULT '0' NOT NULL , "			//1 means end of term has been reached
				. "  sub_cancelled INT DEFAULT '0' NOT NULL, "		//Not used
				. "  sub_created DATETIME , "

				. "  sub_due_date DATETIME , "		
				. "  sub_expire_date DATETIME , "					//Added in V2.0

				. "  PRIMARY KEY (recid) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblpurchased_secureareas was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblpurchased_secureareas " . mysqli_error($link) . "</font><br/><br/>");
			}

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblpurchased_secureareas exists</font><br/><br/>"); 	
	}	
		
	
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++	
	$checktable = mysqli_query($link, "SHOW tables LIKE 'sec_tblsmtp'");
	if($checktable->num_rows == 0) {	
	
		//Create table
		$query = "CREATE TABLE sec_tblsmtp ( "
				. "  recid INT NOT NULL , "
				. "  usesmtp INT DEFAULT '0' NOT NULL , "	
				. "  smtphost VARCHAR(50) , "	
				. "  smtpauthentication VARCHAR(20) , "
				. "  smtpusername VARCHAR(40) , "
				. "  smtppassword VARCHAR(40) , "		
				. "  typeofencryption VARCHAR(20) , "
				. "  smtpport VARCHAR(10) , "			
				. "  fromemail VARCHAR(100) , "		
				. "  fromname VARCHAR(100) , "
				. "  debug INT DEFAULT '0' NOT NULL , "
				. "  PRIMARY KEY (recid) ) "
				. " ";
		
		if ( mysqli_query( $link, $query ) )
			{
			echo("<font color=\"##009900\">The table sec_tblsmtp was successfully created</font><br/><br/>"); 
			}
		else
			{
			echo("<font color=\"#FF0000\">Error creating table sec_tblsmtp " . mysqli_error($link) . "</font><br/><br/>");
			}
		
		
			//Create record id 1 in sec_tblsmtp 
			$query = "INSERT INTO sec_tblsmtp (recid) Values ( 1 )";

			if ( mysqli_query( $link, $query ) )
				{
				echo("<font color=\"##009900\">The default record in sec_tblsmtp was successfully created</font><br/><br/>"); 
				}
			else
				{
				echo("<font color=\"#FF0000\">Error inserting record into sec_tblsmtp " . mysqli_error($link) . "</font><br/><br/>");
				}	
		

	}
	else
	{
		echo("<font color=\"##009900\">The table sec_tblsmtp exists</font><br/><br/>"); 	
	}	

	//sec_tblitems
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD item_number VARCHAR(50) UNIQUE ");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD item_name VARCHAR(100) ");		
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD item_description TEXT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD mc_currency VARCHAR(10) ");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD currency VARCHAR(20) ");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD emailsubject TEXT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD emailtext TEXT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD item_image VARCHAR(150)");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD securearea_id INT default '0' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD a1 VARCHAR(10)");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD p1 INT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD t1 VARCHAR(1)");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD a2 VARCHAR(10)");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD p2 INT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD t2 VARCHAR(1)");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD a3 VARCHAR(10) ");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD p3 INT default '1' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD t3 VARCHAR(1) default 'D' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD src INT default '1' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD sra INT default '1' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD srt INT");
	mysqli_query($link, "ALTER TABLE sec_tblitems ADD publish INT default '1' NOT NULL");
	
	
	//sec_tblsetup	
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD paypaladdress VARCHAR(100)");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD emailsubject TEXT");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD emailtext TEXT");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD adminaddress VARCHAR(100)");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD copyemail INT DEFAULT '1' NOT NULL");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD mc_currency VARCHAR(10) DEFAULT 'USD' ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD currency VARCHAR(20) DEFAULT 'USD $' ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD button VARCHAR(200) DEFAULT '../images/btn/x-click-but24.gif' ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD manual_entered INT DEFAULT '0' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD password_location VARCHAR (255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD sandbox_seller VARCHAR (100) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD referring_server VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD sitetitle VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD cancel_url VARCHAR(200) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD return_url VARCHAR(200) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD notify_url VARCHAR(200) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD notify_sandbox_url VARCHAR(200) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD install_folder VARCHAR(150) ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD protection_type INT DEFAULT '1' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblsetup ADD version_no VARCHAR(10) ");			
	
	
	//sec_tblsaleshistory
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD item_id INT ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD  users_id INT ");	
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD  receiver_email VARCHAR( 100 ) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD item_name VARCHAR( 100 ) ");				
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD item_number VARCHAR( 50 ) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payment_status VARCHAR( 50 ) ");	
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD mc_gross VARCHAR( 10 ) ");		
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payer_email VARCHAR( 100 ) ");				
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD txn_type VARCHAR( 50 ) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD txn_id VARCHAR( 100 ) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD mc_currency VARCHAR(10) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD completed  DATETIME ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD quantity INT default '1' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD business VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD receiver_id VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD invoice VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD custom TEXT ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD memo TEXT ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD tax VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD option_name1 VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD option_selection1 VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD option_name2 VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD option_selection2 VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD num_cart_items VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD mc_fee VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payment_date VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payment_type VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD first_name VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD last_name VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payer_business_name VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_name VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_street VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_city VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_state VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_zip VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_country VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD address_status VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payer_id VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD payer_status VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD notify_version VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblsaleshistory ADD verify_sign VARCHAR(255) ");		
	
	
	//sec_tblusers
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD payer_email VARCHAR(100) UNIQUE ");	
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD password VARCHAR(50) ");			
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD iv INT ");			
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD signedup INT DEFAULT '0' NOT NULL ");		
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD name VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD telephone VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD mobile VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD address_line1 VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD address_line2 VARCHAR(100) ");		
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD city VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD state VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD country VARCHAR(100) ");	
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD zip_post_code VARCHAR(20) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD field1 VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD field2 VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD field3 VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD field4 VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblusers ADD field5 VARCHAR(100) ");	
	
	
	//sec_tblpasswords		
	mysqli_query($link, "ALTER TABLE sec_tblpasswords ADD username VARCHAR(50) ");
	mysqli_query($link, "ALTER TABLE sec_tblpasswords ADD userpassword VARCHAR(50) ");
	mysqli_query($link, "ALTER TABLE sec_tblpasswords ADD type INT DEFAULT '1' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblpasswords ADD link VARCHAR(255) ");
	mysqli_query($link, "ALTER TABLE sec_tblpasswords ADD linkdate DATETIME ");

	
	//sec_tbldatalayer
	mysqli_query($link, "ALTER TABLE sec_tbldatalayer ADD name VARCHAR(255) ");
 	mysqli_query($link, "ALTER TABLE sec_tbldatalayer ADD age INT ");
	mysqli_query($link, "ALTER TABLE sec_tbldatalayer ADD description BLOB ");

	
	//sec_tblsecureareas
	mysqli_query($link, "ALTER TABLE sec_tblsecureareas ADD securearea_name VARCHAR(50) ");


	//sec_tblfolders
	mysqli_query($link, "ALTER TABLE sec_tblfolders ADD securearea_id INT " );
	mysqli_query($link, "ALTER TABLE sec_tblfolders ADD folder_path VARCHAR(255) " );
	
	
	//sec_tblpurchased_secureareas
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD item_number VARCHAR(50) ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD securearea_id INT ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD in_htpasswd INT ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD manual INT DEFAULT '0' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD users_id INT ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD sub_eot INT DEFAULT '0' NOT NULL ");	
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD sub_cancelled INT DEFAULT '0' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD sub_created DATETIME ");
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD sub_due_date DATETIME ");		
	mysqli_query($link, "ALTER TABLE sec_tblpurchased_secureareas ADD sub_expire_date DATETIME ");


	//sec_tblsmtp
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD usesmtp INT DEFAULT '0' NOT NULL ");
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD smtphost VARCHAR(50) ");	
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD smtpauthentication VARCHAR(20) ");
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD smtpusername VARCHAR(40) ");
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD smtppassword VARCHAR(40) ");	
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD typeofencryption VARCHAR(20) ");
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD smtpport VARCHAR(10) ");			
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD fromemail VARCHAR(100) ");		
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD fromname VARCHAR(100) ");
	mysqli_query($link, "ALTER TABLE sec_tblsmtp ADD debug INT DEFAULT '0' NOT NULL ");
			
	
	?>
		<p>If all results are green, the tables have all been created.<br/><br/>After modifying the config.php file you may log 
		into the admin displays<br/>using the default username / password of:
			<br/><br/>
			<font size="+1">
			username:   <strong>admin@somewhere.com</strong><br/>
			password:   <strong>password</strong>
			</font>
			</p>
	<?php

	mysqli_close($link);

	displayfooter();

}
//---------------------------------------------
//Display the header 
function displayheader() {
?>
<!DOCTYPE html>
<html lang="en">
  <head>
	<style>
		body {
			margin: 0;
			padding: 0;
			font-size: 100%;
			font-family: arial;
			color: #000;
			background-color : #e5e5e5;
			/*background-color : #f1f1f1;*/
	}
	</style>
</head>
<body>
<br/>
<table border="0" align="center">
<tr>
	<td align="center"><h3>PHP-SecureArea Set Up</h3></td>
</tr>
<tr>
	<td>

<?php
}
//---------------------------------------------
//Display the footer 
function displayfooter() {
?>
	</td>
</tr>
</table>
</body>
</html>
<?php
}
?>