<?php
session_start();
//----------------------------------------------------
//Process the transaction
//
//This takes the record id from the paypal button and creates
//a set of variables to be posted for this record
//
//This is used for the sign up form
//
//It uses Javascript on load to post, so includes  
//noscript incase the Javascript is not enabled.

//----------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//--------------------------------------------
require_once("../error.php");
require_once('includes/ipnfunctions.php');
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once('../functions/misc.php');
//--------------------------------------------
	

//--------------------------------------------
//This is a single item selection

//--------------------------------------------
$recid 		= input::get('recid');
$custom 	= input::get('custom');
	
//if $recid is empty or not an integer then exit
if (!is_numeric($recid)) { exit(); }

$custom = filter_var($custom, FILTER_SANITIZE_STRING);

?>
<html>
<head>
<title>IPN Process</title>
<style type="text/css">
.body, td, p {
	font-size: 110%;
	font-family: Verdana, Arial, Helvetica, sans-serif; 
}
.tableblue {
background-color: #0066ff;
}
</style>
</head>
<body onLoad="document.paypal_form.submit();"> 
<!--  <body>  -->
	
	<form method="post" name="paypal_form" action="https://www.paypal.com/cgi-bin/webscr">
		<?php
		showpaypal($recid); //show paypal hidden variables for this record id
		?> 
        
        <!-- Custom variable which posts back unchanged from PayPal through IPN -->
        <input type="hidden" name="custom" value="<?php echo( $custom ) ?>" />
			<table border="0" width="100%">
			<tr height="100">
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td align="center" valign="center" height="120">

				<div id="dialog" title="Please Wait">
					<p>&nbsp;</p>
					<h2 style="text-align:center;">Please wait ...</h2>
					<h2 style="text-align:center;">Connecting to PayPal</h2>
					<p style="text-align:center;"><img src="../images/pleasewait.gif" style="text-align:center" /></p>
				</div> 

				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
			</tr>	
		</table>		
	</form>

	<br><br>
	<noscript>
		<table border="0" align="center">
		<tr>
			<td>
				<h2>This page requires Javascript</h2>
			</td>
		</tr>
		</table>
	</noscript>	
	
</body>   
</html>