<?php

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//Server side validation for sign up user
//Returns an array of values for each entry entered in the sign up user form
//Any errors are placed into $message
//This is a set of data that is passed in followed by a set of flags to identify if validation is required or not.
function server_side_validate($email, $name, $phone, $mobile, $addressline1, $addressline2, $city, 
							  $state, $country, $zip, $val_email, $val_name, $val_phone, $val_mobile, 
							  $val_addressline1, $val_addressline2, $val_city, $val_state, $val_country, 
							  $val_zip, &$message, $usercaptcha) {

	//echo($_POST['captcha']);
	//exit;

	$message = "";

	require_once("php-captcha.inc.php");


	//-----------------------------------------------
	//if (PhpCaptcha::Validate($_POST['captcha'])) { 
	//	echo("valid");
	//		echo($_POST['captcha']);
	//} else {
	//	echo("invalid");
	//		echo($_POST['captcha']);
	//}
	//exit;
	//-----------------------------------------------


	if ( $usercaptcha == true ) {
		
		if (PhpCaptcha::Validate($_POST['captcha'])) { 
			$validcaptcha = true;
		} else {
			$validcaptcha = false;
		}

	} else {
		
		$validcaptcha = true;		
		
	}



	if ( $validcaptcha == true ) { 
		//echo 'Valid code entered'; 

		$val = new Validate();
	
		if ( $val_email ) {
			$val->isEmpty($email, "Email should not be empty");	
			$val->isEmailAddress($email, "Error in email address");	
		}
	
		if ( $val_name ) {
			$val->isEmpty($name, "Name should not be empty");
			$val->isString($name, "Name is not a string or is too long", 100);	
		}
	
		if ( $val_phone ) {
			$val->isEmpty($phone, "Phone should not be empty");
			$val->isString($phone, "Phone is not a string or is too long", 100);	
		}

		if ( $val_mobile ) {
			$val->isEmpty($mobile, "Mobile should not be empty");
			$val->isString($mobile, "Mobile is not a string or is too long", 100);	
		}

		if ( $val_addressline1 ) {
			$val->isEmpty($addressline1, "Address line 1 should not be empty");
			$val->isString($addressline1, "Address line 1 is not a string or is too long", 100);	
		}

		if ( $val_addressline2 ) {
			$val->isEmpty($addressline2, "Address line 2 should not be empty");
			$val->isString($addressline2, "Address line 2 is not a string or is too long", 100);	
		}

		if ( $val_city ) {
			$val->isEmpty($city, "City should not be empty");
			$val->isString($city, "City is not a string or is too long", 100);	
		}

		if ( $val_state ) {
			$val->isEmpty($state, "State should not be empty");
			$val->isString($state, "State is not a string or is too long", 100);	
		}

		if ( $val_country ) {
			$val->isEmpty($country, "Country should not be empty");
			$val->isString($country, "Country is not a string or is too long", 100);	
		}

		//if ( $val_zip ) {
		//	$val->isEmpty($zip, "Zip should not be empty");
		//	$val->isString($country, "Zip is not a string or is too long", 20);	
		//}


		if ($val->isError()) {	
			$errors = $val->getErrorList();
			
			$message .= "<strong>Error : </strong>";
			$message .= "<ul>";
			foreach ($errors as $e) {
				$message .= "<li>" . $e['msg'];
			} 
			$message .= "</ul>";
		}


	} else {

		//echo 'Invalid code entered'; 

		$message = "Invalid code, try again";

	}
	

	$array_name['email'] 			= $email;
	$array_name['name'] 			= $name;
	$array_name['phone']			= $phone;
	$array_name['mobile']			= $mobile;
	$array_name['addressline1']		= $addressline1;
	$array_name['addressline2']		= $addressline2;
	$array_name['city']				= $city;
	$array_name['country']			= $country;
	$array_name['state']			= $state;			
	$array_name['zip']				= $zip;

	return $array_name;

}

?>