<?php
//-----------------------------------
//Create the buttons 
//-----------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//
//************************************

//  30/12/2024 V2.9.6
//	* HTML Code improvement 


require_once("a_checkaccess.php");
require_once ("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//----------------------------------------------

	$recid = input::get('recid');
	
	if ( !is_numeric($recid )) {exit();}

	//get action url
	//get item number
	//get graphic

	//Look up details from sec_tblsetup notify_url, button
	$items = gettblsetup();

	if (!$items) {
		echo("Error in table - tblsetup appears to be empty - SQL error - a_createbutton.php ref 2");
		exit();
	}

		$notify_url 		= $items[0]["notify_url"];
		$button				= $items[0]["button"]; 
		$install_folder 	= $items[0]["install_folder"];
		$manual_entered		= $items[0]["manual_entered"];

	//Get item_name
	$items = getproductdetails($recid);

	if (!$items) {
		echo("Error in table - tblsetup appears to be empty - SQL error - a_createbutton.php ref 4");
		exit();
	}					

		$item_name = $items[0]["item_name"];		
		$item_number = $items[0]["item_number"];

	if ($manual_entered == 1) {
		//$button = $button;
	} else {
		$button = $install_folder . substr($button, 3);
	}

require_once("code/header.php");
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
  <li><a href="a_items.php">List of Products</a></li>
</ol>
	
<div class="container">
	
		<div class="row">   
	    	<div class="col-md-12">
				<h2>Create the subscription button for the selected item</h2>
        	</div>   
   		</div>

		<div class="row"> 
			<div class="col-md-12">&nbsp;</div>
		</div>
		
		<div class="row"> 
		
			<div class="col-md-12">
			
				<div class="frmbkg"> 
			
					<p><strong>Use this button to go straight to PayPal without pre-registration</strong></p>				

					<p>This button takes the user straight to PayPal where they make a purchase and which 
					creates a PayPal subsription - as soon as the purchase is completed, the script will allow 
					access to the defined secured area.  The customer will receive an email with their 
					password.  Billing will re-occur for the defined number of installments or for ever if that
					is how the subscription was set up.</p>
					
					<?php 
					$process = $install_folder . "ipn/process.php";
					?>

					<p>Copy the following button text and place on your web page:</p>

					<blockquote class="blockquote">
						<p class="mb-0">
							&lt;form action="<?php echo($process); ?>" method="post"&gt;<br/>
							&lt;input type="hidden" name="recid" value="<?php echo($recid); ?>"&gt;<br/>
							&lt;input type="image" src="<?php echo($button); ?>"<br/>
							border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!"&gt;<br/>
							&lt;/form&gt;
						</p>				
					</blockquote>

					<form action="<?php echo($process); ?>" method="post" target="_blank">
						<input type="hidden" name="recid" value="<?php echo($recid); ?>">
						<input type="image" src="<?php echo($button); ?>" border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!" />
					</form>

					<br/>
					
					<p>or copy the href text link and place on your web page:</p>

					<blockquote class="blockquote">
						<p class="mb-0">				
							&lt;a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>"&gt;Subscribe to : <?php echo($item_name); ?>&lt;/a&gt;
						</p>				
					</blockquote>	
				
					<p><a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>" target="_blank">Subscribe to : <?php echo($item_name); ?></a></p>

				</div>
		
			</div>

		</div>

		<div class="row"> 
			<div class="col-md-12">&nbsp;</div>
		</div>

		<div class="row"> 
		
			<div class="col-md-12">

				<div class="frmbkg"> 			
			
					<p><strong>Use this button to go to PayPal with registration</strong></p>

					<p>This button goes to a pre-registration page where the user can enter personal 
					details which can be programmed to request different pieces of information depending 
					on the requirements.  When the form has been completed, it goes to PayPal where the 
					customer makes their purchase in the same way as the button shown above.</p>
					
					<?php $process = $install_folder . "signup/index.php" ?>

					<p>Copy the following button text and place on your web page:</p>
					
					<blockquote class="blockquote">
						<p class="mb-0">
							&lt;form action="<?php echo($process); ?>" method="post"&gt;<br/>
							&lt;input type="hidden" name="recid" value="<?php echo($recid); ?>"&gt;<br/>
							&lt;input type="image" src="<?php echo($button); ?>"<br/>
							border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!"&gt;<br/>
							&lt;/form&gt;
						</p>
					</blockquote>
				
					<form action="<?php echo($process); ?>" method="post" target="_blank">
						<input type="hidden" name="recid" value="<?php echo($recid); ?>">
						<input type="image" src="<?php echo($button); ?>" border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!" />
					</form>

					<br/>
				
					<p>or copy the href text link and place on your web page:</p>
				
					<blockquote class="blockquote">
						<p class="mb-0">				
							&lt;a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>"&gt;Subscribe to : <?php echo($item_name); ?>&lt;/a&gt;
						</p>
					</blockquote>				
				
					<p><a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>" target="_blank">Subscribe to : <?php echo($item_name); ?></a></p>

				</div>
		
			</div>
		
		</div>
        
		<div class="row"> 
			<div class="col-md-12">&nbsp;</div>
		</div>
  		            
   		<div class="row"> 
		
			<div class="col-md-12">          
				
				<div class="frmbkg"> 					              

					<p><strong>Use this button for a single item purchase button (no PayPal subscription).</strong></p>

					<p>This purchase uses a buy now button rather than a subscription button.  It means that 
					customers do not have to have a PayPal account but can purchase with a credit card.  However, it does 
					mean that you will need to set up a CRON job to ensure that access is removed after the subscription 
					time period.</p>
					
					<?php $process = $install_folder . "ipn/process.php" ?>
					
					<p>Copy the following button text:</p>	
					
					<blockquote class="blockquote">
						<p class="mb-0">
							&lt;form action="<?php echo($process); ?>" method="post"&gt;<br/>
							&lt;input type="hidden" name="cmd" value="_cart"&gt;<br/>
							&lt;input type="hidden" name="recid" value="<?php echo($recid); ?>"&gt;<br/>
							&lt;input type="image" src="<?php echo($button); ?>"<br/>
							border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!"&gt;<br/>
							&lt;/form&gt;
						</p>
					</blockquote>
				
					<form action="<?php echo($process); ?>" method="post" target="_blank">
						<input type="hidden" name="cmd" value="_cart">
						<input type="hidden" name="recid" value="<?php echo($recid); ?>">
						<input type="image" src="<?php echo($button); ?>" border="0" name="submit" alt="Make payments with PayPal - it's fast, free and secure!" />
					</form>

					<br/>
				
					<p>or copy the href text link:</p>
					
					<blockquote class="blockquote">
						<p class="mb-0">
							&lt;a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>&amp;cmd=_cart"&gt;Subscribe to : <?php echo($item_name); ?>&lt;/a&gt;
						</p>					
					</blockquote>			
				
					<p><a href="<?php echo($process); ?>?recid=<?php echo($recid); ?>&cmd=_cart" target="_blank">Subscribe to : <?php echo($item_name); ?></a></p>
			
				</div>
			</div>
		</div>
       
  	</div>                
        
        
<?php
require_once "code/footer_bootstrapjs.php";	
?>
</body>
</html>        
<?php
?>