<?php
@set_time_limit(300);
//-------------------------------------
//Import a previously created csv file
//-------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//
//************************************

//  30/12/2024 V2.9.6
//	* Unused variables removed

//Get the secure area recid
//Read each line and loop around the array
//Check that the payer email address does not already exist in tblUsers 'payer_email.
	//If the email address does not exist, 
		//update tblUsers 'payer_email'
		//if you are to create passwords, then create a new password and update tblUsers 'password'
		//if you are not creating passwords, take the password from the csv file and update tblUsers 'password'
	//Get the record id of the newly created record which will be the users_id
	//Add the user to the htpasswd files
	//Add the details to sec_tblpurchased_secureareas


require_once("a_checkaccess.php");
require_once("../functions/misc.php");
require_once("../functions/user.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../error.php");
require_once("../classes/clspassword.php");
require_once("../classes/clshtpasswd.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//------------------------------------------------------------
/**
*	Purpose : Check if the email address is in tblUsers
*	Returns true if in tblUsers or false if not
*	@return boolean
*/	
function checkemail($payer_email) {	
	
	$table = userintbluser($payer_email);	

	if (count($table) == 0) {
		$bolFound = false;
	} else {
		$bolFound = true;
	}
	
	return $bolFound;
}


//------------------------------------------------------------

require_once("code/header.php");	
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  	<li><a href="index1.php">Home</a></li>
</ol> 
	
<div class="container">
	
	<div class="row">   
	    <div class="col-md-12">
			<h2>Import a file in CSV format</h2>
        </div>   
   	</div>	
	
	<div class="row">   
	    <div class="col-md-12">
	
<?php
//------------------------------------------------------------

$securearea_id 			= $_POST["txtSecureArea_Id"];
$item_id				= $_POST["txtItem_Id"];
$import_passwords 		= $_POST["txtImport_Passwords"];
$send_passwords			= $_POST["txtSend_Passwords"];

$itemdetails	= gettblitems($item_id);

	$item_number 	= $itemdetails["item_number"];
	$item_name 		= $itemdetails["item_name"];
	$mc_currency 	= $itemdetails["mc_currency"];

//echo($securearea_id . "<br/>");
//echo($import_passwords . "<br/>");
//exit();

// read the data file into an array
$fcontents = file($_FILES["userfile"]["tmp_name"]);			//file function reads the entire file into an array
															//$_FILES is a global for upload functions

for($i=0; $i<sizeof($fcontents); $i++) { 	//for each line

	$line = trim($fcontents[$i]); 
    $data = explode(",", $line); 
    #if your data is tab separated
    #instead of , separated, 
    #change the ',' above to '\t'

	echo("Record : " . $i . "<br/>");

	$num = count($data);
	for ($c=0; $c<$num;$c++) {

		$bolnotfull = false;
		if ( count($data) != 12) {
			echo("Record " . $i . " does not have all fields and has not been added to the system<br/>");
			$bolnotfull = true;
		}

		$payer_email 			= trim($data[0]);
		$password 				= trim($data[1]);
		$expiredate 			= trim($data[2]);
		$name 					= trim($data[3]);
		$telephone 				= trim($data[4]); 
		$mobile 				= trim($data[5]); 
		$address_line1 			= trim($data[6]); 
		$address_line2 			= trim($data[7]); 
		$city 					= trim($data[8]); 
		$state 					= trim($data[9]); 
		$country 				= trim($data[10]); 
		$zip_post_code 			= trim($data[11]);	

	}

		$bolcheckmail = checkemail($payer_email);

		if ($bolcheckmail == true) {
			echo("Email address : " . $payer_email . " already found in tblusers");
		}

		//Check if $payer_email is already in tblUsers
		if ( $bolnotfull == false && $bolcheckmail == false ) {	//All fields are full and email address not found

				if ( $password == "" ) { //Create password
			
					$password_plain = createpw();

					echo("User : " . stripslashes($payer_email) . "<br/>");
					echo("Password : " . $password_plain . "<br/>");
	
					srand(make_seed());
					$iv = rand(1, 500);

					$encryption = new password($iv, $password_plain);
					$encryption->encode();
					$password_encrypt = $encryption->getencodedtext();
				
					$active = 1;	//set to activate the password
			
				} else {
			
					$password_plain = $password;

					echo("User : " . stripslashes($payer_email) . "<br/>");
					echo("Password : " . $password_plain . "<br/>");
	
					srand(make_seed());
					$iv = rand(1, 500);

					$encryption = new password($iv, $password_plain);
					$encryption->encode();
					$password_encrypt = $encryption->getencodedtext();
				
					$active = 1;	//set to activate the password
			
				}
			
				//----------------------------------------------
				//Create the entry in tbluser and htpasswd file	
				//echo("payer_email : " . $payer_email . "<br/>");
				//echo("password_plain : " . $password_plain . "<br/>");
				//echo("password_encrypt : " . $password_encrypt . "<br/>");	
				//echo("iv : " . $iv . "<br/>");						
				//echo("item_number : " . $item_number . "<br/>");
				//echo("active : " . $active . "<br/>");
				//echo("securearea_id : " . $securearea_id . "<br/>");
				//echo("message : " . $message . "<br/>");
				//exit();																							

				$message = "";

				$users_id = createmanualuser($payer_email, $password_plain, $password_encrypt, $iv, $item_number, $active, $securearea_id, $message);

				if ($message != "") {
					echo($message . "<br/>");
				}

				if ($send_passwords == "on") { //email the password	
					$testmode = "false";
					sendlogindetails($payer_email, $password_plain, $item_number, $testmode);					
				}

				//Insert into sec_tblsaleshistory
				$currentdate = date("Y-m-d H:i:s");
			
				//entries that are modified
				//$item_number = $item_number;
				//$item_name = $item_name; 
				//$payer_email = $payer_email;
				$completed = $currentdate;
				$payment_status = "Imported"; 
				$mc_gross = "0.00"; 
				//$mc_currency = $mc_currency; 
				$txn_id = $currentdate;			

				//entries that are not modified
				$custom = NULL;
				$business = NULL;
				$receiver_id = NULL;
				$invoice = NULL;
				$memo = NULL;
				$tax = NULL;
				$option_name1 = NULL;
				$option_selection1 = NULL;
				$option_name2 = NULL;
				$option_selection2 = NULL;
				$num_cart_items = NULL;
				$mc_fee = NULL;
				$payment_date = NULL;
				$payment_type = NULL;
				$first_name = NULL;
				$last_name = NULL;
				$payer_business_name = NULL;
				$address_name = NULL;
				$address_street = NULL;
				$address_city = NULL;
				$address_state = NULL;
				$address_zip = NULL;
				$address_country = NULL;
				$address_status = NULL;
				$payer_id = NULL;
				$payer_status = NULL;
				$notify_version = NULL;
				$verify_sign = NULL;
				$receiver_email = NULL;
			
				$rowsaffected = insertsaleshistory($custom, $business, $receiver_id, $invoice, $memo, $tax, $option_name1,
							$option_selection1, $option_name2, $option_selection2, $num_cart_items, $mc_fee, $payment_date, 
							$payment_type, $first_name, $last_name, $payer_business_name, $address_name, $address_street, 
							$address_city, $address_state, $address_zip, $address_country, $address_status, $payer_id, 
							$payer_status, $notify_version, $verify_sign, $txn_id, $item_number, $item_name, $payment_status, 
							$mc_gross, $mc_currency, $receiver_email, $payer_email, $completed);			
			
			
				//As we know the users_id in tblusers we can now add the other details to the table

				$name 					= trim($data[3]);
				$telephone 				= trim($data[4]); 
				$mobile 				= trim($data[5]); 
				$address_line1 			= trim($data[6]); 
				$address_line2 			= trim($data[7]); 
				$city 					= trim($data[8]); 
				$state 					= trim($data[9]); 
				$country 				= trim($data[10]); 
				$zip_post_code 			= trim($data[11]); 

				if ($rowsaffected == 1) {
				
					echo("Name : " . $name . "<br/>");
					echo("Telephone : " . $telephone . "<br/>");
					echo("Mobile : " . $mobile . "<br/>");
					echo("Address line 1 : " . $address_line1 . "<br/>");
					echo("Address line 2 : " . $address_line2 . "<br/>");					
					echo("City : " . $city . "<br/>");
					echo("State : " . $state . "<br/>");					
					echo("Country : " . $country . "<br/>");					
					echo("Zip Post Code : " . $zip_post_code . "<br/>");					
				
				}
			
				$rowssaffected = updatetblusers($name, $telephone, $mobile, $address_line1, $address_line2,
								$city, $zip_post_code, $country, $state, $users_id );
			
				if ($rowssaffected == 0) {
					echo("Name : " . $name . "<br/>");
					echo("Telephone : " . $telephone . "<br/>");
					echo("Mobile : " . $mobile . "<br/>");
					echo("Address line 1 : " . $address_line1 . "<br/>");
					echo("Address line 2 : " . $address_line2 . "<br/>");					
					echo("City : " . $city . "<br/>");
					echo("State : " . $state . "<br/>");					
					echo("Country : " . $country . "<br/>");					
					echo("Zip Post Code : " . $zip_post_code . "<br/>");					
				}			
		
				//------------------------------------
				//Update sec_tblpurchased_securearea as we know the users_id and the securearea_id and the item_number we can update a particular record 

				if ( $expiredate == '') {
					//Do nothing
				} else {		//add expire date	
					
					
					$rowsaffected = updatesubexpiredate($sub_expire_date, $item_number, $users_id, $securearea_id);
			
					if ($rowsaffected == 1) {
						echo("Expire date updated : " . $expiredate . "<br/>");						
					}	
					
				}

		}

}

?>			
			
	    </div>   
   	</div>
	
</div>                
        
<?php
require_once ("code/footer_datatable_transactions.php");
?>

</body>
</html>