<?php

//--------------------------------------
//Functions to display the basic page structure
//--------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_graphs.php");
//--------------------------------------


//--------------------------------------
function displaymainmenu() {	

require_once("code/navigation.php");
?>

<div class="container">

		<div class="row">
			<div class="col-md-2"></div>
			<div class="col-md-10">
		
		<?php
		clearstatcache();  
		if ( file_exists("..//install.php") ) {
			?>
            <h2>
			<font color="red">WARNING - delete install.php from server</font>
            </h2>
			<?php
			}
			
			?>
            	<h2>Version number :
            <?php
			
			echo(getversionnumber());
			
			?>
            	</h2>
            <?php
			
			if (!is_sales_history_empty()) 
				{
				?>&nbsp;<?php
				}
			else
				{
				?>
                <p>&nbsp;</p>
				<h2>Sales to date : </h2>
				<?php displaygraph();?>
				<?php
			}
			?>

			</div>
		</div>            

</div>

<?php
}
//--------------------------------------
//Checks if he sales history table is empty
//Returns number of rows
function is_sales_history_empty() {

	require_once("../error.php");
	require_once("../functions/misc.php");
	
	$table = saleshistorycheck();	
	
	if (count($table) > 0)
	{
		return true;
	}
	else
	{
		return false;
	}
	
}
//--------------------------------------
//Print input dialog elements
function displayinput($bodyid, $divid, $h2id, $fromday, $frommonth, $fromyear, $today, $tomonth, $toyear)
{
//echo("$fromday" . "-" . "$frommonth" . "-" . "$fromyear<br>");
//echo("$today" . "-"  . "$tomonth" . "-" . "$toyear");

$mon = array
	(
		 1 => "Jan",
		 2 => "Feb",
		 3 => "Mar",
		 4 => "Apr",
		 5 => "May",
		 6 => "Jun",
		 7 => "Jul",
		 8 => "Aug",
		 9 => "Sep",
		10 => "Oct",
		11 => "Nov",
		12 => "Dec",
	);

	
?>

	<div class="row">   
	     <div class="col-md-2" sidebar>
   	        <ul class="nav nav-sidebar navbar-dark">                
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_sales.php') { echo(' class="active"'); } ?>><a href="a_sales.php">Sales Details</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesdaily.php') { echo(' class="active"'); } ?>><a href="a_salesdaily.php">Daily Sales Total</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesproduct.php') { echo(' class="active"'); } ?>><a href="a_salesproduct.php">Sales By Product</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salescustomer.php') { echo(' class="active"'); } ?>><a href="a_salescustomer.php">Sales By Customer</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_saleshour.php') { echo(' class="active"'); } ?>><a href="a_saleshour.php">Totals by Hour</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesweekday.php') { echo(' class="active"'); } ?>><a href="a_salesweekday.php">Totals by Weekday</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesmonthday.php') { echo(' class="active"'); } ?>><a href="a_salesmonthday.php">Totals by Monthday</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesmonth.php') { echo(' class="active"'); } ?>><a href="a_salesmonth.php">Totals by Month</a></li>
                <li <?php if(basename($_SERVER['PHP_SELF']) == 'a_salesyear.php') { echo(' class="active"'); } ?>><a href="a_salesyear.php">Totals by Year</a></li>
          </ul>
        </div>
        <div class="col-md-10">

		<h2><?php echo($h2id); ?></h2>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
            <table border="0" align="center">
                <tr>
                    <td></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                    <td>From</td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                    <td>To</td>
                </tr>
                <tr>
                    <td>
                        <input type="submit" name="rangebutton" value="From / To" class="btn btn-primary btn-sm" />
                    </td>
                    <td></td>
                    <td>
                    <select name="frommonth">
                    <?php
                        for ($m = 1; $m<=12; $m++)
                        {
                    ?>
                            <option value="<?php echo($m); ?>" <?php if ($frommonth == $m) {echo"selected";} ?> ><?php echo($mon[$m]); ?></option>
                    <?php
                        }
                    ?>
                    </select>&nbsp;<select name="fromday">
                    <?php
                        for ($d = 1; $d<=31; $d++)
                        {
                    ?>
                            <option value="<?php echo($d); ?>" <?php if ($fromday == $d) {echo"selected";} ?> ><?php echo($d); ?></option>
                    <?php
                        }
                    ?>
                        </select>&nbsp;<select name="fromyear">
                    <?php
                        for ($y = 2008; $y<=date("Y"); $y++)
                        {
                    ?>
                            <option value="<?php echo($y); ?>" <?php if ($fromyear == $y) {echo"selected";} ?> ><?php echo($y); ?></option>
                    <?php
                        }
                    ?>
                        </select></td>
                                <td> </td>
                        <td><select name="tomonth">
                    <?php
                        for ($m = 1; $m<=12; $m++)
                        {
                    ?>
                            <option value="<?php echo($m); ?>" <?php if ($tomonth == $m) {echo"selected";} ?> ><?php echo($mon[$m]); ?></option>
                    <?php
                        }
                    ?>
                        </select>&nbsp;<select name="today">
                    <?php
                        for ($d = 1; $d<=31; $d++)
                        {
                    ?>
                            <option value="<?php echo($d); ?>" <?php if ($today == $d) {echo"selected";} ?> ><?php echo($d); ?></option>
                    <?php
                        }
                    ?>
                        </select>&nbsp;<select name="toyear">
                    <?php
                        for ($y = 2008; $y<=date("Y"); $y++)
                        {
                    ?>
                            <option value="<?php echo($y); ?>" <?php if ($toyear == $y) {echo"selected";} ?> ><?php echo($y); ?></option>
                    <?php
                        }
                    ?>
              </select>
              </td>
                </tr>
        
                <tr>
                    <td colspan="5">&nbsp;</td>
                </tr>        
                
                <tr>
                    <td colspan="5" align="left">
                        <input type="submit" name="rangebutton" value="Today" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 7 Days" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 14 Days" class="btn btn-primary btn-sm" />
                    </td>
                </tr>
                    
                <tr>
                    <td colspan="5">&nbsp;</td>
                </tr>           
                    
                <tr>
                    <td colspan="5" align="left">
                        <input type="submit" name="rangebutton" value="Month To Date" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Previous Month" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 1 Month" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 3 Months" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 6 Months" class="btn btn-primary btn-sm" >
                    </td>
                </tr>
        
                <tr>
                    <td colspan="5">&nbsp;</td>
                </tr>
                        
                <tr>
                    <td colspan="5" align="left">
                        <input type="submit" name="rangebutton" value="Year To Date" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Previous Year" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="Last 1 Year" class="btn btn-primary btn-sm" />
                        <input type="submit" name="rangebutton" value="All" class="btn btn-primary btn-sm" />
                    </td>
                </tr>
        
                <tr>
                    <td colspan="5">&nbsp;</td>
                </tr>
                        
            </table>
    
	</form>	

		</div>      
   </div>    

<?php
}
//--------------------------------------
function set_from_to(&$fromyear, &$frommonth, &$fromday, &$toyear, &$tomonth, &$today, $rangebutton)
{	
	
	$toyear = date('Y');
	$tomonth = date('m');
	$today = date('d');

	if ($rangebutton == 'From / To')
	{
		$fromday = $_POST ['fromday'];
		$frommonth = $_POST ['frommonth'];
		$fromyear = $_POST ['fromyear'];

		$today = $_POST ['today'];
		$tomonth = $_POST ['tomonth'];
		$toyear = $_POST ['toyear'];
	}

	elseif ($rangebutton == 'Today')
	{
			$fromyear = date('Y');
            $frommonth = date('m');
            $fromday = date('d');
    }
	elseif ($rangebutton == 'Last 7 Days')
	{
		$lastweek = mktime (0, 0, 0, date('m'), date('d')-7, date('Y'));
		$fromyear = date ('Y', $lastweek);
		$frommonth = date ('m', $lastweek);
		$fromday = date ('d', $lastweek);
	}
	elseif ($rangebutton == 'Last 14 Days')
	{
		$last2weeks = mktime (0, 0, 0, date('m'), date('d')-14, date('Y'));
		$fromyear = date ('Y', $last2weeks);
		$frommonth = date ('m', $last2weeks);
		$fromday = date ('d', $last2weeks);
	}

        elseif ($rangebutton == 'Month To Date')
        {
                $fromyear = date ('Y');
                $frommonth = date ('m');
                $fromday = 1;
        }
        elseif ($rangebutton == 'Previous Month')
        {
                $previousmonth = mktime (0, 0, 0, date('m')-1, date('d'), date('Y'));

                $fromyear = date ('Y', $previousmonth);
                $frommonth = date ('m', $previousmonth);
                $fromday = 1;

                $toyear = date ('Y', $previousmonth);
                $tomonth = date ('m', $previousmonth);
                $today = 31;
        }
        elseif ($rangebutton == 'Last 1 Month')
        {
                $last1month = mktime (0, 0, 0, date('m')-1, date('d'), date('Y'));

                $fromyear = date ('Y', $last1month);
                $frommonth = date ('m', $last1month);
                $fromday = date ('d', $last1month);
        }
        elseif ($rangebutton == 'Last 3 Months')
        {
                $last3months = mktime (0, 0, 0, date('m')-3, date('d'), date('Y'));

                $fromyear = date ('Y', $last3months);
                $frommonth = date ('m', $last3months);
                $fromday = date ('d', $last3months);
        }
        elseif ($rangebutton == 'Last 6 Months')
        {
                $last6months = mktime (0, 0, 0, date('m')-6, date('d'), date('Y'));

                $fromyear = date ('Y', $last6months);
                $frommonth = date ('m', $last6months);
                $fromday = date ('d', $last6months);
        }

        elseif ($rangebutton == 'Year To Date')
        {
                $fromyear = date ('Y');
                $frommonth = 1;
                $fromday = 1;
        }
	elseif ($rangebutton == 'Previous Year')
	{
		$fromyear = date ('Y')-1;
		$frommonth = 1;
		$fromday = 1;

		$toyear = date ('Y')-1;
		$tomonth = 12;
		$today = 31;
	}
        elseif ($rangebutton == 'Last 1 Year')
        {
                $last1month = mktime (0, 0, 0, date('m'), date('d'), date('Y')-1);

                $fromyear = date ('Y', $last1month);
                $frommonth = date ('m', $last1month);
                $fromday = date ('d', $last1month);
        }
	elseif ($rangebutton == 'All')
	{	
		$oldest = strtotime(getoldestdate ());	//oldest completed data	

		$fromyear = date ('Y', $oldest);
		$frommonth = date ('m', $oldest);
		$fromday = date ('d', $oldest);
	}
	else 
	{
	
	    $last1month = mktime (0, 0, 0, date('m')-1, date('d'), date('Y'));

    	$fromyear = date ('Y', $last1month);
        $frommonth = date ('m', $last1month);
        $fromday = date ('d', $last1month);		
	
	}
	
}

?>