<?php
session_start();

//---------------------------------------------------------------
//Email all purchasers given of a paticular product item
//---------------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

// Increase maximum execution time, but don't complain about it if it isn't allowed.
@set_time_limit(300);

require_once("a_checkaccess.php");	
require_once("../error.php"); 
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//--------------------------------------

//----------------------------------------------
main();


//----------------------------------------------
function main() {	

	$inputSubmit = input::get('Email');

	switch($inputSubmit) {
	
		case "Send":
		
			$txtSubject 	= input::get('txtSubject');
			$txtBody 		= input::get('txtBody');
			$txtProduct		= input::get('txtProduct');
			$txtFormat		= input::get('txtFormat');
			
			//echo($txtSubject);
			//echo($txtBody);
			//exit();
			
			$_SESSION['subject']	= stripslashes($txtSubject);
			$_SESSION['body']		= stripslashes($txtBody);
				
			sendmailconfirm($txtProduct, $txtFormat);
			break;
			
		case "Yes":
		
			$txtSubject 	= input::get('txtSubject');
			$txtBody 		= input::get('txtBody');
			$txtProduct		= input::get('txtProduct');
			$txtFormat		= input::get('txtFormat');
			$testmode		= "false";
			$recordcount = sendmail($_SESSION['subject'], $_SESSION['body'], $txtProduct, $txtFormat, $testmode);
			if ($recordcount > 0)
				displayoptions("$recordcount email sent (sent using Bcc)");
			else
				displayoptions("Email sent " . date("Y-m-d H:i:s"));
				
			break;
			
		case "No":
		
			displayoptions("");
			break;
			
		default:
			
			displayoptions("");
	
	}
	  
}
//----------------------------------------------
function displayoptions($_message) {

require_once("code/header.php");
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li> 
</ol>

<div class="container"> 
		
	<div class="row">
    	<div class="col-md-2" sidebar>        
			<ul class="nav nav-sidebar navbar-dark">
                <li><a href="a_emailall.php">Email All </a></li>
                <li class="active"><a href="a_emailsome.php">Email Some </a></li> 
                <li><a href="a_emailtest.php">Email Test </a></li> 
            </ul>
        </div>
		<div class="col-md-6">        

		<h2>Send email to purchasers of a product</h2>
        
		<div class="frmbkg">        
        
	<!-- START OF FORM -->        
	<form name="frmEmail" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
	
    	<div class = "form-group">
             <h5><label class="label label-danger"><?php if (isset($_message)) { echo($_message); } ?></label></h5>
        </div>

		<p>Use this form to email purchasers of a particular product.<br><br>
		Complete the subject and body text for the email.</p>
		
		<!--
		<div class="form-group">          
			<label for="txtFormat"><strong>Email Format :</strong></label>
            <select name="txtFormat" class="form-control form-control-sm">
                    <option name="text">text</option>
                    <option name="html">html</option>
            </select>
		</div>
		-->
		
		<input type="hidden" name="txtFormat" value="text" />
		
		<div class="form-group">          
            <select name="txtProduct" class="form-control form-control-sm" require>
                <option value="">--choose a product--</option>
                    <?php                    
	
					$db = new Db();

                    $query = " SELECT DISTINCT item_number FROM sec_tblsaleshistory ";
					
					$table = $db->query($query);

                    foreach( $table as $d_row ) {	
                        echo("<option value=\"" . $d_row["item_number"] . "\">" . $d_row["item_number"] . "</option>");	
                    }

                    ?>					
            </select>

		</div>			

		<div class="form-group"> 
			<label for="txtSubject"><strong>Email subject</strong></label>
			<input type="text" name="txtSubject" class="form-control form-control-sm" placeholder="Subject" required />
		</div>                

		<div class="form-group"> 
			<label for="txtBody"><strong>Email body text</strong></label>
			<textarea name="txtBody" rows="8" class="form-control form-control-sm" placeholder="Body" required></textarea>
		</div>
		
		<p>Note that if there are a large number of purchasers, here may be a delay before the script completes.</p>
        <p>Press the "Send" button <strong>once</strong> and wait until the script completes.</p>

		<div class="form-group">  
            <input type="submit" name="Email" value="Send" class="btn btn-primary btn-sm" />
		</div>

	</form>
	<!-- END OF MAIN FORM -->
    
    </div>
    
		</div>
		<div class="col-md-4"></div>
	</div>    
    
</div>

<?php require_once("code/footer_bootstrapjs.php");
}
//----------------------------------------------
//Confrirm that you wish to send email to all purchasers of a particular product
function sendmailconfirm($product, $format) {

//echo("body :" . $_SESSION['body']);
//echo($_SESSION['subject']);
//exit();

require_once("code/header.php");
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
  <li><a href="a_items.php">Product List</a></li>
</ol>

<div class="container"> 
	
	<h2>Email Purchasers of a particular Product</h2>

    <div class="row">
          <div class="col-md-2"></div>
          <div class="col-md-8">

            <form name="frmConfirm" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
            
	            <input type="hidden" name="txtProduct" value="<?php echo($product); ?>">
    	        <input type="hidden" name="txtFormat" value="<?php echo($format); ?>">
            
        	    <p>Confrim that you wish to send the email.</p>
            
				<div class="form-group">
					<input type="submit" name="Email" value="Yes" class="btn btn-primary btn-sm" />&nbsp;&nbsp;
                    <input type="submit" name="Email" value="No" class="btn btn-primary btn-sm" />
            	</div>
            
   				<div class="form-group">
	                <label for="txtProduct"><strong>Product</strong></label>
    	            <?php echo($product); ?>
                </div>

   				<div class="form-group">                
	                <label for="txtSubject"><strong>Subject</strong></label>
    	            <?php echo($_SESSION['subject']); ?>
                </div>
                
   				<div class="form-group">                        
	                <label for="txtBody"><strong>Body</strong></label>
    	            <?php echo($_SESSION['body']); ?>
				</div>                
                
            </form>

          </div>
          <div class="col-md-2"></div>
	</div>

</div>

<?php require_once("code/footer_bootstrapjs.php");
}
?>