<?php
//----------------------------------------------------------
//This receives the id of the item to be tested and extracts 
//the details from the tables.  The item can then be tested.
//----------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************


require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//---------------------------------------------------

main();

//----------------------------------------------------------
function main() {

	require_once("code/header_forjs.php");	
	
	?>
	<script language="JavaScript" type="text/javascript">
	
	//Checks if all fields have been entered before submitting
	function FormSubmit(frmInput) {
		if ( (frmInput.receiver_email.value == "") || (frmInput.item_name.value == "" ) || 
			(frmInput.item_number.value == "" ) || (frmInput.payment_status.value == "" ) || 
			(frmInput.mc_gross.value == "" ) || (frmInput.txn_id.value == "" ) || 
			(frmInput.payer_email.value == "" ) || (frmInput.txn_type.value == "" )  ) {
			alert("All fields must be entered");
		}
		else
		{	
			frmInput.submit();
		}
	}

	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Regular billing
	function Payment_onchange_a3(frmInput) {		
		if (!isNumber(frmInput.mc_gross.value)) {
			window.alert("Regular billing - Enter a number with 2 decimal places");
			frmInput.mc_gross.focus();
		}
		else
		{
			position = frmInput.mc_gross.value.lastIndexOf(".");
			if (frmInput.mc_gross.value.substring(position).length != 3) {
				window.alert("Regular billing - Enter 2 decimal places");
				frmInput.mc_gross.focus();	
			}
		}
	}	
	//--------------------------------------------
	//Checks the number is a positive numeric value with
	//one decimal point
	function isNumber(inputVal) {
		oneDecimal = false;
		inputStr = inputVal.toString();
		for (var i = 0; i < inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);
			if (oneChar == "."  && !oneDecimal) {
				oneDecimal = true;
				continue;
			}
			if (oneChar < "0" || oneChar > "9") {
				return false;
			}		
		}
		
		if (oneDecimal == false) {
			return false; }
			else {
			return true; }
					
	}		
		
	</script>	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />		
	<?php
	
	$recid	= input::get('recid');
	
	display( $recid );

}
//----------------------------------------------------------
//Lists the details of this item
function display($recid) {

	$table = getproductdetails($recid);	

	if (count($table) != 1) {	//tests if the table has any values		
		echo("Error with table - record not found - a_ipntest.php ref 1");	
		exit();		
	}
	
	$a3		=	$table[0]["a3"];
	$p3		=	$table[0]["p3"];	
	$t3		=	$table[0]["t3"];
	
	$src	=	$table[0]["src"];
	$sra	=	$table[0]["sra"];	
	$srt	=	$table[0]["srt"];

	//if ($srt == "0") {$srt = "";}
	
	//if ($p1 == "") {$p1 = 0;}
	//if ($p2 == "") {$p2 = 0;}
	if ($srt == "") {$srt = 0;}
	
	?>
	</html>
	<body>
		
	<?php
		require_once("code/navigation.php");
	?>
	
	<ol class="breadcrumb">
	  <li><a href="index1.php">Home</a></li>
	  <li><a href="a_items.php">Product List</a></li>
	</ol>
	
	<div class="container">

		<div class="row">
			<div class="col-md-2"></div>
			<div class="col-md-8">	

				<h2>Do a local IPN Test</h2>

				<p>This test checks out the system but by passes PayPal, hence is called a local test.</p>
				<p>You <strong>MUST</strong> enter a payer email address and choose a txn_type from 
				the drop down list.</p>
				
				<div class="frmbkg">


					<form name="frmInput" action="../ipn/confirm.php" method="post">
						<input type="hidden" value="true" name="testmode">
						<input type="hidden" name="id" value="<?php echo($table[0]["item_number"]); ?>">
	
						<p>The following entries are required for testing the script:</p>

						<?php $receiver_email = getreceiveremail(); ?>

						<div class = "form-group">		
							<label for="receiver_email"><strong>Receiver email</strong> This is the email address which paypal uses to send 
							confirmation emails, normally it is your email address</label>
							<input type="email" name="receiver_email" id="receiver_email" value="<?php echo($receiver_email); ?>" class="form-control" />
						</div>
		
						<div class = "form-group">
							<label for="item_name"><strong>Item name</strong> The name of the item which can actually be anything and is 
							not validated by the script</label>
							<input type="text" name="item_name" id="item_name" value="<?php echo($table[0]["item_name"]); ?>" class="form-control" />
						</div>
						
						<div class = "form-group">
							<label for="item_number"><strong>Item number</strong> The character reference number of the item which should 
							be the same as entered in the database</label>
							<input type="text" name="item_number" id="item_number" value="<?php echo($table[0]["item_number"]); ?>" class="form-control" />
						</div>
						
						<div class = "form-group">
							<label for="payment_status"><strong>Payment status</strong> Defines the status from Paypal - selecting completed 
							will simulate a completed transaction.</label>
							<select name="payment_status" id="payment_status" class="form-control">
								<option value=""></option>
								<option value="Completed" selected>Completed</option>
								<option value="Pending">Pending</option>
								<option value="Failed">Failed</option>
								<option value="Denied">Denied</option>
							</select>
						</div>
						
						<div class = "form-group">
							<label for="mc_gross"><strong>Regular billing  cost</strong> which must be the same as entered 
							into the database.</label>
							<input type="text" name="mc_gross" id="mc_gross" value="<?php echo($a3); ?>" class="form-control" 
											language="javascript" onChange="return Payment_onchange_a3(frmInput)" />		
						</div>
						
						<div class = "form-group">
							<label for="p3"><strong>Regular billing  period</strong> which must be the same as 
							entered into the database.</label>
							<input type="number" name="p3" id="p3" value="<?php echo($p3); ?>" class="form-control" />
						</div>
						
						<div class="form-group btn-group" data-toggle="buttons">
							<label for="t3"><strong>Regular billing unit</strong> which must be the same as entered into the database.</label><br/>
							<label class="btn">					
								<input type="radio" name="t3" value="D" <?php if ($t3 == "D") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>
								<span>Days (1 - 90)</span>
							</label>
							<label class="btn">	
								<input type="radio" name="t3" value="W" <?php if ($t3 == "W") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>
								<span>Wks (1 - 52)</span>
							</label>
							<label class="btn">	
								<input type="radio" name="t3" value="M" <?php if ($t3 == "M") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>
								<span>Mths (1 - 24)</span>
							</label>	
							<label class="btn">	
								<input type="radio" name="t3" value="Y" <?php if ($t3 == "Y") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>
								<span>Yrs (1 - 5)</span>
							</label>
						</div>
					
						<div class="form-group btn-group" data-toggle="buttons">
							<label for="src"><strong>Recurring payments</strong> which must be the same as entered into the database.</label><br/>				
							<label class="btn">	
								<input type="radio" name="src" value="1" <?php if ($src == "1") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>
								<span>Yes</span>
							</label>							
							<label class="btn">	
								<input type="radio" name="src" value="0" <?php if ($src == "0") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>	
								<span>No</span>
							</label>							
						</div>

						<div class="form-group btn-group" data-toggle="buttons">					
							<label for="sra"><strong>Reattempt on failure</strong> which must be the same as entered into the database.</label><br/>						
							<label class="btn">
								<input type="radio" name="sra" value="1" <?php if ($sra == "1") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>	
								<span>Yes</span>
							</label>							
							<label class="btn">
								<input type="radio" name="sra" value="0" <?php if ($sra == "0") { echo(" checked "); } ?> />
								<i class="fa fa-circle-o fa-2x"></i>
								<i class="fa fa-check-circle-o fa-2x"></i>	
								<span>No</span>
							</label>							
						</div>
						
						<div class = "form-group">
							<label for="srt"><strong>Recurring times (installments)</strong> which must be the same as entered into the database.</label>
							<input type="number" name="srt" id="srt" value="<?php echo($srt); ?>" class="form-control" />
						</div>

						<div class = "form-group">
							<label for="mc_currency"><strong>Currency Code</strong> The currency code which must be the same as entered into the database.</label>
							<input type="text" name="mc_currency" id="mc_currency" value="<?php echo($table[0]["mc_currency"]); ?>" class="form-control" />		
						</div>

						<div class = "form-group">
							<label for="txn_id"><strong>Transaction ID</strong> The PayPal transaction id. You can enter any random series of characters here, 
							I place the current time and date.</label>
							<input type="text" name="txn_id" id="txn_id" value="<?php echo (date( "d/m/y G:i:s" )); ?>" class="form-control" />
						</div>
	
						<div class = "form-group">
							<label for="payer_email"><strong>Payer email</strong> This is the email address of the purchaser. For this test, enter a personal 
							email address so that you can see the resulting emails.</label>
							<input type="email" name="payer_email" id="payer_email" class="form-control" />
						</div>

						<div class = "form-group">
							<input type="hidden" name="num_cart_items" value="1">
							<label for="txn_type"><strong>Txn type</strong> This should be one of the subscription types.</label>
							<select name="txn_type" id="txn_type" class="form-control">
								<option value=""></option>
								<option value="subscr_payment">Subscr payment</option>	
								<option value="subscr_cancel">Subscr cancel</option>
								<option value="subscr_failed">Subscr failed</option>			
								<option value="subscr_eot">Subscr eot</option>
								<option value="subscr_signup">Subscr signup</option>
								<option value="subscr_modify">Subscr modify</option>				
							</select>
						</div>		
	
						<div class = "form-group">
							<input type="button" name="Submit" value="Perform Test" language="javascript" onClick="return FormSubmit(frmInput)" class="btn btn-primary btn-sm" />
						</div>

					</form>

				</div>
				
 			</div>
        <div class="col-md-2"></div>		
	</div>
		
</div>	
		
<?php
require_once("code/footer_bootstrapjs.php");
}
?>