<?php
//---------------------------------------------------
//Displays a list of product items which can be tested
//---------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//---------------------------------------------------

main();

//---------------------------------------------------
//Purpose : Starts the page
function main() {

	display();	

}
//---------------------------------------------------
//Main display
//Purpose : Displays the list of items
function display() {
	
	require_once "code/header.php";	
	require_once "code/navigation.php";
	?>
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol>

<div class="container">

	<div class="row">   
   		<div class="col-md-12">
			<h2>Perform an IPN Test</h2>
    	</div>   
   	</div>

    <div class="row">   
    	<div class="col-md-12">** Click on the column title arrows to sort the column</div>   
   	</div>		
   	
    <div class="row">   
    	<div class="col-md-12">&nbsp;</div>   
   	</div>   			
	
	<div class="row">   
	    <div class="col-md-12">				

			<?php
				$table = itemlist();
			?>

			<?php

				if ( count($table) == 0 ) {	// More than zero entries in the database
					echo('There are no items to display');
				}
				else
				{
				?>
					<table cellspacing="0" width="100%" id="products" class="display">	
							<thead>
							<tr>
								<th>Product Item Number</th>
								<th>Product Item Name</th>
								<th>Regular billing</th>
								<th>&nbsp;</th>	
								<th>Select local test</th>								
							</tr>
							</thead>
							<tfoot>
							<tr>
								<th>Product Item Number</th>
								<th>Product Item Name</th>
								<th>Regular billing</th>
								<th>&nbsp;</th>	
								<th>Select local test</th>																
							</tr>
							</tfoot>
							<tbody>

							<?php			

								foreach( $table as $d_row ) {				

									?>
									<tr>
										<td><?php echo ($d_row["item_number"]); ?></td>					
										<td><?php echo ($d_row["item_name"]); ?></td>					
										<td><?php echo ($d_row["currency"]); ?><?php echo ($d_row["a3"]); ?></td>
										<td>
											<?php echo($d_row['p3']);?> 
											<?php							
												switch ($d_row['t3']) 
												{
												case 'D' :
													echo("days");
													break;				
												case 'W' :
													echo("weeks");
													break;
												case 'M' :
													echo("months");
													break;		
												case 'Y' :
													echo("years");
													break;																		
												}
											?>
										</td>					
										<td>
											<a href="a_ipntest.php?recid=<?php echo($d_row["recid"]) ?>" class="blockover">
												<?php echo($d_row["item_number"]) ?></a> 
										</td>

									</tr>
								<?php
							}
							?>
							</tbody>			
						</table>
				<?php
				}
				?>

		</div>
	</div>

</div>
  
<?php
require_once "code/footer_datatable.php";	
?>
</body>
</html>
  
<?php	
}
?>