<?php
//-----------------------------------------
//Create an new product item in tblitems
//-----------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************
 
// 30/12/2024 V2.9.6
// removed unused variable $item

require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
//----------------------------------------------

//----------------------------------------------
main();

//----------------------------------------------
//Purpose : Starts the page
function main() {

	$inputCreate = input::get('Create');	
	
	if ( $inputCreate == 'Create' ) {	//Create the new item

		$item_number 		= input::get('txtItem_Number');
		$item_name 			= input::get('txtItem_Name');
		$item_description	= input::get('txtItem_Description');
		$emailsubject		= input::get('txtEmailSubject');
		$emailtext			= input::get('txtEmailText');
		$item_image			= input::get('txtItem_Image');		
		$mc_currency		= input::get('txtMc_Currency');	
		$securearea_id		= input::get('txtSecureArea_Id');

		//---------------
		//Trail period 1
		$a1					= input::get('a1');
		if ($a1 != "") {
			$a1				= checkleadingzeros( input::get('a1') );	//Cost 
		}
		$p1					= input::get('p1');				//Unit period
		$t1					= input::get('t1');				//Unit of D, W, M or Y	

		//---------------
		//Trail period 2
		$a2					= input::get('a2');
		if ($a2 != "") {
			$a2				= checkleadingzeros( input::get('a2') );	//Cost
		}
		
		$p2					= input::get('p2');					//Unit period
		$t2					= input::get('t2');					//Unit of D, W, M or Y
		
		//---------------
		//Regular period 
		$a3					= checkleadingzeros( input::get('a3') );	//Cost		
		$p3					= input::get('p3');					//Unit period
		$t3					= input::get('t3');					//Unit of D, W, M or Y

		//---------------
		//Recurring data
		$src				= input::get('src');					//Recurring payments
		$sra				= input::get('sra');					//Reattempt on failure		
		$srt				= input::get('srt');					//Recurring times (installments)
	
		//----------------
		$publish			= 1;	//publish is always 1 in this system.		

		add($item_number, $item_name, $emailsubject, $emailtext, $item_description, $publish, $mc_currency, 
					$securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, $t3, $src, $sra, $srt, $item_image);
		
		header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/" . "a_items.php" );

	}
	else
	{
		displayitem("");
	}

}
//-----------------------------------
//Main display
//Purpose : Displays the items
function displayitem($msg) {

	require_once("code/header_forjs.php");	
	
	?>
	<script language="javascript">
	
	//--------------------------------------------		
	function button_onclick(frmCreate) {
	
		//var win_ie_ver = parseFloat(navigator.appVersion.split("MSIE")[1]);
		//if (navigator.userAgent.indexOf('Mac')        >= 0) { win_ie_ver = 0; }
		//if (navigator.userAgent.indexOf('Windows CE') >= 0) { win_ie_ver = 0; }
		//if (navigator.userAgent.indexOf('Opera')      >= 0) { win_ie_ver = 0; }

		var themessage = "Error in entries : ";
		var isOK = true;

		if ( frmCreate.txtItem_Number.value == "" ) {
			themessage = themessage + "\n" + "* Enter item number";
			isOK = false;
		}

		if ( frmCreate.txtItem_Name.value == "" ) {
			themessage = themessage + "\n" + "* Enter item name";
			isOK = false;
		}

		if ( frmCreate.txtEmailSubject.value == "" ) {
			themessage = themessage + "\n" + "* Enter email subject";
			isOK = false;			
		}

		if ( frmCreate.txtEmailText.value == "" ) {
			themessage = themessage + "\n" + "* Enter email text";
			isOK = false;		
		}

		if ( frmCreate.txtSecureArea_Id.value == "make a selection" ) {
			themessage = themessage + "\n" + "* Select a secure area in the drop down list";
			isOK = false;			
		}

		//--------------------------------
		//Trial 1
		if ( frmCreate.a1.value != "" ) {
		
			if ( !frmCreate.t1[0].checked && !frmCreate.t1[1].checked && !frmCreate.t1[2].checked && !frmCreate.t1[3].checked ) {
				themessage = themessage + "\n" + "* select a trail 1 cycle unit";
				isOK = false;		
			}
			
			if ( frmCreate.t1[0].checked ) {	//days 1 - 90
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 90 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* days value must be 1 - 90";
					isOK = false;
				}						
			}

			if ( frmCreate.t1[1].checked ) {  //weeks 1 - 52
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 52 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* weeks value must be 1 - 52";
					isOK = false;							
				}
			}

			if ( frmCreate.t1[2].checked ) {  //months 1 - 24
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 24 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* months value must be 1 - 24";
					isOK = false;						
				}
			}

			if ( frmCreate.t1[3].checked ) {  //years 1 - 5	
				if ( frmCreate.p1.value  < 1 || frmCreate.p1.value > 5 || frmCreate.p1.value == "" ) {
					themessage = themessage + "\n" + "* years value must be 1 - 5";
					isOK = false;						
				}						
			}
		
		}
		//end of trail 1
		//--------------------------------		

		//--------------------------------
		//Trial 2
		if ( frmCreate.a2.value != "" ) {
		
			if ( !frmCreate.t2[0].checked && !frmCreate.t2[1].checked && !frmCreate.t2[2].checked && !frmCreate.t2[3].checked ) {
				themessage = themessage + "\n" + "* select a trail 2 cycle unit";
				isOK = false;		
			}
			
			if ( frmCreate.t2[0].checked ) {	//days 1 - 90
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 90 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* days value must be 1 - 90";
					isOK = false;
				}						
			}

			if ( frmCreate.t2[1].checked ) {  //weeks 1 - 52
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 52 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* weeks value must be 1 - 52";
					isOK = false;							
				}
			}

			if ( frmCreate.t2[2].checked ) {  //months 1 - 24
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 24 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* months value must be 1 - 24";
					isOK = false;						
				}
			}

			if ( frmCreate.t2[3].checked ) {  //years 1 - 5	
				if ( frmCreate.p2.value  < 1 || frmCreate.p2.value > 5 || frmCreate.p2.value == "" ) {
					themessage = themessage + "\n" + "* years value must be 1 - 5";
					isOK = false;						
				}						
			}
		
		}
		//end of trail 2
		//--------------------------------

		//--------------------------------
		//Regular billing
		if ( frmCreate.a3.value == "" ) {
			themessage = themessage + "\n" + "* Enter regular billing cost";
			isOK = false;		
		}

		if ( !frmCreate.t3[0].checked && !frmCreate.t3[1].checked && !frmCreate.t3[2].checked && !frmCreate.t3[3].checked ) {
			themessage = themessage + "\n" + "* select a regular billing cycle unit";
			isOK = false;		
		}
		
		if ( frmCreate.t3[0].checked ) {	//days 1 - 90
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 90 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* days value must be 1 - 90";
				isOK = false;
			}						
		}

		if ( frmCreate.t3[1].checked ) {  //weeks 1 - 52
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 52 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* weeks value must be 1 - 52";
				isOK = false;							
			}
		}

		if ( frmCreate.t3[2].checked ) {  //months 1 - 24
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 24 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* months value must be 1 - 24";
				isOK = false;						
			}
		}

		if ( frmCreate.t3[3].checked ) {  //years 1 - 5	
			if ( frmCreate.p3.value  < 1 || frmCreate.p3.value > 5 || frmCreate.p3.value == "" ) {
				themessage = themessage + "\n" + "* years value must be 1 - 5";
				isOK = false;						
			}						
		}
		//end of regular billing
		//--------------------------------

		if ( isOK == false ) {
			window.alert(themessage);
		} else {
			frmCreate.submit(frmCreate);
		}

	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Trial 1
	function Payment_onchange_a1(frmCreate) {	
	
		if (frmCreate.a1.value != "") {
	
				if (!isNumber(frmCreate.a1.value)) {
					window.alert("Trial 1 billing cost - Enter a number with 2 decimal places");
					frmCreate.a1.focus();
				}
				else
				{
					position = frmCreate.a1.value.lastIndexOf(".");
					if (frmCreate.a1.value.substring(position).length != 3) {
						window.alert("Trial 1 billing cost - Enter 2 decimal places");
						frmCreate.a1.focus();	
					}
				}
	
		}
	
	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Trial 2
	function Payment_onchange_a2(frmCreate) {	
	
		if (frmCreate.a2.value != "") {
	
				if (!isNumber(frmCreate.a2.value)) {
					window.alert("Trial 2 billing cost - Enter a number with 2 decimal places");
					frmCreate.a2.focus();
				}
				else
				{
					position = frmCreate.a2.value.lastIndexOf(".");
					if (frmCreate.a2.value.substring(position).length != 3) {
						window.alert("Trial 2 billing cost - Enter 2 decimal places");
						frmCreate.a2.focus();	
					}
				}
		
		}
		
	}
	//--------------------------------------------	
	//Check if it is a positive numeric value
	//Check that there are two decimal places after the full stop
	//Regular billing
	function Payment_onchange_a3(frmCreate) {		
		if (!isNumber(frmCreate.a3.value)) {
			window.alert("Regular billing - Enter a number with 2 decimal places");
			frmCreate.a3.focus();
		}
		else
		{
			position = frmCreate.a3.value.lastIndexOf(".");
			if (frmCreate.a3.value.substring(position).length != 3) {
				window.alert("Regular billing - Enter 2 decimal places");
				frmCreate.a3.focus();	
			}
		}
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Trial 1
	function checkdurationvalue_onchange_p1(frmCreate) {
		
		if ( !isNumeric(frmCreate.p1.value) ) {
			window.alert("Trial 1 billing cycle - Value must be numeric with no decimal places");
			frmCreate.p1.focus();
		}
	
	}
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Trial 2
	function checkdurationvalue_onchange_p2(frmCreate) {
		
		if ( !isNumeric(frmCreate.p2.value) ) {
			window.alert("Trial 2 billing cycle - Value must be numeric with no decimal places");
			frmCreate.p2.focus();
		}
	
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Regular billing
	function checkdurationvalue_onchange_p3(frmCreate) {
		
		if ( !isNumeric(frmCreate.p3.value) ) {
			window.alert("Regualr billing cycle - Value must be numeric with no decimal places");
			frmCreate.p3.focus();
		}
	
	}	
	//--------------------------------------------	
	//Checks that the duration value numeric (no decimals) 
	//Recurring times
	function checkdurationvalue_onchange_srt(frmCreate) {
		
		if ( !isNumeric(frmCreate.srt.value) ) {
			window.alert("Value must be numeric with no decimal places");
			frmCreate.srt.focus();
		}
	
	}	
	//--------------------------------------------
	//Checks the number is a positive numeric value with
	//one decimal point
	function isNumber(inputVal) {
		oneDecimal = false;
		inputStr = inputVal.toString();
		for (var i = 0; i < inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);
			if (oneChar == "."  && !oneDecimal) {
				oneDecimal = true;
				continue;
			}
			if (oneChar < "0" || oneChar > "9") {
				return false;
			}		
		}
		
		if (oneDecimal == false) {
			return false; }
			else {
			return true; }
					
	}
	//--------------------------------------------
	//Checks if the entry is numeric
	function isNumeric(inputVal) {
		numeric = true;
		inputStr = inputVal.toString();
		for (var i = 0; i< inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);

			if (oneChar < "0" || oneChar > "9") {
				return false;
			}		

		}

		if (numeric == false) {
			return false; }
			else {
			return true; }

	}	
	//--------------------------------------------
	//checks that the characters are a - z and 0 - 9 only
	function isValidCharacters(frmCreate) {
		var inputStr = frmCreate.txtItem_Number.value.toString().toLowerCase();
		var validChars = "abcdefghijklmnopqrstuvwxyz0123456789 _-";
	
		for (var i = 0; i < inputStr.length; i++) {
			var oneChar = inputStr.charAt(i);			
			var charpos = validChars.indexOf(oneChar);
			if (charpos < 0) {
				frmCreate.txtItem_Number.value = ""
				//frmCreate.txtItem_Number.focus();
				alert("a-z 0-9 _ - and space characters only");
			}
		}	
	}
	
	</script>
	
	<link rel="stylesheet" text="text/css" href="css/checkbox.css" />
	
</html>
<body>

<?php
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  <li><a href="index1.php">Home</a></li>
  <li><a href="a_items.php">Product List</a></li>
</ol>

<div class="container">
	
	<div class="row">
 		<div class="col-md-2"></div>
		<div class="col-md-8">

			<h2>Create a new product</h2>

				<div class="frmbkg">

					<!-- START OF MAIN FORM -->
					<form name="frmCreate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">

						<div class = "form-group">        
							<h5><label class="label label-danger"><?php if (isset($msg)) { echo($msg); } ?></label></h5>
						</div>  						

						<div class = "form-group">
							<input type="hidden" name="Create" value="Create" />
							<input type="button" name="Create" value="Create" class="btn btn-primary btn-sm" language="javascript" onClick="return button_onclick(frmCreate)" />
						</div>

						<div class = "form-group">
							<label for="txtItem_Number"><strong>Product item number:</strong></label>
							<input type="text" name="txtItem_Number" id="txtItem_Number" class="form-control" placeholder="Product item number" language="javascript" onChange="return isValidCharacters(frmCreate)" />
						</div>

						<div class = "form-group">
							<label for="txtItem_Name"><strong>Product Item Name (Brief):</strong></label>
							<input type="text" name="txtItem_Name" id="txtItem_Name" class="form-control" placeholder="The brief name of the product" />
						</div>

						<div class = "form-group">
							<label for="txtMc_Currency"><strong>Currency:</strong></label>

							<?php
							//Display the default mc_currency from tblsetup			
							$mc_currency = getmc_currency();
							?>

							<select name="txtMc_Currency" id="txtMc_Currency" class="form-control" >
								<option value="AUD" <?php if ($mc_currency == "AUD") echo("selected"); ?>>Australian Dollar</option>				
								<option value="CAD" <?php if ($mc_currency == "CAD") echo("selected"); ?>>Canadian Dollar</option>
								<option value="CHF" <?php if ($mc_currency == "CHF") echo("selected"); ?>>Swiss Franc</option>
								<option value="CZK" <?php if ($mc_currency == "CZK") echo("selected"); ?>>Czech Koruna</option>
								<option value="DKK" <?php if ($mc_currency == "DKK") echo("selected"); ?>>Danish Krone</option>
								<option value="EUR" <?php if ($mc_currency == "EUR") echo("selected"); ?>>Euro</option>
								<option value="GBP" <?php if ($mc_currency == "GBP") echo("selected"); ?>>Pound Sterling</option>
								<option value="HKD" <?php if ($mc_currency == "HKD") echo("selected"); ?>>Hong Kong Dollar</option>					
								<option value="HUF" <?php if ($mc_currency == "HUF") echo("selected"); ?>>Hungarian Forint</option>	
								<option value="JPY" <?php if ($mc_currency == "JPY") echo("selected"); ?>>Japanese Yen</option>						
								<option value="NOK" <?php if ($mc_currency == "NOK") echo("selected"); ?>>Norwegian Krone</option>					
								<option value="NZD" <?php if ($mc_currency == "NZD") echo("selected"); ?>>New Zealand Dollar</option>					
								<option value="PLN" <?php if ($mc_currency == "PLN") echo("selected"); ?>>Polish Zloty</option>					
								<option value="SEK" <?php if ($mc_currency == "SEK") echo("selected"); ?>>Swedish Krona</option>					
								<option value="SGD" <?php if ($mc_currency == "SGD") echo("selected"); ?>>Singapore Dollar</option>						
								<option value="USD" <?php if ($mc_currency == "" || $mc_currency == "USD") echo("selected"); ?>>U.S. Dollar</option>
							</select>			

						</div>			

						<div class = "form-group">					
							<!-- Display available secure areas from tblsecureareas -->							
							<label for="txtSecureArea_Id"><strong>Secure Area</strong></label>
							<select name="txtSecureArea_Id" id="txtSecureArea_Id" class="form-control">
								<option value="make a selection">-- Make a selection --</option>
								<?php

								$table = securearealist();

								foreach( $table as $d_row ) {					
								?>
									<option value="<?php echo($d_row['recid']); ?>"><?php echo($d_row['securearea_name']); ?></option>
								<?php
								}

								?>
							</select>
						</div>

						<div class="row">
							<div class="col-md-3">
								<label><strong>Subscription details</strong></label>								
							</div>
							<div class="col-md-9">

								<div class="frmbkg">

									<div class = "form-group">
										<p class="orangetext">Trial 1</p>
									</div>

									<div class = "form-group">									
										<label for="a1"><strong>Trial 1 billing cost : </strong></label>										
										<input type="text" name="a1" id="a1" class="form-control" placeholder="Leave blank to ignore trial, or a value to 2 decimal places" language="javascript" onChange="return Payment_onchange_a1(frmCreate)" /> 0.00 = free, blank = ignore
									</div>

									<div class = "form-group">										
										<label for="p1"><strong>Trial 1 billing cycle : </strong></label>
										<input type="number" name="p1" id="p1" class="form-control" placeholder="An integer value" language="javascript" onChange="return checkdurationvalue_onchange_p1(frmCreate)" />
									</div>

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="t1"><strong>Trial 1 cycle units :</strong></label><br/>
											<label class="btn active">
											  <input type="radio" name="t1" value="D" checked />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t1" value="W" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t1" value="M" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t1" value="Y" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>																
										</div>

									</div>

									<div class = "form-group">
										<p class="orangetext">Trial 2</p>
									</div>

									<div class = "form-group">
										<label for="a2"><strong>Trial 2 billing cost : </strong></label>
										<input type="text" name="a2" id="a2" class="form-control" placeholder="Leave blank to ignore trial, or a value to 2 decimal places" language="javascript" onChange="return Payment_onchange_a2(frmCreate)" /> 0.00 = free, blank = ignore
									</div>

									<div class = "form-group">
										<label for="p2"><strong>Trial 2 billing cycle :</strong></label>
										<input type="number" name="p2" id="p2" class="form-control" placeholder="An integer value" language="javascript" onChange="return checkdurationvalue_onchange_p2(frmCreate)" />
									</div>

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="t2"><strong>Trial 2 cycle units :</strong></label><br/>
											<label class="btn active">
											  <input type="radio" name="t2" value="D" checked />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t2" value="W" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t2" value="M" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t2" value="Y" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>																
										</div>

									</div>

									<div class = "form-group">
										<p class="orangetext">Regular billing</p>
									</div>

									<div class = "form-group">
										<label for="a3"><strong>Regular billing cost : </strong></label>
										<input type="text" name="a3" id="a3" class="form-control" placeholder="A value to 2 decimal places" language="javascript" onChange="return Payment_onchange_a3(frmCreate)" />
									</div>

									<div class = "form-group">
										<label for="p3"><strong>Regular billing cycle : </strong></label>
										<input type="number" name="p3" id="p3" class="form-control" placeholder="An integer value" language="javascript" onChange="return checkdurationvalue_onchange_p3(frmCreate)" />
									</div>

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="t3"><strong>Regular billing cycle units :</strong></label><br/>
											<label class="btn active">
											  <input type="radio" name="t3" value="D" checked />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Days (1 - 90)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t3" value="W" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Weeks (1 - 52)</span>
											</label>
											<label class="btn">
											  <input type="radio" name="t3" value="M" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Months (1 - 24)</span>
											</label>	
											<label class="btn">
											  <input type="radio" name="t3" value="Y" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Years (1 - 5)</span>
											</label>																
										</div>

									</div>

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="src"><strong>Recurring payments :</strong></label><br/>
											<label class="btn active">
											  <input type="radio" name="src" value="1" checked />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Yes</span>
											</label>
											<label class="btn">
											  <input type="radio" name="src" value="0" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> No</span>
											</label>											
										</div>

									</div>

									<div class = "form-group">

										<div class="form-group btn-group" data-toggle="buttons">
											<label for="sra"><strong>Reattempt on failure : </strong></label><br/>
											<label class="btn active">
											  <input type="radio" name="sra" value="1" checked />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> Yes</span>
											</label>
											<label class="btn">
											  <input type="radio" name="sra" value="0" />
												<i class="fa fa-circle-o fa-2x"></i>
												<i class="fa fa-check-circle-o fa-2x"></i>
												<span> No</span>
											</label>											
										</div>

									</div>

									<div class = "form-group">
										<label for="srt"><strong>Recurring times (installments) : </strong></label>	
										<input type="number" name="srt" id="srt" class="form-control" placeholder="Installments (integer value)" language="javascript" onChange="return checkdurationvalue_onchange_srt(frmCreate)" />
									</div>		

								</div>

							</div>
						</div>					

						<div class = "form-group">
							<label for="txtEmailSubject"><strong>Email Subject</strong></label>
							<textarea name="txtEmailSubject" id="txtEmailSubject" class="form-control" rows="3"><?php echo(getemailsubject()); ?></textarea>
						</div>

						<div class = "form-group">		
							<label for="txtEmailText"><strong>Email Text</strong></label>
							<br/>Login url, username and password are substituted for <strong>&lt;login_url&gt;</strong>, <strong>&lt;payer_email&gt;</strong> 
							and <strong>&lt;password&gt;</strong> when the email is sent.
							<textarea name="txtEmailText" id="txtEmailText" rows="7" class="form-control"><?php echo(getemailtext()); ?></textarea>
						</div>

					</form>
					<!-- END OF MAIN FORM -->

				</div>

 			</div>
        <div class="col-md-2"></div>		
	</div>
		
</div>	
		
<?php
require_once("code/footer_bootstrapjs.php");
}
//-----------------------------------
//Purpose 	: Add a new record to tblitems
//Input 	: item_number, item_name, a3, emailsubject, emailtext, item_description, publish, mc_currency, securearea_id, days, $recurring, $reattempt
function add($item_number, $item_name, $emailsubject, $emailtext, $item_description, $publish, $mc_currency, 
			 $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, $p3, $t3, $src, $sra, $srt, $item_image) {

	if (checkitemnumbercreate($item_number) == 1) {
		displayitem("Item number already exists in table");
		exit();		
	}	
	
	if ($item_number == "" || $item_name == "" || $a3 == "") {
      	displayitem("Enter all require fields");
		exit();
	} else {
	
		if ($a1 == "0.00") {$a1 = "0";}
		if ($a1 == "") {	//if a1 is blank, then re-set t1
			$t1 = "";
		}
		if ($a2 == "") {	//if a2 is blank, then re-set t2
			$t2 = "";
		}
	
		//these are needed to give a value so that insert statement will work
		if ($p1 == "") {$p1 = 0;}	
		if ($p2 == "") {$p2 = 0;}	
		if ($srt == ""){$srt = 0;}
	
		$currency = getcurrency($mc_currency);
		/*
		echo("item_number : $item_number s<br>");
		echo("item_name : $item_name s<br>");	
		echo("emailsubject : $emailsubject s<br>");
		echo("emailtext : $emailtext s<br>");
		echo("item_description : $item_description s<br>");
		echo("publish : $publish n<br>");	
		echo("mc_currency : $mc_currency s<br>");
		echo("currency : $currency s<br>");
		echo("securearea_id : $securearea_id n<br>");	
		echo("a1 : $a1 s<br>");
		echo("p1 : $p1 n<br>");	
		echo("t1 : $t1 s<br>");
		echo("a2 : $a2 s<br>");
		echo("p2 : $p2 n<br>");	
		echo("t2 : $t2 s<br>");
		echo("a3 : $a3 s<br>");
		echo("p3 : $p3 n<br>");	
		echo("t3 : $t3 s<br>");
		echo("src : $src n<br>");
		echo("sra : $sra n<br>");
		echo("srt : $srt n<br>");
		echo("item_image : $item_image s<br>");	
		exit();	
		*/	
	
		insertitem($item_number, $item_name, $emailsubject, $emailtext, $item_description, $publish, 
					$mc_currency, $currency, $securearea_id, $a1, $p1, $t1, $a2, $p2, $t2, $a3, 
					$p3, $t3, $src, $sra, $srt, $item_image);		
		
	}

}
?>