<?php

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//*	Synchronise the usernames / passwords in the htpasswd files with the username / passwords in tbluser.
//*	This would be used when you are unsure of the accuracy of the username / passwords in the htpasswd files.
//
//*	Look up the list of secure area ids to identify the htpasswd files.
//*	Delete all users from the htpasswd files.
//*	Loop around each user in tbluser and add the username / password.

	include("../functions/misc.php");
	require_once("a_checkaccess.php");

	//Get list of secure area ids from table sec_tblsecureareas
	//SELECT recid FROM sec_tblsecureareas
 	$items = securearealist();


	$password_location = getpasswordlocation();

	//For each securearea_id
	foreach( $items as $d_row ) {
		
		$securearea_id = $d_row['recid'];

		//Delete all users from this securearea_id
		//This just means blank the htpasswd file

		//Write empty content to the file
		$password_file = $password_location . ".htpasswd_" . $securearea_id;

		$fd = fopen( $password_file, "w" );
		fwrite( $fd, "" );
		fclose( $fd );

		//identify which users need to be enabled, then enable those users

		//get a list of usernames that have to be enabled
		//SELECT ..

		foreach( $table as $d_row ) {

			$message = "";
			$result = enableuser($payer_email, $securearea_id, $message);

		}

	}
	//end of foreach	


?>