<?php

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//---------------------------------------------
//Manage users
//This displays the users and secure areas who are currently active
//Allows a user area to be to be manually disabled / enabled for that secure area 
//Allows a user to be created manually by entering them in the sec_tblpurchased_secureareas table

//----------------------------------------------
require_once("a_checkaccess.php");
require_once("../error.php");
require_once("../classes/clsinput.php");
require_once("../classes/clshtpasswd.php");
require_once("../classes/clspassword.php");
require_once("../dbclass/Db.class.php");
require_once("../functions/misc.php");
require_once("../functions/user.php");
//----------------------------------------------

main();

//---------------------------------------------------
function main() {

	//echo($_POST['Update']);
	//exit();
	
	$inputAction = input::get('action');
	$inputFilter = input::get('filter');	
	$inputDelete = input::get('delete');
	$inputUpdate = input::get('Update');


	$_SESSION['filter'] = $inputFilter;

	
	if ( $inputAction == "active" ) {

		//make this securearea active for this user
		$message = "";
		
		$payer_email 	= input::get('payer_email');	
		$securearea_id 	= input::get('securearea_id');		

		$result = enableuser($payer_email, $securearea_id, $message);

		if ($result == true) {
			display("User made active for this secure area " . date("Y-m-d H:i:s"));
		} else {
			display($message);
		}

	} elseif ( $inputAction == 'edit' ) {	//Edit the item
			edit( input::get('recid'), "" );

	} elseif ( $inputAction == "inactive" ) {

		//make this secure area inactive for this user
		$message = "";		
		$payer_email 	= input::get('payer_email');	
		$securearea_id 	= input::get('securearea_id');

		$result = disableuser( $payer_email, $securearea_id, $message );

		if ($result == true) {
			display("User made inactive for this secure area " . date("Y-m-d H:i:s"));
		} else {
			display($message);
		}

	} elseif ( $inputAction == "delete" ) {

		//delete this user after confirmation
		$payer_email = input::get('payer_email');
		confirmdeletion( $payer_email );

	} elseif ( $inputDelete == "Yes" ) {		//Now delete this user
	
		//delete the user
		$message = "";
		$payer_email = trim(input::get('payer_email'));
	
		//echo($payer_email);
		//exit();
		
		$result = deleteuser( $payer_email, $message );
		
		if ($result == true) {
			display("User deleted " . date("Y-m-d H:i:s"));
		} else {
			display($message);
		}

	} elseif ( $inputUpdate == 'Update') {
		
		$name 				= input::get('txtName');
		$telephone 			= input::get('txtTelephone');
		$mobile				= input::get('txtMobile');			
		$address_line1		= input::get('txtAddress_Line1');
		$address_line2		= input::get('txtAddress_Line2');
		$city				= input::get('txtCity');
		$zip_post_code		= input::get('txtZip_Post_Code');
		$state				= input::get('txtState');			
		$country			= input::get('txtCountry');
		$recid				= input::get('txtRecId');			

		update($name, $telephone, $mobile, $address_line1, $address_line2, 
			   		$city, $state, $zip_post_code, $country, $recid);

	} else {

		$inputMsg = input::get('msg');
		
		if ( $inputMsg == 1 ) { $msg = "Password sent " . date("Y-m-d H:i:s"); } else { $msg = ""; }

		display($msg);

	}

}
//---------------------------------------------------
//Display the current users in tblusers and checks if 
//the user has expired by displaying the in_htpasswd flag
//If the user is active then flag is 1
//If the user is disabled then flag is 0
function display($_message) {

	require_once "code/header.php";	
	require_once "code/navigation.php";
	?>	
	
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li>
	</ol>

	<div class="container-fluid">
	
		<div class="row">
	    	<div class="col-md-12">
				<h2>Manage users</h2>
			</div>   
   		</div>
   		
   		<div class="row">   
           	<div class="col-md-12">
           		<h5><label class="label label-danger"><?php if ($_message == "") echo(""); else echo($_message); ?></label></h5>
           	</div>   
       	</div>
       	
        <div class="row">   
                <div class="col-md-12">&nbsp;</div>   
        </div>        
        
      	<div class="row">  
    		<div class="col-md-8">
				<p>Subscription state indicates if this user is controlled by a PayPal subscription.  Active, indicates that it is controlled from PayPal, disabled indicates either
				that the user has ended the subscription or that access is not controlled by PayPal but has been manually created.</p>

				<p>Password state indicates if the password is active or not.  If disabled, then the user is unable to log in to the secure area.  This will happen 
				automatically when the subscription has ended or if the administrator has manually disabled the password.</p>

				<p>Note that users created through the IPN Local test will give indications as though they have been created via PayPal, so it is recommended that these are deleted to avoid 
				confusion with genuine subscriptions.</p>

				<p><span class="lightyellow">Indicates a manually created user.</span></p>
			</div>
			<div class="col-md-4">&nbsp;</div>
  		</div>
		
	 	<div class="row">    
            <div class="col-md-12">	

				<form name="frmCreate" action="a_usercreate.php" method="post">
					<input type="submit" name="submit" value="Create a new user manually" class="btn btn-primary btn-sm" />					
				</form>

	   		</div>
		</div>	
	
    	<div class="row">   
			<div class="col-md-12">&nbsp;</div>   
		</div>   	    
	    
		<div class="row">   
			<div class="col-md-12">** Click on the column title arrows to sort the column</div>   
        </div>			
		
		<div class="row">               
			<div class="col-md-12">
				<strong>Filter email address by :</strong><br/> 
				<a href="?filter=">Show all</a>&nbsp;&nbsp;<a href="?filter=a">A</a>&nbsp;&nbsp;
				<a href="?filter=b">B</a>&nbsp;&nbsp;<a href="?filter=c">C</a>&nbsp;&nbsp;<a href="?filter=d">D</a>&nbsp;&nbsp;
				<a href="?filter=e">E</a>&nbsp;&nbsp;<a href="?filter=f">F</a>&nbsp;&nbsp;<a href="?filter=g">G</a>&nbsp;&nbsp;
				<a href="?filter=h">H</a>&nbsp;&nbsp;<a href="?filter=i">I</a>&nbsp;&nbsp;<a href="?filter=j">J</a>&nbsp;&nbsp;
				<a href="?filter=k">K</a>&nbsp;&nbsp;<a href="?filter=l">L</a>&nbsp;&nbsp;<a href="?filter=m">M</a>&nbsp;&nbsp;
				<a href="?filter=n">N</a>&nbsp;&nbsp;<a href="?filter=o">O</a>&nbsp;&nbsp;<a href="?filter=p">P</a>&nbsp;&nbsp;
				<a href="?filter=a">Q</a>&nbsp;&nbsp;<a href="?filter=r">R</a>&nbsp;&nbsp;<a href="?filter=s">S</a>&nbsp;&nbsp;
				<a href="?filter=t">T</a>&nbsp;&nbsp;<a href="?filter=u">U</a>&nbsp;&nbsp;<a href="?filter=v">V</a>&nbsp;&nbsp;
				<a href="?filter=w">W</a>&nbsp;&nbsp;<a href="?filter=x">X</a>&nbsp;&nbsp;<a href="?filter=y">Y</a>&nbsp;&nbsp;
				<a href="?filter=z">Z</a>
				<br/>Current filter : <?php if ($_SESSION['filter'] == "") { echo("none"); } else { ?><span class="red"><?php echo(strtoupper($_SESSION['filter'])); ?></span><?php } ?>
			</div>
		</div>
				
		<div class="row">   
	    	<div class="col-md-12">				
				
				<?php

				$items = listofusers($_SESSION['filter']);	

				if (count($items) == 0)
				{
					echo('There are no items to display');
				}
				else
				{
				?>
	
					<table cellspacing="0" width="100%" id="products" class="display">
						<thead>
							<tr>					
								<th>Email<br/>address</th>				
								<th>Securea<br/>area</th>
								<th>Item<br/>number</th>
								<th>Sub-</br>scription<br/>state</th>
								<th>Pass-</br>word<br/>state</th>
								<th>Man-</br>ually<br/>created</th>
								<th>Disable<br/>password</th>
								<th>Date<br/>created</th>
								<th>Date<br/>sub due</th>
								<th>Date<br/>expire</th>					
								<th>Edit</th>
								<th>Send password<br/>to customer</th>
								<th>Edit</th>
								<th>Delete</th>
							</tr>
						</thead>	
						<tfoot>
							<tr>					
								<th>Email<br/>address</th>				
								<th>Securea<br/>area</th>
								<th>Item<br/>number</th>
								<th>Sub-</br>scription<br/>state</th>
								<th>Pass-</br>word<br/>state</th>
								<th>Man-</br>ually<br/>created</th>
								<th>Disable<br/>password</th>
								<th>Date<br/>created</th>
								<th>Date<br/>sub due</th>
								<th>Date<br/>expire</th>
								<th>Edit</th>
								<th>Send password<br/>to customer</th>
								<th>Edit</th>
								<th>Delete</th>
							</tr>
						</tfoot>
						<tbody>
								<?php		
								foreach( $items as $d_row ) {
									?>
									<tr>
									<td>
									
										<?php
											if ( $d_row['manual']  == 1 )
											{
												?><span class="lightyellow"><?php echo($d_row['payer_email']); ?></span><?php
											}
											else
											{
												echo($d_row['payer_email']);
											}
										?>										
									
									</td>					
									<td><?php 
									
										$getsecureareaname = getsecureareaname( $d_row['securearea_id'] ); 
										
										if ( $getsecureareaname == "" )
										{
											echo("<span class='red'>Error - Secure area reference not found.  Have you deleted a secure area?</span>");
										}
										else
										{
											echo( getsecureareaname( $d_row['securearea_id'] ) );
										}
																			   
										?>
									</td>
									<td><?php echo( $d_row['item_number'] ); ?></td>
									<td>
									<?php						
										if ( $d_row['sub_eot']  == 0 ) {
											?>Activated<?php
										} else {
											?><span class="red">Disabled</span><?php
										}
									?>						
									</td>
									<td>
									<?php						
										if ( $d_row['in_htpasswd']  == 1 ) {
											?>Activated<?php
										} else {
											?><span class="red">Disabled</span><?php
										}
									?>						
									</td>
									<td>
									<?php						
										if ( $d_row['manual']  == 1 ) {
											?>Yes<?php
										} else {
											?>No<?php
										}
									?>						
									</td>	
									<td>
									<?php 
										if ( $d_row['in_htpasswd'] == 1 ) {
											?><a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=inactive&securearea_id=<?php echo($d_row['securearea_id']); ?>&payer_email=<?php echo($d_row['payer_email']); ?>">Click to disable</a><?php
										} else {
											?><a href="<?php echo $_SERVER['PHP_SELF']; ?>?action=active&securearea_id=<?php echo($d_row['securearea_id']); ?>&payer_email=<?php echo($d_row['payer_email']); ?>">Click to enable</a><?php
										}								
									?>							
									</td>
									<td><?php echo( $d_row['sub_created'] ); ?>									
									</td>
									<td>
									<?php
									if ( $d_row['sub_due_date'] == "0000-00-00 00:00:00" ) {
										echo("&nbsp;");
									}
									else
									{
										echo( $d_row['sub_due_date'] );
									}
									?>
									</td>
									<td>
									<?php									
									if ( $d_row['sub_expire_date'] == "0000-00-00 00:00:00" ) {
										echo("&nbsp;");
									}
									else
									{
										echo( $d_row['sub_expire_date'] );
									}	
									?>
									</td>
									<td>
									<?php
										//If manual entry, then edit this value
										$show = 0;
										if ( ($d_row['manual']  == 1) && ($show == 1) ) {
											?><a href="a_editdate.php?recid=<?php echo($d_row['pursecid']); ?>&payer_email=<?php echo($d_row['payer_email']); ?>&securearea_id=<?php echo($d_row['securearea_id']); ?>">Edit</a><?php
										} else {
											?><?php
										}
									?>							
									</td>            
									<td><a href="a_usersendpw.php?recid=<?php echo($d_row['recid']); ?>&payer_email=<?php echo($d_row['payer_email']); ?>">Send</a></td>
									<td><a href="<?php $_SERVER['PHP_SELF'] ?>?action=edit&recid=<?php echo($d_row['recid']) ?>&payer_email=<?php echo($d_row['payer_email']); ?>"><i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a></td>
									<td><a href="<?php $_SERVER['PHP_SELF'] ?>?action=delete&recid=<?php echo($d_row['recid']) ?>&payer_email=<?php echo($d_row['payer_email']); ?>"><i class="fa fa-trash fa-2x" aria-hidden="true"></i></a></td>
								</tr>
								<?php	
							}
							?>
							</tbody>			
						</table>

				<?php				
				}			
				?>

      			</div>
        	</div>
        
    	</div>                
        
		<?php
            require_once "code/footer_datatable.php";	
        ?>
        </body>
        </html>        
	<?php
}
//---------------------------------------------------
//Purpose : Edit the details of the user in sec_tblusers
function edit($recid, $msg) {	

	$items = userpersondetails($recid);
	
	if (count($items) == 1) {
	
		$name 				= $items[0]["name"];
		$telephone 			= $items[0]["telephone"];		
		$mobile				= $items[0]["mobile"];		
		$address_line1		= $items[0]["address_line1"];
		$address_line2		= $items[0]["address_line2"];
		$city				= $items[0]["city"];
		$zip_post_code		= $items[0]["zip_post_code"];
		$country			= $items[0]["country"];
		$state				= $items[0]["state"];		
		
	} else {
		display( "Error with table, record not found " . date("Y-m-d H:i:s") );
		exit();
	}

require_once("code/header.php");
require_once("code/navigation.php");
?>

<ol class="breadcrumb">
  	<li><a href="index1.php">Home</a></li> 	
  	<li><a href="a_usermanage.php">User List</a></li>
</ol>

<div class="container">

	<div class="row">
    	<div class="col-md-2">&nbsp;</div>
		<div class="col-md-6">    

			<h2>Edit user details</h2>

				<form name="frmEdit" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
					<input type="hidden" name="txtRecId" value="<?php echo("$recid"); ?>">
					<input type ="hidden" name="page" value="<?php echo($pageno); ?>">

					<div class = "form-group">        
        				<h5><label class="label label-danger"><?php if (isset($msg)) { echo($msg); } ?></label></h5>
        			</div>  	
		
					<div class = "form-group">
						<input type="submit" name="Update" value="Update" class="btn btn-primary btn-sm" />
					</div>  	
	
					<div class = "form-group">
						<label for="txtName"><strong>Name</strong></label>	
						<input type="text" name="txtName" value="<?php echo($name); ?>" class="form-control" />	
					</div>
			
					<div class = "form-group">
						<label for="txtTelephone"><strong>Telephone</strong></label>				
						<input type="text" name="txtTelephone" value="<?php echo($telephone); ?>" class="form-control" />	
					</div>

					<div class = "form-group">
						<label for="txtMobile"><strong>Mobile</strong></label>
						<input type="text" name="txtMobile" value="<?php echo($mobile); ?>" class="form-control" />
					</div>

					<div class = "form-group">
						<label for="txtAddress_Line1"><strong>Address line 1</strong></label>
						<input type="text" name="txtAddress_Line1" value="<?php echo($address_line1); ?>" class="form-control" />	
					</div>

					<div class = "form-group">
						<label for="txtAddress_Line2"><strong>Address line 2</strong></label>
						<input type="text" name="txtAddress_Line2" value="<?php echo($address_line2); ?>" class="form-control" />	
					</div>

					<div class = "form-group">
						<label for="txtCity"><strong>City</strong></label>
						<input type="text" name="txtCity" value="<?php echo($city); ?>" class="form-control" />	
					</div>

					<div class = "form-group">
						<label for="txtState"><strong>State /County</strong></label>
						<input type="text" name="txtState" value="<?php echo($state); ?>" class="form-control" />	
					</div>

					<div class = "form-group">
						<label for="txtCountry"><strong>Country</strong></label>
						<input type="text" name="txtCountry" value="<?php echo($country); ?>" class="form-control" />	
					</div>
					
					<div class = "form-group">				
						<label for="txtZip_Post_Code"><strong>Zip or Post Code</strong></label>
						<input type="text" name="txtZip_Post_Code" value="<?php echo($zip_post_code); ?>" class="form-control" />	
					</div>	

				</form>

		</div>		
		<div class="col-md-4"></div>
	</div>    

</div>

<?php include ("code/footer_bootstrapjs.php");
}
//---------------------------------------------------
//Purpose : Displays a box to confirm deletion of this user.
function confirmdeletion($payer_email) {
										
require_once("code/header.php");	
require_once("code/navigation.php");
?>
<ol class="breadcrumb">
	<li><a href="index1.php">Home</a></li>
	<li><a href="a_usermanage.php">List of users</a></li>
</ol> 
	
<div class="container"> 
  
       <div class="row">   
            <div class="col-md-2"></div>    
            <div class="col-md-6">
  
				<h2>Confirm deletion of user</h2>

				<div class="frmbkg">     
		
					<form name="frmConfirm" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" >
						Are you sure you want to delete this user?<br /><br />
						<input type="hidden" name="payer_email" value="<?php echo($payer_email); ?>" />
						<input type="submit" name="delete" value="Yes" class="btn btn-primary btn-sm" />
						&nbsp;&nbsp;&nbsp;
						<input type="submit" name="delete" value="No" class="btn btn-primary btn-sm" /><br /><br />
						This will complete remove the user<br />from the database and cannot be reversed.
					</form>
							
				</div>	
			</div>   
            <div class="col-md-4"></div>        
        </div>
    
 </div>	

<?php
require_once ("code/footer_bootstrapjs.php");
}
//-----------------------------------
//Purpose : Update the selected item
//Inputs : $name, $telephone, $mobile, $address_line1, $address_line2, $city, $zip_post_code, $country, $recid
function update($name, $telephone, $mobile, $address_line1, $address_line2, 
					$city, $state, $zip_post_code, $country, $recid) {
	
	//echo($query);
	//exit();	

	$rowssaffected = updatetblusers($name, $telephone, $mobile, $address_line1, $address_line2, 
											$city, $zip_post_code, $country, $state, $recid );	
	
	if ($rowssaffected == 0) {		
		edit($recid, "No update " . date("Y-m-d H:i:s") );
	}
	else
	{
		edit($recid, "Record updated " . date("Y-m-d H:i:s") );
	}

}
?>