<?php session_start();

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//---------------------------------------
//Send the password by email to this user
//---------------------------------------

//---------------------------------------
require_once("../error.php"); 
require_once("../classes/clsloginvalidate.php");
require_once("../classes/clsredirect.php");
require_once("../classes/clsinput.php"); 
require_once("../classes/clsuser.php"); 
require_once("../dbclass/Db.class.php"); 
//---------------------------------------
	

if ( isset( $_POST["inputEmail"] ) && isset( $_POST["inputPassword"] ) )
{
	if (!loginvalidate::username( input::get("inputEmail") ) )
	{
		displaysignin("Error in username (email) or password");
		exit();
	}

	if (!loginvalidate::password( input::get("inputPassword") ) )
	{
		displaysignin("Error in username (email) or password");
		exit();
	}	

	if (!user::isValidUser( input::get("inputEmail"), input::get("inputPassword")) )
	{		
		displaysignin("Error in username (email) or password");
		exit();
	}	
	else
	{		
		//valid user			
		$_SESSION['user_session'] = input::get("inputEmail");	
		$_SESSION['access'] = "yes";		

		//echo($_SESSION['user_session']);
		//exit();

		redirect::to("index1.php");
	}	

}
else
{
	displaysignin("");
	exit();
}
//------------------------------------------------------
//Purpose: Shows the sign in box
function displaysignin($message)
{
require_once("code/header_signin.php");
?>
<div class="container">

      <form class="form-signin" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" style="background-color:#FFFFFF">
      
      	<p class="fa fa-lock fa-5x"><p>
      
  		<p style="color:#ff0000;"><?php echo($message); ?></p> 
        <h2 class="form-signin-heading">Please sign in</h2>

            <div class="form-group">
                <label for="inputEmail"><strong>Email Address</strong></label>  
                <input type="email" id="inputEmail" name="inputEmail" class="form-control" placeholder="Email address" aria-describedby="basic-addon1" required autofocus >
            </div>                  
        
            <div class="form-group">        
                <label for="inputPassword"><strong>Password</strong></label>     
                <input type="password" id="inputPassword" name="inputPassword" class="form-control" placeholder="Password"  required >
            </div>                
        
        	<button type="submit" class="btn btn-lg btn-primary btn-block">Sign in</button>
        	
       <br/>
		  <a href="recoverpw.php" class="blockover">Forgot your password</a>
      </form>

    </div> <!-- /container -->
<?php
require_once("code/footer_bootstrapjs.php");	
}
?>