<?php

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//------------------------------------------------
//The user enters the email address and that sends an email with a link
//The user clicks on the link which causes it to reset the password back to 
//the default values.
//------------------------------------------------


//------------------------------------------------
require_once("../error.php"); 
require_once("../dbclass/Db.class.php");
require_once("../classes/clsuser.php");
require_once("../classes/clsloginvalidate.php");
require_once("../classes/clsinput.php");
require_once("../functions/misc.php");

require_once('../classes/phpmailer/src/PHPMailer.php');
require_once('../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;
//------------------------------------------------


main();

//------------------------------------------------
function main() {
	
	$inputReset = input::get("submit");		
	$d = input::get("d");
	
	
	if  ( $inputReset == "inputSubmitReset" )
	{
		$email = input::get("inputEmail");
		sendcheckemail($email);
	}
	elseif ($inputReset == "inputSubmitPassword")
	{
		
		//Check password characters and length
		
		//Update the password
		
		if (!loginvalidate::password( trim(input::get("inputPassword")) ) )
			{
			displaychangepwform($d, "Error characters in password");
			exit();
		}
		
		if (!loginvalidate::password( trim(input::get("inputPasswordAgain")) ) )
			{
			displaychangepwform($d, "Error characters in password");
			exit();
		}
		
		$inputPassword = trim(input::get("inputPassword"));
		$inputPasswordAgain = trim(input::get("inputPasswordAgain"));
		
		//echo($inputPassword);
		//echo($inputPasswordAgain);
		//exit();
		
		//Check pw length
		if ( (strlen($inputPassword) <= 5) || (strlen($inputPassword) > 10) ) {
			displaychangepwform($d, "Passwords must be 6 to 10 characters");
			exit();					
		}
	
		//Check pw length
		if ( (strlen($inputPasswordAgain) <= 5) || (strlen($inputPasswordAgain) > 10) ) {
			displaychangepwform($d, "Passwords must be 6 to 10 characters");
			exit();					
		}	

		if ( trim(input::get("inputPassword")) != trim(input::get("inputPasswordAgain")) )
		{
			displaychangepwform($d, "Passwords must match");
			exit();				
		}
		

		//Now change password
		$update = user::updatePassword( trim(input::get("inputEmail")), trim(input::get("inputPassword") ) );	
	
		//echo($update);
		//exit();
		
		if ($update == true)
		{
			displayform("Password has been updated " . date("Y-m-d H:i:s"));			
			exit();
		}
		else
			{
			displayform("Password has NOT been updated");		
			exit();
		}
		
		
	}	
	elseif ( $d != "" ) 
	{		
		//Check the link is the same as in the database		
		displaychangepwform($d, "");
	}
	else
	{	
		displayform("");
	}
	
}
//------------------------------------------------
function displaychangepwform($d, $_message) {

	//retrieve link and date from databas
	
	$table = getlinkdata();
	
	
	if (count($table) == 1)
	{	
		$link = $table[0]["link"];
		$linkdate = $table[0]["linkdate"];
		$currentdate = date("Y-m-d H:i:s");
		
		$start_date = new DateTime($linkdate);
		$since_start = $start_date->diff(new DateTime($currentdate));
		
		if ($link != trim($d))
		{
			//Error
			displayform("Link not correct");
			exit();
		}		
		
		if ($since_start->days > 0)
		{
			//Error
			displayform("Link expired");
			exit();
		}
		
		//-------------------------------------------------		
		require_once("code/header_signin.php");
		require_once("code/navigation.php");
		?>
	
		<ol class="breadcrumb">
  			<li><a href="index1.php">Home</a></li> 
		</ol>
	
		<div class="container">	
	
		<div class="row">

			<div class="col-md-3">&nbsp;</div>

			<div class="col-md-6">	

				<div class="frmbkg">			

					<form class="form-signin" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">		      

						<p style="color:#ff0000;"><?php if (isset($_message)) { echo($_message); } ?></p> 

						<div class = "form-group">
							<h2>Admin password reset</h2>
						</div>

						<div class="form-group">
							<label for="inputEmail">Enter your username (email address):</label>
							<input type="text" id="inputEmail" name="inputEmail" class="form-control" placeholder="Username" required autofocus />          
						</div>

						<div class="form-group">
							<label for="inputEmail">Enter your new password:</label>
							<input type="password" id="inputPassword" name="inputPassword" class="form-control" placeholder="Password" required autofocus />          
						</div>

						<div class="form-group">
							<label for="inputEmail">Enter your new password again:</label>
							<input type="password" id="inputPasswordAgain" name="inputPasswordAgain" class="form-control" placeholder="Password Again" required autofocus />          
						</div>

						<button type="submit" class="btn btn-lg btn-primary btn-block">Reset Password</button>  
						<input type="hidden" name="submit" value="inputSubmitPassword" /> 
						<input type="hidden" name="d" value="<?php echo($d); ?>" />   

					</form>

				</div>

			</div>
			<div class="col-md-3">&nbsp;</div>
			</div>
		</div>
	
		<?php
		require_once("code/footer_bootstrapjs.php");	
		exit();
		//-------------------------------------------------
		
	}
	else
	{
		//Error
		displayform("No link found");
		exit();
	}	
	
}
//------------------------------------------------
function displayform($_message) {
	
	require_once("code/header_signin.php");
	require_once("code/navigation.php");
	?>
	
	<ol class="breadcrumb">
  		<li><a href="index1.php">Home</a></li> 
	</ol>
	
	<div class="container">	
	
	   	<div class="row">
	
			<div class="col-md-3">&nbsp;</div>
	
			<div class="col-md-6">
	
				<div class="frmbkg">	

					<form class="form-signin" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">		      

						<p style="color:#ff0000;"><?php if (isset($_message)) { echo($_message); } ?></p> 


						<div class = "form-group">
							<h2>Admin password reset</h2>

							<p>Please enter your email address. You will receive a link to create a new password via email.</p>	

						</div>				

						<div class="form-group">
							<label for="inputEmail">Enter your Admin Email Address (your username):</label>
							<input type="email" id="inputEmail" name="inputEmail" class="form-control" placeholder="Email address" required autofocus />          
						</div>

						<button type="submit" class="btn btn-lg btn-primary btn-block">Submit</button>  
						<input type="hidden" name="submit" value="inputSubmitReset" />   

					</form>

				</div>
		
			</div>
			<div class="col-md-3">&nbsp;</div>
		</div>
	</div>
	
	<?php
	require_once("code/footer_bootstrapjs.php");
}
//------------------------------------------------
//Check if this email is the admin email
//If it is the admin email then send an email which asks the person to click the link
function sendcheckemail($email) {
	
	//check this email address
	if ( checkpasswordemail($email) )
	{		
			
		//Create link
		$link = createlink();
		$url = getinstallfolder() . "admin/recoverpw.php?d=" . $link;		
		
		//Save link to database with current date.		
		savelink($link, $email);
		
		//When the user clicks on the link it checks that it is correct.
		//It then allows them to change the password.		
		
		//Send email to this email address
		$to = $email;
		$subject = "PHP-SecureArea Reset password Request";
		$body = "This email is used to reset the admin password of PHP-SecureArea\n\n
		To reset the admin password click the following link:\n\n" . $url;
		$from = getadminemail();
		
		//echo("to " . $to . "<br/>");
		//echo("subject " . $subject . "<br/>");
		//echo("body " . $body . "<br/>");
		//echo("from " . $from . "<br/>");
		//exit();
		
		mailmessage($to, $subject, $body, "", $from, "", "");
		
		displayform("An email has been sent to:<br/>" . $email . ".<br/>Go to your email inbox and click the link.<br/>If you don't see the email, check your spam or junk email box.");
	}
	else
	{
		//Incorrect email address
		displayform("");
	}
	
}
?>