<?php

require_once("checkaccess.php");

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//-----------------------------------------
//Allows the user to change their password 
//after logging in
//-----------------------------------------

error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);

require_once("../../functions/misc.php");
require_once("../../functions/user.php");
require_once("../../classes/clsloginvalidate.php");	
require_once("../../dbclass/Db.class.php");

require_once('../../classes/phpmailer/src/PHPMailer.php');
require_once('../../classes/phpmailer/src/SMTP.php');
//require_once('../classes/phpmailer/src/Exception.php');
//use PHPMailer\PHPMailer\PHPMailer;

//----------------------------------------------
main();


//----------------------------------------------
//Purpose : Starts the page
function main() {

	if ($_POST['Submit'] == "") {
		$username = $_SESSION['username'];
		display("", $username);
	}
	else
	{ 
	
		$username		= $_SESSION['username'];
		$password1 		= $_POST['txtPassword1'];
		$password2 		= $_POST['txtPassword2'];
		$oldpassword 	= $_POST['txtOldPassword'];	

		//echo("username " . $username ."<br>");
		//echo("password1 " . $password1 ."<br>");
		//echo("password2 " . $password2 ."<br>");
		//echo("oldpassword " . $oldpassword ."<br>");		
		//exit();
	
		update($username, $password1, $password2, $oldpassword);
	}

}
//----------------------------------------------
//Purpose :  Updates the password for this $username
function update($username, $password1, $password2, $oldpassword) {

	include("../lang/file.php");

	if ( ($password1 == "") || ($password2 == "") || ($password1 != $password2) ) {
		display($L_CHANGEPW['PWMUSTMATCH'], $username);
		exit();
	}

	if ( !loginvalidate::username($username) ) {
		display("Incorrect characters in username", $username);
		exit();	
	}

	if ( (check_pw($password1) == false) || (check_pw($password2) == false) ) {
		display($L_CHANGEPW['INCORRECTPW'], $username);
		exit();	
	}

	//echo($username . "<br/>");
	//echo($password1 . "<br/>");
	//echo($password2 . "<br/>");
	//echo($oldpassword . "<br/>");
	//exit();

	//Getting here means that the passwords are OK
	//Now update the password
	//Change the password in any htpasswd files
	//Send the new password to the user as confirmation

	require_once("../../classes/clspassword.php");		
	require_once("../../classes/clshtpasswd.php");	
	require_once("functions.php");	

	$message = "";
	//$password = createpw();

	$result = changepw( $username, $password1, $oldpassword, $message );

	if ( !$result ) {
		display($message, $username);
	} else {

		//send login details to user		
		//sendpw( $username, $password1 );
		display($L_CHANGEPW['PWCHANGED'], $username);
		exit();
	}
	
	exit();	

}
//----------------------------------------------
//Purpose : Displays the change password box
function display($msg, $payer_email) {

	include("../lang/file.php");
	?>
	<?php include("../includes/header.php"); ?>
	<form name="frmUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" >
	<table align="center">
		<tr>
			<td class="red">
				<?php if ( $msg == "" ) {echo("&nbsp;");} else {echo($msg);} ?>
			</td>
		</tr>
		<tr>
			<td colspan="3"><?php echo($L_CHANGEPW['ALLOWEDCHARACTERS']); ?></td>
		</tr>
		<tr>
			<td colspan="3">&nbsp;</td>
		</tr>
		<tr>
			<td align="right"><strong><?php echo($L_CHANGEPW['EXISTINGPW']); ?> :</strong></td>
			<td width="5">&nbsp;</td>
			<td><input type="password" name="txtOldPassword" class="inputbox" /></td>
		</tr>
		
		<tr>
			<td align="right"><strong><?php echo($L_CHANGEPW['NEWPASSWORD']); ?> :</strong></td>
			<td width="5">&nbsp;</td>
			<td><input type="password" name="txtPassword1" class="inputbox" /></td>
		</tr>
		<tr>
			<td align="right"><strong><?php echo($L_CHANGEPW['PASSWORDAGAIN']); ?> :</strong></td>
			<td width="5">&nbsp;</td>
			<td><input type="password" name="txtPassword2" class="inputbox" /></td>
		</tr>
		<tr>
			<td colspan="3">&nbsp;</td>
		</tr>
		<tr>
			<td colspan="3" align="center"><input type="submit" name="Submit" value="<?php echo($L_CHANGEPW['SUBMIT']); ?>" class="inputsubmit" /></td>
		</tr>
		<tr>
			<td colspan="3">&nbsp;</td>
		</tr>
		<tr>
			<td colspan="3" align="center"><a href="menu.php"><?php echo($L_CHANGEPW['RETURNTOMAINMENU']); ?></a></td>
		</tr>	
	</table>
	
	</form>
	<?php include("../includes/footer.php"); ?>
	
	<?php

}

?>