<?php
session_start();

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//-----------------------------------------
//	Validates the user login / password in tbluser
//
//	If correct username / password, it redirects to menu.php
//	and sets the session "OK" to identify the user has logged in 
//  and sets the session "username" to identify the user name of the 
//	person that has logged in. 
//	If username / password are not correct, it redirects back to 
//  the login page.
//------------------------------------

	error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);	

	require_once("../lang/file.php");	
	require_once("../../functions/user.php");
	require_once("../../dbclass/Db.class.php");
	require_once("../../classes/clshtpasswd.php");
	require_once("../../classes/clspassword.php");
	require_once("../../classes/clsloginvalidate.php");

	$password = $_POST['password'];
	$payer_email = strtolower($_POST['username']);
	$message = "";

	//Validate username / password	(message is normally returned as a by reference variable)

	$result = validate( $payer_email, $password, $message );

	$message = $L_LOGIN['MESSAGE'];

	if ( !$result ) {	
		header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "../../index.php?message=" . $message );
		exit();
	} else {

		//echo("here");
		//exit();

		$_SESSION['username'] = $payer_email;
		$_SESSION['OK'] = 'yes';

		//echo($_SESSION['username']);
		//echo("<br/>");
		//echo($_SESSION['OK']);
		//exit();

		header("Location:http://" .$_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/menu.php" );
	}

?>