<?php

//----------------------------------------------------------
//List of functions associated with users
//----------------------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//	30/12/2024 V2.9.6
//	* unused variables removed

//----------------------------------------
//Purpose: Return some product details
function listofusers($filter) {

	$db = new Db();
	
	if ($filter == "")
	{
		$table = $db->query( " SELECT sec_tblusers.recid, sec_tblusers.payer_email, sec_tblpurchased_secureareas.in_htpasswd, 
		sec_tblpurchased_secureareas.sub_eot, sec_tblpurchased_secureareas.securearea_id, sec_tblpurchased_secureareas.item_number, 
		sec_tblpurchased_secureareas.manual, sec_tblpurchased_secureareas.sub_created, sec_tblpurchased_secureareas.sub_due_date, 
		sec_tblpurchased_secureareas.sub_expire_date, sec_tblpurchased_secureareas.recid as pursecid 
		FROM 
		sec_tblusers 
		INNER JOIN 
		sec_tblpurchased_secureareas 
		ON 
		sec_tblusers.recid = sec_tblpurchased_secureareas.users_id ");
	}
	else
	{
		$table = $db->query(" SELECT sec_tblusers.recid, sec_tblusers.payer_email, sec_tblpurchased_secureareas.in_htpasswd, 
		sec_tblpurchased_secureareas.sub_eot, sec_tblpurchased_secureareas.securearea_id, sec_tblpurchased_secureareas.item_number, 
		sec_tblpurchased_secureareas.manual, sec_tblpurchased_secureareas.sub_created, sec_tblpurchased_secureareas.sub_due_date, 
		sec_tblpurchased_secureareas.sub_expire_date, sec_tblpurchased_secureareas.recid as pursecid 
		FROM 
		sec_tblusers 
		INNER JOIN 
		sec_tblpurchased_secureareas 
		ON 
		sec_tblusers.recid = sec_tblpurchased_secureareas.users_id 
		WHERE
		payer_email LIKE :filter", 
		array(
				"filter" => $filter ."%"
				));		
	}	
	
	return $table;

}
//------------------------------------
//Enable the user for this secure area only 
//Enabling a user means adding the username/password to the htpasswd file
//Setting the in_htpasswd flag to 1
//It dosn't matter what the state of sub_eot is
//Any error message is retruned in $message
//Returns false if failed, true if OK
function enableuser($payer_email, $securearea_id, &$message) {
	
	//To make the user active, make sure that the user is in htpasswd file
	//If the user is not in htpasswd, create the user in the htpasswd file
	//Set the in_htpasswd flag to 1
	
	//Get the recid of the user from sec_tblusers given the payer_email
	$users_id = userrecid($payer_email);
	
	//-------------------------
	//Get password from tblusers table and decyrpt ready to add to htpasswd file(s).
	//get password and IV for this user and decrypt
	$message = "";
	$password_plain = getpassword($payer_email, $message);
	if ( $message != "") {
		return false;
	}
	//-------------------------
			
	$password_location = getpasswordlocation();

	//echo("<br>securearea_id : " . $d_row['securearea_id'] . "<br>");	
	
	$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);
	if(!($htpasswd->EXISTS))		//Check if file exists
		{
		$message = "htpasswd file not found - user.php ref 3 ";
		return false;
		}

		//Now add this user to the htpasswd file
		//If the user is already in the htpasswd file, then ignore
		//Otherwise add the user
			
		//echo($payer_email);
		//echo($password_plain);				
		//exit;
			
	if ( !$htpasswd->isuser($payer_email) ) //If user already exists in htpasswd, ignore
		{

		$pass = $htpasswd->adduser($payer_email, $password_plain);	//Otherwise add the username / password
			if(empty($pass)) 
			{
				$message = "Add user failed - $htpasswd->ERROR - user.php ref 4 ";			
				return false;
			} else {
				$message = "$payer_email has been activated with password : $password_plain";
			}	

		}		
	
	//Set the flag in sec_tblpurchased_secureareas in_htpasswd for this user and securearea_id
	//This shows that this user is in htpasswd
	$update = sethtpasswdflag($users_id, $securearea_id);	

	if ($update == 0) {
		$message = "SQL error - user.php ref 5 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
		return false;
	}
	
	return true;

}
//------------------------------------
//Disable the user means to remove the user from the htpasswd file.
//That is, do not delete the user from all htpasswd files, only  
//disable access for this user with the identified securearea_id 
//Any error message is retruned in $message
//Returns false if failed, true if OK
function disableuser($payer_email, $securearea_id, &$message) {

	//echo($payer_email);
	//echo($securearea_id);
	//exit();

	//Given the payer_email, get the record id (users_id) from tblusers		
	$users_id = userrecid($payer_email);
	
		
	//Un-set the flag in sec_tblpurchased_secureareas in_htpasswd for this user and securearea_id
	//This shows that this user is not in htpasswd
	$update = unsethtpasswdflag($users_id, $securearea_id);
	
	if ($update == 0) {
		$message = "SQL error - user.php ref 6 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
		//You can have no update if there is no change required in the table
		//return false;
	}	

	
	$password_location = getpasswordlocation();

	//Now modify the appropriate htpasswd file		

	$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);
	if( !($htpasswd->EXISTS) )		//Check if file exists
		{
		$message = "htpasswd file not found - user.php ref 8 ";
		return false;
		}
					
		//Now remove this user from the htpasswd file.

		if ( $htpasswd->isuser($payer_email) ) 		//If user exists in htpasswd remove this user
		{
		$removeuser = $htpasswd->deleteuser ($payer_email);	
			if (!$removeuser) 
			{
				$message = "Change password failed - $htpasswd->ERROR - user.php ref 9 ";
				return false;		
			}
			else
			{
				$message = "$payer_email has been removed from htpasswd files";
			}
		}
	
	return true;
	
}
//------------------------------------
/**
*	Create a user manually given an emailaddress
*	Add user to tblusers if the user does not exist already.
*	Add the user to tblpurchased_securearea with purchase information
*	Set the sub_eot flag to 1 if creating an entry, leave as is if updating an entry, and set the in_htpasswd flag to 1
*	A flag of 1 means sub_eot has finished
*	Add user to htpasswd file if the make active flag is set.
*	Set in_htpasswd to 1
*	Set the manual flag in tblpurchased_securearea to 1 to show manual creation
*
*	As this function has to run 'unattended' using IPN, the errors have to be returned to 
*	the calling function.
*
*
*	$active  =  1 means activate the password, $active = 0, do not put password on htpasswd file
*
*	Any error message is retruned in $message
*	Returns false if failed, true if OK
*	return @boolean
*/
function createmanualuser( $payer_email, $password_plain, $password_encrypt, $iv, $item_number, $active, $securearea_id, &$message ) {

	//$payer_email = addslashes($payer_email);

	/*
	echo("Start up---------------------------<br/>");
	echo($payer_email . "<br/>");
	echo($password_plain . "<br/>");
	echo($password_encrypt . "<br/>");
	echo($iv . "<br/>");
	echo($item_number . "<br/>");
	echo($active . "<br/>");
	*/

	//--------------------------------------------
	//Save user to tblusers table.
	//Check if this payer_email is already in tblusers.
	//	If not, then add to table users, and get the record id of the newly created field.
	//	If it exists, get the record id.

	//first check if this email already exists in tblusers
	$users_id = userrecid($payer_email);
	
	
	//--------------------------
	if ( $users_id == "" ) {		//record not found, means is a new user	
		
			//Create a new user
			//Save user to tblusers and get the record id of newly created user	
			$users_id = insertnewuser($payer_email, $password_encrypt, $iv);		
		
			if ( $users_id == 0 ) {
				$message = "SQL error - new user not created - user.php ref 12 ";
				return false;
			}		
		
		
			//Now create new entry in sec_tblpurchased_secureareas including item_number, users_id, securearea_id, sub_created, sub_eot, manual
			//users_id is the newly created recid from sec_tblusers
			//securearea_id, item_number from tblitems
			
			$sub_created = date("Y-m-d H:i:s");  //Should this be subscr_date as returned from IPN
			$sub_expire_date = calculate_expire_date($sub_created, $item_number, "1");

			/*
			echo("insert A ---------------------------<br/>");
			echo("item_number" . $item_number . "<br/>");
			echo("securearea_id" . $securearea_id . "<br/>");
			echo("users_id" . $users_id . "<br/>");
			echo("sub_eot" . "1 ". "<br/>");					
			echo("sub_created" . $sub_created . "<br/>");		
			echo("manual" . "1" . "<br/>");				
			echo("sub_expire_date" . $sub_expire_date . "<br/>");
			*/
		
			$insert = createpurchasedsecurearea($item_number, $securearea_id, $users_id, 1, $sub_created, 1, $sub_expire_date, NULL);
		
			if ( $insert == 0) {
				$message = "SQL error - entry not created - user.php ref 13 ";	
				return false;
			}

			if ($active == 1) {	//create password whien tick box is ticked to activate password

					//------------------------
					//Update the htpasswd file with the password
			
					//--------------------------------------------
					//Save username / password to the .htpasswd file
					//.htpasswd file contains username:password list	
					$password_location = getpasswordlocation();

					//echo("email : " . $payer_email . "<br>");
					//echo("password location : " . $password_location . "<br/>");
					//echo("password : " . $password_encrypt . "<br/>");
					//echo("password location : " . $password_location . ".htpasswd_" . $this->SECUREAREA_ID);
					//exit();

					$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

					if(!($htpasswd->EXISTS)) { //Check if file exists
						$message = "htpasswd does not exist  - user.php ref 14 - Could not update htpasswd with user details";
						return false;
					}

					//First encrypt password for htpasswd file
					$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
					if ( empty($pw_for_htpasswd) ) {
						$message = "Could not create password - user.php ref 15 ";
						return false;
					}

					$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
					if(empty($pass)) {
						$message = "Add user failed - user.php ref 16 $htpasswd->ERROR";
						return false;
					}
				
					//update in_htpasswd flag in sec_tblpurchased_secureareas
					//UPDATE sec_tblpurchased_secureareas SET in_htpasswd = 1 WHERE securearea_id = $securearea_id AND users_id = $users_id
					$update = sethtpasswdflag($users_id, $securearea_id);
				
					if ($update == 0) {
						$message = "SQL error - user.php ref 17 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
						return false;
					}

			}
			
	}
	else
	{		
		
				//This user users_id already exists 
				//Get the record id of the existing user and update sec_tblpurchased_secureareas

				//echo($users_id);
				//exit();

				//If this user has already purchased this securea area in tblpurchased_secureaareas, then update it.
				//Otherwise create an entry in sec_tblpurchased_secureareas.

				//First check if this user has already purchased this secure area.			

				$table = secureareadetails( $users_id, $securearea_id );
		
		
				if ( count($table) == 0 ) {		//record not found, means this user has NOT purchased this securearea before
			
						//Create a new record in sec_tblpurchased_secureareas including item_number, users_id, securearea_id, sub_created, sub_eot, manual

						//users_id is the recid in tblusers
						//securearea_id, item_number from tblitems
			
						$sub_created = date("Y-m-d H:i:s"); //Should this be subscr_date as returned from IPN
						$sub_expire_date = calculate_expire_date($sub_created, $item_number, "1");						
	
						/*
						echo("insert B ---------------------------<br/>");
						echo("item_number" . $item_number . "<br/>");
						echo("securearea_id" . $securearea_id . "<br/>");
						echo("users_id" . $users_id . "<br/>");
						echo("sub_eot" . "1 ". "<br/>");					
						echo("sub_created" . $sub_created . "<br/>");		
						echo("manual" . "1" . "<br/>");				
						echo("sub_expire_date" . $sub_expire_date . "<br/>");	
						*/
	
						$insert = createpurchasedsecurearea($item_number, $securearea_id, $users_id, 1, $sub_created, 1, $sub_expire_date, NULL);
					
						if ( $insert == 0) {
							$message = "SQL error - entry not created - user.php ref 19 ";	
							return false;
						}					
		
						//------------------------
						//Update the htpasswd file with the password
			
						//--------------------------------------------
						//Save username / password to the .htpasswd file
						//.htpasswd file contains username:password list	
						$password_location = getpasswordlocation();
	
						//echo("email : " . $payer_email . "<br>");
						//echo("password location : " . $password_location . "<br/>");
						//echo("password : " . $password_encrypt . "<br/>");
						//echo("password location : " . $password_location . ".htpasswd_" . $securearea_id);
						//exit();

						$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

						if(!($htpasswd->EXISTS)) { //Check if file exists
							$message = "htpasswd does not exist  - user.php ref 20 - Could not update htpasswd with user details";
							return false;
						}

						//First encrypt password for htpasswd file
						$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
						if ( empty($pw_for_htpasswd) ) {
							$message = "Could not create password - user.php ref 21 ";
							return false;
						}

						$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
						if(empty($pass)) {
							$message = "Add user failed - user.php ref 22 $htpasswd->ERROR";
							return false;
						}

					
						//update in_htpasswd flag in sec_tblpurchased_secureareas
						//UPDATE sec_tblpurchased_secureareas SET in_htpasswd = 1 WHERE securearea_id = $securearea_id AND users_id = $users_id
						$update = sethtpasswdflag($users_id, $securearea_id);
				
						if ($update == 0) {
							$message = "SQL error - user.php ref 23 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
							return false;
						}					
					
			
				} else {	//record found, means this user HAS purchased this securearea before, so just update the existing record


						//Check if user has htpasswd active.
						//If not active then create password and make htpasswd flag active
						//If htpasswd is active, carry on
					 	$items = secureareadetails( $users_id, $securearea_id );
						if (count($items) == 0) {
								$isactive = false;		
							} else {
								if ($items[0]['in_htpasswd'] == 1) {
									$isactive = true;		
								} else {
									$isactive = false;
								}								
							}
					

						if ($isactive == false) {	//Create password and make htpasswd flag active

								//------------------------
								//Update the htpasswd file with the password
			
								//--------------------------------------------
								//Save username / password to the .htpasswd file
								//.htpasswd file contains username:password list	
								$password_location = getpasswordlocation();

								//echo("email : " . $payer_email . "<br>");
								//echo("password location : " . $password_location . "<br/>");
								//echo("password : " . $password_encrypt . "<br/>");
								//echo("password location : " . $password_location . ".htpasswd_" . $securearea_id);
								//exit();

								$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

								if(!($htpasswd->EXISTS)) { //Check if file exists
									$message = "htpasswd does not exist  - user.php ref 25 - Could not update htpasswd with user details";
									return false;
								}

								//First encrypt password for htpasswd file
								$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
								if ( empty($pw_for_htpasswd) ) {
									$message = "Could not create password - user.php ref 26 ";
									return false;
								}

								$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
								if(empty($pass)) {
									$message = "Add user failed - user.php ref 27 $htpasswd->ERROR";
									return false;
								}
							
								//update in_htpasswd flag in sec_tblpurchased_secureareas
								//UPDATE sec_tblpurchased_secureareas SET in_htpasswd = 1 WHERE securearea_id = $securearea_id AND users_id = $users_id
								$update = sethtpasswdflag($users_id, $securearea_id);
				
								if ($update == 0) {
									$message = "SQL error - user.php ref 28 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
									return false;
								}									
							

						}


						//have to set manual = 1 and sub_eot = 1 for create manual user

						//update sec_tblpurchased_secureareas
						$sub_created = date("Y-m-d H:i:s"); //Should this be subscr_date as returned from IPN
						$sub_due_date = calculate_due_date($sub_created, $item_number);	
						$sub_expire_date = calculate_expire_date($sub_created, $item_number, "1");		

						/*
						echo("insert C ---------------------------<br/>");
						echo("item_number" . $item_number . "<br/>");
						echo("securearea_id" . $securearea_id . "<br/>");
						echo("users_id" . $users_id . "<br/>");
						echo("sub_eot" . "1 ". "<br/>");					
						echo("sub_created" . $sub_created . "<br/>");		
						echo("manual" . "1" . "<br/>");				
						echo("sub_expire_date" . $sub_expire_date . "<br/>");
						*/					
					
						$update = updatepurchasedsecurearea( $item_number, 1, $sub_created, 1, $sub_due_date, $sub_expire_date, $users_id, $securearea_id );					
					
						if ( $update == 0) {
							$message = "SQL error - entry not created - user.php ref 29 ";	
							return false;
						}	
					
					
				}
			

	}
	//--------------------------

	return $users_id;

}
//------------------------------------
//Sign up the user given an emailaddress
//Add user to tblusers if the user does not exist already.
//Add the user to tblpurchased_securearea with purchase information
//Set the sub_eot flag to 0 and set the in_htpasswd flag to 1
//Add user to htpasswd file.
//Set in_htpasswd to 1
//
//As this function has to run 'unattended' using IPN, the errors have to be returned to 
//the calling function.
//
//Any error message is retruned in $message
//Returns false if failed, true if OK
function signupuser($custom, $payer_email, $password_plain, $password_encrypt, $iv, $item_number, $securearea_id, &$message, $set_manual_flag) {

	//$custom is the field which identifies if the sign up has come from the signup form.  $custom is actually the users_id	
	
	if ( $custom == "" ) {	//indicates that the sign up form is not being used
		
		//--------------------------------------------
		//Save user to tblusers table.
		//Check if this payer_email is already in tblusers.
		//	If not, then add to table users, and get the record id of the newly created field.
		//	If it exists, get the record id.

		//First check if this email already exists in tblusers
		//We need to do this even if $custom is being used, that is there may be a situation where someone has signed up, 
		//completed the subscription and then signs up again with the $custom method
		//$strSQL = " SELECT recid, password FROM sec_tblusers WHERE payer_email = '" . $payer_email . "'"
		$users_id = userrecid($payer_email);
		if ( $users_id == "" ) {
			$emptytable = "true";
		} else {
			$emptytable = "false";
		}
		
	} else {
	
		// custom field contains UserID
		// Check if it is an existing user
		$table = usersandsignedup($payer_email);		
		
		// Check if signup=1 was found
		if ( count($table) == 0 ) {
			//  (singedup = 1 not found) it is a new signup
			$emptytable = "true";
		} else {
			$emptytable = "false";
			// Yes it is an existing User
		}	
		
	}


	//--------------------------
	if ( $emptytable == "true" ) {		//record not found, means is a new user, or custom field is not empty

			if ( $custom == "" ) {
				
				//This is a new user
				//Save user to tblusers and get the record id of newly created user							
				$users_id = insertnewuser($payer_email, $password_encrypt, $iv);	//return the automatically increment field that has just been created
				
			} else {
			
				$users_id = $custom;		//the contents of $custom is the user id, so in this case we update sec_tblusers with the password etc

				//Have to update sec_tblusers with email address and password
				$update = updateuser($payer_email, $password_encrypt, $iv, $custom);
				
				if ( $update == 0) {
					$message = "SQL error - no update in sec_tbluser - user.php ref 33 ";	
					return false;
				}
				
			}

			if ($set_manual_flag == true) {		//In some situations, we want to set the manual flag to true.  This is used for single purchase buy now button purchase.
				$sub_eot = 0;
				$manual = 1;
			} else {			
				$sub_eot = 0;
				$manual = 0;
			}		
		
			//create new entry in sec_tblpurchased_secureareas including item_number, users_id, securearea_id, sub_created, sub_eot, manual
			//users_id is the newly created recid in tblusers
			//securearea_id, item_number from tblitems			
		
			$sub_created = date("Y-m-d H:i:s");  //Should this be subscr_date as returned from IPN
			$sub_due_date = calculate_due_date($sub_created, $item_number);
			$sub_expire_date = calculate_expire_date($sub_created, $item_number, $manual);		
		

			$insert = createpurchasedsecurearea($item_number, $securearea_id, $users_id, $sub_eot, $sub_created, $manual, $sub_expire_date, $sub_due_date);
		
			if ( $insert == 0 ) {
				$message = "SQL error - entry not created - user.php ref 34 ";	
				return false;
			}
		
			//------------------------
			//Update the htpasswd file with the password
			
			//--------------------------------------------
			//Save username / password to the .htpasswd file
			//.htpasswd file contains username:password list	
			$password_location = getpasswordlocation();

			//echo("email : " . $payer_email . "<br>");
			//echo("password location : " . $password_location . "<br/>");
			//echo("password : " . $password_encrypt . "<br/>");
			//echo("password location : " . $password_location . ".htpasswd_" . $securearea_id);
			//exit();

			$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

			if(!($htpasswd->EXISTS)) { //Check if file exists
				$message = "htpasswd does not exist  - user.php ref 35 - Could not update htpasswd with user details";
				return false;
			}

			//First encrypt password for htpasswd file
			$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
			if ( empty($pw_for_htpasswd) ) {
				$message = "Could not create password - user.php ref 36 ";
				return false;
			}

			$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
			if(empty($pass)) {
				$message = "Add user failed - user.php ref 37 $htpasswd->ERROR";
				return false;
			}

			//update in_htpasswd flag in sec_tblpurchased_secureareas		
			$update = sethtpasswdflag($users_id, $securearea_id);
		
			if ($update == 0) {
				$message = "SQL error - user.php ref 38 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
				return false;
			}

	}
	else
	{

			//This user users_id already exists 
			//Get the record id of the existing user and update sec_tblpurchased_secureareas

			//echo("users_id: " . $users_id);
			//exit();

			//If this user has already purchased this securea area in tblpurchased_secureaareas, then update it.
			//Otherwise create an entry in sec_tblpurchased_secureareas.
			
			//First check if this user has already purchased this secure area.		
			$table = secureareadetails( $users_id, $securearea_id );

				if ( count($table) == 0 ) {		//record not found, means this user has NOT purchased this securearea before
			
						if ($set_manual_flag == true) {		//In some situations, we want to set the manual flag to true.  This is used for single purchase buy now button purchase.
							$sub_eot = 0;
							$manual = 1;
						}
							else
						{
							$sub_eot = 0;
							$manual = 0;
						}										
					
						//Create a new record in sec_tblpurchased_secureareas including item_number, 
						//users_id, securearea_id, sub_created, sub_eot, manual

						//users_id is the recid in tblusers
						//securearea_id, item_number from tblitems
			
						$sub_created = date("Y-m-d H:i:s"); //Should this be subscr_date as returned from IPN
						$sub_due_date = calculate_due_date($sub_created, $item_number);
						$sub_expire_date = calculate_expire_date($sub_created, $item_number, $manual);			
					
						$insert = createpurchasedsecurearea($item_number, $securearea_id, $users_id, $sub_eot, $sub_created, $manual, $sub_expire_date, $sub_due_date);
		
						if ( $insert == 0 ) {
							$message = "SQL error - entry not created - user.php ref 40 ";	
							return false;
						}					
		
						//------------------------
						//Update the htpasswd file with the password
			
						//--------------------------------------------
						//Save username / password to the .htpasswd file
						//.htpasswd file contains username:password list	
						$password_location = getpasswordlocation();

						//echo("email : " . $payer_email . "<br>");
						//echo("password location : " . $password_location . "<br/>");
						//echo("password : " . $password_encrypt . "<br/>");
						//echo("password location : " . $password_location . ".htpasswd_" . $securearea_id);
						//exit();

						$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

						if(!($htpasswd->EXISTS)) { //Check if file exists
							$message = "htpasswd does not exist  - user.php ref 41 - Could not update htpasswd with user details";
							return false;
						}

						//First encrypt password for htpasswd file
						$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
						if ( empty($pw_for_htpasswd) ) {
							$message = "Could not create password - user.php ref 42 ";
							return false;
						}

						$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
						if(empty($pass)) {
							$message = "Add user failed - user.php ref 43 $htpasswd->ERROR";
							return false;
						}
					
						//update in_htpasswd flag in sec_tblpurchased_secureareas		
						$update = sethtpasswdflag($users_id, $securearea_id);
		
						if ($update == 0) {
							$message = "SQL error - user.php ref 44 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
							return false;
						}
					
		
				} else {	//record found, means this user HAS purchased this securearea before, 
							//so just update the existing record


						//Check if user has htpasswd active.
						//If not active then create password and make htpasswd flag active
						//If htpasswd is active, carry on					
						$items = secureareadetails( $users_id, $securearea_id );
						if (count($items) == 0) {
								$isactive = false;		
							} else {
								if ($items[0]['in_htpasswd'] == 1) {
									$isactive = true;		
								} else {
									$isactive = false;
								}								
							}
					
					
						if ($isactive == false) {	//Create password and make htpasswd flag active

								//------------------------
								//Update the htpasswd file with the password
			
								//--------------------------------------------
								//Save username / password to the .htpasswd file
								//.htpasswd file contains username:password list	
								$password_location = getpasswordlocation();

								//echo("email : " . $payer_email . "<br>");
								//echo("password location : " . $password_location . "<br/>");
								//echo("password : " . $password_encrypt . "<br/>");
								//echo("password location : " . $password_location . ".htpasswd_" . $securearea_id);
								//exit();

								$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);

								if(!($htpasswd->EXISTS)) { //Check if file exists
									$message = "htpasswd does not exist  - user.php ref 46 - Could not update htpasswd with user details";
									return false;
								}

								//First encrypt password for htpasswd file
								$pw_for_htpasswd = $htpasswd->cryptpass($password_plain);
								if ( empty($pw_for_htpasswd) ) {
									$message = "Could not create password - user.php ref 47 ";
									return false;
								}

								$pass = $htpasswd->addusercryptpw($payer_email, $pw_for_htpasswd);	//add user with already encrypted password
								if(empty($pass)) {
									$message = "Add user failed - user.php ref 48 $htpasswd->ERROR";
									return false;
								}

								//update in_htpasswd flag in sec_tblpurchased_secureareas		
								$update = sethtpasswdflag($users_id, $securearea_id);
		
								if ($update == 0) {
									$message = "SQL error - user.php ref 49 - No update to sec_tblpurchased_secureareas for users_id: $users_id securearea_id: $securearea_id";
									return false;
								}
							
											
						}


						if ($set_manual_flag == true) {	 //In some situations, we want to set the manual flag to true.  This is used for single purchase buy now button purchase.
							$sub_eot = 0;
							$manual = 1;
						}
						else
						{
							$sub_eot = 0;
							$manual = 0;
						}									
					
						//update sec_tblpurchased_secureareas
						$sub_created = date("Y-m-d H:i:s"); //Should this be subscr_date as returned from IPN
						$sub_due_date = calculate_due_date($sub_created, $item_number);	
						$sub_expire_date = calculate_expire_date($sub_created, $item_number, $manual);		

					
						$update = updatepurchasedsecurearea( $item_number, $sub_eot, $sub_created, $manual, $sub_due_date, $sub_expire_date, $users_id, $securearea_id );					
					
						if ( $update == 0) {
							$message = "SQL error - entry not created - user.php ref 50 ";	
							return false;
						}					
					
				}			

	}
	//--------------------------

	return true;

}
//------------------------------------	
//Delete the user completely from the system, from tbluser,
//tblpurchased_securearea, and from the htpasswd file(s).
//Delete the user from the database and from htpasswd
//Delete the user from tbluser
//Delete the user from tblpurchased_securearea
//
//Any error message is returned in $message
//Returns false if failed, true if OK
function deleteuser($payer_email, &$message ) {
	
	if ( $payer_email == "" ) {
		$message = "Error - Payer email address is empty";
		return false;
	}
	
	//---------------
	//Given the email address, look up recid in tblusers
	$users_id = userrecid($payer_email);
	
	//echo($payer_email);
	//exit();	
	
	if ( $users_id == "" ) {
		$message = "Error - Payer email address is empty or cannot be found in table";
		return false;	
	}
	
	
	//---------------
	//Delete the user from all htpasswd files(s)		
	//Look up securearea_id (may be more than one) from sec_tblpurchased_secureareas	
	$table = listsecureareaids($users_id);
	
	//echo("<br>Count : " . count($table) );
	//exit();	
	
	if ( count($table) == 0 )  
	{
		$message = "$payer_email is not in any htpasswd files";
		return false;
	}
	else
	{

		$password_location = getpasswordlocation();
	
		foreach( $table as $d_row ) {
			//for each securearea_id, remove the user from the appropriate htpasswd file
			//echo("<br>securearea_id : " . $d_row['securearea_id'] . "<br>");

			$securearea_id = $d_row['securearea_id'];

			$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);
			if(!($htpasswd->EXISTS))		//Check if file exists
				{
				$message = "htpasswd file not found - user.php ref 52 ";
				//return false;		//commented out so that if htpasswd does not exist, it still deletes the user
				} else {
					
					//Now remove this user from the htpasswd file.
					if ( $htpasswd->isuser($payer_email) ) 		//If user exists in htpasswd remove this user
					{
					$removeuser = $htpasswd->deleteuser ($payer_email);	
						if (!$removeuser) {
							$message = "Delete user failed - $htpasswd->ERROR - user.php ref 53 ";
							return false;
						}
						else
						{
							$message = "$payer_email has been removed from htpasswd file(s)";
						}
					}

				}

		}
		//end of foreach
		
	}
	//end of if 
	
	//---------------
	//Now delete the user from tblusers	
	//$delete =
	deleteuserfromtbluser($payer_email);

	//---------------
	//Delete users from tblpurchased_securearea
	//$delete =
	deleteuserfromtblpurchased_secureareas($users_id);
	
	//echo(users_id);
	//exit();
	
	return true;

}
//------------------------------------
//Set the end of term flag in sec_tblpurchased_secureareas
function seteot($payer_email, $securearea_id, &$message) {
		
	//Given the payer_email, get the record id (users_id) from tblusers
	$users_id = userrecid($payer_email);	
	
	if ( $users_id == "" )
	{
		$message = "SQL error - user.php ref 56 ";
		return false;
	}
	
	//Un-set the flag in sec_tblpurchased_secureareas for this user and securearea_id
	//This shows that this user has completed their subscription	
	$update = settblpurchased_secureareasflags($users_id, $securearea_id);
	
	if ($update == 0) {
		$message = "SQL error - user.php ref 57 ";
		return false;		
	}
	
	return true;

}
//---------------------------------------
//Purpose: Given the payer_email address, return the decrypted password
function getpassword($payer_email, &$message) {

	$db = new Db();
	
	$table = $db->query(" SELECT password, iv FROM sec_tblusers 
						WHERE payer_email = :payer_email ", 
					array(
						"payer_email" => $payer_email
						));
	
	if ( count($table) == 0 )
	{
		$message = "SQL Error - user.php ref 58";
		exit();
	}

	$IV = $table[0]['iv'];
	$password = $table[0]['password'];

	$decryption = new password($IV, $password);
	$decryption->decode();
	$decode = $decryption->getdecodedtext();

	return $decode;

}
//------------------------------------
//Change the passwords, that is all htpasswd entries and the entry in tblusers
//
//Any error message is returned in $message
//Returns false if failed, true if OK
function changepw($payer_email, $password, $oldpassword, &$message ) {

	/*
	echo($payer_email . "<br/>");
	echo($password . "<br/>");
	echo($oldpassword . "<br/>");	
	exit();
	*/
	
	//validate username / password first
	//encrypt the new password using clspassword
	//modify tblusers with new password
	//look up secureaarea_id's for the user
	//for each sercurearea_id change the username / password in the htpasswd files	
		
	//validate existing username / password
	if ( !validate($payer_email, $oldpassword, $message) ) {
		$message = "Existing password not valid";
		return false;
	} else {
		

			//look up securearea_id (may be more than one) from sec_tblpurchased_secureareas 
		
			//first get the users_id from tblusers for this payer_email
		
			$users_id = userrecid($payer_email);
		
			if ($users_id == "")
			{
				$message = "$payer_email not found in tblusers";
				return false;
			}
		
			//echo($users_id);
			//exit();
		
			//Get distinct list of secure areas for thise user
			$table = listsecureareaids($users_id);
		
			if ( count($table) == 0 )  {
				$message = "$payer_email is not in any htpasswd files - user.php ref 60";
				return false;
			}
		
		
			$password_location = getpasswordlocation();

			//------------------------------------------
			//for each securearea, change the password		
			foreach( $table as $d_row ) {
					
				$securearea_id = $d_row['securearea_id'];
				
				//Check if htpasswd file exists, which it should do
				$htpasswd = new htpasswd($password_location . ".htpasswd_" . $securearea_id, $password_location);
				if(!($htpasswd->EXISTS))		//Check if file exists
					{
					$message = "htpasswd file for secure area id $securearea_id not found - user.php ref 61 ";
					return false;
					}
					
					//Check if the user is in the htpasswd file
					if ( $htpasswd->isuser($payer_email) ) //If user exists in htpasswd, change the password to the new value
					{
					$passch = $htpasswd->changepass ($payer_email, $password );	//if put nothing for old password, it does not check it.
						if (!$passch) {
							//$messge = "Change password failed - $htpasswd->ERROR - user.php ref 62 ";
							return false;
						}
					}

			} //end of for loop

	} // end 


	//------------------------------------------
	//Now update tbluser with the new password
	//UPDATE sec_tbluser SET password = $password, iv = $iv WHERE payer_email = $email	

	//encrypt pasword first 
	srand(make_seed());
	$iv = rand(1, 500);

	$encryption = new password($iv, $password);
	$encryption->encode();
	$password_encrypt = $encryption->getencodedtext();	
	
	//update sec_tblusers with new password
	$update_table = updateuserpassword($password_encrypt, $iv, $payer_email);
	
	if ($update_table == 0) {	//update returns the number of rows effected
		$message = "$payer_email not found in sec_tblusers - user.php ref 63";
		return false;
	}	

	return true;

}
//------------------------------------	
//Checks the username and password for correct characters
//Checks the username / password against database
//Returns true only if username / password are correct
//Returns false and a message if there is a failure of username / password
//Note that the password is the plain text version after the user has entered
//it into the form
function validate($payer_email, $password, &$message ) {
	
	//echo("payer email : " . $payer_email . "<br/>");
	//echo("password : " . $password . "<br/>");	
	//exit();

	if ( $payer_email == "" || $password == "" ) {
		$message = "Enter username / password";
		return false;
	}

	if ( !$password ) {
		$message = "Enter username / password";
		return false;
	}

	if ( !loginvalidate::username($payer_email) ) {
		$message = "Error in username";
		return false;		
	}
	
	if ( !check_pw($password) ) {
		$message = "Error in password";
		return false;
	}

	//Getting here means that the characters are correct.
	//Now check the database entry.

	//Check if this username exists in tblusers
	//If not, exit
	//If it does then get iv and password
	//encrypt the given password using the iv and compare with the database password

	if ( !validateusername( $payer_email, $message ) ) {	//Check if this username exists in tblusers
		return false;
	} else {

			//-------------------------
			//Get password from tblusers table and decyrpt ready to add to htpasswd file(s).
			//get password and IV for this user and decrypt
			$message = "";
			$dbpassword = getpassword($payer_email, $message);
			if ( $message != "") {
				return false;
			}
			//-------------------------

			//echo("entered password : " . $password . "<br/>");
			//echo("password decoded : " . $dbpassword . "<br/>");
			//exit();
			
			if ( strcmp($dbpassword, $password ) != 0 ) {		
				$message = "Enter username / password";
				return false;
			} else {
				return true;
			}

	}
	
	return true;
	
}
//------------------------------------
//Internal function to check if password characters are OK
//only a-z, 0-9 characters allowed and 6 to 10 characters in length
function check_pw($password) {

	if ( preg_match( "/[^0-9a-z]/", $password, $array ) ) {		
		return false;		//invalid characters
	}

	if ( (strlen($password) >= 6) && (strlen($password) <= 10) ) {
		return true;
	} else {
		return false;
	}

}
//------------------------------------
//Checks the username for correct characters, then
//checks the database to see if the username actually exists
//Returns true if OK, false if not
function validateusername( $payer_email, &$message ) {
	
	if (!loginvalidate::username($payer_email) ) {
		$message = "Incorrect username";
		return false;
	}	

	//Getting here means that the characters are correct.
	//Now check the database entry.

	$result = userrecid($payer_email);

	if ( $result >= 0 ) {
       	return true;		  
	} else {
		$message = "Incorrect username";
       	return false;
	}
		
	return true;		
	
}
//------------------------------------
//Given the current date and the securearea_id, calculate the date the next subscription is due
function calculate_due_date($sub_created, $item_number) {

	$table = gettblitems_number($item_number);

		//$a1 = $table['a1'];
		//$p1 = $table['p1'];
		//$t1 = $table['t1'];

		//$a2 = $table['a2'];
		//$p2 = $table['p2'];
		//$t2 = $table['t2'];

		//billing
		//$a3 = $table['a3'];				//Regular billing cost - the rate of the subscription
		$p3 = $table['p3'];				//Regular billing cycle. This is the length of the billing cycle. The number is modified by the regular billing cycle units (t3, below)
		$t3 = $table['t3'];				//Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: D (days), W (weeks), M (months), Y (years)

		//recurring payments
		//$src = $table['src'];			//Recurring payments. If set to “1” the payment will recur
		//$sra = $table['sra'];			//Reattempt on failure.
		//$srt = $table['srt'];			//Recurring Times. This is the number of payments which will occur at the regular rate. If omitted, payment will continue to recur at the regular rate until the subscription is cancelled.

	
		//We omly need $p3 and $t3 where $p3 is a number and $t3 is a letter, D, W, M or Y

		if ( $t3 == "D" ) {
			$units = "day";
		}
		
		if ( $t3 == "W" ) {
			$units = "week";
		}
		
		if ( $t3 == "M" ) {
			$units = "month";
		}

		if ( $t3 == "Y" ) {
			$units = "year";
		}

		//????????????????????		
		//echo("units " . $units);
		//echo("p3 " . $p3);
		//exit();

		$temp = "+".$p3." ".$units;

		$sub_due_date = date( "Y-m-d H:i:s", strtotime( $temp ) );

		//echo($sub_created . "<br/>");
		//echo($sub_due_date . "<br/>");
		//echo($temp . "<br/>");		
		//exit();		

		return $sub_due_date;

}
//------------------------------------
//Given the current date and the securearea_id, calculate the date the subscription will expire
//that is the date the end of term will be reached which will depend on the number of recurring payments due.
function calculate_expire_date($sub_created, $item_number, $manual) {

	/*
	echo($sub_created . "<br/>");
	echo($item_number . "<br/>");
	echo($manual . "<br/>");
	exit();
	*/
	
	$table = gettblitems_number($item_number);

        //Trail period 1
		//$a1 = $table['a1'];         //Cost
		$p1 = $table['p1'];         //Period
		$t1 = $table['t1'];         //Unit

        //Trail period 2
		//$a2 = $table['a2'];         //Cost
		$p2 = $table['p2'];         //Period
		$t2 = $table['t2'];         //Unit

		//billing
		//$a3 = $table['a3'];			//Regular billing cost - the rate of the subscription
		$p3 = $table['p3'];		    //Regular billing cycle. This is the length of the billing cycle. The number is modified by the regular billing cycle units (t3, below)
		$t3 = $table['t3'];		    //Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: D (days), W (weeks), M (months), Y (years)

		//recurring payments
		//$src = $table['src'];	    //Recurring payments. If set to “1” the payment will recur
		//$sra = $table['sra'];		//Reattempt on failure.
		$srt = $table['srt'];		//Recurring Times. This is the number of payments which will occur at the regular rate. If omitted, payment will continue to recur at the regular rate until the subscription is cancelled.

        /*
        echo("a1: ". $a1 . "<br/>");
        echo("p1: ". $p1 . "<br/>");
        echo("t1: ". $t1 . "<br/>");
    
        echo("a2: ". $a2 . "<br/>");
        echo("p2: ". $p2 . "<br/>");
        echo("t2: ". $t2 . "<br/>");
    
        echo("a3: ". $a3 . "<br/>");
        echo("p3: ". $p3 . "<br/>");
        echo("t3: ". $t3 . "<br/>");
    
        echo("src: ". $src . "<br/>");
        echo("sra: ". $sra . "<br/>");
        echo("srt: ". $srt . "<br/>");
        */

        //------------------------------
        //Calcuate end of trial period
        if ( $t1 == "D" ) {
            $units_t1 = "day";
        }
        if ( $t1 == "W" ) {
            $units_t1 = "week";
        }
        if ( $t1 == "M" ) {
            $units_t1 = "month";
        }
        if ( $t1 == "Y" ) {
            $units_t1 = "year";
        }

        if ( $t2 == "D" ) {
            $units_t2 = "day";
        }
        if ( $t2 == "W" ) {
            $units_t2 = "week";
        }
        if ( $t2 == "M" ) {
            $units_t2 = "month";
        }
        if ( $t2 == "Y" ) {
            $units_t2 = "year";
        }


        if ( $p1 != "" && $p1 != "0" )
        {
            //trial period 1            
            $temp_t1 = "+" . $p1 . " " . $units_t1;            
            //$end_of_t1 = date( "Y-m-d H:i:s", strtotime( $temp_t1 ) );
        }
        else
        {
            $temp_t1 = "";
        }

        if ( $p2 != "" && $p2 != "0" )
        {            
            //trial period 2
            $temp_t2 = "+" . $p2 . " " . $units_t2;
            //$end_of_t2 = date( "Y-m-d H:i:s", strtotime( $temp_t2 ) );
        }
        else
        {
            $temp_t2 = "";
        }
        //------------------------------
	
		
        //We omly need $p3 and $t3 where $p3 is a number and $t3 is a letter, D, W, M or Y
        if ( $t3 == "D" ) {
            $units = "day";
        }

        if ( $t3 == "W" ) {
            $units = "week";
        }

        if ( $t3 == "M" ) {
            $units = "month";
        }

        if ( $t3 == "Y" ) {
            $units = "year";
        }


        if (  ($srt == "")  ||  ($srt == "0")  ) {
            $temp = "+". $p3 . " " . $units;
        } else {
            $temp = "+". ($p3 * $srt) . " " . $units;
        }

        /*
        echo("trial 1: " . $temp_t1 . "<br/>");
        echo("trial 2: " . $temp_t2 . "<br/>");
        echo("regular billing period: " . $temp . "<br/>");
        echo("<p>&nbsp;</p>");
        */
    
        //---------------------------------
        //Calculate expire date
        $currentdate = date("Y-m-d H:i:s");

        //add to current date
        $sub_expire_date = date('Y-m-d H:i:s', strtotime($currentdate . $temp_t1 . $temp_t2 . $temp));

        return $sub_expire_date;
    
}
//------------------------------------
//Given the current date and the securearea_id, calculate the date the subscription will expire
//that is the date the end of term will be reached which will depend on the number of recurring payments due.
function calculate_expire_date_x($sub_created, $item_number, $manual) {

	/*
	echo($sub_created . "<br/>");
	echo($item_number . "<br/>");
	echo($manual . "<br/>");
	exit();
	*/
	
	$table = gettblitems_number($item_number);

		//$a1 = $table['a1'];
		//$p1 = $table['p1'];
		//$t1 = $table['t1'];

		//$a2 = $table['a2'];
		//$p2 = $table['p2'];
		//$t2 = $table['t2'];

		//billing
		//$a3 = $table['a3'];				//Regular billing cost - the rate of the subscription
		$p3 = $table['p3'];				//Regular billing cycle. This is the length of the billing cycle. The number is modified by the regular billing cycle units (t3, below)
		$t3 = $table['t3'];				//Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: D (days), W (weeks), M (months), Y (years)

		//recurring payments
		//$src = $table['src'];			//Recurring payments. If set to “1” the payment will recur
		//$sra = $table['sra'];			//Reattempt on failure.
		$srt = $table['srt'];			//Recurring Times. This is the number of payments which will occur at the regular rate. If omitted, payment will continue to recur at the regular rate until the subscription is cancelled.

		//echo($src);
		//exit();
	
		//if ( $src == "0" ) {		//When there are no recurring payments
		
			//We omly need $p3 and $t3 where $p3 is a number and $t3 is a letter, D, W, M or Y

			if ( $t3 == "D" ) {
				$units = "day";
			}
		
			if ( $t3 == "W" ) {
				$units = "week";
			}
		
			if ( $t3 == "M" ) {
				$units = "month";
			}

			if ( $t3 == "Y" ) {
				$units = "year";
			}

			//????????????????????		
			//echo("units " . $units);
			//echo("p3 " . $p3);
			//exit();

			if (  ($srt == "")  ||  ($srt == "0")  ) {
				$temp = "+". $p3 . " " . $units;
			} else {
				$temp = "+". ($p3 * $srt) . " " . $units;
			}

			$sub_expire_date = date( "Y-m-d H:i:s", strtotime( $temp ) );

			//echo($sub_created . "<br/>");
			//echo($sub_due_date . "<br/>");
			//echo($temp . "<br/>");		
			//exit();		

			return $sub_expire_date;
			
		//}
		//else
		//{
		//	return NULL;
		//}
	
}
//------------------------------------
//Purpose: return the recid of the user from sec_tblusers given the payer_email
function userrecid($payer_email) {
	
	$db = new Db();
	
	//SELECT recid FROM sec_tblusers WHERE payer_email = $payer_email	
	$table = $db->query(" SELECT recid
							FROM sec_tblusers 
							WHERE payer_email = :payer_email", 
							array(
								"payer_email" => $payer_email
							));
	
	if ( count($table) == 0 )
	{
		return "";
	}
	else
	{
		return $table[0]['recid'];	
	}	
	
}
//------------------------------------
//Purpose: Delete users from sec_tblusers given payer_email
function deleteuserfromtbluser($payer_email) {
	
	$db = new Db();
	
	//DELETE FROM sec_tblusers WHERE payer_email = '" . $payer_email . "'"	
	
	$delete = $db->query( " DELETE FROM sec_tblusers WHERE payer_email = :payer_email ",
						 	array( 
								"payer_email" => $payer_email 								 
							 )); 
	
	return $delete;
	
}
//------------------------------------
//Purpose: Delete users from sec_tblpurchased_secureareas given recid
function deleteuserfromtblpurchased_secureareas($users_id) {

	$db = new Db();
	
	//DELETE FROM sec_tblpurchased_secureareas WHERE users_id = '" . users_id . "'"	
	$delete = $db->query( " DELETE FROM sec_tblpurchased_secureareas WHERE users_id = :$users_id ",
						 	array( 
								"$users_id" => $users_id 								 
							 )); 
	
	return $delete;	
	
}
//------------------------------------
//Purpose: set the htpasswd flag to 1 for thus users_id and securearea_id
function sethtpasswdflag($users_id, $securearea_id) {
	
	//Set the flag in sec_tblpurchased_secureareas in_htpasswd for this user and securearea_id
	//This shows that this user is in htpasswd
	$db = new Db();
	
	$update = $db->query(" UPDATE sec_tblpurchased_secureareas
							SET in_htpasswd = 1
							WHERE users_id = :users_id AND securearea_id =:securearea_id",
								array(
									"users_id" => $users_id,
									"securearea_id" => $securearea_id
							));
	
	return $update;
	
}
//------------------------------------
//Purpose: un-set the htpasswd flag to 1 for thus users_id and securearea_id
function unsethtpasswdflag($users_id, $securearea_id) {
	
	//echo($users_id);
	//echo($securearea_id);
	//exit;
	
	//Un-set the flag in sec_tblpurchased_secureareas in_htpasswd for this user and securearea_id
	//This shows that this user is not in htpasswd
	$db = new Db();
	
	$update = $db->query(" UPDATE sec_tblpurchased_secureareas
							SET in_htpasswd = 0
							WHERE users_id = :users_id AND securearea_id =:securearea_id",
								array(
									"users_id" => $users_id,
									"securearea_id" => $securearea_id
							));	
	
	return $update;	
	
}
//------------------------------------
//Purpose: Set sub_due_date and sub_expire_date to blank for this user id and secure area id
//This disables this user.
function blankdates($users_id, $securearea_id) {
	
	$db = new Db();
	
	$update = $db->query(" UPDATE sec_tblpurchased_secureareas 
								SET sub_due_date='2038-01-01 00:00:00', sub_expire_date='1970-01-01 00:00:00' 
								WHERE users_id =:users_id AND securearea_id =:securearea_id ",
									array(		
										"users_id" => $users_id,
										"securearea_id" => $securearea_id	
									));
		
	return $update;
	
}
//------------------------------------
//Purpose: insert new user into sec_tblusers and return the created recid
function insertnewuser($payer_email, $password_encrypt, $iv) {
	
	//INSERT INTO sec_tblusers (payer_email, password, iv, signedup) VALUES ($payer_email, $password, $iv, $signedup)
	
	//echo($payer_email . "<br/>");
	//echo($password_encrypt . "<br/>");
	//echo($iv . "<br/>");
	//exit();
	
	$db = new Db();
	
	$signedup = 1;	
	
	$update = $db->query(" INSERT INTO sec_tblusers
								(
								payer_email, 
								password, 
								iv, 
								signedup 
								)
								VALUES 
								(
								:payer_email, 
								:password, 
								:iv, 
								:signedup
								) ",
								array(
									"payer_email" => $payer_email,
									"password" => $password_encrypt,
									"iv" => $iv,
									"signedup" => $signedup								
								));
	
		//echo("update: " . $update);
		//exit();
		
		if ($update == 0)
		{
			//$message = "SQL error - insert new user failed - user.php ref 65 ";
			return 0;
		}
		else
		{			
			$lastinsertid = $db->lastInsertId(); 			
			//echo("lastinsertid: " . $lastinsertid);
			//exit();			
			return $lastinsertid;
		}
	
}
//------------------------------------
//Purpose:  Update sec_tbluser with email address and password and set signedup = 1
function updateuser($payer_email, $password_encrypt, $iv, $custom) {
	
	$db = new Db();	
	
	$signedup = 1;
	
	$update = $db->query(" UPDATE sec_tblusers 
							SET 
							payer_email =:payer_email, 
							password =:password, 
							iv =:iv, 
							signedup =:signedup 
							WHERE 
							recid =:recid ",
					   		array(
								"payer_email" => $payer_email,
								"password" => $password_encrypt,
								"iv" => $iv,
								"signedup" => $signedup,
								"recid" => $custom
							));
	
	return $update;
	
}
//------------------------------------
//Pirpose: update sectbluser with the new password
function updateuserpassword($password, $iv, $payer_email) {

	$db = new Db();	
	
	//UPDATE sec_tblusers SET password = $password, iv = $iv WHERE payer_email = $email	
	$update = $db->query(" UPDATE sec_tblusers 
							SET
							password =:password,
							iv = :iv
							WHERE
							payer_email = :payer_email ",
								array(
									"password" => $password,
									"iv" => $iv,
									"payer_email" => $payer_email
							));
	
	return $update;
	
}
//------------------------------------
//Purpose: finds users with a payer_email and with signedup flag as 1
//Check if the user is signedup
function usersandsignedup($payer_email) {	
		
	$db = new Db();	
	
	$table = $db->query(" SELECT recid, password, signedup
							FROM sec_tblusers 
							WHERE 
							payer_email = :payer_email AND signedup = 1 ", 
							array(
								"payer_email" => $payer_email
							));
	
	return $table;
	
}
//------------------------------------
//Purpose: return list of secureareas, there may be more than one, given the 
//users_id of the user.
function listsecureareaids($users_id) {
	
	$db = new Db();	
	
	//SELECT DISTINCT securearea_id FROM sec_tblpurchased_secureareas WHERE users_id = $recid
	$table = $db->query(" SELECT DISTINCT securearea_id FROM sec_tblpurchased_secureareas WHERE users_id = :users_id ",
					   		array(
								"users_id" => $users_id
							));
	
	return $table;
	
}
//------------------------------------
//Purpose: create entry in sec_tblpurchased_secureareas
function createpurchasedsecurearea($item_number, $securearea_id, $users_id, $sub_eot, $sub_created, $manual, $sub_expire_date, $sub_due_date) {

        if ($sub_due_date == "") {
            $sub_due_date = "2038-01-01 00:00:00";
        }    
        
        /*
		echo("insert A ---------------------------<br/>");
		echo("item_number" . $item_number . "<br/>");
		echo("securearea_id" . $securearea_id . "<br/>");
		echo("users_id" . $users_id . "<br/>");
		echo("sub_eot" . $sub_eot . "<br/>");					
		echo("sub_created" . $sub_created . "<br/>");		
		echo("manual" . $manual . "<br/>");				
		echo("sub_expire_date" . $sub_expire_date . "<br/>");
		echo("sub_due_date" . $sub_due_date . "<br/>");
        exit();
        */
    
	
	$db = new Db();
	
	$insert = $db->query( " INSERT INTO sec_tblpurchased_secureareas 
								( 
								item_number, 
								securearea_id, 
								users_id, 
								sub_eot, 
								sub_created, 
								manual, 
								sub_expire_date,
								sub_due_date
								) 
								VALUES 
								(
								:item_number, 
								:securearea_id, 
								:users_id, 
								:sub_eot, 
								:sub_created, 
								:manual, 
								:sub_expire_date,
								:sub_due_date								
								) ",
								array(
									"item_number" => $item_number,
									"securearea_id" => $securearea_id,
									"users_id" => $users_id,
									"sub_eot" => $sub_eot,
									"sub_created" => $sub_created,
									"manual" => $manual,
									"sub_expire_date" => $sub_expire_date,
									"sub_due_date" => $sub_due_date
								));
		
	return $insert;
	
}
//------------------------------------
//Purchase:  Update sec_tblpurchased_secureareas
function updatepurchasedsecurearea( $item_number, $sub_eot, $sub_created, $manual, $sub_due_date, $sub_expire_date, $users_id, $securearea_id ) {

    if ($sub_due_date == "") {
        $sub_due_date = "2038-01-01 00:00:00";
    }  
    
	$db = new Db();
	
	$update = $db->query(" UPDATE sec_tblpurchased_secureareas
							SET 
							item_number =:item_number,
							sub_eot =:sub_eot,
							sub_created =:sub_created,
							manual =:manual,
							sub_due_date =:sub_due_date,
							sub_expire_date =:sub_expire_date
							WHERE users_id = :users_id AND securearea_id =:securearea_id",
								array(
									"item_number" => $item_number,
									"sub_eot" => $sub_eot,
									"sub_created" => $sub_created,
									"manual" => $manual,
									"sub_due_date" => $sub_due_date,
									"sub_expire_date" => $sub_expire_date,
									"users_id" => $users_id,
									"securearea_id" => $securearea_id
							));
	
	return $update;
	
}
//------------------------------------
//Purpose: return recid from sec_tblpurchased_secureareas given $users_id and $securearea_id
function secureareadetails( $users_id, $securearea_id ) {
	
	$db = new Db();	
	
	//SELECT recid FROM sec_tblpurchased_secureareas WHERE users_id = $users_id AND securearea_id = $securearea_id
	
	$table = $db->query(" SELECT recid, in_htpasswd
							FROM sec_tblpurchased_secureareas 
							WHERE 
							users_id = :users_id AND securearea_id =:securearea_id ", 
							array(
								"users_id" => $users_id,
								"securearea_id" => $securearea_id
							));

	return $table;			
	
}
//------------------------------------
//Purpose: Updates the flags in sec_tblpurchased_secureareas to show that the area has expired
function settblpurchased_secureareasflags($users_id, $securearea_id) {
	
	$db = new Db();	

	//UPDATE sec_tblpurchased_secureareas SET sub_eot = 1, sub_due_date='' sub_expire_date='' WHERE users_id = $users_id AND securearea_id = $securearea_id	
	
	$update = $db->query( " UPDATE sec_tblpurchased_secureareas 
								SET 
								sub_eot = 1,
								sub_due_date = '2038-01-01 00:00:00',
								sub_expire_date = '1970-01-01 00:00:00'
								WHERE users_id =:users_id AND securearea_id =:securearea_id ",
									array(
										"users_id" => $users_id,
										"securearea_id" => $securearea_id
								));
	
	return $update;	

}
//------------------------------------
//Purpose: Update sec_tblpurchased_securearea as we know the users_id and 
//the securearea_id and the item_number we can update a particular record 
function updatesubexpiredate($sub_expire_date, $item_number, $users_id, $securearea_id) {
		
	$db = new Db();

	$update = $db->query(" UPDATE sec_tblpurchased_secureareas
			SET					
			sub_expire_date =:sub_expire_date
			WHERE item_number =:item_number AND securearea_id =:securearea_id AND users_id = :users_id ",
				array(
					"sub_expire_date" => $sub_expire_date,
					"item_number" => $item_number,
					"securearea_id" => $securearea_id,
					"users_id" => $users_id						
			));

	return $update;

}
//------------------------------------
//Purpose: Query returns all the users who are manually created, and who are in the htpasswd file and are 
//older than the current date The cron job will disable the user, removing them from the htpasswd file so 
//that in_htpasswd will become 0
function usersforcron() {

	$db = new Db();

	$currentdate = date("Y-m-d H:i:s");	

	$query  = " SELECT sec_tblusers.recid, sec_tblusers.payer_email, sec_tblpurchased_secureareas.in_htpasswd,  sec_tblpurchased_secureareas.sub_eot, sec_tblpurchased_secureareas.securearea_id, sec_tblpurchased_secureareas.item_number, sec_tblpurchased_secureareas.manual, sec_tblpurchased_secureareas.sub_created, sec_tblpurchased_secureareas.sub_due_date, 
	sec_tblpurchased_secureareas.sub_expire_date 
	FROM 
	sec_tblusers 
	INNER JOIN 
	sec_tblpurchased_secureareas 
	ON 
	sec_tblusers.recid = sec_tblpurchased_secureareas.users_id 
	WHERE 
	sec_tblpurchased_secureareas.in_htpasswd = 1 
	AND 
	sec_tblpurchased_secureareas.sub_expire_date < :sub_expire_date ";	
	
	$table = $db->query( $query , array("sub_expire_date" => $currentdate ));
	
	//$query .= "sec_tblpurchased_secureareas.manual = 1 AND " . "sec_tblpurchased_secureareas.in_htpasswd = 1 ";	
	//Use this in the where clause if you just want manual users to be checked and expired.

	//echo($query);
	//echo($currentdate);
	//exit();
	
	return $table;
	
}
//------------------------------------
//Purpose: 
function getsecureareadetails($recid) 
{
	
	$db = new Db();
	
	//$query = " SELECT * FROM sec_tblpurchased_secureareas WHERE recid = $recid ";
	$table = $db->query(" SELECT *
							FROM sec_tblpurchased_secureareas 
							WHERE 
							recid = :recid ", 
							array(
								"recid" => $recid
							));

	return $table;

}
?>