<?php session_start();
@set_time_limit(300);		//added to make sure emails are sent out from smtp

	//-------------------------------------------------------------
	//Confirm PayPal transaction and store data in database
	//
	//*	Check the payment_status is Completed				
	//*	Check that txn_id has not been previously processed			
	//*	Check that receiver_email is your Primary PayPal email			
	//*	Check that a1, p1, t1, a2, p2, t2, a3, p3, t3, src, sra, srt are correct
	//*	Check that mc_currency is correct			
	//*	Process payment and update database
	
	//Note that :	
	//	currency_code is mc_currency, payment_gross is a3.  payment_gross is the legacy version.		
	//	currency_code is the variable that you use on your HTML button code.
	//	mc_currency is the variable that IPN post back.
	//	So, currency_code is posted back as mc_currency.
		
	//-------------------------------------------------------------

	//************************************
	//  Paul Gibbs copyright 2024
	//  paulvgibbs@gmail.com
	//************************************

	//--------------------------------------------
	require_once("includes/ipnfunctions.php");
	require_once("../ipncommon/com_ipnfunctions.php");	
	require_once("../functions/misc.php");
	require_once("../functions/user.php");
	require_once("../dbclass/Db.class.php");
	require_once("../classes/clshtpasswd.php");	
	require_once("../classes/clspassword.php");
	require_once("../error.php");

	require_once('../classes/phpmailer/src/PHPMailer.php');
	require_once('../classes/phpmailer/src/SMTP.php');
	//require_once('../classes/phpmailer/src/Exception.php');
	//use PHPMailer\PHPMailer\PHPMailer;
	//--------------------------------------------

	//#############################################################################
	if (isset($_POST['testmode'])) {
		$testmode = filter_var( $_POST['testmode'], FILTER_SANITIZE_STRING );	//During testing.  Comes from a_ipntest.php - set to "true"
	} else {
		$testmode = "false";
	}
	//#############################################################################


	//#############################################################################
	//During testing, set the return to VERIFIED.  Comes from a_ipntest.php local test
	if ($testmode == "true")  { 		//$testmode is INTERNAL test
		//First check that the admin session has been set as this is the only way the test can be done.
		if ($_SESSION['access'] != "yes") {
			echo("Error in test - refer to administrator");
			exit();			
		}
		$result = "VERIFIED";
	}
	//#############################################################################


	//#############################################################################
	//Format the received post data for display purposes
	$req_format = format_post($_POST);



//Remove comments to log ipn into /ipn/logs/log.txt file

	//------------------------------------
	//IPN Log
	$log_dir = "logs/";
	//files requires write permissions
	if ( @fopen($log_dir . 'log.txt', 'a') )
	{
		//Save to file
		$logfile = fopen($log_dir . 'log.txt', 'a');
		$today = date("Y-m-d H:i:s"); 
		$txtstart = "START " . $today . "---------------------\n";
		$txtend =   "END -------------------------------------\n\n\n\n";		
		$txt = $txtstart . $req_format . $txtend;		
		fwrite($logfile, $txt);
		fclose($logfile);
	}
	//------------------------------------



	//Get the required posted variables and place into an array
	$cmd = $_POST['txn_type'];
	//This is single item selection
	$paypal = create_local_variables();

	//Get the to and from email addresses and other entries from tblsetup
	$setup = gettblsetup();	
	
	//Get the admin address from tblsetup which will be either the paypal address or the entered admin address
	$adminaddress = getadminemail();

	//This is single item selection
	//Get emailsubject, emailtext from tblitems for this item - not from tblsetup which is the global settings.
	$emaildetails 		= getemaildetails( $paypal['item_number'] );
		
		$emailsubject 		= $emaildetails['emailsubject'];
		$emailtext 			= $emaildetails['emailtext'];		


	//#############################################################################


	//#############################################################################	
	//use the fsockopen method to get the result
	if ($testmode != "true") { 		//$testmode is INTERNAL test
		$result = fsockpost( "https://www.paypal.com/cgi-bin/webscr", $_POST );		
	}
	//#############################################################################


	//#############################################################################
	//Set the variables for test mode when returned from ipntest.php 
	if ($testmode == "true") {
		if ( ($paypal["txn_type"] == "subscr_signup") || ($paypal["txn_type"] == "subscr_cancel") || ($paypal["txn_type"] == "subscr_failed") || ($paypal["txn_type"] == "subscr_eot") || ($paypal["txn_type"] == "subscr_modify") ) {
			$paypal["payment_status"] = "";
		}		
	}	
	//#############################################################################


	//#############################################################################
	//Get receiver email address
	$receiver_email = $setup[0]['paypaladdress'];
	//#############################################################################


	//#############################################################################
	//Add in common confirm details	
	require_once("../ipncommon/com_confirm.php");
	//#############################################################################

?>