<?php

//------------------------------------------
//MAIN PAYPAL SITE
//------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

//This adds in shipping value set to 0.  
//Added do not prompt payers for shipping address with no_shipping.

//-----------------------------------------
//Purpose : Displays the PayPal hidden variables as applicable
//			to a subscription button which then gets posted to 
//			the PayPal server
function showpaypal($item_id) {

	//from tblsetup	:	paypaladdress, currency_code, urls
	//from tblitems :	item_name, amount, item_number
	
	//Look up post details from tblsetup
	$setup_details 	= gettblsetuppost();

		$paypaladdress 	= $setup_details['paypaladdress'];
		$cancel_url		= $setup_details['cancel_url'];
		$return_url		= $setup_details['return_url'];
		$notify_url		= $setup_details['notify_url'];

		//echo($paypaladdress . "<br/>");
		//echo($cancel_url . "<br/>");
		//echo($return_url . "<br/>");
		//echo($notify_url . "<br/>");
		//exit;

	//Look up item details given the item_id
	$item_details 	= gettblitems($item_id);

		$item_name 		= $item_details['item_name'];
		$item_number 	= $item_details['item_number'];
		$mc_currency 	= $item_details['mc_currency'];	
		
		$a1				= $item_details['a1'];
		$p1				= $item_details['p1'];
		$t1				= $item_details['t1'];
		
		$a2				= $item_details['a2'];
		$p2				= $item_details['p2'];
		$t2				= $item_details['t2'];

		$a3				= $item_details['a3'];
		$p3				= $item_details['p3'];
		$t3				= $item_details['t3'];
	
		$src			= $item_details['src'];
		$sra			= $item_details['sra'];
		$srt			= $item_details['srt'];
	
	?>

	<!-- PayPal Configuration --> 
	<input type="hidden" name="cmd" value="_xclick-subscriptions" />	
	<input type="hidden" name="business" value="<?php echo($paypaladdress); ?>" />	
	<input type="hidden" name="currency_code" value="<?php echo($mc_currency); ?>" />	
	<input type="hidden" name="no_note" value="1" />
	<input type="hidden" name="modify" value="0" />

	<!-- Product Information --> 
	<input type="hidden" name="item_name" value="<?php echo($item_name); ?>" />	
	<input type="hidden" name="item_number" value="<?php echo($item_number); ?>" />

	<!-- Subscription information-->

	<?php
	if ($a1 != "") {
		if ($a1 == "0.00") {$a1 = "0";}
		?>
		<!-- Trail 1 -->
		<input type="hidden" name="a1" value="<?php echo($a1); ?>" />
		<input type="hidden" name="p1" value="<?php echo($p1); ?>" />
		<input type="hidden" name="t1" value="<?php echo($t1); ?>" />
	<?php
	}
	?>
	
	<?php
	if ($a2 != "") {
		if ($a2 == "0.00") {$a2 = "0";}
		?>
		<!-- Trail 2 -->		
		<input type="hidden" name="a2" value="<?php echo($a2); ?>" />
		<input type="hidden" name="p2" value="<?php echo($p2); ?>" />
		<input type="hidden" name="t2" value="<?php echo($t2); ?>" />
	<?php
	}
	?>
	
	<!-- Regular billing -->
	<input type="hidden" name="a3" value="<?php echo($a3); ?>" />
	<input type="hidden" name="p3" value="<?php echo($p3); ?>" />
	<input type="hidden" name="t3" value="<?php echo($t3); ?>" />
	
	<!-- Recurring payments etc -->
	<input type="hidden" name="src" value="<?php echo($src); ?>" />
	<input type="hidden" name="sra" value="<?php echo($sra); ?>" />
	
	<?php
	if ($srt != "0" && $srt != "") {	//recurring times
		?>	
		<input type="hidden" name="srt" value="<?php echo($srt); ?>" />
	<?php
	}
	?>
	
	<!-- Build notation -->
	<input type="hidden" name="bn" value="Withinweb_Cart_WPS" />
	<input type="hidden" name="mrb" value="L9C6XEDHCDXQ2" />

	<!-- //language code, France(FR), Spain (ES), Italy (IT), Germany (DE), China (CN), English (US). -->
	<input type="hidden" name="lc" value="US" />

	<!-- No shipping -->
	<input type="hidden" name="shipping" value="0" />

	<!-- Do not prompt payers for shipping address -->
	<input type="hidden" name="no_shipping" value="1" />
	
	<!-- URLs -->
	<input type="hidden" name="notify_url" value="<?php echo($notify_url); ?>" />
	<?php
	if ($cancel_url != "") {
		?>
		<input type="hidden" name="cancel_return" value="<?php echo($cancel_url); ?>" />
	<?php
	}
	?>
	
	<?php
	if ($return_url != "") {
		?>	
		<input type="hidden" name="return" value="<?php echo($return_url); ?>" />
	<?php
	}

/*
<form name="_xclick" action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_xclick-subscriptions" />	
	<input type="hidden" name="business" value="me@mybusiness.com" />
	<input type="hidden" name="currency_code" value="EUR" />
	<input type="hidden" name="no_note" value="1" />
	<input type="hidden" name="modify" value="0" />
	<input type="hidden" name="item_name" value="test" />
	<input type="hidden" name="item_number" value="item" />	
		
	<input type="hidden" name="a3" value="10.00" />
	<input type="hidden" name="p3" value="4" />
	<input type="hidden" name="t3" value="W" />
	<input type="hidden" name="src" value="1" />
	<input type="hidden" name="sra" value="1" />
		
	<input type="hidden" name="bn" value="Elmwood.PHPSecureArea" />
	<input type="hidden" name="no_shipping" value="1" />	
	<input type="hidden" name="cancel_return" value="htp://www.servername.com/cancel_return.htm" />
	<input type="hidden" name="return" value="htp://www.servername.com/return.htm" />

	<input type="hidden" name="notify_url" value="htp://www.servername.com/phpsecurearea/ipn/confirm.php" />

</form>
*/

}
//-----------------------------------------
/**
*  Purpose : Displays the PayPal hidden variables as applicable
*			to single item buttons which then get posted to 
*			the PayPal server (no subscription)
*/
function showpaypalcmd($item_id) {

	//from tblsetup	:	paypaladdress, currency_code, urls, mc_currency
	//from tblitems :	item_name, amount, item_number

	//Look up post details from tblsetup
	$setup_details 	= gettblsetuppost();

		$paypaladdress 	= $setup_details['paypaladdress'];
		$cancel_url		= $setup_details['cancel_url'];
		$return_url		= $setup_details['return_url'];
		$notify_url		= $setup_details['notify_url'];

		
	//Look up item_number, item_name, and a3, mc_currency and physicalgoods given the item_id
	$item_details 	= gettblitems($item_id);

		$item_name 		= $item_details['item_name'];
		//$mc_gross		= $item_details['mc_gross'];	
		$item_number 	= $item_details['item_number'];
		$mc_currency 	= $item_details['mc_currency'];	
		
		$a3				= $item_details['a3'];		

	?>

	<!-- PayPal Configuration --> 
	<input type="hidden" name="cmd" value="_xclick" /> 
	<input type="hidden" name="business" value="<?php echo($paypaladdress); ?>" />
	<input type="hidden" name="currency_code" value="<?php echo($mc_currency); ?>" />
	<input type="hidden" name="no_note" value="1" />

	<!-- Product Information --> 
	<input type="hidden" name="item_name" value="<?php echo($item_name); ?>" />
	<input type="hidden" name="amount" value="<?php echo($a3); ?>" />
	<input type="hidden" name="item_number" value="<?php echo($item_number); ?>" />

	<!-- Build notation -->
	<input type="hidden" name="bn" value="Withinweb_Cart_WPS" />
	<input type="hidden" name="mrb" value="L9C6XEDHCDXQ2" />

	<!-- //language code, France(FR), Spain (ES), Italy (IT), Germany (DE), China (CN), English (US). -->
	<input type="hidden" name="lc" value="US" />

	<?php
	//Custom entry
	if ( isset( $_POST["custom"] ) ) {
		$custom = $_POST["custom"];
		?>
		<input type="hidden" name="custom" value="<?php echo( $custom ) ?>" />
        <?php
	}	
	
	?>

	<!-- URLs -->
	<input type="hidden" name="notify_url" value="<?php echo($notify_url); ?>" />
	<?php
	if ($cancel_url != "") {
	?>
		<input type="hidden" name="cancel_return" value="<?php echo($cancel_url); ?>" />
	<?php
	}
	?>
	
	<?php
	if ($return_url != "") {
	?>	
		<input type="hidden" name="return" value="<?php echo($return_url); ?>" />
	<?php
	}

}
?>