<?php

//----------------------------------------------
//Common confirm
//----------------------------------------------

//************************************
//  Paul Gibbs copyright 2024
//  paulvgibbs@gmail.com
//************************************

	//#############################################################################	
	//check the ipn result received back from paypal
	if ( preg_match("/INVALID/i", $result) ) {
		$reason = "This is either attempted fraud (check that they have paid before you send anything off) or there is corruption of IPN data between your site and PayPal's site";
		mailmessage($receiver_email, "IPN - INVALID result", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
	} else {

		switch( strtolower( $paypal["payment_status"] ) ) {

			case "completed":		//The payment has been completed and the funds are now in your account.

					//check email address - note the trim of the email addresses						
				if ( strcasecmp( trim( $paypal["receiver_email"] ), trim( $receiver_email ) ) == 0) {

					switch( strtolower( $paypal["txn_type"] ) ) {
						case "web_accept": //"web_accept": The payment was sent by your customer via a Buy Now button.								

							//Transaction OK, so now make further tests.
							//mailmessage($receiver_email, "IPN Single item purchase - Error, single item purchase not supported in this system", $req_format, "", $adminaddress, "", $testmode);

							//Added Version V2.1
							//We need to identify that this purchase has to set the manual flag which is done by $set_manual_flag = 1
							process_subscr_payment($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode, true);
							$reason = "This IPN is for a single item purchase subscription payment\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SINGLE ITEM PURCHASE", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);

							break;

						case "cart":  //"cart": This payment was sent by your customer via the Shopping Cart feature

							//Transaction OK, so now make further tests.
							//Cart not used
							mailmessage($receiver_email, "IPN Shopping cart purchase - Error, cart system not supported in this system", $req_format, "", $adminaddress, "", $testmode);
							break;

						case "send_money":
							$reason = "This payment was sent by your customer from the PayPal website using the Send Money tab\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SOMEBODY SENT MONEY", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						//subscr_signup, subscr_cancel,subscr_failed,subscr_eot,subscr_modify - these do not have a payment_status of Completed	

						case "subscr_payment":
							process_subscr_payment($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode, false);
							$reason = "This IPN is for a subscription payment\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SUBSCRIPTION PAYMENT", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						//case "subscr_eot": //does not have a payment_status of Completed and so is not here
						//	process_subscr_eot($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode);
						//	$reason = "This IPN is for a subscription's end-of-term\r\n";
						//	mailmessage($receiver_email, "IPN - Verified and subscription end of term", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
						//	break;

						//case "subscr_modify": //does not have a payment_status of Completed and so is not here
						//	process_subscr_modify();
						//	$reason = "This IPN is for a modification to a subscription\r\n";
						//	mailmessage($receiver_email, "IPN - Verified and modified", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
						//	break;

						default:
							$reason = "Unknown txn type is received\r\n";
							mailmessage($receiver_email, "IPN - UNKNOWN txn type is received", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;								

						}
						
					}
					else
					{
					$reason = "This usually means that you have multiple emails registered with PayPal but you have not used the primary email address in the PHP-SecureArea admin set up";
					mailmessage($receiver_email, "IPN - VERIFIED but incorrect Receiver_email address", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
					}
					
					break;

			case "pending":	//The payment is pending - see the "pending reason" variable below for more information. 
							//Note: You will receive another instant payment notification when the payment becomes 
							//"completed", "failed", or "denied"

				switch( strtolower ( $paypal["pending_reason"]  )  ) {
					case "address":
						$reason = "The payment is pending because your customer did not include a confirmed shipping address and you, the merchant, have your Payment Receiving Preferences set such that you want to manually accept or deny each of these payments. To change your preference, go to the Preferences section of your Profile";
						break;
					case "echeck":
						$reason = "The payment is pending because it was made by an eCheck, which has not yet cleared";
						break;								
					case "intl":
						$reason = "The payment is pending because you, the merchant, hold an international account and do not have a withdrawal mechanism. You must manually accept or deny this payment from your Account Overview";
						break;								
					case "multi-currency":
						$reason = "You do not have a balance in the currency sent, and you do not have your Payment Receiving Preferences set to automatically convert and accept this payment. You must manually accept or deny this payment";
						break;								
					case "unilateral":
						$reason = "The payment is pending because it was made to an email address that is not yet registered or confirmed.";
						break;								
					case "upgrade":
						$reason = "The payment is pending because it was made via credit card and you, the merchant, must upgrade your account to Business or Premier status in order to receive the funds";
						break;								
					case "verify":
						$reason = "The payment is pending because you, the merchant, are not yet verified. You must verify your account before you can accept this payment";
						break;								
					case "other":
						$reason = "The payment is pending for some other reason. For more information, contact PayPal customer service";
						break;
					default:
						$reason = "Unknown pending reason was received.";
						break;						

					}

				mailmessage($receiver_email, "IPN - VERIFIED and PENDING", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				mailmessage($paypal["payer_email"], "PayPal purchase verified and order is waiting to be processed", $reason . "\r\n", "", $adminaddress, "", $testmode);
				break;
				
			case "failed":					
				$reason = "This only happens if the payment was made from your customer's bank account.\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and FAILED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;
						
			case "denied":
				$reason = "You, the merchant, denied the payment. This will only happen if the payment was previously pending due to one of the pending reasons\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and DENIED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;

			case "refunded";
				$reason = "You refunded the payment\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and REFUNDED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;					

			case "partially-refunded";
				$reason = "The transaction has been partially refunded\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and PARTIALLY-REFUNDED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;
					
			case "expired";
				$reason = "This authorization has expired and cannot be captured\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and EXPIRED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;
				
			case "processed";
				$reason = "A payment has been accepted\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and PROCESSED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;

			case "canceled-reversal";
				$reason = "A reversal has been cancelled. For example, you won a dispute with the customer, and the funds for the transaction that was reversed have been returned to you.\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and CANCELLED-REVERSAL", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;
			
			case "in-progress";
				$reason = "The transaction is in process of authorization and capture\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and IN-PROGRESS", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;
	
			case "reversed";
				$reason = "A payment was reversed due to a chargeback or other type of reversal. The funds have been removed from your account balance and returned to the buyer.\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and REVERSED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;													
			
			case "":	//blank payment_status, so check subscription txt_type
				
				//check email address - note the trim of the email addresses						
				if ( strcasecmp( trim( $paypal["receiver_email"] ), trim( $receiver_email ) ) == 0) {

					switch( strtolower( $paypal["txn_type"] ) ) {

						case "subscr_signup":
							process_subscr_signup($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode);
							$reason = "This IPN is for a subscription sign-up\r\n";								
							mailmessage($receiver_email, "IPN - VERIFIED and SUBSCRIPTION SIGNUP", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						case "subscr_cancel":
							process_subscr_cancel($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode);
							$reason = "This IPN is for a subscription cancellation\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SUBSCRIPTION CANCELLED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						case "subscr_failed":
							process_subscr_failed($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode);
							$reason = "This IPN is for a subscription payment failure\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SUBSCRIPTION FAILED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						//subscr_payment is not here because it has a status of Completed
						//case "subscr_payment": // has a payment_status of Completed
						//	process_subscr_payment($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode, false);
						//	$reason = "This IPN is for a subscription payment\r\n";
						//	mailmessage($receiver_email, "IPN - Verfied and subscription payment", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
						//	break;

						case "subscr_eot":
							process_subscr_eot($paypal, $receiver_email, $adminaddress, $emailsubject, $emailtext, $setup[0]['copyemail'], $testmode);
							$reason = "This IPN is for a subscription's end-of-term\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and SUBSCRIPTION END OF TERM", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						case "subscr_modify":
							process_subscr_modify();
							$reason = "This IPN is for a modification to a subscription, which is not used in this application\r\n";
							mailmessage($receiver_email, "IPN - VERIFIED and MODIFIED ATTEMPTED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;

						default:
							$reason = "Unknown txn type is received\r\n";
							mailmessage($receiver_email, "IPN - UNKNOWN txn type is received", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
							break;								
									
						}

					}
					else
					{
					$reason = "This usually means that you have multiple emails registered with PayPal but you have not used the primary email address in the PHP-SecureArea admin set up";
					mailmessage($receiver_email, "IPN - VERIFIED but incorrect Receiver_email address", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
					}
																
					break;

			default:
				$reason = "Unknown payment status was received : " . $paypal["payment_status"] . "\r\n\r\n";
				mailmessage($receiver_email, "IPN - VERIFIED and FAILED", $reason . "\r\n" . $req_format, "", $adminaddress, "", $testmode);
				break;		
				
		}
				
	}
	//#############################################################################	


	//#############################################################################
	if ($testmode == "true") {	
		?> 
		<br><br>End of test<br><br>
		<?php		
	}
	//#############################################################################	


?>