<?php

//------------------------------------------
//Common ipn functions for sandbox and live PayPal server

//------------------------------------------
//Copyright 2024 Paul Gibbs
//Contact :  paulvgibbs@gmail.com
//------------------------------------------

//	30/12/2024 V2.9.6
//	* removal of unused variables.


//------------------------------------------
//V1.3a Mod to correct problem with saving to tbldownloads when someone
//purchases multiple items with multiple files.
//------------------------------------------


//-----------------------------------------
//posts transaction data using fsockopen. 
function fsockpost($url, $data) { 

	//Parse url 
	$web = parse_url($url); 

	//build post string 
	//foreach($data as $i=>$v) { 
	//	$postdata.= $i . "=" . urlencode($v) . "&"; 
	//}
	
		$postdata = "";

	//stripslashes added
	foreach($data as $i=>$v) { 
		$postdata.= $i . "=" . urlencode(stripslashes($v)) . "&"; 
	}
	
	$postdata .= "cmd=_notify-validate";

	//Set the port number
	if ($web['scheme'] == "https") { $web['port']="443";  $ssl="ssl://"; } else { $web['port']="80"; }  

	//Create paypal connection
	$fp = @fsockopen($ssl . $web['host'], $web['port'], $errnum, $errstr, 30); 

	//Error checking
	if(!$fp) 
		{

//		Debugging
//		//echo "$errnum: $errstr"; 
//		// HTTP error
//		
//		//Send email if there is an http error
		
		} else { //Post Data
 
		fputs($fp, "POST $web[path] HTTP/1.1\r\n"); 
		fputs($fp, "Host: $web[host]\r\n"); 
		fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n"); 
		fputs($fp, "Content-length: ".strlen($postdata)."\r\n"); 
		fputs($fp, "Connection: close\r\n\r\n"); 
		fputs($fp, $postdata . "\r\n\r\n"); 

		//loop through the response from the server 
		while(!feof($fp)) { $info[]=@fgets($fp, 1024); } 

		//close fp - we are done with it 
		fclose($fp); 

		//break up results into a string
		$info = implode(",",$info); 

		}

	return $info; 

}  
/*
//-------------------------------------------
//posts transaction data using libCurl 
function libCurlPost($url, $data)  {

	//build post string 
	//foreach($data as $i=>$v) { 
	//	$postdata.= $i . "=" . urlencode($v) . "&"; 
	//}

	//stripslashes added
	foreach($data as $i=>$v) { 
		$postdata.= $i . "=" . urlencode(stripslashes($v)) . "&"; 
	}

	$postdata.="cmd=_notify-validate";

	$ch=curl_init(); 

	//--------------------------
	//	Standard start
	curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
	curl_setopt($ch,CURLOPT_URL,$url); 
	curl_setopt($ch,CURLOPT_POST,1); 
	curl_setopt($ch,CURLOPT_POSTFIELDS,$postdata); 
	//	Standard end
	//--------------------------	

	//--------------------------
	//	godaddy specific start
	//	curl_setopt($ch, CURLOPT_VERBOSE, 1);
	//	//curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, TRUE);
	//	curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
	//	curl_setopt ($ch, CURLOPT_PROXY,"http://proxy.shr.secureserver.net:3128");
	//	curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	//	curl_setopt ($ch, CURLOPT_URL, $url);
	//	curl_setopt ($ch, CURLOPT_TIMEOUT, 120);	
	//	godaddy specific end
	//--------------------------
	
	//Start ob to prevent curl_exec from displaying stuff. 
	ob_start(); 
	curl_exec($ch);

	//Get contents of output buffer 
	$info=ob_get_contents(); 
	curl_close($ch);

	//End ob and erase contents.  
	ob_end_clean(); 

	return $info; 

}
*/  
//-------------------------------------------
//Format the array into a better list
function format_post($data) {

if ( is_array ($data) ) {
		$file_values = "";
		foreach($data as $key=>$val) {
			$file_values .= "$key = $val\r\n";
		}
		
		return $file_values;

	}
	else
		{ 
		return false; 
		}

}
//------------------------------------------
//Purpose :	Creates variables (single item) which are used in various places for further processing.
function create_local_variables() { 

	//PayPal Configuration 
	
	if ( isset($_POST['business']) ) { $array_name['business'] 				= $_POST['business']; }	
	//Your primary paypal email address	
	if ( isset($_POST['receiver_email']) ) { $array_name['receiver_email']	= $_POST['receiver_email']; }	
	if ( isset($_POST['receiver_id']) ) { $array_name['receiver_id']		= $_POST['receiver_id']; }	

	//A brief description of the item
	if ( isset($_POST['item_name']) ) { $array_name['item_name']			= $_POST['item_name']; }
	//The item identity which is used to define the item
	if ( isset($_POST['item_number']) ) { $array_name['item_number']		= $_POST['item_number']; }
	
	//Currency code	
	if ( isset($_POST['mc_currency']) ) { $array_name['mc_currency']		= $_POST['mc_currency']; }
	if ( isset($_POST['quantity']) ) { $array_name['quantity']				= $_POST['quantity']; }	
	if ( isset($_POST['invoice']) ) { $array_name['invoice']				= $_POST['invoice']; }
	if ( isset($_POST['custom']) ) { $array_name['custom']					= $_POST['custom']; }
	if ( isset($_POST['memo']) ) { $array_name['memo']						= $_POST['memo']; }
	if ( isset($_POST['tax']) ) { $array_name['tax']						= $_POST['tax']; }
	if ( isset($_POST['option_name1']) ) { $array_name['option_name1']		= $_POST['option_name1']; }
	if ( isset($_POST['option_selection1']) ) { $array_name['option_selection1']		= $_POST['option_selection1']; }
	if ( isset($_POST['option_name2']) ) { $array_name['option_name2']					= $_POST['option_name2']; }
	if ( isset($_POST['option_selection2']) ) { $array_name['option_selection2']		= $_POST['option_selection2']; }
	if ( isset($_POST['num_cart_items']) ) { $array_name['num_cart_items']		= $_POST['num_cart_items']; }
	if ( isset($_POST['mc_gross']) ) { $array_name['mc_gross']				= $_POST['mc_gross']; }
	if ( isset($_POST['mc_fee']) ) { $array_name['mc_fee']					= $_POST['mc_fee']; }
	if ( isset($_POST['mc_currency']) ) { $array_name['mc_currency']		= $_POST['mc_currency']; }
	if ( isset($_POST['settle_amount']) ) { $array_name['settle_amount']	= $_POST['settle_amount']; }	
	if ( isset($_POST['settle_currency']) ) { $array_name['settle_currency']	= $_POST['settle_currency']; }		
	if ( isset($_POST['exchange_rate']) ) { $array_name['exchange_rate']	= $_POST['exchange_rate']; }		
	if ( isset($_POST['payment_fee']) ) { $array_name['payment_fee']		= $_POST['payment_fee']; }		
	if ( isset($_POST['payment_status']) ) { $array_name['payment_status']	= $_POST['payment_status']; }		
	if ( isset($_POST['pending_reason']) ) { $array_name['pending_reason']	= $_POST['pending_reason']; }		
	if ( isset($_POST['reason_code']) ) { $array_name['reason_code']		= $_POST['reason_code']; }		
	if ( isset($_POST['payment_date']) ) { $array_name['payment_date']		= $_POST['payment_date']; }		

	//The PayPal transaction id
	if ( isset($_POST['txn_id']) ) { $array_name['txn_id']					= $_POST['txn_id']; }		
	
	//The type of paypal transaction
	if ( isset($_POST['txn_type']) ) { $array_name['txn_type']				= $_POST['txn_type']; }	
	if ( isset($_POST['payment_type']) ) { $array_name['payment_type']		= $_POST['payment_type']; }	
	if ( isset($_POST['for_auction']) ) { $array_name['for_auction']		= $_POST['for_auction']; }			
	if ( isset($_POST['auction_buyer_id']) ) { $array_name['auction_buyer_id']		= $_POST['auction_buyer_id']; }				
	if ( isset($_POST['auction_closing_date']) ) { $array_name['auction_closing_date']	= $_POST['auction_closing_date']; }				
	if ( isset($_POST['auction_multi_item']) ) { $array_name['auction_multi_item']		= $_POST['auction_multi_item']; }	
	if ( isset($_POST['first_name']) ) { $array_name['first_name']			= $_POST['first_name']; }				
	if ( isset($_POST['last_name']) ) { $array_name['last_name']			= $_POST['last_name']; }				
	if ( isset($_POST['payer_business_name']) ) { $array_name['payer_business_name']	= $_POST['payer_business_name']; }				
	if ( isset($_POST['address_name']) ) { $array_name['address_name']		= $_POST['address_name']; }				
	if ( isset($_POST['address_street']) ) { $array_name['address_street']	= $_POST['address_street']; }				
	if ( isset($_POST['address_city']) ) { $array_name['address_city']		= $_POST['address_city']; }
	if ( isset($_POST['address_state']) ) { $array_name['address_state']	= $_POST['address_state']; }
	if ( isset($_POST['address_zip']) ) { $array_name['address_zip']		= $_POST['address_zip']; }
	if ( isset($_POST['address_country']) ) { $array_name['address_country']	= $_POST['address_country']; }
	if ( isset($_POST['address_status']) ) { $array_name['address_status']	= $_POST['address_status']; }

	//The email address of the person who is purchasing the product
	if ( isset($_POST['payer_email']) ) { $array_name['payer_email']		= $_POST['payer_email']; }
	if ( isset($_POST['payer_id']) ) { $array_name['payer_id']				= $_POST['payer_id']; }	

	//Will be COMPLETE if transaction is complete
	if ( isset($_POST['payer_status']) ) { $array_name['payer_status']		= $_POST['payer_status']; }		
	if ( isset($_POST['notify_version']) ) { $array_name['notify_version']	= $_POST['notify_version']; }			
	if ( isset($_POST['verify_sign']) ) { $array_name['verify_sign']		= $_POST['verify_sign']; }			

 
 	//subscription sign up details 	
	//https://www.paypal.com/en_US/ebook/subscriptions/Appx-ipn_subscription_variables.html
	
	//(optional) Trial subscription interval in days, weeks, months, years (example: a 4 day interval is �period1: 4 D�).
	if ( isset($_POST['period1']) ) { $array_name['period1']			= $_POST['period1']; }
	//(optional) Trial subscription interval in days, weeks, months, or years.
	if ( isset($_POST['period2']) ) { $array_name['period2']			= $_POST['period2']; }
	//Regular subscription interval in days, weeks, months, or years.
	if ( isset($_POST['period3']) ) { $array_name['period3']			= $_POST['period3']; }	
	//Amount of payment for trial period 1 for USD payments; otherwise blank (optional).
	if ( isset($_POST['amount1']) ) { $array_name['amount1']			= $_POST['amount1']; }	
	//Amount of payment for trial period 2 for USD payments; otherwise blank (optional)
	if ( isset($_POST['amount2']) ) { $array_name['amount2']			= $_POST['amount2']; }	
	//Amount of payment for regular subscription period for USD payments; otherwise blank.
	if ( isset($_POST['amount3']) ) { $array_name['amount3']			= $_POST['amount3']; }	
	//Amount of payment for trial period 1, regardless of currency (optional).
	if ( isset($_POST['mc_amount1']) ) { $array_name['mc_amount1']		= $_POST['mc_amount1']; }
	//Amount of payment for trial period 2, regardless of currency (optional).
	if ( isset($_POST['mc_amount2']) ) { $array_name['mc_amount2']		= $_POST['mc_amount2']; }	
	//Amount of payment for regular subscription period, regardless of currency.
	if ( isset($_POST['mc_amount3']) ) { $array_name['mc_amount3']		= $_POST['mc_amount3']; }	
	if ( isset($_POST['subscr_id']) ) { $array_name['subscr_id']		= $_POST['subscr_id']; }	
	if ( isset($_POST['subscr_date']) ) { $array_name['subscr_date']	= $_POST['subscr_date']; }	
	if ( isset($_POST['subscr_effective']) ) { $array_name['subscr_effective']	= $_POST['subscr_effective']; }	

	if ( isset($_POST['recurring']) ) { $array_name['recurring']	= $_POST['recurring']; }	
	if ( isset($_POST['reattempt']) ) { $array_name['reattempt']	= $_POST['reattempt']; }		
	if ( isset($_POST['retry_at']) ) { $array_name['retry_at']		= $_POST['retry_at']; }
	if ( isset($_POST['recur_times']) ) { $array_name['recur_times']		= $_POST['recur_times']; }	
	if ( isset($_POST['username']) ) { $array_name['username']		= $_POST['username']; }	
	if ( isset($_POST['password']) ) { $array_name['password']		= $_POST['password']; }	

	//auction specific vars
	if ( isset($_POST['for_auction']) ) { $array_name['for_auction']		= $_POST['for_auction']; }		
	if ( isset($_POST['auction_closing_date']) ) { $array_name['auction_closing_date']		= $_POST['auction_closing_date']; }	
	if ( isset($_POST['auction_multi_item']) ) { $array_name['auction_multi_item']		= $_POST['auction_multi_item']; }
	if ( isset($_POST['auction_buyer_id']) ) { $array_name['auction_buyer_id']		= $_POST['auction_buyer_id']; }
	
return $array_name; 

/*
if ( is_array ($data) ) {
		$file_values = "";
		foreach($data as $key=>$val) {
			$array_name[trim($key)] = trim($val);			
		}
		
		return $array_name;

	}
	else
		{ 
		return false; 
		}
*/

}
//-----------------------------------------
//Subscription sign up
//Check if the a3, p3, t3, src, sra, srt values are correct
//Check if the mc_currency code is correct
//Check if txn_id has been used before
//Save the data to the database
//Send the email
function process_subscr_payment($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode, $set_manual_flag) {

	$txn_id 		=	$paypal['txn_id'];
	$item_number 	=	$paypal['item_number'];	
	$item_name 		=	$paypal['item_name'];
	$payment_status =	$paypal['payment_status'];
	$mc_currency	=	$paypal['mc_currency'];
	$receiver_email	=	$paypal['receiver_email'];
	$payer_email	=	$paypal['payer_email'];
	$mc_gross		= 	$paypal['mc_gross'];
	if ( isset($_POST['custom']) ) 
			{ 
				$custom = $_POST['custom']; 
			}
		else
			{
				$custom = "";
			}
	
	/*
	echo("test mode : $testmode<br/>"); 
	echo("txn_id : $txn_id<br>");
	echo("item_number : $item_number<br>");
	echo("item_name : $item_name<br>");	
	echo("payment_status : $payment_status<br>");	
	echo("mc_currency : $mc_currency<br>");	
	echo("receiver_email : $receiver_email<br>");	
	echo("payer_email : $payer_email<br>");	
	echo("email text : $emailtext<br>");		
	echo("mc_gross : $mc_gross<br>");	
	exit;
	*/
	
	//Get tblitems details given the item_number
	$item_details 		= gettblitems_number($item_number);

		$dbmc_amount1	= 	$item_details["a1"];
		$dbmc_amount2	= 	$item_details["a2"];
		$dbmc_gross		=	$item_details['a3'];
		$dbmc_currency	=	$item_details['mc_currency'];

	/*
	echo("dbmc_gross : $dbmc_gross<br>");
	echo("dbmc_currency : $dbmc_currency<br>");
	exit;
	*/

	//if any of the following are wrong, we don't actually need to do anything.  If the person doesnot pay, then
	//an end of term will come through from PayPal anyway.

	//Regular billing		if (mc_gross < dbmc_gross)		PayPal payment must be equal to or greater than database payment
															//Means we don't have to worry about Tax etc
															
	$found = false;		//Flag to define if the correct amount has been found or not.
	$checked = false;	//Flag to define if the amount has been checked or not.
	if ($dbmc_amount1 != "") {	//Now check each value
		//if ($mc_gross == $dbmc_amount1) {
		if ( strcmp($mc_gross, $dbmc_amount1 ) == 0 ) {
			$found = true;
			$checked = true;
			//mailmessage($toaddress, "IPN - Error (1)", "mc_gross : $mc_gross ; mc_amount1 : $dbmc_amount1", "", $fromaddress, "", $testmode);
		}
	}

	if ($dbmc_amount2 != "") {	//Now check each value	
		//if ($mc_gross == $dbmc_amount2) {
		if ( strcmp($mc_gross, $dbmc_amount2 ) == 0 ) {
			$found = true;
			$checked = true;
			//mailmessage($toaddress, "IPN - Error (2)", "mc_gross : $mc_gross ; mc_amount2 : $dbmc_amount2", "", $fromaddress, "", $testmode);			
		}
	}

	if ($checked == false) {	//Only check this if the amount has not been checked.
		//if ( $mc_gross == $dbmc_gross ) {
		if ( strcmp($mc_gross, $dbmc_gross ) == 0 ) {
			$found = true;
			//mailmessage($toaddress, "IPN - Error (3)", "mc_gross : $mc_gross ; dbmc_gross : $dbmc_gross", "", $fromaddress, "", $testmode);			
		}
	}
															
	
	//If amount not found then send am email
	if ( $found == false ) {
		mailmessage($toaddress, "IPN - Error : mc_gross is not correct", "No action taken\r\nDatabase entry : mc_gross : $mc_gross ; dbmc_gross : $dbmc_gross; amount1 : $dbmc_amount1 ; amount2 : $dbmc_amount2 ", "", $fromaddress, "", $testmode);
		exit;
	}
	
	//Now check if the currency code is the same as in the database		
	if (strcmp($dbmc_currency, $mc_currency) != 0) {			
		mailmessage($toaddress, "IPN - Error : Currency Code is not correct", "No action taken\r\nDatabase entry : $dbmc_currency, mc_currency : $mc_currency", "", $fromaddress, "", $testmode);
		exit;
	}
	//Now check if the txn_id has been used before
	if (checktxnid($txn_id, $toaddress, $fromaddress, $testmode) != 0) {	
		//mailmessage($toaddress, "IPN - Error : Txn_ID has been duplicated", "No action taken\r\ntxn_id : $txn_id", "", $fromaddress, "", $testmode);
		exit;		
	}
	

	//---------------------------------------
	//Everything OK	 ---- now create the user
	
	//Check if this user exists, if yes then decrypt password, if no then create a new password
	//End up with $password_plain, $password_encrypt and $iv for the user. 

	//	if user exists
	//		$password_plain = 
	//		$password_encrypt = 
	//	else
	//		$password_plain = createpw();	//unencrypted password
	//		$password_encrypt = 
	//	end if

	if ( $custom != "" ) {		//If custom field is not empty then this means that this is a new sign up process using the signup form	
								//$custom is actually userid
								//In this case just create the password
		
		$password_plain = createpw();
	
		srand(make_seed());
		$iv = rand(1, 500);

		$encryption = new password($iv, $password_plain);
		$encryption->encode();
		$password_encrypt = $encryption->getencodedtext();
		
	} else {
	
			//Check if user exists in tbluser
			$table = userintbluser($payer_email);

			if ( count($table) == 0 ) {		//user does not exist, then create a new password

				$password_plain = createpw();
	
				srand(make_seed());
				$iv = rand(1, 500);

				$encryption = new password($iv, $password_plain);
				$encryption->encode();
				$password_encrypt = $encryption->getencodedtext();
		
			}
			else	//get the existing password
			{
	
				$message = "";
		
				$password_plain = getpassword($payer_email, $message);
				$iv = $table[0]['iv'];
				$password_encrypt = $table[0]['password'];

				if ( $message != "") {
					$emailsubject = "Get password error - com_ipnfunctions.php ref 3";
					mailmessage($toaddress, $emailsubject, $message, "", $fromaddress, "", $testmode);
					exit;		
				}

			}

	}
	
	//echo($password_encrypt . "<br>");
	//echo($iv . "<br>");
	//echo($password_plain . "<br>");
	//exit;
	
	//Given the $item_number, look up the details from tblitems for this item	
	$userdetails = getuserdetails($item_number);	

		$securearea_id = $userdetails['securearea_id'];

		$message = "";

	//Create the new user
	$result = signupuser($custom, $payer_email, $password_plain, $password_encrypt, $iv, $item_number, $securearea_id, $message, $set_manual_flag);

	if ( $result == false ) {
		$emailsubject = "Error creating new user - com_ipnfunctions.php ref 4";
		mailmessage($toaddress, $emailsubject, $message, "", $fromaddress, "", $testmode);
		exit;		
	}

	//send login details to customer
	$testmode = "false";
	sendlogindetails($paypal['payer_email'], $password_plain, $item_number, $testmode);


	//--------------------------------------------
	//Save transaction details to tblsaleshistory
	//INSERT INTO sec_tblsaleshistory (txn_id, item_number, item_name, payment_status, mc_gross, mc_currency, receiver_email, payer_email) VALUES ($txn_id, $item_number, $mc_gross, $mc_currency, $receiver_email, $payer_email)
	//Add payment to transactions history
	//May need to check if mc_gross is correct value.
	//mc_gross is the total amount paid less fees
	//Not sure about checking mc_gross as I don't think we
	//can identify whether its trial 1 or 2 or regular 

	$txn_id 		=	$paypal['txn_id'];
	$item_number 	=	$paypal['item_number'];	
	$item_name 		=	$paypal['item_name'];
	$payment_status =	$paypal['payment_status'];
	$mc_gross		=	$paypal['mc_gross'];
	$mc_currency	=	$paypal['mc_currency'];	
	$receiver_email	=	$paypal['receiver_email'];
	$payer_email	=	$paypal['payer_email'];
	$currentdate 	= 	date("Y-m-d H:i:s");	//date("Y-m-d H:i:s") for database

	$completed			=	$currentdate;
	
	//$item_name 			= 	$item_name;	
	//$receiver_email 	= 	$receiver_email;		
	//$payer_email 		= 	$payer_email;
	
	
	if ( isset( $paypal["custom"] ) ) { $custom = $paypal["custom"]; } else { $custom = ""; }
	if ( isset( $paypal["business"] ) ) { $business = substr( $paypal["business"] , 0, 254); } else { $business = ""; }
	if ( isset( $paypal["receiver_id"] ) ) { $receiver_id = substr( $paypal["receiver_id"] , 0, 254); } else { $receiver_id = ""; }
	if ( isset( $paypal["invoice"] ) ) { $invoice = substr( $paypal["invoice"] , 0, 254); } else { $invoice = ""; }
	if ( isset( $paypal["memo"] ) ) { $memo = $paypal["memo"]; } else { $memo = ""; }	
	if ( isset( $paypal["tax"] ) ) { $tax = substr( $paypal["tax"] , 0, 254); } else { $tax = ""; }
	if ( isset( $paypal["option_name1"] ) ) { $option_name1 = substr( $paypal["option_name1"] , 0, 254); } else { $option_name1 = ""; }
	if ( isset( $paypal["option_selection1"] ) ) { $option_selection1 = substr( $paypal["option_selection1"] , 0, 254); } else { $option_selection1 = ""; }
	if ( isset( $paypal["option_name2"] ) ) { $option_name2 = substr( $paypal["option_name2"] , 0, 254); } else { $option_name2 = ""; }	
	if ( isset( $paypal["option_selection2"] ) ) { $option_selection2 = substr( $paypal["option_selection2"] , 0, 254); } else { $option_selection2 = ""; }
	if ( isset( $paypal["num_cart_items"] ) ) { $num_cart_items = substr( $paypal["num_cart_items"] , 0, 254); } else { $num_cart_items = ""; }
	if ( isset( $paypal["mc_fee"] ) ) { $mc_fee = substr( $paypal["mc_fee"] , 0, 254); } else { $mc_fee = ""; }	
	if ( isset( $paypal["payment_date"] ) ) { $payment_date = substr( $paypal["payment_date"] , 0, 254); } else { $payment_date = ""; }
	if ( isset( $paypal["payment_type"] ) ) { $payment_type = substr( $paypal["payment_type"] , 0, 254); } else { $payment_type = ""; }	
	if ( isset( $paypal["first_name"] ) ) { $first_name = substr( $paypal["first_name"] , 0, 254); } else { $first_name = ""; }		
	if ( isset( $paypal["last_name"] ) ) { $last_name = substr( $paypal["last_name"] , 0, 254); } else { $last_name = ""; }
	if ( isset( $paypal["payer_business_name"] ) ) { $payer_business_name = substr( $paypal["payer_business_name"] , 0, 254); } else { $payer_business_name = ""; }
	if ( isset( $paypal["address_name"] ) ) { $address_name = substr( $paypal["address_name"] , 0, 254); } else { $address_name = ""; }	
	if ( isset( $paypal["address_street"] ) ) { $address_street = substr( $paypal["address_street"] , 0, 254); } else { $address_street = ""; }	
	if ( isset( $paypal["address_city"] ) ) { $address_city = substr( $paypal["address_city"] , 0, 254); } else { $address_city = ""; }	
	if ( isset( $paypal["address_state"] ) ) { $address_state = substr( $paypal["address_state"] , 0, 254); } else { $address_state = ""; }	
	if ( isset( $paypal["address_zip"] ) ) { $address_zip = substr( $paypal["address_zip"] , 0, 254); } else { $address_zip = ""; }
	if ( isset( $paypal["address_country"] ) ) { $address_country = substr( $paypal["address_country"] , 0, 254); } else { $address_country = ""; }
	if ( isset( $paypal["address_status"] ) ) { $address_status = substr( $paypal["address_status"] , 0, 254); } else { $address_status = ""; }	
	if ( isset( $paypal["payer_id"] ) ) { $payer_id = substr( $paypal["payer_id"] , 0, 254); } else { $payer_id = ""; }
	if ( isset( $paypal["payer_status"] ) ) { $payer_status = substr( $paypal["payer_status"] , 0, 254); } else { $payer_status = ""; }
	if ( isset( $paypal["notify_version"] ) ) { $notify_version = substr( $paypal["notify_version"] , 0, 254); } else { $notify_version = ""; }	
	if ( isset( $paypal["verify_sign"] ) ) { $verify_sign = substr( $paypal["verify_sign"] , 0, 254); } else { $verify_sign = ""; }	
	
	if ( $testmode == "true" ) {	
		$payment_status = "Test Mode";
	}	
	
	$rowsaffected = insertsaleshistory($custom, $business, $receiver_id, $invoice, $memo, $tax, $option_name1, $option_selection1, 
								$option_name2, $option_selection2, $num_cart_items, $mc_fee, $payment_date, $payment_type, $first_name, $last_name, $payer_business_name, $address_name, $address_street, $address_city, $address_state, $address_zip, $address_country, $address_status, $payer_id, $payer_status, $notify_version, $verify_sign,
								$txn_id, $item_number, $item_name, $payment_status, $mc_gross, $mc_currency, $receiver_email, 
								$payer_email, $completed);	
	
	if ($rowsaffected == 0) {
		$emailsubject = "SQL error - com_ipnfunctions.php ref 5";
		$emailtext = "No record created";			
		mailmessage($toaddress, $emailsubject, $emailtext, "", $fromaddress, "", $testmode);		
		exit;	
		}	

}
//-----------------------------------------
//Subscription cancelled
//Don't have to do anything for this because at eot an eot IPN will be sent which does the work
//Just sends an email to admin to say someone has cancelled
function process_subscr_cancel($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode) {
	
	//http://www.pdncommunity.com/pdn/board/message?board.id=ipn&message.id=17497
	//https://www.x.com/message/155532 suggests that subscr_eot are not sent out for some accounts.

	//sub cancel is the same as sub eot
	process_subscr_eot($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode);
	
}
//-----------------------------------------
//Subscription sign up - The mainprocesing is done in the subscription payment function
//Just sends an email to admin to say someone has signed up
function process_subscr_signup($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode) {

	//Check amount1, amount2, amount3 and period1, period2, and period3
	if ( isset($amount1) ) { $amount1 = $paypal["amount1"]; } else { $amount1 = ""; }
	if ( isset($amount2) ) { $amount2 = $paypal["amount2"]; } else { $amount2 = ""; }
	if ( isset($amount3) ) { $amount3 = $paypal["amount3"]; } else { $amount3 = ""; }

	if ( isset($period1) ) { $period1 = $paypal["period1"]; } else { $period1 = ""; }
	if ( isset($period2) ) { $period2 = $paypal["period2"]; } else { $period2 = ""; }
	if ( isset($period3) ) { $period3 = $paypal["period3"]; } else { $period3 = ""; }

	$item_number 	=	$paypal['item_number'];	

		//Get tblitems details given the item_number
		$item_details 		= gettblitems_number($item_number);

		$db_amount1		=	$item_details['a1'];	//Trial amount 1. This is the price of the first trial period. For a free trial, use a value of 0.
		$db_amount2		=	$item_details['a2'];	//Trial amount 2. This is the price of the second trial period.
		$db_amount3		=	$item_details['a3'];	//[required] Regular rate. This is the price of the subscription.				

		//$db_period1		=	$item_details['t1'];	//Trial period 1 units. This is the units of trial period 1 (p1, above). Acceptable values are: D (days), W (weeks), M (months), Y (years).	
		//$db_period2		=	$item_details['t2'];	//Trial period 2 units. This is the units of trial period 2 (p2, above). Acceptable values are: D (days), W (weeks), M (months), Y (years).
		//$db_period3		=	$item_details['t3'];	//[required] Regular billing cycle units. This is the units of the regular billing cycle (p3, above) Acceptable values are: 
													//D (days), W (weeks), M (months), Y (years)	
	
	//echo($db_amount1 . "<br/>");
	//echo($db_amount2 . "<br/>");
	//echo($db_amount3 . "<br/>");		
	//echo($db_period1 . "<br/>");	
	//echo($db_period2 . "<br/>");	
	//echo($db_period3 . "<br/>");		
	//echo($item_number . "<br/>");	
	//exit;
	
	
	if ($amount1 != "") {
		if ($amount1 != $db_amount1) {
			$emailsubject = "Trial period 1 does not match database value";
			$emailtext = $paypal["payer_email"];
			mailmessage($toaddress, $emailsubject, $emailtext, "", $fromaddress, "", $testmode);		
			exit;	
		}
	}

	if ($amount2 != "") {
		if ($amount2 != $db_amount2) {
			$emailsubject = "Trial period 2 does not match database value";
			$emailtext = $paypal["payer_email"];
			mailmessage($toaddress, $emailsubject, $emailtext, "", $fromaddress, "", $testmode);		
			exit;	
		}		
	}

	if ($amount3 != "") {
		if ($amount3 != $db_amount3) {
			$emailsubject = "Subscription amount does not match database value";
			$emailtext = $paypal["payer_email"];
			mailmessage($toaddress, $emailsubject, $emailtext, "", $fromaddress, "", $testmode);		
			exit;			
		}		
	}


}
//-----------------------------------------
//Subscription failed
function process_subscr_failed($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode) {

	//Remove user from htpasswd files(s).
	//Do NOT set eot flag to true as that is done by subscr_eot. 

	
	//Delete the user for this securearea_id number.  
	//That is, only delete the user for this item_number and not for any other item numbers.

	$item_number = $paypal['item_number'];	
	
	//Given the $item_number, look up the details from tblitems for this item	
	$userdetails = getuserdetails($item_number);
	
	//Delete this user from htpasswd file, set in_htpwasswd flag to false.
	//This is for the given user details i.e. securearea_id, item number and so on
	
	$message = "";
	$payer_email = $paypal['payer_email'];
	$securearea_id = $userdetails['securearea_id'];
	
	$result = disableuser($payer_email, $securearea_id, $message);
	
	if ( $result == false ) {
		$emailsubject = "Error processing subscription failed - com_ipnfunctions.php ref 6";
		mailmessage($toaddress, $emailsubject, $message, "", $fromaddress, "", $testmode);
		exit;
	}	

	
}
//-----------------------------------------
//Subscription end of term
//I have found that this does not seem to get sent out now by PayPal.
//To get over this you need to set up the CRON job so that any expired subscriptions will be cancelled by the CRON job script
function process_subscr_eot($paypal, $toaddress, $fromaddress, $emailsubject, $emailtext, $copyemail, $testmode) {

	//Remove user from htpasswd files(s)
	//Set eot flag to true	
	
	
	//Delete the user for this securearea_id number.  
	//That is, only delete the user for this item_number and not for any other item numbers.

	$item_number = $paypal['item_number'];	
	$payer_email = $paypal['payer_email'];
	
	//Given the $item_number, look up the details from tblitems for this item	
	$userdetails = getuserdetails($item_number);
	
	$securearea_id = $userdetails['securearea_id'];
	$message = "";

	//echo($securearea_id . "<br/>");
	//echo($item_number . "<br/>");
	//echo($payer_email . "<br/>");
	//exit;

	//Delete this user for the given user details i.e. securearea_id, item number and so on	
	$result = disableuser($payer_email, $securearea_id, $message);

	if ( $result == false ) {
		$emailsubject = "SQL error - com_ipnfunctions.php ref 7 - no update";
		mailmessage($toaddress, $emailsubject, $message, "", $fromaddress, "", $testmode);
		//exit();	
	}

	$message = "";
	
	//set eot flag
	$result = seteot( $payer_email, $securearea_id, $message );

	if ( $result == false ) {
		//$emailsubject = "Warning - com_ipnfunctions.php ref 8 - no update to end of term for " . $payer_email . " .  This may mean an update was not required as the end of term may already be set.";
		//mailmessage($toaddress, $emailsubject, $message, "", $fromaddress, "", $testmode);
		//exit();	
	}

}
//-----------------------------------------
//Subscription modify
function process_subscr_modify() {
//not used - I do not allow modification of subscription
//An email is sent to the admin for this

//The subscription button has modify value = 0 in it to indicate that you do not allow 
//subscription modifications
}

?>