<?php session_start();

//------------------------------------------
//Copyright 2024 Paul Gibbs
//Contact :  paulvgibbs@gmail.com
//------------------------------------------

//  30/12/2024 V2.9.6
//	* unused variables removed

//----------------------------------------------------------------
require_once("../error.php");
require_once('../functions/misc.php');
require_once("../classes/clsinput.php");
require_once("../classes/clsvalidate.php");
require_once("../dbclass/Db.class.php");
//----------------------------------------------------------------

//----------------------------------------------------------------
main();


//----------------------------------------------------------------
//Purpose : The main function that is run each time the page is displayed
function main() {

	$payer_email = "";
	
	$a3 	= input::get('a3');
	$recid	= input::get('recid');
	
	//echo("a3: " . $a3 . "<br/>");
	//echo("recid: " . $recid . "<br/>");
	
	if ( $a3 != "" ) { if ( !is_numeric( $a3 )) { exit(); } }	
	if ( !is_numeric( $recid )) { exit(); }
	
	//If this is a post back in situations where the cost is "0.00" then
	//the entry is created as a manual entry 
	if ( $a3 != "" ) {

		if ( $a3 == "0.00" ) {		//If 0.00 for cost			
		
			$tableitems = gettblitems($recid);
				$item_number = $tableitems["item_number"];	//Get item_number		
			
			$payer_email = input::get('email');		//check email address	
				if (!filter_var($payer_email, FILTER_VALIDATE_EMAIL)) {
    				exit();
				}			
			
			$active = "on";
			$sendpassword = "on";

			$email 			= filter_var(input::get('email'), FILTER_SANITIZE_EMAIL);
			$name			= filter_var(input::get('name'), FILTER_SANITIZE_STRING);
			$phone			= filter_var(input::get('phone'), FILTER_SANITIZE_STRING);
			$mobile			= filter_var(input::get('mobile'), FILTER_SANITIZE_STRING);
			$addressline1	= filter_var(input::get('addressline1'), FILTER_SANITIZE_STRING);
			$addressline2	= filter_var(input::get('addressline2'), FILTER_SANITIZE_STRING);
			$city			= filter_var(input::get('city'), FILTER_SANITIZE_STRING);
			$state			= filter_var(input::get('state'), FILTER_SANITIZE_STRING);
			$country		= filter_var(input::get('country'), FILTER_SANITIZE_STRING);
			$zip			= filter_var(input::get('zip'), FILTER_SANITIZE_STRING);			
	
		
			$_SESSION['email'] 			= $email;
			$_SESSION['name'] 			= $name;			
			$_SESSION['phone'] 			= $phone;
			$_SESSION['mobile'] 		= $mobile;			
			$_SESSION['addressline1'] 	= $addressline1;			
			$_SESSION['addressline2'] 	= $addressline2;
			$_SESSION['city'] 			= $city;
			$_SESSION['state'] 			= $state;			
			$_SESSION['country'] 		= $country;									
			$_SESSION['zip'] 			= $zip;

			//Process for 0.00 cost
			processcreate000($payer_email, $active, $item_number, $sendpassword, $email, $name, $phone, $mobile, 
							 		$addressline1, $addressline2, $city, $state, $country, $zip, $a3, $recid);
			exit();

		} else {		//If not 0.00 for cost
			
			$tableitems = gettblitems($recid);			
				$item_number = $tableitems["item_number"];	//Get item_number			
			
			
			$active = "on";
			$sendpassword = "on";		
		
			//	Collect together the details that the person has entered into the sign up form
			//	Create a new record in the sec_tblusers table
			//	Get the record id of the newly created record
			//	Use the record id as the comment field to post to PayPal			
			//	Post to PayPal		
		
			$email 			= filter_var(input::get('email'), FILTER_SANITIZE_EMAIL);
			$name			= filter_var(input::get('name'), FILTER_SANITIZE_STRING);
			$phone			= filter_var(input::get('phone'), FILTER_SANITIZE_STRING);
			$mobile			= filter_var(input::get('mobile'), FILTER_SANITIZE_STRING);
			$addressline1	= filter_var(input::get('addressline1'), FILTER_SANITIZE_STRING);
			$addressline2	= filter_var(input::get('addressline2'), FILTER_SANITIZE_STRING);
			$city			= filter_var(input::get('city'), FILTER_SANITIZE_STRING);
			$state			= filter_var(input::get('state'), FILTER_SANITIZE_STRING);
			$country		= filter_var(input::get('country'), FILTER_SANITIZE_STRING);
			$zip			= filter_var(input::get('zip'), FILTER_SANITIZE_STRING);			
			
			$_SESSION['email'] 			= $email;
			$_SESSION['name'] 			= $name;			
			$_SESSION['phone'] 			= $phone;
			$_SESSION['mobile'] 		= $mobile;			
			$_SESSION['addressline1'] 	= $addressline1;			
			$_SESSION['addressline2'] 	= $addressline2;
			$_SESSION['city'] 			= $city;
			$_SESSION['state'] 			= $state;			
			$_SESSION['country'] 		= $country;									
			$_SESSION['zip'] 			= $zip;
		
			//Process for costs other than 0.00
			processcreate($active, $item_number, $sendpassword, $email, $name, $phone, $mobile, $addressline1, 
						  				$addressline2, $city, $state, $country, $zip, $a3, $recid);
			exit();		
		
		}
		
	}	
		
	//Get cost and item_number	
	$tableitems = gettblitems($recid);			
		$item_number = $tableitems['item_number'];	//Get item_number
		$a3 = $tableitems['a3'];	
	
	//Display the subscription form
	display($a3, $item_number, $recid, "");

}
//----------------------------------------------------------------
//Purpose : Display the subscription form
//Inputs : 	$a3 is the cost of the subscription
//			$item_number is the item number of the Subscription
//			$validation_errormsg is any error message returned
function display($a3, $item_number, $recid, $validation_errormsg) {

require("lang/file.php");
	
	$email 			= filter_var(input::get('email'), FILTER_SANITIZE_EMAIL);
	$name			= filter_var(input::get('name'), FILTER_SANITIZE_STRING);
	$phone			= filter_var(input::get('phone'), FILTER_SANITIZE_STRING);
	$mobile			= filter_var(input::get('mobile'), FILTER_SANITIZE_STRING);
	$addressline1	= filter_var(input::get('addressline1'), FILTER_SANITIZE_STRING);
	$addressline2	= filter_var(input::get('addressline2'), FILTER_SANITIZE_STRING);
	$city			= filter_var(input::get('city'), FILTER_SANITIZE_STRING);
	$state			= filter_var(input::get('state'), FILTER_SANITIZE_STRING);
	$country		= filter_var(input::get('country'), FILTER_SANITIZE_STRING);
	$zip			= filter_var(input::get('zip'), FILTER_SANITIZE_STRING);	

?><!DOCTYPE html>
<html lang="en">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<title><?php echo($L_TITLE); ?></title>
			<script type="text/javascript" src="scripts/jquery-1.2.6.pack.js"></script>
			<script type="text/javascript">

				$(function(){
					// Grab each form element
					$("label[title]").each(function(){
						$(this).append("<div class=\"infopop\">");	
						titletext = $(this).attr("title");
						$(this).removeAttr("title");
						$(".infopop",this).css({opacity:0}).html(titletext);
						$("input",this).focus(function(){
							// Mouseover
							doFocus(this);
						}).blur(function(){
							// MouseOut
							doBlur(this);
						});
					});
				});
			
				//Add class active and animate info bubble
				function doFocus(obj) {
					$(obj).addClass("active").parents("label").addClass("active").find(".infopop").animate({opacity:1,left:492},500);
				}
			
				function doBlur(obj) {
					if (validate(obj)) { 
						isGood(obj);
					}
				}
			
				function reportErr(obj, message) {
					$(obj).addClass("error").parents("label").removeClass("isgood").addClass("required").addClass("error").find(".infopop").html(message).addClass("errorpop").animate({opacity:1,left:492},500);
				}
			
				function isGood(obj) {
					$(obj).removeClass("error").removeClass("active").parents("label").addClass("isgood").removeClass("error").removeClass("active").find(".infopop").removeClass("errorpop").animate({opacity:0,left:513},500);
				} 			
			
				function validate(obj) {
					// Extend jQuery object to include Regular expression masks assigned to properties
					mask = jQuery.extend({textfieldmask: /^[a-z\.\s-]{4,}$/i,phonemask: /^[0-9\(\)\+\.\s-]{5,}$/i,passwordmask: /^\w{5,}$/, emailmask:/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/,emptymask: /^[a-z0-9\.\s-]{1,}$/i});
					// Extend jQuery object to include error messages assigned to properties
					errmsg = jQuery.extend({textfielderr:"<?php echo($L_TEXTERROR); ?>",phoneerr: "<?php echo($L_PHONEERROR); ?>",passworderr:"<?php echo($L_PASSWORDERROR); ?>",emailerr:"<?php echo($L_EMAILERROR); ?>",matcherr: "<?php echo($L_PASSWORDMATCHERROR); ?>", emptyerr:"<?php echo($L_TEXTEMPTY); ?>"});
			
					// Set up variables to hold details of which mask to use and whether the field should match another field
					var masktouse = null;
					var mustmatch = null;
					// Determine the type of mask we're going to validate against
					switch(obj.name) {
						case "name": 			masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
						case "phone": 			masktouse="phonemask"; 			errtouse="phoneerr"; 		break;
						case "addressline1": 	masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
					
						case "city": 			masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
						case "state": 			masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
						case "country": 		masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
						case "zip": 			masktouse="emptymask"; 			errtouse="emptyerr"; 		break;
					
						case "username": 		masktouse="textfieldmask"; 		errtouse="textfielderr"; 	break;					
						case "email": 			masktouse="emailmask"; 			errtouse="emailerr"; 		break;
						case "password": 		masktouse="passwordmask"; 		errtouse="passworderr"; 	mustmatch="verpassword"; 	break;
						case "verpassword": 	masktouse="passwordmask"; 		errtouse="passworderr"; 	mustmatch="password"; 		break;
					}
					// Check that the element is a required field before validating against it.
					if($(obj).parents("label").hasClass("required") && masktouse) {
						// Set up a quick way of accessing the object we're validating
						pointer = $(obj);
						// Test the value of the field against the Regular Expression
						if (mask[masktouse].test(pointer.val())) {
							// The field validated successfully!
							
							// Check to see if the field needs to match another field in the form
							if (mustmatch) {
								// It does need to match, so grab the object it needs to match
								matchobj = $("#"+mustmatch);
								if (matchobj.val()!='' && matchobj.val()!=pointer.val()) {
									// The fields don't match, so report an error on both of them
									reportErr(obj,errmsg["matcherr"]);	
									reportErr(matchobj,errmsg["matcherr"]);
								}
								else {
									// Either the fields match, or the other field hasn't been completed yet
									// If the other field has been completed, call the isGood function to clear any error message showing
									if (matchobj.val()!='') { isGood(matchobj);}
									return true;
								}
							}
							else {
								// No match is required, so return true - validation passed!
								return true;
							} 
						}
						else { 
							// The field failed to validate against the Regular Expression
							reportErr(obj,errmsg[errtouse]);
							return false; 
						}
					} 
					else {	
						// This isn't a required field, so we won't validate it against anything			
						return true;
					}
				}
	
			</script>
			<link href="styles/screen.css" rel="stylesheet" type="text/css" />
		</head>
		<body>
    
    	<?php
		include("includes/header.php");
		?>
    
	    	<div style="margin-left:auto;margin-right:auto;width:500px;text-align:left;">
    
				<h1><?php echo($L_TITLE); ?></h1>
	
				<p><?php echo($L_INSTRUCTIONS); ?></p>
	
		        <form name="frmRegister" method="post" action="<?php echo( $_SERVER['PHP_SELF'] ); ?>">

					<!-- hidden values used for when value = "0.00" -->
    		    	<input type="hidden" name="item_number" value="<?php echo($item_number); ?>" />  
           	      	<input type="hidden" name="recid" value="<?php echo($recid); ?>" />
            	    <input type="hidden" name="a3" value="<?php echo($a3); ?>" />

					<?php 
						if ( $a3 == "0.00" ) {
							?>
							<label class="required" for="email" title="<?php echo($L_EMAILMESSAGE); ?>"><input type="text" id="email" name="email" value="<?php echo($email); ?>" /><?php echo($L_EMAILLABEL); ?></label>
                	        <?php
						}
					?>

					<label class="required" for="name" title="<?php echo($L_NAMEMESSAGE); ?>"><input type="text" id="name" name="name" value="<?php echo($name); ?>" /><?php echo($L_NAMELABEL); ?></label>
	
					<label class="required" for="phone" title="<?php echo($L_PHONEMESSAGE); ?>"><input type="text" id="phone" name="phone" value="<?php echo($phone); ?>" /><?php echo($L_PHONELABEL); ?></label>

					<label for="mobile" title="<?php echo($L_MOBILEPHONEMESSAGE); ?>"><input type="text" id="mobile" name="mobile" value="<?php echo($mobile); ?>" /><?php echo($L_MOBILELABEL); ?></label>

					<label class="required" for="addressline1" title="<?php echo($L_ADDRESSLINE1MESSAGE); ?>"><input type="text" id="addressline1" name="addressline1" value="<?php echo($addressline1); ?>" /><?php echo($L_ADDRESSLINE1LABEL); ?></label>

					<label for="addressline2" title="<?php echo($L_ADDRESSLINE2MESSAGE); ?>"><input type="text" id="addressline2" name="addressline2" value="<?php echo($addressline2); ?>" /><?php echo($L_ADDRESSLINE2LABEL); ?></label>

					<label class="required" for="city" title="<?php echo($L_CITYMESSAGE); ?>"><input type="text" id="city" name="city" value="<?php echo($city); ?>" /><?php echo($L_CITYLABEL); ?></label>
                    
					<label class="required" for="state" title="<?php echo($L_STATEMESSAGE); ?>"><input type="text" id="state" name="state" value="<?php echo($state); ?>" /><?php echo($L_STATELABEL); ?></label>

					<label class="required" for="country" title="<?php echo($L_COUNTRYMESSAGE); ?>"><input type="text" id="country" name="country" value="<?php echo($country); ?>" /><?php echo($L_COUNTRYLABEL); ?></label> 

					<label for="zip" title="<?php echo($L_ZIPMESSAGE); ?>"><input type="text" id="zip" name="zip" value="<?php echo($zip); ?>" /><?php echo($L_ZIPLABEL); ?></label>


					<?php
					if ($usercaptcha == true) {
					?>
					<label for="captcha" class="captcha">
                    <?php echo($L_CAPTCHALABEL); ?><br/>
   					<img src="visual-captcha.php" width="200" height="60" alt="Visual CAPTCHA" />
					<input type="text" name="captcha" />
                    </label>
                    <?php
					}
					?>

					<label for="formsubmit" class="nocontent">
                    <input type="submit" id="formsubmit" value="<?php echo($L_BUTTONTEXT); ?>" />
		            <img src="images/required1.gif" alt="Required marker" /><?php echo($L_EXPLAINTEXT); ?>
                    </label>

				</form>

				<?php
				if ( $validation_errormsg != "" ) {
				?>         
                	<div class="red"><?php echo($validation_errormsg); ?></div>
                <?php
                }
				?>

			</div>

	<?php include("includes/footer.php"); ?>

	</body>
	</html>
<?php
}
//----------------------------------------------
//Purpose : This creates a new user and then transfers to PayPal
//In this situation payer_email or email is not required as that 
//will be filled in when IPN comes back from PayPal
function processcreate($active, $item_number, $sendpassword, $email, $name, $phone, $mobile, $addressline1, 
					   		$addressline2, $city, $state, $country, $zip, $a3, $recid) {

	require_once("scripts/server_side_validate.php");
	require_once('../functions/misc.php');
	require_once("lang/file.php");

	$message = "";

	$form_vals = server_side_validate($email, $name, $phone, $mobile, $addressline1, $addressline2, 
									  $city, $state, $country, $zip, false, true, true, false, true, 
									  false, true, true, true, true, $message, $usercaptcha);

		$form_name 			= 	$form_vals["name"];
		$form_phone			= 	$form_vals["phone"];
		$form_mobile		= 	$form_vals["mobile"];			
		$form_addressline1	= 	$form_vals["addressline1"];
		$form_addressline2	= 	$form_vals["addressline2"];
		$form_city			= 	$form_vals["city"];
		$form_country		= 	$form_vals["country"];
		$form_state			= 	$form_vals["state"];
		$form_zip			= 	$form_vals["zip"];

		if ($message != "") {		//If there is an error
			display($a3, $item_number, $recid, $message);
			exit;
		}

	$val = new Validate();	

	//Create a dummy email address for $payer_email
	//This is need as a temporary email address because we need an entry in the table
	//The payer_email address gets overwritten from the IPN after purchase
	$payer_email = createpw() . createpw() . "@dummy.com";
 	$signedup = "0";
	//$name = $name;
	$telephone = $phone;
	//$mobile = $mobile;
	$address_line1 = $addressline1; 
	$address_line2 = $addressline2; 
	//$city = $city; 
	$zip_post_code = $zip;
	//$country = $country;
	//$state = $state;
	
	//Custom variable is the record id of the newly created record in sec_tblusers
	//This variable is posted back from PayPal through the IPN	
	$custom = insertuserpersondetails( $payer_email, $signedup, $name, $telephone, $mobile, $address_line1, 
								$address_line2, $city, $zip_post_code, $country, $state);
	
	if ( $custom == 0) {
		display($a3, $item_number, $recid, "Error in inserting personal details into sec_tblusers");
		exit();
	}

	$install_folder = getinstallfolder();	
	$process = $install_folder . "ipn/process_signup.php?recid=" . $recid . "&custom=" . $custom;

	//echo($process);
	//exit;

	//Redirect to the ipn/process_signup.php page
	header( "Location:".$process );
	exit();	

}
//----------------------------------------------
//Purpose : This creates a new user for this email address when 0.00 is the value of the product.
//This is a manual creation and is similar to the automatic creation of a user but has the manual flag set
function processcreate000($payer_email, $active, $item_number, $sendpassword, $email, $name, $phone, $mobile, 
						  $addressline1, $addressline2, $city, $state, $country, $zip, $a3, $recid) {

	require_once('../functions/misc.php');
	require_once('../functions/user.php');
	require_once('../classes/clspassword.php');
	require_once('../classes/clshtpasswd.php');
	require_once("scripts/server_side_validate.php");
	require_once("lang/file.php");

	//-----------------------------------------------
	if ($email != "") {
		if (banuser($email) == true) {
			display($a3, $item_number, $recid, "Error with email address");
			exit;
		}
	}
	//-----------------------------------------------	

	$message = "";

	$form_vals = server_side_validate($email, $name, $phone, $mobile, $addressline1, $addressline2, $city, $state, 
									  $country, $zip, true, true, true, false, true, false, true, true, true, true, 
									  $message, $usercaptcha);

		$form_email			=	$form_vals["email"];
		$form_name 			= 	$form_vals["name"];
		$form_phone			= 	$form_vals["phone"];
		$form_mobile		= 	$form_vals["mobile"];

		$form_addressline1	= 	$form_vals["addressline1"];
		$form_addressline2	= 	$form_vals["addressline2"];
		$form_city			= 	$form_vals["city"];
		$form_country		= 	$form_vals["country"];
		$form_state			= 	$form_vals["state"];			
		$form_zip			= 	$form_vals["zip"];

		if ($message != "") {		//If there is an error
			display($a3, $item_number, $recid, $message);
			exit;
		}

	//given the $item_number, look up the details from tblitems for this item		
	$userdetails = getuserdetails($item_number);

		$securearea_id 	= $userdetails['securearea_id'];
		$item_name		= $userdetails['item_name'];
		$mc_currency	= $userdetails['mc_currency'];
	
	
	//active is needed when you create a manual user to ensure that the user is activated
	if ( $active == "on" ) { $active = 1; } else { $active = 0; }

	//First check if this email exists, if not then create a new password
	//If it does exist, then get the password and decrypt.

	$payer_email = addslashes($payer_email);

	//echo($payer_email . "<br/>");
	//echo($active . "<br/>");		
	//echo($item_number . "<br/>");
	//echo($sendpassword . "<br/>");		
	//exit;

	//Check if user exists in tbluser	
	$table = userintbluser($payer_email);
	
	if ( count($table) == 0 ) {		//User does not exist then create a new password

		$userexits = "no";

		$password_plain = createpw();

		srand(make_seed());
		$iv = rand(1, 500);

		$encryption = new password($iv, $password_plain);
		$encryption->encode();
		$password_encrypt = $encryption->getencodedtext();

	}
	else
	{					//User does not exist, so get the existing password,

		$userexits = "yes";

		$message = "";

		$password_plain = getpassword($payer_email, $message);
		$iv = $table[0]['iv'];
		$password_encrypt = $table[0]['password'];

		if ( $message != "") {			
			echo ("SQL Error - index.php ref 2 " . $message );
			exit;
		}

	}

	//echo($password_plain . "<br>");
	//echo($iv . "<br>");
	//echo($password_encrypt . "<br>");
	//exit;

	$message = "";

	$users_id = createmanualuser($payer_email, $password_plain, $password_encrypt, $iv, 
								 		$item_number, $active, $securearea_id, $message);
									
	if ($message != "") {
		display($a3, $item_number, $recid, $message);
		exit;
	}

	//echo($sendpassword . "<br/>");
	//echo($active . "<br/>");		
	//exit;

	//if tick boxes are on, send email to user
	if ( $sendpassword == "on" && $active == 1 ) {

		//Send details of how to login to the customer
		$testmode = "false";
		sendlogindetails($payer_email, $password_plain, $item_number, $testmode);
	}

	//Update tblsaleshistory with manual entry

	$currentdate = date("Y-m-d H:i:s");
	
	//Variables we provide
	//$item_number = $item_number;
	//$item_name = $item_name;
	//$payer_email = $payer_email;
	$completed = $currentdate;
	$payment_status	= "Manual";
	$mc_gross =  '0.00';
	//$mc_currency = $mc_currency;
	$txn_id = $currentdate;
		
	//Default values
	$custom  = NULL; 
	$business = NULL; 
	$receiver_id = NULL; 
	$invoice = NULL; 
	$memo = NULL; 
	$tax = NULL; 
	$option_name1 = NULL; 
	$option_selection1 = NULL; 
	$option_name2 = NULL;
	$option_selection2 = NULL; 
	$num_cart_items = NULL; 
	$mc_fee = NULL; 
	$payment_date = NULL; 
	$payment_type = NULL; 
	$first_name = NULL; 
	$last_name = NULL;
	$payer_business_name = NULL; 
	$address_name = NULL; 
	$address_street = NULL; 
	$address_city = NULL; 
	$address_state = NULL; 
	$address_zip = NULL;
	$address_country = NULL; 
	$address_status = NULL; 
	$payer_id = NULL; 
	$payer_status = NULL; 
	$notify_version = NULL; 
	$verify_sign = NULL;
	$receiver_email = NULL;
		
	$rowsaffected = insertsaleshistory($custom, $business, $receiver_id, $invoice, $memo, $tax, $option_name1, $option_selection1, $option_name2,
							$option_selection2, $num_cart_items, $mc_fee, $payment_date, $payment_type, $first_name, $last_name,
							$payer_business_name, $address_name, $address_street, $address_city, $address_state, $address_zip,
							$address_country, $address_status, $payer_id, $payer_status, $notify_version, $verify_sign,
							$txn_id, $item_number, $item_name, $payment_status, $mc_gross, $mc_currency, $receiver_email, 
							$payer_email, $completed);
	
	//echo( $query );
	
	if ( $rowsaffected == 0 ) {	//SQL Error
		echo("SQL Error - index.php ref 3 - no insert into sec_tblsaleshistor" );
		exit;
	}

	//echo(" email " . $form_email . "<br/>");
	//echo(" name " . $form_name . "<br/>");
	//echo(" phone " . $form_phone . "<br/>");
	//echo(" mobile " . $form_mobile . "<br/>");
	//echo(" addressline1 " . $form_addressline1 . "<br/>");
	//echo(" addressline2 " . $form_addressline2 . "<br/>");
	//echo(" city " . $form_city . "<br/>");
	//echo(" country " . $form_country . "<br/>");
	//echo(" city " . $form_zip . "<br/>");
	//exit;
	
	//Update information (the user has already been created in tblusers
	$rowsaffected = updatetbluserspayer_email($name, $telephone, $mobile, $address_line1, $address_line2,
								$city, $zip_post_code, $country, $state, $payer_email );

	//echo($query);
	//exit;

	displayresult( stripslashes($payer_email), $password_plain );
	exit;

}
//----------------------------------------------
//Purpose : This is used when a product value is 0.00 and it 
//			is used to display the username / password for the subscriber
//			$user is the user name (email address) and $password is the password
function displayresult( $user, $password ) {

include("lang/file.php");	

?><!DOCTYPE html>
<html lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<link href="styles/screen.css" rel="stylesheet" type="text/css" />            
		<title><?php echo($L_TITLE); ?></title>
	</head>
	<body>

	<?php        
	include("includes/header.php");
	?>        
	<div style="margin-left:auto;margin-right:auto;width:500px;text-align:left;">

			<p>&nbsp;</p>
			<p>&nbsp;</p>        

			<?php //echo($user);  Commented out ?></p>
			<?php //echo($password); Commented out ?></p>

			<?php echo($L_INSTRUCTIONS_THANK_YOU); ?>

			<p>&nbsp;</p>
			<p>&nbsp;</p>                

	</div>

	<?php include("includes/footer.php"); ?>

   </body>
   </html>
	<?php
}
//----------------------------------------------
//Checks if this is a banned user.
//Returns true if a banned user, false otherwise.
function banuser($email) {

	//Note that the email addresses have to be in LOWER CASE
	$emails = array( "fred_2005@hotmail.com", "pete@hotmail.com", "john@hotmail.com", "susan068@inbox.com", "joe@joe.net" );

	//All ban filters are in lower case as set when they are entered into the database

	if (in_array( $email, $emails)) {
		return true;
	} else {
		return false;
	}

}

?>